/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.ipmworks.domains;

import fr.inra.agrosyst.api.entities.FrostProtectionType;
import fr.inra.agrosyst.api.entities.HosesPositionning;
import fr.inra.agrosyst.api.entities.IrrigationSystemType;
import fr.inra.agrosyst.api.entities.MaxSlope;
import fr.inra.agrosyst.api.entities.PompEngineType;
import fr.inra.agrosyst.api.entities.SolWaterPh;
import fr.inra.agrosyst.api.entities.Stoniness;
import fr.inra.agrosyst.api.entities.WaterFlowDistance;
import fr.inra.agrosyst.api.entities.ZoneType;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlot;
import fr.inra.agrosyst.api.entities.referential.RefElementVoisinage;
import fr.inra.agrosyst.api.entities.referential.RefSolCaracteristiqueIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolProfondeurIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolTextureGeppa;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.api.services.practiced.PracticedPlotService;
import fr.inra.agrosyst.web.actions.ipmworks.domains.DomainsEdit;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class DomainsEdit
extends fr.inra.agrosyst.web.actions.domains.DomainsEdit {
    private static final Log LOGGER = LogFactory.getLog(DomainsEdit.class);
    protected transient GrowingPlanService growingPlanService;
    protected transient PracticedPlotService practicedPlotService;
    protected List<RefSolTextureGeppa> solTextures;
    protected List<RefSolProfondeurIndigo> solProfondeurs;
    protected List<RefSolCaracteristiqueIndigo> solCaracteristiques;
    protected List<RefElementVoisinage> adjacentElements;
    protected List<String> adjacentElementIds;
    protected List<PracticedPlot> practicedPlot;

    protected void initForInput() {
        super.initForInput();
        this.solTextures = this.referentialService.getAllNotFrenchActiveSolTextures();
        this.solProfondeurs = this.referentialService.getAllActiveSolProfondeurs();
        this.solCaracteristiques = this.referentialService.getAllActiveSolCaracteristiques();
        this.adjacentElements = this.referentialService.getAllActiveElementVoisinages();
        if (this.domain.isPracticedPlotNotEmpty()) {
            this.domain.getPracticedPlot().forEach(practicedPlot -> {
                this.solTextures.stream().filter(texture -> texture.getTopiaId().equals(practicedPlot.getSurfaceTexture().getTopiaId())).findFirst().ifPresent(arg_0 -> ((PracticedPlot)practicedPlot).setSurfaceTexture(arg_0));
                this.solProfondeurs.stream().filter(profondeur -> profondeur.getTopiaId().equals(practicedPlot.getSolDepth().getTopiaId())).findFirst().ifPresent(arg_0 -> ((PracticedPlot)practicedPlot).setSolDepth(arg_0));
            });
        }
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "domains-edit-input", "domainTopiaId", "${domain.topiaId}"})})
    public String execute() throws Exception {
        String result = super.execute();
        if ("success".equals(result)) {
            this.growingPlanService.getOrCreateDefaultGrowingPlanForDomain(this.domain);
        }
        return result;
    }

    protected void createOrUpdateDomain() {
        this.domain = this.domainService.createOrUpdateDomainWithoutCommit(this.domain, this.locationTopiaId, this.legalStatusId, this.geoPoints, this.croppingPlans, this.otex18, this.otex70, this.grounds, this.equipments, this.toolsCouplings, this.livestockUnits, (Collection)this.inputStockUnits, this.harvestingPriceDtos);
        this.domain = this.domainService.setPracticedPlotsForDomain(this.domain, (Collection)this.practicedPlot);
        this.domainService.validateAndCommit(this.domain.getTopiaId());
    }

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    public void setPracticedPlotService(PracticedPlotService practicedPlotService) {
        this.practicedPlotService = practicedPlotService;
    }

    public Map<MaxSlope, String> getMaxSlopes() {
        return this.getEnumAsMap((Object[])MaxSlope.values());
    }

    public Map<WaterFlowDistance, String> getWaterFlowDistances() {
        return this.getEnumAsMap((Object[])WaterFlowDistance.values());
    }

    public void setLocationTopiaId(String locationTopiaId) {
        this.locationTopiaId = locationTopiaId;
    }

    public String getLocationTopiaId() {
        return this.locationTopiaId;
    }

    public Map<Stoniness, StoninessDTO> getSolStoninesses() {
        Map translationMap = this.i18nService.getEnumTranslationMap(Stoniness.class);
        LinkedHashMap<Stoniness, StoninessDTO> result = new LinkedHashMap<Stoniness, StoninessDTO>();
        translationMap.forEach((key, value) -> result.put((Stoniness)key, new StoninessDTO(key.getStoninessValue(), value)));
        return result;
    }

    public Map<IrrigationSystemType, String> getIrrigationSystemTypes() {
        return this.getEnumAsMap((Object[])IrrigationSystemType.values());
    }

    public Map<PompEngineType, String> getPompEngineTypes() {
        return this.getEnumAsMap((Object[])PompEngineType.values());
    }

    public Map<HosesPositionning, String> getHosesPositionnings() {
        return this.getEnumAsMap((Object[])HosesPositionning.values());
    }

    public Map<FrostProtectionType, String> getFrostProtectionTypes() {
        return this.getEnumAsMap((Object[])FrostProtectionType.values());
    }

    public Map<SolWaterPh, String> getSolWaterPhs() {
        return this.getEnumAsMap((Object[])SolWaterPh.values());
    }

    public List<RefSolTextureGeppa> getSolTextures() {
        return this.solTextures;
    }

    public List<RefSolProfondeurIndigo> getSolProfondeurs() {
        return this.solProfondeurs;
    }

    public List<RefSolCaracteristiqueIndigo> getSolCaracteristiques() {
        return this.solCaracteristiques;
    }

    public Map<ZoneType, String> getZoneTypes() {
        return this.getEnumAsMap((Object[])ZoneType.values());
    }

    public List<RefElementVoisinage> getAdjacentElements() {
        return this.adjacentElements;
    }

    public List<String> getAdjacentElementIds() {
        return this.adjacentElementIds;
    }

    public void setAdjacentElementIds(List<String> adjacentElementIds) {
        this.adjacentElementIds = adjacentElementIds;
    }

    public void setPracticedPlot(String practicedPlot) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.practicedPlot = (List)this.getGson().fromJson(practicedPlot, type);
    }
}

