/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.growingsystems;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.opensymphony.xwork2.conversion.annotations.Conversion;
import com.opensymphony.xwork2.conversion.annotations.TypeConversion;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.GrowingSystemCharacteristicType;
import fr.inra.agrosyst.api.entities.GrowingSystemImpl;
import fr.inra.agrosyst.api.entities.MarketingDestinationObjective;
import fr.inra.agrosyst.api.entities.ModalityDephy;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.entities.managementmode.CategoryStrategy;
import fr.inra.agrosyst.api.entities.managementmode.ManagementMode;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.referential.RefTraitSdC;
import fr.inra.agrosyst.api.entities.referential.RefTypeAgriculture;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.domain.PlotDto;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.Preparable;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.topia.persistence.TopiaEntity;

@Conversion
public class GrowingSystemsEdit
extends AbstractAgrosystAction
implements Preparable {
    private static final Log LOGGER = LogFactory.getLog(GrowingSystemsEdit.class);
    private static final long serialVersionUID = 2739566488786458389L;
    protected transient DomainService domainService;
    protected transient GrowingSystemService growingSystemService;
    protected transient PlotService plotService;
    protected transient NetworkService networkService;
    protected transient GrowingPlanService growingPlanService;
    protected transient ReferentialService referentialService;
    protected String growingSystemTopiaId;
    protected GrowingSystem growingSystem;
    protected double domainSAUArea;
    protected LinkedHashMap<Integer, String> relatedGrowingSystems;
    protected List<PlotDto> availablePlots;
    protected GrowingPlan growingPlan;
    protected String growingPlanTopiaId;
    protected GrowingPlan selectedGrowingPlan;
    protected List<String> selectedPlotsIds;
    protected List<String> growingSystemNetworkIds;
    protected List<RefTypeAgriculture> typeAgricultures;
    protected String typeAgricultureTopiaId;
    protected List<RefTraitSdC> growingSystemCharacteristics;
    protected List<String> growingSystemCharacteristicIds;
    protected List<PracticedSystem> practicedSystems;
    protected List<ManagementMode> managementModes;
    protected Map<Sector, List<MarketingDestinationObjective>> marketingDestinationsBySector;
    protected String missingTypeAgricultureTopiaId;
    protected static final String PERCENT_FIELD = "La valeur doit \u00eatre comprise entre 0 et 100";
    protected static final String INCOHERENT_STARTING_AND_ENDING_DATES = "Les dates de d\u00e9but et de fin sont incoh\u00e9rentes";

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setGrowingSystemCharacteristicIds(List<String> growingSystemCharacteristicIds) {
        this.growingSystemCharacteristicIds = growingSystemCharacteristicIds;
    }

    public void prepare() {
        this.missingTypeAgricultureTopiaId = this.growingSystemService.getMissingTypeAgricultureTopiaId();
        if (StringUtils.isEmpty((CharSequence)this.growingSystemTopiaId)) {
            this.growingSystem = this.growingSystemService.newGrowingSystem();
        } else {
            this.authorizationService.checkGrowingSystemReadable(this.growingSystemTopiaId);
            this.readOnly = !this.authorizationService.isGrowingSystemWritable(this.growingSystemTopiaId);
            this.growingSystem = this.growingSystemService.getGrowingSystem(this.growingSystemTopiaId);
            this.growingPlanTopiaId = this.growingSystem.getGrowingPlan().getTopiaId();
            boolean bl = this.activated = this.growingSystem.isActive() && this.growingSystem.getGrowingPlan().isActive() && this.growingSystem.getGrowingPlan().getDomain().isActive();
            if (this.readOnly || Strings.isNullOrEmpty((String)this.growingPlanTopiaId)) {
                this.notificationSupport.growingSystemNotWritable();
                this.readOnly = true;
            }
            this.marketingDestinationsBySector = this.growingSystemService.loadMarketingDestinationObjective(this.growingSystem);
        }
        if (!this.growingSystem.isPersisted() && StringUtils.isNotBlank((CharSequence)this.growingPlanTopiaId)) {
            GrowingPlan growingPlan = this.growingPlanService.getGrowingPlan(this.growingPlanTopiaId);
            this.growingSystem.setGrowingPlan(growingPlan);
        }
    }

    public GrowingSystem getGrowingSystem() {
        return Objects.requireNonNullElseGet(this.growingSystem, GrowingSystemImpl::new);
    }

    @Action(value="growing-systems-edit-input")
    public String input() {
        GrowingSystem growingSystem = this.getGrowingSystem();
        if (growingSystem.getGrowingPlan() != null) {
            this.growingPlanTopiaId = growingSystem.getGrowingPlan().getTopiaId();
        }
        if (growingSystem.getTypeAgriculture() != null) {
            this.typeAgricultureTopiaId = growingSystem.getTypeAgriculture().getTopiaId();
        }
        this.initForInput();
        if (growingSystem.isPersisted()) {
            this.selectedPlotsIds = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)this.availablePlots)) {
                for (PlotDto plot : this.availablePlots) {
                    if (plot.getGrowingSystem() == null || !growingSystem.getTopiaId().equals(plot.getGrowingSystem().getTopiaId())) continue;
                    this.selectedPlotsIds.add(plot.getTopiaId());
                }
            }
            if (this.growingSystemService.isMissingTypeAgriculture(growingSystem)) {
                this.notificationSupport.error("Le type de conduite n'est pas renseign\u00e9. Merci de pr\u00e9ciser le type de conduite dans l'onglet 'G\u00e9n\u00e9ralit\u00e9s'", new Object[0]);
            }
        }
        this.growingSystemCharacteristicIds = growingSystem.getCharacteristics() != null ? growingSystem.getCharacteristics().stream().map(Entities.GET_TOPIA_ID).collect(Collectors.toList()) : new ArrayList();
        return "input";
    }

    protected void initForInput() {
        GrowingSystem growingSystem = this.getGrowingSystem();
        if (growingSystem.isPersisted()) {
            this.relatedGrowingSystems = this.growingSystemService.getRelatedGrowingSystemIdsByCampaigns(growingSystem.getCode());
            this.practicedSystems = this.growingSystemService.getPracticedSystems(growingSystem.getCode());
            this.managementModes = this.growingSystemService.getManagementModes(growingSystem.getTopiaId());
            this.availablePlots = this.plotService.findAllFreeAndGrowingSystemPlots(growingSystem, this.growingPlanTopiaId);
            this.domainSAUArea = this.domainService.getDomainSAUArea(growingSystem.getGrowingPlan().getDomain().getTopiaId());
        } else if (StringUtils.isNotBlank((CharSequence)this.growingPlanTopiaId)) {
            this.selectedGrowingPlan = this.growingPlanService.getGrowingPlan(this.growingPlanTopiaId);
            this.availablePlots = this.plotService.findAllFreeAndGrowingSystemPlots(null, this.growingPlanTopiaId);
        }
        this.typeAgricultures = this.growingSystemService.findAllTypeAgricultures();
        this.growingSystemCharacteristics = this.referentialService.getAllActiveGrowingSystemCharacteristics();
    }

    public void validate() {
        Integer domainsToolsUsageRate;
        Integer affectedWorkForceRate;
        Double affectedAreaRate;
        LocalDate startingDate;
        if (StringUtils.isBlank((CharSequence)this.growingPlanTopiaId)) {
            this.addFieldError("growingPlanTopiaId", this.getText("common.filedValue.required"));
        }
        if (this.growingSystem.isPersisted() && !this.activated) {
            this.addActionError("Le systeme de culture et/ou son dispositif et/ou son domain sont inactifs !");
        }
        if (StringUtils.isBlank((CharSequence)this.growingSystem.getName())) {
            this.addFieldError("growingSystem.name", this.getText("common.filedValue.required"));
        }
        if ((startingDate = this.growingSystem.getStartingDate()) == null) {
            this.addFieldError("growingSystem.startingDate", this.getText("common.filedValue.required"));
        }
        if (this.growingSystem.getSector() == null) {
            this.addFieldError("growingSystem.sector", this.getText("common.filedValue.required"));
        }
        if (Sector.MARAICHAGE == this.growingSystem.getSector() && this.growingSystem.getProduction() == null) {
            this.addFieldError("growingSystem.production", this.getText("common.filedValue.required"));
            this.addActionError("Le type de production doit \u00eatre renseign\u00e9 pour les fili\u00e8res mara\u00eechage");
        }
        if (Sector.HORTICULTURE == this.growingSystem.getSector() && this.growingSystem.getProduction() == null) {
            this.addFieldError("growingSystem.production", this.getText("common.filedValue.required"));
            this.addActionError("Le type de production doit \u00eatre renseign\u00e9 pour les fili\u00e8res horticulture");
        }
        LocalDate endingDate = this.growingSystem.getEndingDate();
        if (startingDate != null && endingDate != null && endingDate.isBefore(startingDate)) {
            this.addFieldError("growingSystem.startingDate", INCOHERENT_STARTING_AND_ENDING_DATES);
            this.addFieldError("growingSystem.endingDate", INCOHERENT_STARTING_AND_ENDING_DATES);
        }
        if ((affectedAreaRate = this.growingSystem.getAffectedAreaRate()) != null) {
            if (affectedAreaRate < 0.0 || affectedAreaRate > 100.0) {
                this.addFieldError("growingSystem.affectedAreaRate", PERCENT_FIELD);
            }
        } else {
            this.addFieldError("growingSystem.affectedAreaRate", "Le pourcentage de surface du domaine affect\u00e9e est obligatoire.");
        }
        if ((affectedWorkForceRate = this.growingSystem.getAffectedWorkForceRate()) != null && (affectedWorkForceRate < 0 || affectedWorkForceRate > 100)) {
            this.addFieldError("growingSystem.affectedWorkForceRate", PERCENT_FIELD);
        }
        if ((domainsToolsUsageRate = this.growingSystem.getDomainsToolsUsageRate()) != null && (domainsToolsUsageRate < 0 || domainsToolsUsageRate > 100)) {
            this.addFieldError("growingSystem.domainsToolsUsageRate", PERCENT_FIELD);
        }
        if (StringUtils.isBlank((CharSequence)this.typeAgricultureTopiaId) || !this.typeAgricultureTopiaId.startsWith(RefTypeAgriculture.class.getName()) || this.typeAgricultureTopiaId.equals(this.missingTypeAgricultureTopiaId)) {
            this.addFieldError("typeAgricultureTopiaId", this.getText("common.filedValue.required"));
            this.addActionError("Le type de conduite est obligatoire");
        }
        if (this.growingSystem.getGrowingPlan() != null && TypeDEPHY.DEPHY_FERME.equals((Object)this.growingSystem.getGrowingPlan().getType())) {
            if (this.growingSystem.getModality() == null) {
                this.addFieldError("growingSystem.modality", this.getText("common.filedValue.required"));
                this.addActionError("Le modalit\u00e9 de suivi dans DEPHY est obligatoire");
            }
            if (ModalityDephy.DETAILLE.equals((Object)this.growingSystem.getModality()) && StringUtils.isBlank((CharSequence)this.growingSystem.getDephyNumber())) {
                this.addFieldError("growingSystem.dephyNumber", this.getText("common.filedValue.required"));
                this.addActionError("Le num\u00e9ro DEPHY est obligatoire");
            }
        }
        if (this.hasErrors()) {
            if (LOGGER.isErrorEnabled()) {
                String growingSystemId = this.getLogEntityId((TopiaEntity)this.growingSystem);
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":validate, action errors : gs:'%s' -> %s", growingSystemId, this.getActionErrors().toString()));
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":validate, fields errors : gs:'%s' -> %s", growingSystemId, this.getFieldErrors().toString()));
            }
            this.initForInput();
        }
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "growing-systems-edit-input", "growingSystemTopiaId", "${growingSystem.topiaId}"})})
    public String execute() throws Exception {
        this.growingSystem = this.growingSystemService.createOrUpdateGrowingSystem(this.growingSystem, this.growingSystemNetworkIds, (Collection)this.selectedPlotsIds, this.typeAgricultureTopiaId, this.growingSystemCharacteristicIds, this.marketingDestinationsBySector);
        this.notificationSupport.growingSystemSaved(this.growingSystem);
        if (Strings.isNullOrEmpty((String)this.growingSystemTopiaId)) {
            this.navigationContextEntityCreated((TopiaEntity)this.growingSystem);
        }
        return "success";
    }

    public void setGrowingSystem(GrowingSystem growingSystem) {
        this.growingSystem = growingSystem;
    }

    public Map<String, Boolean> getSelectedPlotsIds() {
        ImmutableMap result = this.selectedPlotsIds == null ? new HashMap() : Maps.toMap((Iterable)this.selectedPlotsIds, AbstractJsonAction.GET_TRUE::apply);
        return result;
    }

    public List<PlotDto> getAvailablePlots() {
        return this.availablePlots;
    }

    public String getGrowingSystemTopiaId() {
        return this.growingSystemTopiaId;
    }

    public void setGrowingSystemTopiaId(String growingSystemTopiaId) {
        this.growingSystemTopiaId = growingSystemTopiaId;
    }

    public String getGrowingPlanTopiaId() {
        return this.growingPlanTopiaId;
    }

    public void setGrowingPlanTopiaId(String growingPlanTopiaId) {
        this.growingPlanTopiaId = growingPlanTopiaId;
    }

    public void setSelectedPlotsIds(List<String> selectedPlotsIds) {
        this.selectedPlotsIds = selectedPlotsIds;
    }

    public Map<CategoryStrategy, String> getCategoryStrategies() {
        return this.getEnumAsMap((Object[])CategoryStrategy.values());
    }

    public LinkedHashMap<Integer, String> getRelatedGrowingSystems() {
        return this.relatedGrowingSystems;
    }

    public void setGrowingSystemNetworkIds(List<String> growingSystemNetworkIds) {
        this.growingSystemNetworkIds = growingSystemNetworkIds;
    }

    public List<RefTypeAgriculture> getTypeAgricultures() {
        return this.typeAgricultures;
    }

    public String getTypeAgricultureTopiaId() {
        return this.typeAgricultureTopiaId;
    }

    public void setTypeAgricultureTopiaId(String typeAgricultureTopiaId) {
        this.typeAgricultureTopiaId = typeAgricultureTopiaId;
    }

    public List<PracticedSystem> getPracticedSystems() {
        return this.practicedSystems;
    }

    public List<ManagementMode> getManagementModes() {
        return this.managementModes;
    }

    public List<RefTraitSdC> getGrowingSystemCharacteristics() {
        return this.growingSystemCharacteristics;
    }

    public Map<GrowingSystemCharacteristicType, String> getGrowingSystemCharacteristicTypes() {
        return this.getEnumAsMap((Object[])GrowingSystemCharacteristicType.values());
    }

    public List<String> getGrowingSystemCharacteristicIds() {
        return this.growingSystemCharacteristicIds;
    }

    public double getDomainSAUArea() {
        return this.domainSAUArea;
    }

    @TypeConversion(converter="fr.inra.agrosyst.web.actions.commons.AgrosystStringToDateConverter")
    public void setGrowingSystemStartingDate(LocalDate date) {
        GrowingSystem gs = this.getGrowingSystem();
        gs.setStartingDate(date);
    }

    @TypeConversion(converter="fr.inra.agrosyst.web.actions.commons.AgrosystStringToDateConverter")
    public void setGrowingSystemEndingDate(LocalDate date) {
        GrowingSystem gs = this.getGrowingSystem();
        gs.setEndingDate(date);
    }

    public Map<Sector, List<MarketingDestinationObjective>> getMarketingDestinationsBySector() {
        return this.marketingDestinationsBySector;
    }

    public void setMarketingDestinationsBySector(String marketingDestinationsBySector) {
        this.marketingDestinationsBySector = this.convertMarketingDestinationObjectiveJson(marketingDestinationsBySector);
    }

    protected Map<Sector, List<MarketingDestinationObjective>> convertMarketingDestinationObjectiveJson(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        return (Map)this.getGson().fromJson(json, type);
    }

    public GrowingPlan getSelectedGrowingPlan() {
        return this.selectedGrowingPlan;
    }

    public Map<TypeDEPHY, String> getTypesDephy() {
        return this.getEnumAsMap((Object[])new TypeDEPHY[]{TypeDEPHY.DEPHY_FERME, TypeDEPHY.DEPHY_EXPE, TypeDEPHY.NOT_DEPHY});
    }

    public String getMissingTypeAgricultureTopiaId() {
        return this.missingTypeAgricultureTopiaId;
    }
}

