/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.effective;

import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadEffectiveZonesForCopyJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(LoadEffectiveZonesForCopyJson.class);
    private static final long serialVersionUID = -2610482141000789371L;
    protected transient String zoneId;
    protected transient EffectiveCropCycleService effectiveCropCycleService;

    public String execute() throws Exception {
        try {
            this.jsonData = this.effectiveCropCycleService.getAvailableZonesForCopy(this.zoneId);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load available zones to copy for zoneId '%s'", this.zoneId), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public EffectiveCropCycleService getEffectiveCropCycleService() {
        return this.effectiveCropCycleService;
    }

    public void setEffectiveCropCycleService(EffectiveCropCycleService effectiveCropCycleService) {
        this.effectiveCropCycleService = effectiveCropCycleService;
    }
}

