/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.effective;

import com.google.common.base.Preconditions;
import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.entities.VariableType;
import fr.inra.agrosyst.api.entities.measure.MeasurementType;
import fr.inra.agrosyst.api.services.measurement.MeasurementService;
import fr.inra.agrosyst.api.services.measurement.ProtocoleVgObsFilter;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;

public class EffectiveMeasurementsEditJson
extends AbstractJsonAction {
    private static final long serialVersionUID = -4576065541768079736L;
    private static final Log LOGGER = LogFactory.getLog(EffectiveMeasurementsEditJson.class);
    protected transient MeasurementService measurementService;
    protected MeasurementType measurementType;
    protected VariableType variableType;
    protected String cropFamily;
    protected String vegetativeProfile;
    protected String vgObsFilter;
    protected BioAgressorType pestType;

    public void setMeasurementObservationService(MeasurementService measurementService) {
        this.measurementService = measurementService;
    }

    public void setMeasurementType(MeasurementType measurementType) {
        this.measurementType = measurementType;
    }

    public void setVariableType(VariableType variableType) {
        this.variableType = variableType;
    }

    public void setCropFamily(String cropFamily) {
        this.cropFamily = cropFamily;
    }

    public void setVegetativeProfile(String vegetativeProfile) {
        this.vegetativeProfile = vegetativeProfile;
    }

    public void setPestType(BioAgressorType pestType) {
        this.pestType = pestType;
    }

    @Action(value="effective-measurements-variable-types-json")
    public String listVariableTypes() {
        try {
            this.jsonData = this.measurementService.findAllVariableTypes(this.measurementType);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load measurements-variable-types for measurementType '%s':", this.measurementType), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="effective-measurements-variables-json")
    public String listVariables() {
        try {
            this.jsonData = this.measurementService.findAllVariables(this.measurementType, this.variableType);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load measurements-variable for measurementType '%s' and variableType '%s':", this.measurementType, this.variableType), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="effective-measurements-stades-json")
    public String listStadeEdis() {
        try {
            Preconditions.checkArgument((boolean)(this.cropFamily != null ^ this.vegetativeProfile != null));
            this.jsonData = this.measurementService.findAllStadeEdi(this.cropFamily, this.vegetativeProfile);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load effective-measurements-stades for cropFamily '%s' and vegetativeProfile '%s':", this.cropFamily, this.vegetativeProfile), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    public void setVgObsFilter(String vgObsFilter) {
        this.vgObsFilter = vgObsFilter;
    }

    protected ProtocoleVgObsFilter getVgObsFilter() {
        ProtocoleVgObsFilter protocoleVgObsFilter = (ProtocoleVgObsFilter)this.getGson().fromJson(this.vgObsFilter, ProtocoleVgObsFilter.class);
        return protocoleVgObsFilter;
    }

    @Action(value="effective-measurements-vgobs-labels-json")
    public String listVgobsLabels() {
        try {
            this.jsonData = this.measurementService.findAllProtocoleVgObsLabels();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load effective-measurements-vgobs-labels", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="effective-measurements-vgobs-pests-json")
    public String listVgobsPests() {
        try {
            this.jsonData = this.measurementService.findAllProtocoleVgObsPests(this.getVgObsFilter());
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load effectivemeasurements-vgobs-pests", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="effective-measurements-vgobs-stades-json")
    public String listVgobsStades() {
        try {
            this.jsonData = this.measurementService.findAllProtocoleVgObsStades(this.getVgObsFilter());
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load effective-measurements-vgobs-stades", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="effective-measurements-vgobs-supports-json")
    public String listVgobsSupports() {
        try {
            this.jsonData = this.measurementService.findAllProtocoleVgObsSupports(this.getVgObsFilter());
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load effective-measurements-vgobs-supports", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="effective-measurements-vgobs-observations-json")
    public String listVgobsObservations() {
        try {
            this.jsonData = this.measurementService.findAllProtocoleVgObsObservations(this.getVgObsFilter());
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load effective-measurements-vgobs-observations", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="effective-measurements-vgobs-qualitatives-json")
    public String listVgobsQualitatives() {
        try {
            this.jsonData = this.measurementService.findAllProtocoleVgObsQualitatives(this.getVgObsFilter());
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load effective-measurements-vgobs-qualitatives", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="effective-measurements-vgobs-units-json")
    public String listVgobsUnits() {
        try {
            this.jsonData = this.measurementService.findAllProtocoleVgObsUnits(this.getVgObsFilter());
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load effective-measurements-vgobs-units", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="effective-measurements-vgobs-qualifiers-json")
    public String listVgobsQualifiers() {
        try {
            this.jsonData = this.measurementService.findAllProtocoleVgObsQualifiers(this.getVgObsFilter());
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load effective-measurements-vgobs-qualifiers", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="effective-measurements-edi-pesttypes-json")
    public String listPestTypes() {
        try {
            this.jsonData = this.measurementService.findAllEdiPestTypes();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load effective-measurements-edi-pesttypes", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="effective-measurements-edi-pests-json")
    public String listPests() {
        try {
            this.jsonData = this.measurementService.findAllEdiPests(this.pestType);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load effective-measurements-edi-pests", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="effective-measurements-edi-peststades-json")
    public String listPestStades() {
        try {
            this.jsonData = this.measurementService.findAllEdiPestStades();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load effective-measurements-edi-peststades", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="effective-measurements-edi-supports-json")
    public String listSupports() {
        try {
            this.jsonData = this.measurementService.findAllSupportOrganeEDI();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load effective-measurements-edi-supports", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="effective-measurements-edi-notations-json")
    public String listNotations() {
        try {
            this.jsonData = this.measurementService.findAllEdiNotations();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load effective-measurements-edi-notations", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="effective-measurements-edi-qualitatives-json")
    public String listQualitatives() {
        try {
            this.jsonData = this.measurementService.findAllEdiQualitatives();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load effective-measurements-edi-qualitatives", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="effective-measurements-edi-qualifierunits-json")
    public String listQualifierUnits() {
        try {
            this.jsonData = this.measurementService.findAllEdiQualifiantUnits();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load effective-measurements-edi-qualifierunits", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="effective-measurements-edi-units-json")
    public String listUnits() {
        try {
            this.jsonData = this.measurementService.findAllVgObsUnits();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load effective-measurements-edi-units", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }
}

