/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.domains;

import fr.inra.agrosyst.api.services.edaplos.EdaplosParsingResult;
import fr.inra.agrosyst.api.services.edaplos.EdaplosParsingStatus;
import fr.inra.agrosyst.api.services.edaplos.EdaplosService;
import fr.inra.agrosyst.api.services.security.AgrosystAccessDeniedException;
import fr.inra.agrosyst.api.services.users.AuthenticatedUser;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.action.UploadedFilesAware;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

public class DomainsPreImportEdaplos
extends AbstractAgrosystAction
implements UploadedFilesAware {
    private static final Log LOGGER = LogFactory.getLog(DomainsPreImportEdaplos.class);
    private static final long serialVersionUID = 1L;
    protected File file;
    protected String fileContentType;
    protected String fileFileName;
    protected String edaplosFileId;
    protected transient EdaplosService edaplosService;
    protected EdaplosParsingResult edaplosParsingResults;

    public void setEdaplosService(EdaplosService edaplosService) {
        this.edaplosService = edaplosService;
    }

    public String input() throws Exception {
        return super.input();
    }

    public String execute() throws Exception {
        block12: {
            if (this.file != null) {
                try (FileInputStream stream = new FileInputStream(this.file);){
                    AuthenticatedUser authenticatedUser = this.getAuthenticatedUser();
                    this.authorizationService.checkComputedPermissionsFromUserId(authenticatedUser.getTopiaId());
                    this.edaplosFileId = this.edaplosService.storeEdaplosFile((InputStream)stream, this.fileFileName, this.fileContentType);
                    this.edaplosParsingResults = this.edaplosService.validEdaplosData(this.edaplosFileId);
                    break block12;
                }
                catch (AgrosystAccessDeniedException ex) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.error((Object)"Can't import eDaplos file", (Throwable)ex);
                    }
                    throw ex;
                }
                catch (Exception ex) {
                    this.sendFeedback(ex);
                    this.edaplosParsingResults = this.getEdaplosParsingErrorResults("L'import eDaplos a \u00e9chou\u00e9, veuillez contacter l'\u00e9quipe Agrosyst");
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.error((Object)"Can't import eDaplos file", (Throwable)ex);
                    }
                    return "error";
                }
            }
            this.edaplosParsingResults = this.getEdaplosParsingErrorResults("L'import eDaplos a \u00e9chou\u00e9, aucun fichier re\u00e7u");
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"No eDaplos file provided");
            }
            return "error";
        }
        return "success";
    }

    protected void sendFeedback(Exception ex) {
        try {
            this.edaplosService.sendExceptionFeedbackEmail(ex, "Analyse du fichier d'import Edaplos", this.fileFileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected EdaplosParsingResult getEdaplosParsingErrorResults(String message) {
        this.edaplosParsingResults = new EdaplosParsingResult();
        this.edaplosParsingResults.addErrorMessage(message, "");
        this.edaplosParsingResults.setEdaplosParsingStatus(EdaplosParsingStatus.EXCEPTION);
        return this.edaplosParsingResults;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFileContentType(String fileContentType) {
        this.fileContentType = fileContentType;
    }

    public void setFileFileName(String fileFileName) {
        this.fileFileName = fileFileName;
    }

    public EdaplosParsingResult getEdaplosParsingResults() {
        return this.edaplosParsingResults;
    }

    public String getEdaplosFileId() {
        return this.edaplosFileId;
    }

    public void withUploadedFiles(List<UploadedFile> uploadedFiles) {
        if (LOGGER.isDebugEnabled()) {
            Collection uploadedFiles1 = CollectionUtils.emptyIfNull(uploadedFiles);
            LOGGER.debug((Object)String.format("L'utilisateur %s \u00e0 soumis les fichiers Edaplos %s", this.getAuthenticatedUser().getEmail(), uploadedFiles1.stream().map(UploadedFile::getOriginalName).collect(Collectors.joining())));
        }
    }
}

