/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.domains;

import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.domain.DomainSummaryDto;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DomainSummaryListJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(DomainSummaryListJson.class);
    private static final long serialVersionUID = -3782509535850441876L;
    protected transient DomainService domainService;
    protected transient String filter;
    protected transient Boolean pagination = true;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setPagination(Boolean pagination) {
        this.pagination = pagination;
    }

    public String execute() {
        try {
            DomainFilter domainFilter = (DomainFilter)this.getGson().fromJson(this.filter, DomainFilter.class);
            if (!this.pagination.booleanValue()) {
                domainFilter.setAllPageSize();
                domainFilter.setPage(0);
            } else {
                this.writeListNbElementByPage(DomainSummaryDto.class, domainFilter.getPageSize());
            }
            this.jsonData = this.domainService.getFilteredDomainSummariesDto(domainFilter);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load domains list", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }
}

