/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.auth;

import fr.inra.agrosyst.api.services.users.AuthenticatedUser;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(LoginJson.class);
    private static final long serialVersionUID = -495238362631537397L;
    protected transient UserService userService;
    protected String email;
    protected String password;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String execute() throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)String.format("[sid=%s] Trying to login with email '%s'", this.getSessionId(), this.email));
        }
        if (StringUtils.isEmpty((CharSequence)this.email)) {
            this.jsonData = "Le champ 'email' est obligatoire";
            this.httpCode = 417;
            return "error";
        }
        if (StringUtils.isEmpty((CharSequence)this.password)) {
            this.jsonData = "Le champ 'password' est obligatoire";
            this.httpCode = 417;
            return "error";
        }
        AuthenticatedUser loginResult = this.authenticationService.login(this.email, this.password);
        if (loginResult == null) {
            this.jsonData = this.userService.isValidEmail(this.email) && !this.userService.isUserActive(this.email) ? "Votre compte est d\u00e9sactiv\u00e9, merci de contacter un administrateur d'Agrosyst." : "\u00c9chec de connexion.";
            this.httpCode = 401;
            return "error";
        }
        if (this.authorizationService.isInMaintenanceMode() && !this.authorizationService.isAdminFromUserId(loginResult.getTopiaId())) {
            this.jsonData = this.authorizationService.getMaintenanceModeMessage();
            this.httpCode = 401;
            return "error";
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("[sid=%s] user email '%s' redirect to %s", loginResult.getSid(), this.email, "next"));
        }
        this.applicationContext.writeAuthenticationCookie(loginResult, this.getCookieHelper());
        this.jsonData = loginResult;
        return "success";
    }
}

