/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.auth;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.common.MocoribaConnectorService;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaQueryException;

public class LoadMocoribaTokenJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(LoadMocoribaTokenJson.class);
    private static final long serialVersionUID = 1L;
    private MocoribaConnectorService mocoribaConnectorService;

    public String execute() throws Exception {
        try {
            NavigationContext navigationContext = this.getNavigationContext();
            DomainFilter domainFilter = null;
            if (navigationContext.getDomainsCount() > 0 || navigationContext.getCampaignsCount() > 0 || navigationContext.getGrowingPlansCount() > 0 || navigationContext.getGrowingSystemsCount() > 0 || navigationContext.getNetworksCount() > 0) {
                domainFilter = new DomainFilter();
                domainFilter.setNavigationContext(navigationContext);
            }
            this.jsonData = this.mocoribaConnectorService.getMocoribaConnexionUrl(domainFilter);
        }
        catch (TopiaQueryException e) {
            this.jsonData = "\u00c9chec de la bascule sur MoCoRiBA : il se peut que le nombre de domaine auquel vous avez acc\u00e8s soit trop important pour permettre l'envoi d'informations. R\u00e9essayez en mettant \u00e0 jour votre filtre contextuel.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Unable to contact MoCoRiBA instance: ", (Throwable)e);
            }
            return "error";
        }
        catch (Exception e) {
            this.jsonData = "\u00c9chec de la bascule sur MoCoRiBA : il se peut que les param\u00e8tres de connexion aient chang\u00e9es.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Unable to contact MoCoRiBA instance: ", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Generated
    public void setMocoribaConnectorService(MocoribaConnectorService mocoribaConnectorService) {
        this.mocoribaConnectorService = mocoribaConnectorService;
    }
}

