/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.admin;

import fr.inra.agrosyst.api.services.async.AsyncService;
import fr.inra.agrosyst.web.AgrosystWebApplicationContext;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import fr.inra.agrosyst.web.actions.admin.StatusDto;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class StatusJson
extends AbstractJsonAction {
    protected static final List<String> READABLE_SIZE_UNITS = Arrays.asList("B", "KB", "MB", "GB", "TB", "PB");
    protected static final double ONE_BYTE_AS_DOUBLE = 1024.0;
    private static final long serialVersionUID = -5216908457477602159L;
    protected AsyncService asyncService;
    protected boolean includeThreadDetails = false;

    public void setAsyncService(AsyncService asyncService) {
        this.asyncService = asyncService;
    }

    public void setIncludeThreadDetails(boolean includeThreadDetails) {
        this.includeThreadDetails = includeThreadDetails;
    }

    protected String asReadableSize(Long bytes) {
        double bytesAsDouble;
        Iterator iterator = READABLE_SIZE_UNITS.iterator();
        String unit = (String)iterator.next();
        for (bytesAsDouble = bytes.doubleValue(); bytesAsDouble > 1024.0; bytesAsDouble /= 1024.0) {
            unit = (String)iterator.next();
        }
        String result = String.format("%.2f%s", bytesAsDouble, unit);
        return result;
    }

    protected String formatDuration(LocalDateTime from, LocalDateTime to) {
        long s = ChronoUnit.SECONDS.between(from, to);
        long m = ChronoUnit.MINUTES.between(from, to);
        long h = ChronoUnit.HOURS.between(from, to);
        long d = ChronoUnit.DAYS.between(from, to);
        Object result = String.format("%ds", s % 60L);
        if (m > 0L) {
            result = String.format("%dm", m % 60L) + (String)result;
        }
        if (h > 0L) {
            result = String.format("%dh", h % 24L) + (String)result;
        }
        if (d > 0L) {
            result = String.format("%dd", d) + (String)result;
        }
        return result;
    }

    protected void appendMemoryValues(StatusDto builder) {
        Runtime runtime = Runtime.getRuntime();
        long freeMemoryOnAllocated = runtime.freeMemory();
        long totalMemory = runtime.totalMemory();
        long maxMemory = runtime.maxMemory();
        long usedMemory = totalMemory - freeMemoryOnAllocated;
        double usedPercent = (double)usedMemory / (double)maxMemory * 100.0;
        long freeMemory = maxMemory - usedMemory;
        double freePercent = 100.0 - usedPercent;
        builder.setMemoryAllocated(this.asReadableSize(Long.valueOf(totalMemory)));
        builder.setMemoryUsed(String.format("%s (%.2f%s)", this.asReadableSize(Long.valueOf(usedMemory)), usedPercent, "%"));
        builder.setMemoryFree(String.format("%s (%.2f%s)", this.asReadableSize(Long.valueOf(freeMemory)), freePercent, "%"));
        builder.setMemoryMax(this.asReadableSize(Long.valueOf(maxMemory)));
    }

    protected void appendAsyncJobsValues(StatusDto builder) {
        Pair runningAndPendingTasks = this.asyncService.countRunningAndPendingTasks();
        builder.setRunningTasks(((Integer)runningAndPendingTasks.getLeft()).intValue());
        builder.setPendingTasks(((Integer)runningAndPendingTasks.getRight()).intValue());
    }

    public String execute() throws Exception {
        long statusStart = System.currentTimeMillis();
        Future pingJms = this.asyncService.pingJms();
        StatusDto result = new StatusDto();
        result.setInstance(ManagementFactory.getRuntimeMXBean().getName());
        result.setVersion(this.config.getApplicationVersion());
        result.setRevision(this.config.getApplicationRevision());
        result.setBuildDate(this.config.getApplicationBuildDate());
        result.setCurrentDate(new Date().toString());
        result.setCurrentTimeZone(TimeZone.getDefault().toString());
        result.setEncoding(System.getProperty("file.encoding"));
        String jvmName = System.getProperty("java.vm.name");
        result.setJvmName(jvmName);
        String javaVersion = System.getProperty("java.version");
        result.setJavaVersion(javaVersion);
        this.appendMemoryValues(result);
        this.appendAsyncJobsValues(result);
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        result.setAvailableProcessors(availableProcessors);
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        double systemLoadAverage = os.getSystemLoadAverage();
        result.setLoadAverage(systemLoadAverage);
        LocalDateTime startupTime = AgrosystWebApplicationContext.RUNNING_SINCE;
        String runningSince = startupTime.format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss"));
        result.setRunningSince(runningSince);
        result.setUptime(this.formatDuration(startupTime, LocalDateTime.now()));
        long permissionsCount = this.authorizationService.countPermissions();
        result.setComputedPermissions(permissionsCount);
        AbstractAgrosystAction.ActiveSessionsAndUsers sessionsAndUsers = this.computeConnectedUsersCount();
        int sessionsCount = sessionsAndUsers.sessionsCount();
        result.setActiveSessions(sessionsCount);
        int connectedUsersCount = sessionsAndUsers.uniqueUsersCount();
        result.setConnectedUsers(connectedUsersCount);
        if (pingJms.isCancelled()) {
            result.setJmsPing("N/A");
        } else {
            try {
                pingJms.get(1L, TimeUnit.SECONDS);
                result.setJmsPing("success");
            }
            catch (TimeoutException te) {
                result.setJmsPing("timeout");
            }
        }
        List threadNames = Thread.getAllStackTraces().keySet().stream().map(t -> String.format("%s (%d)", t.getName(), t.getId())).collect(Collectors.toList());
        if (this.includeThreadDetails) {
            result.setThreadNames(threadNames);
        }
        result.setThreadCount(threadNames.size());
        long statusEnd = System.currentTimeMillis();
        result.setDuration(statusEnd - statusStart);
        this.jsonData = result;
        return "success";
    }
}

