/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.admin;

import com.google.common.base.Strings;
import fr.inra.agrosyst.api.exceptions.AgrosystImportException;
import fr.inra.agrosyst.api.services.referential.ImportService;
import fr.inra.agrosyst.web.actions.admin.AbstractAdminAction;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class RunApiImport
extends AbstractAdminAction {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RunApiImport.class);
    protected transient ImportService importService;
    protected String genericClassName;
    protected Class<?> klass;
    protected String url;
    protected String apiKey;
    protected InputStream inputStream;
    protected String apiUser;
    protected String apiPasswd;

    public void setImportService(ImportService importService) {
        this.importService = importService;
    }

    public void validate() {
        if (Strings.isNullOrEmpty((String)this.genericClassName)) {
            this.addFieldError("genericClassName", "Ce champ est obligatoire");
        }
        try {
            this.klass = Class.forName(this.genericClassName);
        }
        catch (ClassNotFoundException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)e);
            }
            this.addFieldError("genericClassName", "Classe non trouv\u00e9e");
        }
        super.validate();
    }

    @Action(results={@Result(name={"success"}, type="stream", params={"contentType", "text/csv", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""}), @Result(name={"error"}, type="redirectAction", params={"namespace", "/generic", "actionName", "generic-entities-list", "genericClassName", "${genericClassName}", "importFileError", "false"})})
    public String execute() throws Exception {
        this.checkIsAdmin();
        try {
            this.inputStream = this.importService.getImportSolFromApiToCSVResult(StringUtils.trimToNull((String)this.url), StringUtils.trimToNull((String)this.apiKey), this.klass, StringUtils.trimToNull((String)this.apiUser), StringUtils.trimToNull((String)this.apiPasswd));
            if (this.inputStream == null) {
                this.notificationSupport.importError("Aucune donn\u00e9e n'a pu \u00eatre charg\u00e9e");
                return "error";
            }
        }
        catch (AgrosystImportException e) {
            LOGGER.error((Object)e.getMessage());
            this.notificationSupport.importError(e.getMessage());
            return "error";
        }
        return "success";
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getGenericClassName() {
        return this.genericClassName;
    }

    public String getFilename() {
        String filename = "Import_" + StringUtils.substringAfterLast((String)this.genericClassName, (String)".") + "_From_API.csv";
        return filename;
    }

    public void setGenericClassName(String genericClassName) {
        this.genericClassName = genericClassName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setApiUser(String apiUser) {
        this.apiUser = apiUser;
    }

    public void setApiPasswd(String apiPasswd) {
        this.apiPasswd = apiPasswd;
    }
}

