/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.admin;

import fr.inra.agrosyst.api.services.async.AsyncService;
import fr.inra.agrosyst.api.services.async.ScheduledTaskDto;
import fr.inra.agrosyst.api.services.async.TaskFilter;
import fr.inra.agrosyst.api.services.security.AgrosystAccessDeniedException;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

public class AdminTaskJson
extends AbstractJsonAction {
    private static final long serialVersionUID = 3961688540524235085L;
    private AsyncService asyncService;
    protected String filter;
    protected transient Boolean pagination = true;

    public void setPagination(Boolean pagination) {
        this.pagination = pagination;
    }

    public void setAsyncService(AsyncService asyncService) {
        this.asyncService = asyncService;
    }

    public String execute() throws Exception {
        if (this.authorizationService.isAdmin()) {
            try {
                TaskFilter taskFilter = (TaskFilter)this.getGson().fromJson(this.filter, TaskFilter.class);
                if (!this.pagination.booleanValue()) {
                    taskFilter.setAllPageSize();
                    taskFilter.setPage(0);
                } else {
                    this.writeListNbElementByPage(ScheduledTaskDto.class, taskFilter.getPageSize());
                }
                this.jsonData = this.asyncService.getRunningAndPendingTasks(taskFilter);
            }
            catch (Exception e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error((Object)"Failed to load domains list", (Throwable)e);
                }
                return "error";
            }
        } else {
            throw new AgrosystAccessDeniedException();
        }
        return "success";
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }
}

