/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions;

import com.google.common.base.MoreObjects;
import com.google.gson.Gson;
import com.opensymphony.xwork2.ActionSupport;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.DoseType;
import fr.inra.agrosyst.api.entities.EstimatingIftRules;
import fr.inra.agrosyst.api.entities.IftSeedsType;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.action.YealdUnit;
import fr.inra.agrosyst.api.entities.history.Message;
import fr.inra.agrosyst.api.entities.managementmode.SectionType;
import fr.inra.agrosyst.api.services.common.AttachmentService;
import fr.inra.agrosyst.api.services.context.NavigationContextService;
import fr.inra.agrosyst.api.services.history.MessageService;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.api.services.security.AuthenticationService;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import fr.inra.agrosyst.api.services.users.AuthenticatedUser;
import fr.inra.agrosyst.commons.gson.AgrosystGsonSupplier;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.common.AgrosystI18nService;
import fr.inra.agrosyst.services.common.CommonService;
import fr.inra.agrosyst.web.AgrosystWebApplicationContext;
import fr.inra.agrosyst.web.AgrosystWebConfig;
import fr.inra.agrosyst.web.AgrosystWebNotification;
import fr.inra.agrosyst.web.AgrosystWebNotificationSupport;
import fr.inra.agrosyst.web.CookieHelper;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import fr.inra.agrosyst.web.actions.AgrosystLayoutData;
import fr.inra.agrosyst.web.actions.RichNavigationContext;
import fr.inra.agrosyst.web.converters.LocalDateTimeHelper;
import fr.inra.agrosyst.web.listeners.AgrosystWebSessionListener;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.action.ParametersAware;
import org.apache.struts2.action.ServletRequestAware;
import org.apache.struts2.action.ServletResponseAware;
import org.apache.struts2.dispatcher.HttpParameters;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class AbstractAgrosystAction
extends ActionSupport
implements ServletRequestAware,
ServletResponseAware,
ParametersAware {
    private static final long serialVersionUID = -8765692518009997590L;
    protected static final String REQUIRED_FIELD = "common.filedValue.required";
    protected static final String NAVIGATION_CONTEXT = "NavigationContext";
    protected static final DecimalFormat df = new DecimalFormat("#.#");
    protected static final Log LOGGER = LogFactory.getLog(AbstractAgrosystAction.class);
    protected static final AgrosystLayoutData ERROR_LAYOUT_DATA = new AgrosystLayoutData();
    protected transient AgrosystWebConfig config;
    protected transient AgrosystWebNotificationSupport notificationSupport;
    protected transient AgrosystWebApplicationContext applicationContext;
    protected transient NavigationContextService navigationContextService;
    protected transient BusinessAuthorizationService authorizationService;
    protected transient MessageService messageService;
    protected transient AgrosystI18nService i18nService;
    protected transient AuthenticationService authenticationService;
    protected transient HttpServletRequest servletRequest;
    protected transient HttpServletResponse servletResponse;
    protected transient HttpParameters parameters;
    protected transient RichNavigationContext richNavigationContext;
    protected transient boolean readOnly = false;
    protected transient boolean activated = true;
    protected transient Boolean currentUserAnAdmin;
    protected transient Boolean currentUserAnIsDataProcessor;
    protected transient String currentUserLanguage;
    protected transient String baseUrl;
    protected transient AttachmentService attachmentService;
    protected transient Long attachmentCount;
    protected String lastBroadcastDate;
    protected List<Message> broacastMessages;
    private transient Gson gson;
    protected transient AgrosystLayoutData layoutData;

    public Gson getGson() {
        if (this.gson == null) {
            this.gson = new AgrosystGsonSupplier().get();
        }
        return this.gson;
    }

    public CookieHelper getCookieHelper() {
        HttpServletRequest servletRequest = this.getServletRequest();
        CookieHelper result = new CookieHelper(servletRequest, this.servletResponse, this.getConfig());
        return result;
    }

    public String toJson(Object element) {
        String result;
        block2: {
            result = null;
            try {
                result = this.getGson().toJson(element);
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error((Object)e, (Throwable)e);
            }
        }
        return result;
    }

    public Set<String> getSelectedGrowingSystemIds(String growingSystemIdsJson) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        Map managementModeDtos = (Map)this.getGson().fromJson(growingSystemIdsJson, type);
        HashSet<String> growingSystemIds = new HashSet<String>();
        if (managementModeDtos != null) {
            for (Map.Entry growingSystemIdToSelected : managementModeDtos.entrySet()) {
                if (!((Boolean)growingSystemIdToSelected.getValue()).booleanValue()) continue;
                growingSystemIds.add((String)growingSystemIdToSelected.getKey());
            }
        }
        return growingSystemIds;
    }

    public void withServletRequest(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    public void withServletResponse(HttpServletResponse servletResponse) {
        this.servletResponse = servletResponse;
    }

    public void withParameters(HttpParameters parameters) {
        this.parameters = parameters;
    }

    public final void setConfig(AgrosystWebConfig config) {
        this.config = config;
    }

    public final void setNavigationContextService(NavigationContextService navigationContextService) {
        this.navigationContextService = navigationContextService;
    }

    public final void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public final void setAuthorizationService(BusinessAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public final void setNotificationSupport(AgrosystWebNotificationSupport notificationSupport) {
        this.notificationSupport = notificationSupport;
    }

    public String getSessionId() {
        return AgrosystWebSessionListener.getSessionId((HttpServletRequest)this.getServletRequest());
    }

    protected NavigationContext getNavigationContext() {
        Optional navigationContext = this.readNavigationContextCookie();
        NavigationContext result = navigationContext.orElseGet(NavigationContext::new);
        return result;
    }

    protected NavigationContext verifyAndSaveNavigationContext(NavigationContext navigationContext) {
        NavigationContext newNavigationContext = this.navigationContextService.verify(navigationContext);
        this.writeNavigationContextCookie(newNavigationContext);
        return newNavigationContext;
    }

    protected NavigationContext navigationContextEntityCreated(TopiaEntity newEntity) {
        NavigationContext navigationContext = this.getNavigationContext();
        NavigationContext newNavigationContext = this.navigationContextService.verify(navigationContext, newEntity);
        this.writeNavigationContextCookie(newNavigationContext);
        return newNavigationContext;
    }

    protected Optional<NavigationContext> readNavigationContextCookie() {
        Optional result = this.getCookieHelper().readCookie("nav.context", cookieValue -> {
            NavigationContext parsed = (NavigationContext)this.getGson().fromJson(cookieValue, NavigationContext.class);
            return parsed;
        });
        return result;
    }

    protected void writeNavigationContextCookie(NavigationContext navigationContext) {
        this.getCookieHelper().writeCookie("nav.context", (Object)navigationContext, arg_0 -> ((Gson)this.getGson()).toJson(arg_0), false);
    }

    public RichNavigationContext getRichNavigationContext() {
        if (this.richNavigationContext == null) {
            NavigationContext navigationContext = this.getNavigationContext();
            this.richNavigationContext = new RichNavigationContext(navigationContext, this.navigationContextService);
        }
        return this.richNavigationContext;
    }

    protected Integer getListNbElementByPage(Class<?> listType) {
        return this.getListNbElementByPage(listType, "");
    }

    protected Integer getListNbElementByPage(Class<?> listType, String suffix) {
        String cookieName = "list.nbByPage." + listType.getSimpleName() + suffix;
        Optional value = this.getCookieHelper().readCookie(cookieName, Integer::valueOf);
        Integer result = value.orElseGet(() -> ((AgrosystWebConfig)this.getConfig()).getListResultsPerPage());
        return result;
    }

    protected void writeListNbElementByPage(Class<?> listType, int nbElementByPage) {
        this.writeListNbElementByPage(listType, "", nbElementByPage);
    }

    protected void writeListNbElementByPage(Class<?> listType, String suffix, int nbElementByPage) {
        String cookieName = "list.nbByPage." + listType.getSimpleName() + suffix;
        CookieHelper cookieHelper = this.getCookieHelper();
        if (nbElementByPage == this.getConfig().getListResultsPerPage()) {
            cookieHelper.deleteCookie(cookieName);
        } else {
            cookieHelper.writeCookie(cookieName, (Object)nbElementByPage, String::valueOf, true);
        }
    }

    @SafeVarargs
    protected final <T> Map<T, String> getEnumAsMap(T ... values) {
        return this.i18nService.getEnumAsMap(null, (Object[])values);
    }

    protected void initForInput() {
    }

    public Set<AgrosystWebNotification> getInfoNotifications() {
        Set notifications = this.notificationSupport.consumeInfoNotifications();
        return notifications;
    }

    public boolean isInfoNotificationsEmpty() {
        return this.notificationSupport.isInfoNotificationsEmpty();
    }

    public Set<AgrosystWebNotification> getLightBoxNotifications() {
        Set notifications = this.notificationSupport.consumeLightBoxNotifications();
        return notifications;
    }

    protected List<Message> loadBroadcastMessages(LocalDateTime fromDate) {
        List list;
        block9: {
            ServiceContext serviceContext = this.applicationContext.getApplicationContext().newServiceContext();
            try {
                List result;
                MessageService service = (MessageService)serviceContext.newService(MessageService.class);
                list = result = service.getMessagesFromDate(fromDate);
                if (serviceContext == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (serviceContext != null) {
                        try {
                            serviceContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception eee) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn((Object)"Unexpected error in ephemeral context", (Throwable)eee);
                    }
                    return new LinkedList<Message>();
                }
            }
            serviceContext.close();
        }
        return list;
    }

    public List<Message> getBroadcastMessages() {
        if (this.broacastMessages == null) {
            this.broacastMessages = Optional.ofNullable(this.lastBroadcastDate).map(LocalDateTimeHelper::urlSafeParse).map(arg_0 -> this.loadBroadcastMessages(arg_0)).orElseGet(LinkedList::new);
        }
        return this.broacastMessages;
    }

    public boolean isBroadcastMessagesEmpty() {
        return this.getBroadcastMessages().isEmpty();
    }

    public boolean getIsFirstTimeMessageRead() {
        return !this.getBroadcastMessages().isEmpty();
    }

    public void setLastBroadcastDate(String lastBroadcastDate) {
        this.lastBroadcastDate = StringUtils.trimToNull((String)StringUtils.trimToEmpty((String)lastBroadcastDate).split(", ")[0]);
    }

    public Set<AgrosystWebNotification> getWarningNotifications() {
        Set messages = this.notificationSupport.consumeWarningNotifications();
        return messages;
    }

    public boolean isWarningNotificationsEmpty() {
        return this.notificationSupport.isWarningNotificationsEmpty();
    }

    public Set<AgrosystWebNotification> getErrorNotifications() {
        Set messages = this.notificationSupport.consumeErrorNotifications();
        return messages;
    }

    public boolean isErrorNotificationsEmpty() {
        return this.notificationSupport.isErrorNotificationsEmpty();
    }

    protected Optional<AuthenticatedUser> getAuthenticatedUserOptional() {
        HttpServletRequest servletRequest = this.getServletRequest();
        AuthenticatedUser userDto = (AuthenticatedUser)servletRequest.getAttribute("authenticatedUser");
        Optional<AuthenticatedUser> result = Optional.ofNullable(userDto);
        return result;
    }

    protected AuthenticatedUser getAuthenticatedUser() {
        AuthenticatedUser result = (AuthenticatedUser)this.getAuthenticatedUserOptional().orElseThrow(() -> new IllegalStateException("AuthenticatedUser manquant"));
        return result;
    }

    public boolean isCurrentUserAnAdmin() {
        if (this.currentUserAnAdmin == null) {
            this.currentUserAnAdmin = this.getAuthenticatedUserOptional().map(AuthenticatedUser::isAdmin).orElse(false);
        }
        return this.currentUserAnAdmin;
    }

    public boolean isCurrentUserAnIsDataProcessor() {
        if (this.currentUserAnIsDataProcessor == null) {
            this.currentUserAnAdmin = this.getAuthenticatedUserOptional().map(AuthenticatedUser::isISDataProcessor).orElse(false);
        }
        return this.currentUserAnIsDataProcessor;
    }

    public String getCurrentUserLanguage() {
        if (this.currentUserLanguage == null) {
            this.currentUserLanguage = this.getAuthenticatedUserOptional().map(AuthenticatedUser::getLocale).map(Locale::getLanguage).orElse(Locale.FRANCE.getLanguage());
        }
        return this.currentUserLanguage;
    }

    public String getBaseUrl() {
        if (this.baseUrl == null) {
            this.baseUrl = this.getConfig().getBaseUrl();
        }
        return this.baseUrl;
    }

    public long getAttachmentCount(String codeOrId) {
        if (this.attachmentCount == null) {
            this.attachmentCount = this.attachmentService.getAttachmentMetadatasCount(codeOrId);
        }
        return this.attachmentCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgrosystLayoutData initLayoutData() {
        AgrosystLayoutData result;
        block19: {
            HttpServletRequest servletRequest = this.getServletRequest();
            String bannerName = null;
            try {
                Optional authenticatedUser;
                Map emailsByCategoryAndTypeDephyAndSector;
                boolean isDp;
                boolean admin;
                AgrosystLayoutData instance;
                block20: {
                    if (this.layoutData != null) break block19;
                    Object locLayoutData = servletRequest.getAttribute("layoutData");
                    instance = locLayoutData == null ? new AgrosystLayoutData() : (AgrosystLayoutData)locLayoutData;
                    admin = false;
                    isDp = false;
                    emailsByCategoryAndTypeDephyAndSector = Map.of();
                    try (ServiceContext serviceContext = this.applicationContext.getApplicationContext().newServiceContext();){
                        ReferentialService referentialService = (ReferentialService)serviceContext.newService(ReferentialService.class);
                        emailsByCategoryAndTypeDephyAndSector = referentialService.getAllEmailsByCategoryAndTypeDephyAndSector();
                    }
                    catch (Exception eee) {
                        if (!LOGGER.isWarnEnabled()) break block20;
                        LOGGER.warn((Object)"Unexpected error in ephemeral context", (Throwable)eee);
                    }
                }
                if ((authenticatedUser = this.getAuthenticatedUserOptional()).isPresent()) {
                    instance.setCurrentUserLastName(((AuthenticatedUser)authenticatedUser.get()).getLastName());
                    instance.setCurrentUserFirstName(((AuthenticatedUser)authenticatedUser.get()).getFirstName());
                    instance.setCurrentUserItEmail((String)((AuthenticatedUser)authenticatedUser.get()).getItEmail().orElse(null));
                    instance.setCurrentUserLanguage(((AuthenticatedUser)authenticatedUser.get()).getLanguage());
                    admin = ((AuthenticatedUser)authenticatedUser.get()).isAdmin();
                    isDp = ((AuthenticatedUser)authenticatedUser.get()).isISDataProcessor();
                    instance.setNavigationContext(this.getNavigationContext());
                    instance.setCampaigns(this.getRichNavigationContext().getCampaigns());
                    instance.setNetworks(this.getRichNavigationContext().getNetworks());
                    instance.setDomains(this.getRichNavigationContext().getDomains());
                    instance.setGrowingPlans(this.getRichNavigationContext().getGrowingPlans());
                    instance.setGrowingSystems(this.getRichNavigationContext().getGrowingSystems());
                    instance.setEmailsByCategoryAndTypeDephyAndSector(emailsByCategoryAndTypeDephyAndSector);
                    bannerName = ((AuthenticatedUser)authenticatedUser.get()).getBanner().orElse(null);
                }
                instance.setCurrentUserAnAdmin(admin);
                instance.setCurrentUserAnIsDataProcessor(isDp);
                this.layoutData = instance;
            }
            catch (Exception eee) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error((Object)"Unable to compute layoutData: ", (Throwable)eee);
                }
            }
            finally {
                result = (AgrosystLayoutData)MoreObjects.firstNonNull((Object)this.layoutData, (Object)ERROR_LAYOUT_DATA);
                if (this.applicationContext != null) {
                    String[] bannerData;
                    Map bannersMap = this.applicationContext.getBannersMap();
                    if (!bannersMap.containsKey(bannerName)) {
                        bannerName = "Photo_F_Liagre";
                    }
                    if ((bannerData = (String[])bannersMap.get(bannerName)) != null) {
                        result.setCurrentUserBannerPath(bannerData[0]);
                        result.setCurrentUserBannerMeta(bannerData[1]);
                    }
                }
                if (servletRequest != null) {
                    servletRequest.setAttribute("layoutData", (Object)result);
                }
            }
        }
        return result;
    }

    public AgrosystLayoutData getLayoutData() {
        if (this.layoutData == null) {
            this.layoutData = this.initLayoutData();
        }
        return this.layoutData;
    }

    protected String getServletInfo() {
        HttpServletRequest httpServletRequest = this.getServletRequest();
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        StringBuilder headers = new StringBuilder();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            headers.append(String.format("[%s=%s] ", name, httpServletRequest.getHeader(name)));
        }
        return String.format("Requested URL is: %s ; headers are: %s", httpServletRequest.getRequestURL(), headers.toString().trim());
    }

    public Map<YealdUnit, String> getYealdUnits() {
        Map enumTranslationMap = this.i18nService.getEnumTranslationMap(YealdUnit.class);
        return enumTranslationMap;
    }

    protected HttpServletRequest getServletRequest() {
        if (this.servletRequest == null) {
            HttpServletRequest httpServletRequest = ServletActionContext.getRequest();
            this.withServletRequest(httpServletRequest);
        }
        return this.servletRequest;
    }

    public String getVersionSuffix() {
        String version = this.config.getApplicationVersion();
        return String.format("?v=%s", version);
    }

    public void setV(String v) {
    }

    public Map<EstimatingIftRules, String> getEstimatingIftRules() {
        return this.getEnumAsMap((Object[])EstimatingIftRules.values());
    }

    public Map<IftSeedsType, String> getIftSeedsTypes() {
        return this.getEnumAsMap((Object[])IftSeedsType.values());
    }

    public Map<DoseType, String> getDoseTypes() {
        return this.getEnumAsMap((Object[])DoseType.values());
    }

    protected String getLogEntityId(TopiaEntity te) {
        return te != null && te.getTopiaId() != null ? te.getTopiaId() : "?";
    }

    public Pair<Integer, Integer> getCampaignsBounds() {
        return CommonService.getInstance().getCampaignsBounds();
    }

    @Deprecated
    public Map<Sector, String> getSectors() {
        return this.getEnumAsMap((Object[])Sector.values());
    }

    @Deprecated
    public Map<SectionType, String> getSectionTypes() {
        return this.getEnumAsMap((Object[])SectionType.values());
    }

    public boolean isErrors() {
        return this.hasErrors();
    }

    protected void refreshAuthenticatedUser() {
        Optional authenticatedUserOptional = this.getAuthenticatedUserOptional();
        if (authenticatedUserOptional.isPresent()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Demande explicite pour rafra\u00eechir le token");
            }
            AuthenticatedUser authenticatedUser = this.authenticationService.reloadAuthenticatedUser();
            this.applicationContext.writeAuthenticationCookie(authenticatedUser, this.getCookieHelper());
        }
    }

    protected ActiveSessionsAndUsers computeConnectedUsersCount() {
        Map sessions = this.applicationContext.getSessionsCache();
        int activeSessions = sessions.keySet().size();
        int uniqueUsers = new HashSet(sessions.values()).size();
        ActiveSessionsAndUsers result = new ActiveSessionsAndUsers(activeSessions, uniqueUsers);
        return result;
    }

    public void addActionError(String anErrorMessage) {
        if (!super.getActionErrors().contains(anErrorMessage)) {
            super.addActionError(anErrorMessage);
        }
    }

    public void addActionMessage(String anErrorMessage) {
        if (!super.getActionMessages().contains(anErrorMessage)) {
            super.addActionMessage(anErrorMessage);
        }
    }

    public void addFieldError(String fieldName, String errorMessage) {
        if (!super.getFieldErrors().containsKey(fieldName)) {
            super.addFieldError(fieldName, errorMessage);
        }
    }

    @Generated
    public AgrosystWebConfig getConfig() {
        return this.config;
    }

    @Generated
    public AgrosystWebNotificationSupport getNotificationSupport() {
        return this.notificationSupport;
    }

    @Generated
    public AgrosystWebApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Generated
    public NavigationContextService getNavigationContextService() {
        return this.navigationContextService;
    }

    @Generated
    public BusinessAuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    @Generated
    public MessageService getMessageService() {
        return this.messageService;
    }

    @Generated
    public AgrosystI18nService getI18nService() {
        return this.i18nService;
    }

    @Generated
    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    @Generated
    public HttpServletResponse getServletResponse() {
        return this.servletResponse;
    }

    @Generated
    public HttpParameters getParameters() {
        return this.parameters;
    }

    @Generated
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Generated
    public boolean isActivated() {
        return this.activated;
    }

    @Generated
    public Boolean getCurrentUserAnAdmin() {
        return this.currentUserAnAdmin;
    }

    @Generated
    public Boolean getCurrentUserAnIsDataProcessor() {
        return this.currentUserAnIsDataProcessor;
    }

    @Generated
    public AttachmentService getAttachmentService() {
        return this.attachmentService;
    }

    @Generated
    public Long getAttachmentCount() {
        return this.attachmentCount;
    }

    @Generated
    public String getLastBroadcastDate() {
        return this.lastBroadcastDate;
    }

    @Generated
    public List<Message> getBroacastMessages() {
        return this.broacastMessages;
    }

    @Generated
    public void setApplicationContext(AgrosystWebApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Generated
    public void setI18nService(AgrosystI18nService i18nService) {
        this.i18nService = i18nService;
    }

    @Generated
    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @Generated
    public void setServletRequest(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    @Generated
    public void setServletResponse(HttpServletResponse servletResponse) {
        this.servletResponse = servletResponse;
    }

    @Generated
    public void setParameters(HttpParameters parameters) {
        this.parameters = parameters;
    }

    @Generated
    public void setRichNavigationContext(RichNavigationContext richNavigationContext) {
        this.richNavigationContext = richNavigationContext;
    }

    @Generated
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Generated
    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    @Generated
    public void setCurrentUserAnAdmin(Boolean currentUserAnAdmin) {
        this.currentUserAnAdmin = currentUserAnAdmin;
    }

    @Generated
    public void setCurrentUserAnIsDataProcessor(Boolean currentUserAnIsDataProcessor) {
        this.currentUserAnIsDataProcessor = currentUserAnIsDataProcessor;
    }

    @Generated
    public void setCurrentUserLanguage(String currentUserLanguage) {
        this.currentUserLanguage = currentUserLanguage;
    }

    @Generated
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Generated
    public void setAttachmentService(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    @Generated
    public void setAttachmentCount(Long attachmentCount) {
        this.attachmentCount = attachmentCount;
    }

    @Generated
    public void setBroacastMessages(List<Message> broacastMessages) {
        this.broacastMessages = broacastMessages;
    }

    @Generated
    public void setGson(Gson gson) {
        this.gson = gson;
    }

    @Generated
    public void setLayoutData(AgrosystLayoutData layoutData) {
        this.layoutData = layoutData;
    }

    static {
        ERROR_LAYOUT_DATA.setCurrentUserAnAdmin(false);
        ERROR_LAYOUT_DATA.setCurrentUserFirstName("#Error!");
        ERROR_LAYOUT_DATA.setCurrentUserLastName("#Error!");
        ERROR_LAYOUT_DATA.setNavigationContext(new NavigationContext());
    }
}

