/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.filters;

import fr.inra.agrosyst.web.listeners.AgrosystWebSessionListener;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.dispatcher.filter.StrutsExecuteFilter;

public class StrutsExecuteMonitorFilter
extends StrutsExecuteFilter {
    private static final Log LOGGER = LogFactory.getLog(StrutsExecuteMonitorFilter.class);

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        long start = System.currentTimeMillis();
        super.doFilter(req, res, chain);
        if (LOGGER.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            HttpServletRequest httpServletRequest = (HttpServletRequest)req;
            HttpServletResponse httpServletResponse = (HttpServletResponse)res;
            String sid = AgrosystWebSessionListener.getSessionId((HttpServletRequest)httpServletRequest);
            String method = httpServletRequest.getMethod();
            String requested = httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length());
            int status = httpServletResponse.getStatus();
            String queryString = httpServletRequest.getQueryString();
            Object format = "[sid=%s] %s %s %dms [%d%s]";
            if (StringUtils.isNotEmpty((CharSequence)queryString)) {
                format = (String)format + " {%s}";
            }
            String location = Optional.ofNullable(httpServletResponse.getHeader("Location")).map(l -> " -> " + l).orElse("");
            String message = String.format((String)format, sid, method, requested, end - start, status, location, queryString);
            LOGGER.debug((Object)message);
        }
    }
}

