/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.reports;

import fr.inra.agrosyst.api.services.report.ReportService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import java.util.List;
import java.util.stream.Collectors;

public class ReportGrowingSystemExportXlsAsync
extends AbstractJsonAction {
    private static final long serialVersionUID = 8686993981231582811L;
    protected transient ReportService reportService;
    protected List<String> reportGrowingSystemIds;

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setReportGrowingSystemIds(String reportGrowingSystemIds) {
        this.reportGrowingSystemIds = (List)this.getGson().fromJson(reportGrowingSystemIds, List.class);
    }

    public String execute() throws Exception {
        List safeReportGrowingSystemIds = this.reportGrowingSystemIds.stream().filter(reportGrowingSystemId -> {
            try {
                this.authorizationService.checkReportGrowingSystemReadable(reportGrowingSystemId);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }).collect(Collectors.toList());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.debug((Object)String.format("Export asynchrone XLS de %d bilans de campagne SDC", safeReportGrowingSystemIds.size()));
        }
        this.reportService.exportXlsReportGrowingSystemsAsync(safeReportGrowingSystemIds);
        return "success";
    }
}

