/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.practiced;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.services.domain.CroppingPlans;
import fr.inra.agrosyst.api.services.domain.inputStock.DomainInputStockUnitService;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.practiced.CropCycleModelDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.services.common.CommonService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;

public class PracticedSystemsEditJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(PracticedSystemsEditJson.class);
    private static final long serialVersionUID = 4385936088893971371L;
    public static final String GS_NOT_FOUND = "NOT_FOUND";
    protected transient PracticedSystemService practicedSystemService;
    protected transient GrowingSystemService growingSystemService;
    protected transient DomainInputStockUnitService domainInputStockUnitService;
    protected String growingSystemId;
    protected String campaigns;

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setDomainInputStockUnitService(DomainInputStockUnitService domainInputStockUnitService) {
        this.domainInputStockUnitService = domainInputStockUnitService;
    }

    public void setGrowingSystemId(String growingSystemId) {
        this.growingSystemId = growingSystemId;
    }

    public void setCampaigns(String campaigns) {
        this.campaigns = campaigns;
    }

    @Action(value="practiced-systems-crops-tools-json")
    public String execute() {
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            boolean are_campaigns_valids = CommonService.getInstance().areCampaignsValids(this.campaigns);
            data.put("areValidCampaigns", are_campaigns_valids);
            if (are_campaigns_valids) {
                Domain originalDomain;
                Set practicedSystemCampaigns = (Set)CommonService.GET_CAMPAIGNS_SET.apply(this.campaigns);
                GrowingSystem practicedSystemSelectedGrowingSystem = this.growingSystemService.getGrowingSystem(this.growingSystemId);
                Domain toDomain = originalDomain = practicedSystemSelectedGrowingSystem.getGrowingPlan().getDomain();
                if (!practicedSystemCampaigns.contains(originalDomain.getCampaign())) {
                    GrowingSystem sameCodeGrowingSystemReplacement = this.growingSystemService.getLastGrowingSystemForCampaigns(practicedSystemSelectedGrowingSystem.getCode(), practicedSystemCampaigns);
                    if (sameCodeGrowingSystemReplacement != null) {
                        toDomain = sameCodeGrowingSystemReplacement.getGrowingPlan().getDomain();
                        data.put("practicedSystemGrowingSystemReplacement", sameCodeGrowingSystemReplacement.getTopiaId());
                    } else {
                        data.put("practicedSystemGrowingSystemReplacement", GS_NOT_FOUND);
                        practicedSystemCampaigns.add(originalDomain.getCampaign());
                        this.campaigns = (String)CommonService.ARRANGE_CAMPAIGNS_SET.apply(practicedSystemCampaigns);
                    }
                }
                Map modelToSpecies = this.practicedSystemService.getCropCycleModelMap(this.growingSystemId, true);
                Set croppingPlanEntryDtos = modelToSpecies.keySet();
                Iterable modelMain = Iterables.filter(croppingPlanEntryDtos, CroppingPlans.IS_NOT_INTERMEDIATE::test);
                data.put("practicedSystemMainCropCycleModels", Lists.newArrayList((Iterable)modelMain));
                Iterable modelIntermediate = Iterables.filter(croppingPlanEntryDtos, CroppingPlans.IS_INTERMEDIATE::test);
                data.put("practicedSystemIntermediateCropCycleModels", Lists.newArrayList((Iterable)modelIntermediate));
                HashMap<String, List> croppingPlanEntryCodesToSpecies = new HashMap<String, List>();
                for (Map.Entry entry : modelToSpecies.entrySet()) {
                    croppingPlanEntryCodesToSpecies.put(((CropCycleModelDto)entry.getKey()).getCroppingPlanEntryCode(), (List)entry.getValue());
                }
                data.put("croppingPlanEntryCodesToSpecies", croppingPlanEntryCodesToSpecies);
                data.put("domainCode", this.practicedSystemService.getDomainCode(this.growingSystemId));
                data.put("sector", this.growingSystemService.getGrowingSystemSector(this.growingSystemId));
                data.put("isOrganic", this.growingSystemService.isOrganicGrowingSystem(this.growingSystemId));
                NavigationContext navigationContext = this.getNavigationContext();
                data.put("growingSystemCampaigns", this.growingSystemService.getGrowingSystemCampaignsFromId(this.growingSystemId, navigationContext));
                data.put("campaigns", CommonService.ARRANGE_CAMPAIGNS.apply(this.campaigns));
                data.put("cattles", this.practicedSystemService.getAllCampaignsGrowingSystemRelatedCattles(this.growingSystemId, (Set)CommonService.GET_CAMPAIGNS_SET.apply(this.campaigns)));
                data.put("domainInputsByCodes", this.domainInputStockUnitService.loadDomainInputStockDtoByCodes(toDomain.getTopiaId()));
            }
            this.jsonData = data;
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load practiced System crops-tools for growingSystemId '%s' and campaigns '%s'", this.growingSystemId, this.campaigns), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }
}

