/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.growingplans;

import com.google.common.base.Strings;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingPlanImpl;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.Preparable;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.topia.persistence.TopiaEntity;

public class GrowingPlansEdit
extends AbstractAgrosystAction
implements Preparable {
    private static final Log LOGGER = LogFactory.getLog(GrowingPlan.class);
    private static final long serialVersionUID = 2811409038914984468L;
    protected transient DomainService domainService;
    protected transient GrowingPlanService growingPlanService;
    protected String growingPlanTopiaId;
    protected GrowingPlan growingPlan;
    protected LinkedHashMap<Integer, String> relatedGrowingPlans;
    protected String domainId;
    protected List<GrowingSystem> growingSystems;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    public void setGrowingPlanTopiaId(String growingPlanTopiaId) {
        this.growingPlanTopiaId = growingPlanTopiaId;
    }

    public GrowingPlan getGrowingPlan() {
        return Objects.requireNonNullElseGet(this.growingPlan, GrowingPlanImpl::new);
    }

    public void prepare() {
        if (StringUtils.isNotBlank((CharSequence)this.growingPlanTopiaId)) {
            this.authorizationService.checkGrowingPlanReadable(this.growingPlanTopiaId);
            boolean bl = this.readOnly = !this.authorizationService.isGrowingPlanWritable(this.growingPlanTopiaId);
            if (this.readOnly) {
                this.notificationSupport.growingPlanNotWritable();
            }
            this.growingPlan = this.growingPlanService.getGrowingPlan(this.growingPlanTopiaId);
            this.activated = this.growingPlan.isActive() && this.growingPlan.getDomain().isActive();
        } else {
            this.growingPlan = this.growingPlanService.newGrowingPlan();
        }
    }

    @Action(value="growing-plans-edit-input")
    public String input() throws Exception {
        this.initForInput();
        return "input";
    }

    protected void initForInput() {
        if (this.getGrowingPlan().getTopiaId() != null) {
            this.relatedGrowingPlans = this.growingPlanService.getRelatedGrowingPlans(this.getGrowingPlan().getCode());
            this.growingSystems = this.growingPlanService.getGrowingPlanGrowingSystems(this.getGrowingPlan().getTopiaId());
        }
    }

    public void validate() {
        if (this.growingPlan.isPersisted() && !this.activated) {
            this.addActionError("Le disposistif et/ou son domain sont inactifs !");
        }
        if (StringUtils.isBlank((CharSequence)this.getGrowingPlan().getTopiaId()) && StringUtils.isBlank((CharSequence)this.domainId)) {
            this.addFieldError("domainId", this.getText("common.filedValue.required"));
        }
        if (StringUtils.isBlank((CharSequence)this.growingPlan.getName())) {
            this.addFieldError("growingPlan.name", this.getText("common.filedValue.required"));
        }
        if (this.growingPlan.getType() == null) {
            this.addFieldError("growingPlan.type", this.getText("common.filedValue.required"));
        }
        if (this.hasErrors()) {
            if (LOGGER.isErrorEnabled()) {
                String growingPlanId = this.getLogEntityId((TopiaEntity)this.growingPlan);
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":validate, action errors : gp:'%s' -> %s", growingPlanId, this.getActionErrors().toString()));
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":validate, fields errors : gp:'%s' -> %s", growingPlanId, this.getFieldErrors().toString()));
            }
            this.initForInput();
        }
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "growing-plans-edit-input", "growingPlanTopiaId", "${growingPlan.topiaId}"})})
    public String execute() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.getGrowingPlan().getTopiaId())) {
            Domain domain = this.domainService.getDomain(this.domainId);
            this.growingPlan.setDomain(domain);
        }
        this.growingPlan = this.growingPlanService.createOrUpdateGrowingPlan(this.growingPlan);
        this.notificationSupport.growingPlanSaved(this.growingPlan);
        if (Strings.isNullOrEmpty((String)this.growingPlanTopiaId)) {
            this.navigationContextEntityCreated((TopiaEntity)this.growingPlan);
        }
        return "success";
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public Map<TypeDEPHY, String> getTypesDephy() {
        return this.getEnumAsMap((Object[])new TypeDEPHY[]{TypeDEPHY.DEPHY_FERME, TypeDEPHY.DEPHY_EXPE, TypeDEPHY.NOT_DEPHY});
    }

    public LinkedHashMap<Integer, String> getRelatedGrowingPlans() {
        return this.relatedGrowingPlans;
    }

    public List<GrowingSystem> getGrowingSystems() {
        return this.growingSystems;
    }
}

