/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.effective;

import fr.inra.agrosyst.api.services.effective.CopyEffectiveInterventionToZoneResult;
import fr.inra.agrosyst.api.services.effective.CopyStatus;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.effective.EffectiveInterventionDto;
import fr.inra.agrosyst.api.services.effective.TargetedZones;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import fr.inra.agrosyst.web.actions.effective.EffectiveInterventionsCopy;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class EffectiveInterventionsCopy
extends AbstractJsonAction {
    private static final long serialVersionUID = 1L;
    protected transient List<TargetedZones> targetedZones;
    protected transient List<EffectiveInterventionDto> interventionDtos;
    protected transient EffectiveCropCycleService service;

    public String execute() throws Exception {
        if (this.targetedZones != null) {
            Collection result = this.service.copyInterventions(this.targetedZones, this.interventionDtos);
            this.jsonData = new EffectiveInterventionsCopyResult(String.join((CharSequence)"\\d", result.stream().map(CopyEffectiveInterventionToZoneResult::toString).toList()), result.stream().anyMatch(ir -> ir.getCopyStatus() == CopyStatus.FAILED) ? CopyStatus.FAILED : (result.stream().anyMatch(ir -> ir.getCopyStatus() == CopyStatus.PARTIAL) ? CopyStatus.PARTIAL : CopyStatus.SUCCESS), result);
            Set excludedInputs = result.stream().map(CopyEffectiveInterventionToZoneResult::getExcludedInputs).flatMap(Collection::stream).collect(Collectors.toSet());
            if (!excludedInputs.isEmpty()) {
                String names = excludedInputs.stream().map(input -> String.format("'%s'", input.getInputName())).collect(Collectors.joining(", "));
                if (excludedInputs.size() > 1) {
                    this.notificationSupport.warning(String.format("Les usages des intrants %s n'ont pas \u00e9t\u00e9 copi\u00e9s car leurs unit\u00e9s d'application ne sont pas autoris\u00e9es.", names), new Object[0]);
                } else {
                    this.notificationSupport.warning(String.format("L'usage de l'intrant %s n'a pas \u00e9t\u00e9 copi\u00e9 car son unit\u00e9 d'application n'est pas autoris\u00e9e.", names), new Object[0]);
                }
            }
            return "success";
        }
        this.jsonData = true;
        return "error";
    }

    public void setInterventionDtos(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.interventionDtos = (List)this.getGson().fromJson(json, type);
    }

    public void setTargetedZones(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.targetedZones = (List)this.getGson().fromJson(json, type);
    }

    @Generated
    public void setService(EffectiveCropCycleService service) {
        this.service = service;
    }
}

