/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.domains;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.services.domain.DomainExtendException;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.topia.persistence.TopiaEntity;

public class DomainsExtend
extends AbstractAgrosystAction {
    private static final Log LOGGER = LogFactory.getLog(DomainsExtend.class);
    private static final long serialVersionUID = 2031204987636332755L;
    protected transient DomainService domainService;
    protected String domainIds;
    protected int extendCampaign;
    protected Domain domain;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setDomainIds(String domainIds) {
        List list = (List)this.getGson().fromJson(domainIds, List.class);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.domainIds = (String)list.getFirst();
        }
    }

    public void setExtendCampaign(int extendCampaign) {
        this.extendCampaign = extendCampaign;
    }

    @Action(results={@Result(name={"success"}, type="redirectAction", params={"actionName", "domains-edit-input", "domainTopiaId", "${domain.topiaId}"}), @Result(name={"error"}, type="redirectAction", params={"actionName", "domains-list"})})
    public String execute() throws Exception {
        try {
            Pair result = this.domainService.extendDomain(this.domainIds, this.extendCampaign);
            this.domain = (Domain)result.getLeft();
            this.navigationContextEntityCreated((TopiaEntity)this.domain);
            if (!((List)result.getRight()).isEmpty()) {
                String names = ((List)result.getRight()).stream().map(input -> String.format("'%s'", input.getInputName())).collect(Collectors.joining(", "));
                if (((List)result.getRight()).size() > 1) {
                    this.notificationSupport.domainExtendWarning(String.format("Les intrants %s n'ont pas \u00e9t\u00e9 prolong\u00e9s, car leurs unit\u00e9s d'application ne sont pas autoris\u00e9es.", names));
                } else {
                    this.notificationSupport.domainExtendWarning(String.format("L'intrant %s n'a pas \u00e9t\u00e9 prolong\u00e9, car son unit\u00e9 d'application n'est pas autoris\u00e9e.", names));
                }
            }
        }
        catch (DomainExtendException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)("For user email:" + this.getAuthenticatedUser().getEmail() + ":failed to extends domains '" + this.domainIds + "' to campaigns: " + this.extendCampaign + ", the domain must exists for this campaign !"), (Throwable)e);
            }
            this.notificationSupport.domainExtendError(String.format("Ce domaine existe d\u00e9j\u00e0 en %d. La prolongation sur cette campagne n'est pas autoris\u00e9e.", this.extendCampaign));
            return "error";
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":\u00c9chec de prolongation du domaine '%s' campagne: '%d'", this.domainIds, this.extendCampaign), (Throwable)e);
            }
            this.notificationSupport.domainExtendError("\u00c9chec de prolongation du domaine. " + e.getMessage());
            return "error";
        }
        Domain duplicatedDomain = this.domainService.getDomain(this.domainIds);
        this.notificationSupport.info("Domaine \"" + duplicatedDomain.getName() + "\" (" + duplicatedDomain.getCampaign() + ") prolong\u00e9 en " + this.domain.getCampaign(), new Object[0]);
        return "success";
    }

    public Domain getDomain() {
        return this.domain;
    }
}

