/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.domains;

import fr.inra.agrosyst.api.entities.Equipment;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DomainMaterielsCopy
extends AbstractJsonAction {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(DomainMaterielsCopy.class);
    protected transient String fromDomain;
    protected transient String toDomains;
    protected transient Boolean includeToolsCouplings;
    protected transient List<Equipment> equipments;
    protected transient List<ToolsCoupling> toolsCouplings;
    protected transient DomainService domainService;
    protected transient boolean forceCopy;

    public String execute() throws Exception {
        try {
            List targetedDomainIds = this.getTargetedDomainIds(this.toDomains);
            this.jsonData = this.domainService.copyTools(this.fromDomain, targetedDomainIds, this.includeToolsCouplings, this.equipments, this.toolsCouplings, Boolean.valueOf(this.forceCopy));
            return "success";
        }
        catch (IllegalArgumentException e) {
            this.jsonData = e.getClass().getSimpleName();
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("copy tools from domain '%s' to domains '%s' failed", this.fromDomain, this.toDomains), (Throwable)e);
            }
            return "error";
        }
        catch (Exception e) {
            return "error";
        }
    }

    public void setFromDomain(String fromDomain) {
        this.fromDomain = fromDomain;
    }

    public void setIncludeToolsCouplings(Boolean includeToolsCouplings) {
        this.includeToolsCouplings = includeToolsCouplings;
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setToDomains(String json) {
        this.toDomains = json;
    }

    public void setForceCopy(boolean forceCopy) {
        this.forceCopy = forceCopy;
    }

    protected List<String> getTargetedDomainIds(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        List targetedDomains = (List)this.getGson().fromJson(json, type);
        return targetedDomains;
    }

    public void setEquipmentsJson(String json) {
        block2: {
            try {
                Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
                this.equipments = (List)this.getGson().fromJson(json, type);
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error((Object)("Echec de d\u00e9serialisation des \u00e9quipements: '" + json + "' :" + e.getMessage()));
            }
        }
    }

    public void setToolsCouplingsJson(String json) {
        block2: {
            try {
                Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
                this.toolsCouplings = (List)this.getGson().fromJson(json, type);
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error((Object)("Echec de d\u00e9serialisation des combinaisons d'outils: '" + json + "' :" + e.getMessage()));
            }
        }
    }
}

