/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.admin;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.entities.security.TrackedEvent;
import fr.inra.agrosyst.api.entities.security.TrackedEventType;
import fr.inra.agrosyst.api.services.security.TrackedEventFilter;
import fr.inra.agrosyst.api.services.security.TrackerService;
import fr.inra.agrosyst.api.services.security.UserRoleDto;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.Users;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import fr.inra.agrosyst.web.actions.admin.TrackedEventDto;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.nuiton.util.pagination.PaginationParameter;
import org.nuiton.util.pagination.PaginationResult;

public class TrackedEventsListJson
extends AbstractJsonAction {
    protected static final Function<UserRoleDto, RoleType> GET_ROLE_TYPE = UserRoleDto::getType;
    private static final long serialVersionUID = 8970357227857428597L;
    protected transient String filter;
    protected transient TrackerService trackerService;

    public void setTrackerService(TrackerService trackerService) {
        this.trackerService = trackerService;
    }

    protected Function<TrackedEvent, @Nullable TrackedEventDto> getEventToDtoFunction() {
        return input -> {
            TrackedEventDto result = new TrackedEventDto();
            result.setType(input.getType());
            String logKey = TrackedEvent.class.getName() + "." + String.valueOf(input.getType());
            String logFormat = this.getText(logKey);
            Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
            List argsList = (List)this.getGson().fromJson(input.getArgs(), type);
            if (TrackedEventType.USER_ACTIVATION.equals((Object)input.getType())) {
                action = "true".equals(argsList.get(1)) ? "Activation" : "D\u00e9sactivation";
                argsList = Lists.newArrayList((Object[])new String[]{action, (String)argsList.get(0)});
            } else if (TrackedEventType.USER_MOD.equals((Object)input.getType()) || TrackedEventType.USER_MOD_SELF.equals((Object)input.getType())) {
                action = "true".equals(argsList.get(1)) ? "avec" : "sans";
                argsList = Lists.newArrayList((Object[])new String[]{(String)argsList.get(0), action});
            } else if (TrackedEventType.USER_ROLE_ADD.equals((Object)input.getType()) || TrackedEventType.USER_ROLE_REMOVE.equals((Object)input.getType())) {
                RoleType roleType = RoleType.valueOf((String)((String)argsList.get(0)));
                String role = this.getText(RoleType.class.getName() + "." + roleType.name());
                argsList.set(0, role);
                if (RoleType.DOMAIN_RESPONSIBLE.equals((Object)roleType)) {
                    logFormat = this.getText(logKey + ".long");
                    argsList.add(1, "domaine");
                } else if (RoleType.GROWING_PLAN_RESPONSIBLE.equals((Object)roleType)) {
                    logFormat = this.getText(logKey + ".long");
                    argsList.add(1, "dispositif");
                } else if (RoleType.GS_DATA_PROCESSOR.equals((Object)roleType)) {
                    logFormat = this.getText(logKey + ".long");
                    argsList.add(1, "syst\u00e8me de culture");
                } else if (RoleType.NETWORK_RESPONSIBLE.equals((Object)roleType) || RoleType.NETWORK_SUPERVISOR.equals((Object)roleType)) {
                    logFormat = this.getText(logKey + ".medium");
                    argsList.add(1, "r\u00e9seau");
                }
            }
            String log = String.format(logFormat, argsList.toArray());
            result.setDate(input.getDate());
            result.setLog(log);
            result.setAuthor((UserDto)Users.TO_USER_DTO.apply(input.getAuthor()));
            HashMap rolesCache = new HashMap();
            if (input.getAuthor() != null && result.getAuthor() != null) {
                Set userRoles = this.getUserRoles(rolesCache, input.getAuthor().getTopiaId());
                result.getAuthor().setRoles((Set)ImmutableSet.copyOf((Collection)userRoles));
            }
            return result;
        };
    }

    protected Set<RoleType> getUserRoles(Map<String, Set<RoleType>> rolesCache, String userId) {
        if (!rolesCache.containsKey(userId)) {
            List userRoles = this.authorizationService.getUserRoles(userId);
            Set roles = userRoles.stream().map(GET_ROLE_TYPE).collect(Collectors.toSet());
            rolesCache.put(userId, roles);
        }
        return rolesCache.get(userId);
    }

    public String execute() throws Exception {
        this.checkIsAdmin();
        TrackedEventFilter trackedEventFilter = null;
        if (StringUtils.isNotBlank((CharSequence)this.filter)) {
            trackedEventFilter = (TrackedEventFilter)this.getGson().fromJson(this.filter, TrackedEventFilter.class);
            this.writeListNbElementByPage(TrackedEvent.class, trackedEventFilter.getPageSize());
        }
        PaginationResult trackedEvents = this.trackerService.list(trackedEventFilter);
        List dtos = trackedEvents.getElements().stream().map(this.getEventToDtoFunction()).collect(Collectors.toList());
        this.jsonData = PaginationResult.of(dtos, (long)trackedEvents.getCount(), (PaginationParameter)trackedEvents.getCurrentPage());
        return "success";
    }

    protected void checkIsAdmin() {
        this.authorizationService.checkIsAdmin();
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }
}

