/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.admin;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.async.AsyncService;
import fr.inra.agrosyst.api.services.async.ScheduledTaskDto;
import fr.inra.agrosyst.api.services.async.TaskFilter;
import fr.inra.agrosyst.api.services.security.AgrosystAccessDeniedException;
import fr.inra.agrosyst.web.actions.admin.AbstractAdminAction;
import org.nuiton.util.pagination.PaginationResult;

public class AdminTaskAction
extends AbstractAdminAction {
    private static final long serialVersionUID = 3961688540524235085L;
    private AsyncService asyncService;
    protected boolean admin;
    protected PaginationResult<ScheduledTaskDto> runningAndPendingTasks;
    protected TaskFilter filter;
    protected transient Boolean pagination = true;

    public void setPagination(Boolean pagination) {
        this.pagination = pagination;
    }

    public void setAsyncService(AsyncService asyncService) {
        this.asyncService = asyncService;
    }

    public String execute() throws Exception {
        this.admin = this.authorizationService.isAdmin();
        if (!this.admin) {
            throw new AgrosystAccessDeniedException();
        }
        this.filter = new TaskFilter();
        NavigationContext navigationContext = this.getNavigationContext();
        this.filter.setNavigationContext(navigationContext);
        this.filter.setPageSize(this.getListNbElementByPage(ScheduledTaskDto.class).intValue());
        this.runningAndPendingTasks = this.asyncService.getRunningAndPendingTasks(this.filter);
        return "success";
    }

    public PaginationResult<ScheduledTaskDto> getRunningAndPendingTasks() {
        return this.runningAndPendingTasks;
    }

    public void setFilter(TaskFilter filter) {
        this.filter = filter;
    }

    public TaskFilter getFilter() {
        return this.filter;
    }

    public boolean isAdmin() {
        return this.admin;
    }
}

