---
-- %%Ignore-License
---

DROP INDEX IF EXISTS action_to_practiced_intervention_idx;
DROP INDEX IF EXISTS action_to_effective_intervention_idx;

DROP INDEX IF EXISTS mineral_product_input_idx;
DROP INDEX IF EXISTS organic_product_input_idx;
DROP INDEX IF EXISTS seeding_product_input_idx;
DROP INDEX IF EXISTS biological_product_input_idx;
DROP INDEX IF EXISTS pesticide_product_input_idx;
DROP INDEX IF EXISTS other_product_input_idx;

CREATE INDEX action_to_practiced_intervention_idx ON abstractaction (practicedintervention NULLS LAST, topiadiscriminator);
CREATE INDEX action_to_effective_intervention_idx ON abstractaction (effectiveintervention NULLS LAST, topiadiscriminator);

CREATE INDEX mineral_product_input_idx ON abstractinput (mineralfertilizersspreadingaction NULLS LAST, topiadiscriminator);
CREATE INDEX organic_product_input_idx ON abstractinput (organicfertilizersspreadingaction NULLS LAST, topiadiscriminator);
CREATE INDEX seeding_product_input_idx ON abstractinput (seedingaction NULLS LAST, topiadiscriminator);
CREATE INDEX biological_product_input_idx ON abstractinput (biologicalcontrolaction NULLS LAST, topiadiscriminator);
CREATE INDEX pesticide_product_input_idx ON abstractinput (pesticidesspreadingaction NULLS LAST, topiadiscriminator);
CREATE INDEX other_product_input_idx ON abstractinput (otheraction NULLS LAST, topiadiscriminator);
