---
-- %%Ignore-License
---

-- Création d'une table dans laquelle seront poussés
--  les identifiants des toolscoupling en double associés avec l'identifiant du toolscoupling que l'on concerve et le couple code, domain qui permet de repérer les doublons
CREATE TABLE toolscouplingptn (previoustoolscouplingid varchar(255), newtoolscouplingid varchar(255), tccodedomain varchar(255));

-- dans un premier temps on insert dans la table les couples toolscouplingId, toolscoupling.code || domain
INSERT INTO toolscouplingptn (previoustoolscouplingid, tccodedomain)
  SELECT tc.topiaid, tc.code||' '||tc.domain FROM toolscoupling tc WHERE tc.code||' '||tc.domain IN
  (
    SELECT tc2.code||' '||tc2.domain FROM toolscoupling tc2
    GROUP BY tc2.code, tc2.domain
    HAVING COUNT(*)>1
  )
  ORDER BY tc.code, tc.domain;

-- On met à jour la table afin d'indiquer par tools couplings vers quel unique toolscoupling pointer
UPDATE toolscouplingptn SET newtoolscouplingid =
  (
    SELECT DISTINCT ON (tc.code||' '||tc.domain) tc.topiaid
    FROM toolscoupling tc
    WHERE tc.code||' '||tc.domain IN
      (
        SELECT code||' '||domain FROM toolscoupling
        GROUP BY code, domain
        HAVING COUNT(*)>1
      )
    AND tccodedomain LIKE tc.code||' '||tc.domain
  );

-- On supprime de la table les lignes non concernées par une modification, c'est à dire dont le nouvel identifiant est identique à l'ancien
DELETE FROM toolscouplingptn tcotn WHERE tcotn.newtoolscouplingid = tcotn.previoustoolscouplingid;

-- On met à jour les interventions qui pointeraient vers toolscouplings qui vont être supprimés.
UPDATE effectiveintervention_toolcouplings SET toolcouplings = toolscouplingptn.newtoolscouplingid FROM toolscouplingptn WHERE effectiveintervention_toolcouplings.toolcouplings = toolscouplingptn.previoustoolscouplingid;
-- Enfin on supprime les doublons dans les tables y faisant référence
DELETE FROM mainsactions_toolscoupling matc WHERE matc.toolscoupling IN (SELECT tcotn.previoustoolscouplingid FROM toolscouplingptn tcotn);
DELETE FROM equipments_toolscoupling etc WHERE etc.toolscoupling IN (SELECT tcotn.previoustoolscouplingid FROM toolscouplingptn tcotn);
DELETE FROM toolscoupling WHERE topiaid IN (SELECT tcotn.previoustoolscouplingid FROM toolscouplingptn tcotn);

DROP TABLE toolscouplingptn;

-- Création d'une table dans laquelle seront poussés
-- les identifiants des equipements en double associés avec l'identifiant de l'équipement que l'on conserve et le couple code, domain qui permet de repérer les doublons
CREATE TABLE equipmentmaj (previousequipmentid varchar(255), newequipmentid varchar(255), ecodedomain varchar(255));

-- dans un premier temps on insert dans la table les couples equipmentId, toolscoupling.code || domain
INSERT INTO equipmentmaj (previousequipmentid, ecodedomain)
  SELECT e.topiaid, e.code||' '||e.domain FROM equipment e WHERE e.code||' '||e.domain IN
  (
    SELECT e2.code||' '||e2.domain FROM equipment e2
    GROUP BY e2.code, e2.domain
    HAVING COUNT(*)>1
  )
  ORDER BY e.code, e.domain;


-- On met à jour la table afin d'indiquer par doublon equipment vers quel unique equipment pointer
UPDATE equipmentmaj SET newequipmentid =
  (
    SELECT DISTINCT ON (e.code||' '||e.domain) e.topiaid
    FROM equipment e
    WHERE e.code||' '||e.domain IN
      (
        SELECT code||' '||domain FROM equipment
        GROUP BY code, domain
        HAVING COUNT(*)>1
      )
    AND ecodedomain LIKE e.code||' '||e.domain
  );


-- On supprime de la table les lignes non concernées par une modification, c'est à dire dont le nouvel identifiant est identique à l'ancien
DELETE FROM equipmentmaj etn WHERE etn.newequipmentid = etn.previousequipmentid;

-- On met à jour les equipments_toolscoupling qui pointeraient vers des équipements qui vont être supprimés.
UPDATE equipments_toolscoupling SET equipments = equipmentmaj.newequipmentid FROM equipmentmaj WHERE equipments_toolscoupling.equipments = equipmentmaj.previousequipmentid;

-- On met à jour les toolscoupling (tracteurs/automoteurs) qui pointeraient vers des équipements qui vont être supprimés.
UPDATE toolscoupling SET tractor = equipmentmaj.newequipmentid FROM equipmentmaj WHERE toolscoupling.tractor = equipmentmaj.previousequipmentid;

-- Enfin on supprime les doublons
DELETE FROM equipment WHERE topiaid IN (SELECT etn.previousequipmentid FROM equipmentmaj etn);

DROP TABLE equipmentmaj;
