---
-- %%Ignore-License
---

-- add column solOccupationPercent to PracticedPerennialCropCycle.
ALTER TABLE seedingactionspecies ADD COLUMN biologicalSeedInoculation boolean;

-- dans un premier temps on les met tous à false pour ne pas avoir des données valides
UPDATE seedingactionspecies SET biologicalseedinoculation = FALSE;

-- S'il existe un intrant de type 'Inoculation biologique des semences / plants' alors la case 'Inoculation biologique des semences / plants' est cochée
UPDATE seedingactionspecies sas SET biologicalseedinoculation = TRUE WHERE sas.seedingaction IN (
    SELECT ai.seedingaction FROM refactatraitementsproduitscateg  atpc, refactatraitementsproduit ratp, abstractinput ai, seedingactionspecies sas
    WHERE atpc.type_produit LIKE '%culation biologique%'
    AND ratp.code_traitement = atpc.code_traitement
    AND ai.phytoproduct = ratp.topiaid
    AND sas.seedingaction = ai.seedingaction
    AND sas.treatment = TRUE
    AND ai.seedingaction IS NOT NULL
  )
  AND sas.treatment = true;

-- Toutes les actions qui pointent uniquement vers des intrants de type 'Inoculation biologique des semences / plants' ont la case treatment à false
UPDATE seedingactionspecies SET treatment = FALSE WHERE seedingaction IN (
SELECT ai.seedingaction FROM refactatraitementsproduitscateg  atpc, refactatraitementsproduit ratp, abstractinput ai, seedingactionspecies sas
    WHERE atpc.type_produit LIKE '%culation biologique%'
    AND ratp.code_traitement = atpc.code_traitement
    AND ai.phytoproduct = ratp.topiaid
    AND sas.seedingaction = ai.seedingaction
    AND sas.treatment = TRUE
    AND ai.seedingaction IS NOT NULL)
 AND seedingaction NOT IN(
   SELECT ai.seedingaction FROM refactatraitementsproduitscateg  atpc, refactatraitementsproduit ratp, abstractinput ai, seedingactionspecies sas
     WHERE atpc.type_produit NOT LIKE '%culation biologique%'
     AND ratp.code_traitement = atpc.code_traitement
     AND ai.phytoproduct = ratp.topiaid
     AND sas.seedingaction = ai.seedingaction
     AND sas.treatment = TRUE
     AND ai.seedingaction IS NOT NULL
 );