/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.users;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.entities.security.AgrosystUserTopiaDao;
import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.entities.security.UserRole;
import fr.inra.agrosyst.api.entities.security.UserRoleTopiaDao;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.referential.ImportResult;
import fr.inra.agrosyst.api.services.security.AuthorizationService;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.UserFilter;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.api.services.users.Users;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.EmailService;
import fr.inra.agrosyst.services.security.TrackerServiceImpl;
import fr.inra.agrosyst.services.users.UserImportModel;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.PagerBean;
import org.nuiton.util.StringUtil;

public class UserServiceImpl
extends AbstractAgrosystService
implements UserService {
    protected static final String PROPERTY_ROLE_USER_TPIA_ID = "agrosystUser.topiaId";
    private static final Log log = LogFactory.getLog(UserServiceImpl.class);
    protected static final Function<UserRole, RoleType> GET_ROLE_TYPE = new Function<UserRole, RoleType>(){

        public RoleType apply(UserRole userRole) {
            return userRole.getType();
        }
    };
    protected EmailService emailService;
    protected TrackerServiceImpl trackerService;
    protected AuthorizationService authorizationService;
    protected AgrosystUserTopiaDao agrosystUserDao;
    protected UserRoleTopiaDao userRoleDao;

    public static String hashPassword(String clearPassword) {
        String hashedPassword = StringUtil.encodeSHA1((String)Strings.nullToEmpty((String)clearPassword));
        return hashedPassword;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void setTrackerService(TrackerServiceImpl trackerService) {
        this.trackerService = trackerService;
    }

    public void setAgrosystUserDao(AgrosystUserTopiaDao agrosystUserDao) {
        this.agrosystUserDao = agrosystUserDao;
    }

    public void setUserRoleDao(UserRoleTopiaDao userRoleDao) {
        this.userRoleDao = userRoleDao;
    }

    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    protected void copyFromDto(UserDto dto, AgrosystUser entity) {
        entity.setFirstName(dto.getFirstName());
        entity.setLastName(dto.getLastName());
        entity.setEmail(StringUtils.lowerCase((String)dto.getEmail()));
        entity.setOrganisation(dto.getOrganisation());
        entity.setPhoneNumber(dto.getPhoneNumber());
        entity.setBanner(dto.getBanner());
        entity.setActive(dto.isActive());
    }

    public boolean isEmailInUse(String email, String currentUserId) {
        boolean result = false;
        if (!Strings.isNullOrEmpty((String)email)) {
            AgrosystUser user = (AgrosystUser)this.agrosystUserDao.forEmailEquals(email.toLowerCase()).findAnyOrNull();
            result = user != null && !user.getTopiaId().equals(currentUserId);
        }
        return result;
    }

    public UserDto createUser(UserDto dto, String password) {
        AgrosystUser user = (AgrosystUser)this.agrosystUserDao.newInstance();
        this.copyFromDto(dto, user);
        String hashedPassword = UserServiceImpl.hashPassword(password);
        user.setPassword(hashedPassword);
        AgrosystUser createdUser = (AgrosystUser)this.agrosystUserDao.create((TopiaEntity)user);
        this.trackerService.userCreated(createdUser);
        this.getTransaction().commit();
        UserDto result = (UserDto)Users.TO_USER_DTO.apply((Object)createdUser);
        return result;
    }

    public UserDto getUser(String topiaId) {
        AgrosystUser user = (AgrosystUser)this.agrosystUserDao.forTopiaIdEquals(topiaId).findUnique();
        UserDto result = (UserDto)Users.TO_USER_DTO.apply((Object)user);
        return result;
    }

    public UserDto updateUser(UserDto dto, String password) {
        AgrosystUser user = (AgrosystUser)this.agrosystUserDao.forTopiaIdEquals(dto.getTopiaId()).findUnique();
        this.copyFromDto(dto, user);
        boolean passwordChange = false;
        if (!Strings.isNullOrEmpty((String)password)) {
            String hashedPassword = UserServiceImpl.hashPassword(password);
            user.setPassword(hashedPassword);
            passwordChange = true;
        }
        AgrosystUser updatedUser = (AgrosystUser)this.agrosystUserDao.update((TopiaEntity)user);
        this.trackerService.userModified(updatedUser, passwordChange);
        this.getTransaction().commit();
        UserDto result = (UserDto)Users.TO_USER_DTO.apply((Object)updatedUser);
        return result;
    }

    public void unactivateUsers(Set<String> topiaIds, boolean activate) {
        if (topiaIds != null && !topiaIds.isEmpty()) {
            for (String topiaId : topiaIds) {
                AgrosystUser user = (AgrosystUser)this.agrosystUserDao.forTopiaIdEquals(topiaId).findUnique();
                user.setActive(activate);
                AgrosystUser updatedUser = (AgrosystUser)this.agrosystUserDao.update((TopiaEntity)user);
                this.trackerService.userActivation(updatedUser, activate);
            }
            this.getTransaction().commit();
        }
    }

    public ResultList<UserDto> getFilteredUsers(UserFilter userFilter, boolean includeRoles) {
        ResultList<AgrosystUser> usersList = this.agrosystUserDao.getFilteredUsers(userFilter);
        ResultList result = ResultList.of((List)Lists.transform((List)usersList.getElements(), (Function)Users.TO_USER_DTO), (PagerBean)usersList.getPager());
        if (includeRoles) {
            for (UserDto userDto : result) {
                List roles = this.userRoleDao.forProperties(PROPERTY_ROLE_USER_TPIA_ID, userDto.getTopiaId(), new Object[0]).findAll();
                LinkedHashSet roleTypes = Sets.newLinkedHashSet((Iterable)Iterables.transform((Iterable)roles, GET_ROLE_TYPE));
                userDto.setRoles((Set)roleTypes);
            }
        }
        return result;
    }

    public List<UserDto> getNameFilteredActiveUsers(String research, Integer nbResult) {
        List<AgrosystUser> usersList = this.agrosystUserDao.getNameFilteredActiveUsers(research, nbResult);
        List result = Lists.transform(usersList, (Function)Users.TO_USER_DTO);
        return result;
    }

    public long getUsersCount(Boolean active) {
        if (active == null) {
            return this.agrosystUserDao.count();
        }
        return this.agrosystUserDao.forActiveEquals(active).count();
    }

    public boolean askForPasswordReminder(String email) {
        Optional any = this.agrosystUserDao.forEmailEquals(email.toLowerCase()).tryFindUnique();
        boolean result = false;
        if (any.isPresent()) {
            String token = UUID.randomUUID().toString();
            AgrosystUser agrosystUser = (AgrosystUser)any.get();
            agrosystUser.setReminderToken(UserServiceImpl.hashPassword(token));
            this.getTransaction().commit();
            this.emailService.sendPasswordReminder(agrosystUser, token);
            result = true;
        }
        return result;
    }

    public UserDto preparePasswordChange(String token, String userId) {
        UserDto result = null;
        Optional optional = this.agrosystUserDao.forProperties("topiaId", userId, new Object[]{"reminderToken", UserServiceImpl.hashPassword(token)}).tryFindUnique();
        if (optional.isPresent()) {
            result = (UserDto)Users.TO_USER_DTO.apply(optional.get());
        }
        return result;
    }

    public boolean updatePassword(String token, String userId, String password) {
        Optional optional = this.agrosystUserDao.forProperties("topiaId", userId, new Object[]{"reminderToken", UserServiceImpl.hashPassword(token)}).tryFindUnique();
        if (optional.isPresent()) {
            AgrosystUser agrosystUser = (AgrosystUser)optional.get();
            agrosystUser.setReminderToken(null);
            agrosystUser.setPassword(UserServiceImpl.hashPassword(password));
            this.getTransaction().commit();
            return true;
        }
        return false;
    }

    public void sendFeedback(String env, String location, String locationTitle, String category, String feedback, String requested, String referer, byte[] screenshotData) {
        String user;
        block2: {
            Preconditions.checkArgument((feedback != null ? 1 : 0) != 0);
            user = "unknown";
            try {
                String userId = this.getSecurityContext().getUserId();
                AgrosystUser agrosystUser = (AgrosystUser)this.agrosystUserDao.forTopiaIdEquals(userId).findUnique();
                user = String.format("%s %s <%s>", agrosystUser.getFirstName(), agrosystUser.getLastName(), agrosystUser.getEmail());
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Unable to get current user", (Throwable)eee);
            }
        }
        this.emailService.sendFeedback(user, env, location, locationTitle, category, feedback, requested, referer, screenshotData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportResult importUsers(InputStream userFileStream) {
        Import importer = null;
        ImportResult result = new ImportResult();
        try {
            UserImportModel model = new UserImportModel();
            importer = Import.newImport((ImportModel)model, (InputStream)userFileStream);
            for (AgrosystUser entity : importer) {
                AgrosystUser agrosystUser;
                if (entity.getEmail() != null) {
                    entity.setEmail(entity.getEmail().toLowerCase());
                }
                if ((agrosystUser = (AgrosystUser)this.agrosystUserDao.forEmailEquals(entity.getEmail()).findAnyOrNull()) != null) {
                    result.incIgnored();
                    continue;
                }
                String token = UUID.randomUUID().toString();
                entity.setReminderToken(UserServiceImpl.hashPassword(token));
                String password = RandomStringUtils.randomAlphanumeric((int)8);
                entity.setPassword(UserServiceImpl.hashPassword(password));
                entity.setActive(true);
                agrosystUser = (AgrosystUser)this.agrosystUserDao.create((TopiaEntity)entity);
                try {
                    this.emailService.sendCreatedAccountNotification(agrosystUser, token);
                }
                catch (AgrosystTechnicalException exception) {
                    String errorMessage = "Unable to send created account email, for user user with email :%s.";
                    errorMessage = String.format(errorMessage, agrosystUser.getEmail());
                    result.addError(errorMessage);
                }
                result.incCreated();
                this.trackerService.userCreated(agrosystUser);
            }
            this.getTransaction().commit();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(importer);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)importer);
        return result;
    }

    public UserDto acceptCharter() {
        String userId = this.getSecurityContext().getUserId();
        AgrosystUser agrosystUser = (AgrosystUser)this.agrosystUserDao.forTopiaIdEquals(userId).findUnique();
        agrosystUser.setCharterVersion(Integer.valueOf(2));
        this.agrosystUserDao.update((TopiaEntity)agrosystUser);
        this.getTransaction().commit();
        UserDto userDto = (UserDto)Users.TO_USER_DTO.apply((Object)agrosystUser);
        return userDto;
    }

    public UserDto readInfoMessages(Date lastMessageReadDate) {
        String userId = this.getSecurityContext().getUserId();
        AgrosystUser agrosystUser = (AgrosystUser)this.agrosystUserDao.forTopiaIdEquals(userId).findUnique();
        agrosystUser.setLastMessageReadDate(lastMessageReadDate);
        this.agrosystUserDao.update((TopiaEntity)agrosystUser);
        this.getTransaction().commit();
        UserDto userDto = (UserDto)Users.TO_USER_DTO.apply((Object)agrosystUser);
        return userDto;
    }
}

