/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.security;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.entities.security.AgrosystUserTopiaDao;
import fr.inra.agrosyst.api.entities.security.TrackedEvent;
import fr.inra.agrosyst.api.entities.security.TrackedEventTopiaDao;
import fr.inra.agrosyst.api.entities.security.TrackedEventType;
import fr.inra.agrosyst.api.entities.security.UserRole;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import fr.inra.agrosyst.api.services.security.TrackedEventFilter;
import fr.inra.agrosyst.api.services.security.TrackerService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.PagerBean;

public class TrackerServiceImpl
extends AbstractAgrosystService
implements TrackerService {
    private static final Log log = LogFactory.getLog(TrackerServiceImpl.class);
    protected BusinessAuthorizationService businessAuthorizationService;
    protected AgrosystUserTopiaDao usersDao;
    protected TrackedEventTopiaDao eventsDao;

    public void setBusinessAuthorizationService(BusinessAuthorizationService businessAuthorizationService) {
        this.businessAuthorizationService = businessAuthorizationService;
    }

    public void setUsersDao(AgrosystUserTopiaDao usersDao) {
        this.usersDao = usersDao;
    }

    public void setEventsDao(TrackedEventTopiaDao eventsDao) {
        this.eventsDao = eventsDao;
    }

    public ResultList<TrackedEvent> list(TrackedEventFilter filter) {
        this.businessAuthorizationService.checkIsAdmin();
        List elements = this.eventsDao.findAll();
        PagerBean pagerBean = new PagerBean();
        pagerBean.setPageIndex(0);
        pagerBean.setPageSize(elements.size());
        pagerBean.setPagesNumber(1L);
        ResultList result = ResultList.of((List)elements, (PagerBean)pagerBean);
        return result;
    }

    protected AgrosystUser getCurrentUser() {
        AgrosystUser result = null;
        try {
            String userId = this.getSecurityContext().getUserId();
            result = (AgrosystUser)this.usersDao.forTopiaIdEquals(userId).findUnique();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected void create(TrackedEventType type, List<String> args) {
        this.eventsDao.create("date", this.context.getCurrentDate(), new Object[]{"author", this.getCurrentUser(), "type", type, "args", this.context.getGson().toJson(args)});
    }

    public void userCreated(AgrosystUser user) {
        ArrayList args = Lists.newArrayList((Object[])new String[]{user.getEmail()});
        this.create(TrackedEventType.USER_CREATION, args);
    }

    public void userModified(AgrosystUser user, boolean passwordChange) {
        ArrayList args = Lists.newArrayList((Object[])new String[]{user.getEmail(), String.valueOf(passwordChange)});
        AgrosystUser currentUser = this.getCurrentUser();
        TrackedEventType type = user.equals(currentUser) ? TrackedEventType.USER_MOD_SELF : TrackedEventType.USER_MOD;
        this.create(type, args);
    }

    public void userActivation(AgrosystUser user, boolean active) {
        ArrayList args = Lists.newArrayList((Object[])new String[]{user.getEmail(), String.valueOf(active)});
        this.create(TrackedEventType.USER_ACTIVATION, args);
    }

    protected List<String> roleToArgs(UserRole role) {
        ArrayList result = Lists.newArrayList((Object[])new String[]{role.getType().name()});
        switch (role.getType()) {
            case DOMAIN_RESPONSIBLE: {
                Domain domain = (Domain)this.context.getDaoSupplier().getDomainDao().forCodeEquals(role.getDomainCode()).findAny();
                result.add(domain.getName());
                result.add("Toutes campagnes");
                break;
            }
            case GROWING_PLAN_RESPONSIBLE: {
                GrowingPlan growingPlan = (GrowingPlan)this.context.getDaoSupplier().getGrowingPlanDao().forCodeEquals(role.getGrowingPlanCode()).findAny();
                result.add(growingPlan.getName());
                result.add("Toutes campagnes");
                break;
            }
            case GS_DATA_PROCESSOR: {
                if (Strings.isNullOrEmpty((String)role.getGrowingSystemCode())) {
                    GrowingSystem growingSystem = (GrowingSystem)this.context.getDaoSupplier().getGrowingSystemDao().forTopiaIdEquals(role.getGrowingSystemId()).findUnique();
                    result.add(growingSystem.getName());
                    result.add(String.valueOf(growingSystem.getGrowingPlan().getDomain().getCampaign()));
                    break;
                }
                GrowingSystem growingSystem = (GrowingSystem)this.context.getDaoSupplier().getGrowingSystemDao().forCodeEquals(role.getGrowingSystemCode()).findAny();
                result.add(growingSystem.getName());
                result.add("Toutes campagnes");
                break;
            }
            case NETWORK_RESPONSIBLE: {
                Network network = (Network)this.context.getDaoSupplier().getNetworkDao().forTopiaIdEquals(role.getNetworkId()).findUnique();
                result.add(network.getName());
            }
        }
        result.add(role.getAgrosystUser().getEmail());
        return result;
    }

    public void roleAdded(UserRole role) {
        List<String> args = this.roleToArgs(role);
        this.create(TrackedEventType.USER_ROLE_ADD, args);
    }

    public void roleRemoved(UserRole role) {
        List<String> args = this.roleToArgs(role);
        this.create(TrackedEventType.USER_ROLE_REMOVE, args);
    }
}

