/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.security;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.security.ComputedUserPermission;
import fr.inra.agrosyst.api.entities.security.PermissionObjectType;
import fr.inra.agrosyst.services.security.SecurityContext;
import java.util.Map;

public class SecurityHelper {
    protected static final String ZONE_GROWING_SYSTEM = Joiner.on((String)".").join((Object)"plot", (Object)"growingSystem", new Object[0]);
    public static final int PERMISSION_READ_VALIDATED = 1;
    public static final int PERMISSION_READ_RAW = 3;
    public static final int PERMISSION_WRITE = 7;
    public static final int PERMISSION_ADMIN = 15;
    protected static final String IN_SELECT_CUP_ACTION_HIGHER_THAN = " %s.%s IN (    SELECT DISTINCT cup.object   FROM " + ComputedUserPermission.class.getName() + " cup" + "   WHERE cup." + "userId" + " = :cup_userId" + "   AND   cup." + "type" + " = :%s" + "   AND   cup." + "action" + " >= :cup_action" + " ) ";
    protected static final String IN_SELECT_CUP_ACTION_EQUALS = " %s.%s IN (    SELECT DISTINCT cup.object   FROM " + ComputedUserPermission.class.getName() + " cup" + "   WHERE cup." + "userId" + " = :cup_userId" + "   AND   cup." + "type" + " = :%s" + "   AND   cup." + "action" + " = :cup_action_read_validated" + " ) ";

    protected static void addMinimumActionSecurityFilter(StringBuilder query, Map<String, Object> args, SecurityContext securityContext, String alias, PermissionObjectType cupTypeCode, PermissionObjectType cupTypeId, String propCode, String propId, int action) {
        if (!securityContext.isAdmin()) {
            String userId = securityContext.getUserId();
            String codeInReadRaw = String.format(IN_SELECT_CUP_ACTION_HIGHER_THAN, alias, propCode, "cup_type_code");
            String topiaIdInReadRaw = String.format(IN_SELECT_CUP_ACTION_HIGHER_THAN, alias, propId, "cup_type_id");
            String securityQuery = String.format(" AND ( %s OR %s ) ", codeInReadRaw, topiaIdInReadRaw);
            query.append(securityQuery);
            args.put("cup_userId", userId);
            args.put("cup_type_code", cupTypeCode);
            args.put("cup_type_id", cupTypeId);
            args.put("cup_action", action);
        }
    }

    protected static void addReadSecurityFilter(StringBuilder query, Map<String, Object> args, SecurityContext securityContext, String alias, PermissionObjectType cupTypeCode, PermissionObjectType cupTypeId, String propCode, String propId) {
        SecurityHelper.addMinimumActionSecurityFilter(query, args, securityContext, alias, cupTypeCode, cupTypeId, propCode, propId, 3);
    }

    protected static void addReadValidatedSecurityFilter(StringBuilder query, Map<String, Object> args, SecurityContext securityContext, String alias, PermissionObjectType cupTypeCode, PermissionObjectType cupTypeId, String propCode, String propId) {
        SecurityHelper.addMinimumActionSecurityFilter(query, args, securityContext, alias, cupTypeCode, cupTypeId, propCode, propId, 1);
    }

    protected static void addWriteSecurityFilter(StringBuilder query, Map<String, Object> args, SecurityContext securityContext, String alias, PermissionObjectType cupTypeCode, PermissionObjectType cupTypeId, String propCode, String propId) {
        SecurityHelper.addMinimumActionSecurityFilter(query, args, securityContext, alias, cupTypeCode, cupTypeId, propCode, propId, 7);
    }

    protected static void addReadSecurityFilterOnValidableEntity(StringBuilder query, Map<String, Object> args, SecurityContext securityContext, String alias, PermissionObjectType cupTypeCode, PermissionObjectType cupTypeId, String propCode, String propId, String propValidated) {
        if (!securityContext.isAdmin()) {
            String userId = securityContext.getUserId();
            String codeInReadRaw = String.format(IN_SELECT_CUP_ACTION_HIGHER_THAN, alias, propCode, "cup_type_code");
            String topiaIdInReadRaw = String.format(IN_SELECT_CUP_ACTION_HIGHER_THAN, alias, propId, "cup_type_id");
            String validated = alias + "." + propValidated;
            String codeInReadValidated = String.format(IN_SELECT_CUP_ACTION_EQUALS, alias, propCode, "cup_type_code");
            String topiaIdInReadValidated = String.format(IN_SELECT_CUP_ACTION_EQUALS, alias, propId, "cup_type_id");
            String securityQuery = String.format(" AND ( ( %s OR %s ) OR ( %s = true AND ( %s OR %s ) ) ) ", codeInReadRaw, topiaIdInReadRaw, validated, codeInReadValidated, topiaIdInReadValidated);
            query.append(securityQuery);
            args.put("cup_userId", userId);
            args.put("cup_type_code", cupTypeCode);
            args.put("cup_type_id", cupTypeId);
            args.put("cup_action", 3);
            args.put("cup_action_read_validated", 1);
        }
    }

    public static void addDomainFilter(StringBuilder query, Map<String, Object> args, SecurityContext securityContext, String alias) {
        SecurityHelper.addReadSecurityFilterOnValidableEntity(query, args, securityContext, alias, PermissionObjectType.DOMAIN_CODE, PermissionObjectType.DOMAIN_ID, "code", "topiaId", "validated");
    }

    public static void addWritableDomainFilter(StringBuilder query, Map<String, Object> args, SecurityContext securityContext, String alias) {
        SecurityHelper.addWriteSecurityFilter(query, args, securityContext, alias, PermissionObjectType.DOMAIN_CODE, PermissionObjectType.DOMAIN_ID, "code", "topiaId");
    }

    public static void addWritableDomainFilterForDecisionRuleCreation(StringBuilder query, Map<String, Object> args, SecurityContext securityContext, String alias) {
        StringBuilder subQuery1 = new StringBuilder();
        SecurityHelper.addWriteSecurityFilter(subQuery1, args, securityContext, alias, PermissionObjectType.DOMAIN_CODE, PermissionObjectType.DOMAIN_ID, "code", "topiaId");
        StringBuilder subQuery2 = new StringBuilder();
        if (!securityContext.isAdmin()) {
            subQuery2.append(String.format(IN_SELECT_CUP_ACTION_HIGHER_THAN, alias, "topiaId IN ( SELECT gp.domain.topiaId FROM " + GrowingPlan.class.getName() + " gp WHERE gp." + "code", "cup_gp_code"));
            subQuery2.append(" ) ");
            args.put("cup_gp_code", PermissionObjectType.GROWING_PLAN_CODE);
        }
        if (subQuery1.length() > 0 && subQuery2.length() > 0) {
            String hql = subQuery1.toString();
            Preconditions.checkState((boolean)hql.endsWith(" ) "));
            hql = hql.substring(0, hql.length() - 3);
            hql = hql + " OR ";
            hql = hql + subQuery2.toString();
            hql = hql + " ) ";
            query.append(hql);
        }
    }

    public static void addGrowingPlanFilter(StringBuilder query, Map<String, Object> args, SecurityContext securityContext, String alias) {
        SecurityHelper.addReadSecurityFilterOnValidableEntity(query, args, securityContext, alias, PermissionObjectType.GROWING_PLAN_CODE, PermissionObjectType.GROWING_PLAN_ID, "code", "topiaId", "validated");
    }

    public static void addGrowingSystemFilter(StringBuilder query, Map<String, Object> args, SecurityContext securityContext, String alias) {
        SecurityHelper.addReadSecurityFilterOnValidableEntity(query, args, securityContext, alias, PermissionObjectType.GROWING_SYSTEM_CODE, PermissionObjectType.GROWING_SYSTEM_ID, "code", "topiaId", "validated");
    }

    public static void addZoneFilter(StringBuilder query, Map<String, Object> args, SecurityContext securityContext, String alias) {
        if (!securityContext.isAdmin()) {
            StringBuilder subQuery1 = new StringBuilder(" SELECT p1.topiaId FROM " + Plot.class.getName() + " p1 ");
            subQuery1.append(" WHERE p1.growingSystem IS NULL ");
            SecurityHelper.addReadSecurityFilterOnValidableEntity(subQuery1, args, securityContext, "p1", PermissionObjectType.DOMAIN_CODE, PermissionObjectType.DOMAIN_ID, Joiner.on((String)".").join((Object)"domain", (Object)"code", new Object[0]), Joiner.on((String)".").join((Object)"domain", (Object)"topiaId", new Object[0]), Joiner.on((String)".").join((Object)"domain", (Object)"validated", new Object[0]));
            String subQuery1String = subQuery1.toString();
            for (String toReplace : Sets.newHashSet((Object[])new String[]{"cup_type_code", "cup_type_id"})) {
                String dotPlusToReplace = ":" + toReplace;
                while (subQuery1String.contains(dotPlusToReplace)) {
                    int index = subQuery1String.indexOf(dotPlusToReplace);
                    String part0 = subQuery1String.substring(0, index);
                    String part1 = ":domain_" + toReplace;
                    String part2 = subQuery1String.substring(index + dotPlusToReplace.length());
                    subQuery1String = part0 + part1 + part2;
                }
            }
            args.remove("cup_type_code");
            args.remove("cup_type_id");
            args.put("domain_cup_type_code", PermissionObjectType.DOMAIN_CODE);
            args.put("domain_cup_type_id", PermissionObjectType.DOMAIN_ID);
            StringBuilder subQuery2 = new StringBuilder(" SELECT p2.topiaId FROM " + Plot.class.getName() + " p2 ");
            subQuery2.append(" WHERE p2.growingSystem IS NOT NULL ");
            SecurityHelper.addReadSecurityFilterOnValidableEntity(subQuery2, args, securityContext, "p2", PermissionObjectType.GROWING_SYSTEM_CODE, PermissionObjectType.GROWING_SYSTEM_ID, Joiner.on((String)".").join((Object)"growingSystem", (Object)"code", new Object[0]), Joiner.on((String)".").join((Object)"growingSystem", (Object)"topiaId", new Object[0]), Joiner.on((String)".").join((Object)"growingSystem", (Object)"validated", new Object[0]));
            query.append(String.format(" AND ( " + alias + "." + "plot" + "." + "topiaId" + " IN ( %s ) " + " OR " + alias + "." + "plot" + "." + "topiaId" + " IN ( %s ) " + " ) ", subQuery1String, subQuery2));
        }
    }

    public static void addWritableGrowingSystemFilter(StringBuilder query, Map<String, Object> args, SecurityContext securityContext, String alias) {
        SecurityHelper.addWriteSecurityFilter(query, args, securityContext, alias, PermissionObjectType.GROWING_SYSTEM_CODE, PermissionObjectType.GROWING_SYSTEM_ID, "code", "topiaId");
    }

    public static void addDecisionRuleFilter(StringBuilder query, Map<String, Object> args, SecurityContext securityContext, String alias) {
        StringBuilder subQuery2 = new StringBuilder();
        SecurityHelper.addReadValidatedSecurityFilter(subQuery2, args, securityContext, alias, PermissionObjectType.DOMAIN_CODE, PermissionObjectType.DOMAIN_ID, "domainCode", "domainCode IN ( SELECT d.code FROM " + Domain.class.getName() + " d WHERE d.topiaId ");
        if (subQuery2.length() > 0) {
            subQuery2.append(" ) ");
        }
        query.append((CharSequence)subQuery2);
    }

    public static void addPracticedSystemFilter(StringBuilder query, Map<String, Object> args, SecurityContext securityContext, String alias) {
        String propertyValidated = "validated = true AND " + alias + "." + Joiner.on((char)'.').join((Object)"growingSystem", (Object)"validated", new Object[0]);
        SecurityHelper.addReadSecurityFilterOnValidableEntity(query, args, securityContext, alias, PermissionObjectType.GROWING_SYSTEM_CODE, PermissionObjectType.GROWING_SYSTEM_ID, Joiner.on((char)'.').join((Object)"growingSystem", (Object)"code", new Object[0]), Joiner.on((char)'.').join((Object)"growingSystem", (Object)"topiaId", new Object[0]), propertyValidated);
    }

    public static void addPracticedPlotFilter(StringBuilder query, Map<String, Object> args, SecurityContext securityContext, String alias) {
        StringBuilder subQuery = new StringBuilder();
        SecurityHelper.addPracticedSystemFilter(subQuery, args, securityContext, "ps");
        if (subQuery.length() > 0) {
            String subFilter = String.format(" AND %s.%s IN ( SELECT ps.%s FROM %s ps WHERE 1=1 %s ) ", alias, Joiner.on((char)'.').join((Object)"practicedSystem", (Object)"topiaId", new Object[0]), "topiaId", PracticedSystem.class.getName(), subQuery.toString());
            query.append(subFilter);
        }
    }
}

