/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.security;

import com.google.common.base.Strings;
import fr.inra.agrosyst.api.services.ServiceFactory;
import fr.inra.agrosyst.api.services.security.AuthorizationService;

public class SecurityContext {
    protected ServiceFactory serviceFactory;
    protected String authenticationToken;
    protected String doAsUserId;
    protected transient AuthorizationService authorizationService;
    protected transient Boolean admin;
    protected transient String userId;

    public SecurityContext(ServiceFactory serviceFactory, String authenticationToken) {
        this.serviceFactory = serviceFactory;
        this.authenticationToken = authenticationToken;
    }

    public SecurityContext(ServiceFactory serviceFactory, String authenticationToken, String doAsUserId) {
        this.serviceFactory = serviceFactory;
        this.authenticationToken = authenticationToken;
        this.doAsUserId = doAsUserId;
    }

    protected AuthorizationService getAuthorizationService() {
        if (this.authorizationService == null) {
            this.authorizationService = (AuthorizationService)this.serviceFactory.newService(AuthorizationService.class);
        }
        return this.authorizationService;
    }

    public boolean isAdmin() {
        if (this.admin == null) {
            this.admin = this.getAuthorizationService().isAdmin(this.authenticationToken);
        }
        return this.admin;
    }

    public String getUserId() {
        if (this.userId == null) {
            this.userId = Strings.isNullOrEmpty((String)this.doAsUserId) ? this.getAuthorizationService().checkComputedPermissions(this.authenticationToken) : this.getAuthorizationService().checkComputedPermissions(this.authenticationToken, this.doAsUserId);
        }
        return this.userId;
    }

    public String getAuthenticationToken() {
        return this.authenticationToken;
    }
}

