/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.security;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.AttachmentMetadata;
import fr.inra.agrosyst.api.entities.AttachmentMetadataTopiaDao;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.entities.NetworkManager;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.PlotTopiaDao;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.ZoneTopiaDao;
import fr.inra.agrosyst.api.entities.managementmode.DecisionRule;
import fr.inra.agrosyst.api.entities.managementmode.DecisionRuleTopiaDao;
import fr.inra.agrosyst.api.entities.managementmode.ManagementMode;
import fr.inra.agrosyst.api.entities.managementmode.ManagementModeTopiaDao;
import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.entities.performance.PerformanceTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlot;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlotTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystemTopiaDao;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.entities.security.PermissionObjectType;
import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.entities.security.UserRole;
import fr.inra.agrosyst.api.services.security.AgrosystAccessDeniedException;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import fr.inra.agrosyst.services.security.AuthorizationServiceImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.nuiton.topia.persistence.TopiaIdFactory;

public class BusinessAuthorizationServiceImpl
extends AuthorizationServiceImpl
implements BusinessAuthorizationService {
    protected static final Predicate<NetworkManager> IS_ACTIVE_NETWORK_MANAGER = new Predicate<NetworkManager>(){

        public boolean apply(NetworkManager input) {
            return input.isActive() && input.getToDate() == null;
        }
    };
    protected PracticedSystemTopiaDao practicedSystemDao;
    protected ManagementModeTopiaDao managementModeDao;
    protected DecisionRuleTopiaDao decisionRuleDao;
    protected ZoneTopiaDao zoneDao;
    protected AttachmentMetadataTopiaDao attachmentMetadataDao;
    protected PerformanceTopiaDao performanceDao;
    protected PlotTopiaDao plotDao;
    protected PracticedPlotTopiaDao practicedPlotDao;

    public void setPracticedSystemDao(PracticedSystemTopiaDao practicedSystemDao) {
        this.practicedSystemDao = practicedSystemDao;
    }

    public void setManagementModeDao(ManagementModeTopiaDao managementModeDao) {
        this.managementModeDao = managementModeDao;
    }

    public void setDecisionRuleDao(DecisionRuleTopiaDao decisionRuleDao) {
        this.decisionRuleDao = decisionRuleDao;
    }

    public void setZoneDao(ZoneTopiaDao zoneDao) {
        this.zoneDao = zoneDao;
    }

    public void setAttachmentMetadataDao(AttachmentMetadataTopiaDao attachmentMetadataDao) {
        this.attachmentMetadataDao = attachmentMetadataDao;
    }

    public void setPerformanceDao(PerformanceTopiaDao performanceDao) {
        this.performanceDao = performanceDao;
    }

    public void setPlotDao(PlotTopiaDao plotDao) {
        this.plotDao = plotDao;
    }

    public void setPracticedPlotDao(PracticedPlotTopiaDao practicedPlotDao) {
        this.practicedPlotDao = practicedPlotDao;
    }

    protected boolean hasObjectPermissionAdmin(String userId, PermissionObjectType type, String object) {
        boolean result = this.hasPermissionActionLevel(userId, type, object, 15);
        return result;
    }

    protected boolean hasObjectPermissionWritable(String userId, PermissionObjectType type, String object) {
        boolean result = this.hasPermissionActionLevel(userId, type, object, 7);
        return result;
    }

    protected boolean hasObjectPermissionWritable(String userId, String object) {
        boolean result = this.hasPermissionActionLevel(userId, object, 7);
        return result;
    }

    protected boolean hasObjectPermissionReadable(String userId, PermissionObjectType type, String object) {
        boolean result = this.hasPermissionActionLevel(userId, type, object, 1);
        return result;
    }

    protected boolean hasObjectPermissionReadable(String userId, String object) {
        boolean result = this.hasPermissionActionLevel(userId, object, 1);
        return result;
    }

    protected boolean hasPermissionActionLevel(String userId, String object, int expectedActionLevel) {
        int maxActionLevel = this.getHighestPermissionLevel(userId, null, object);
        boolean result = maxActionLevel >= expectedActionLevel;
        return result;
    }

    protected boolean hasPermissionActionLevel(String userId, PermissionObjectType type, String object, int expectedActionLevel) {
        int maxActionLevel = this.getHighestPermissionLevel(userId, type, object);
        boolean result = maxActionLevel >= expectedActionLevel;
        return result;
    }

    protected int getHighestPermissionLevel(String userId, PermissionObjectType type, String object) {
        int result = this.computedUserPermissionDao.getMaxAction(userId, object, type);
        return result;
    }

    public boolean isDomainWritable(String domainId) {
        boolean result;
        String userId = this.getUserId();
        boolean bl = result = this.isAdmin() || this.hasObjectPermissionWritable(userId, PermissionObjectType.DOMAIN_ID, domainId);
        if (!result) {
            Domain domain = (Domain)this.domainDao.forTopiaIdEquals(domainId).findUnique();
            result = this.hasObjectPermissionWritable(userId, PermissionObjectType.DOMAIN_CODE, domain.getCode());
        }
        return result;
    }

    public boolean areDomainPlotsEditable(String domainId) {
        boolean result;
        if (this.isDomainWritable(domainId)) {
            result = true;
        } else {
            Domain domain = (Domain)this.domainDao.forTopiaIdEquals(domainId).findUnique();
            Iterable growingPlans = this.growingPlanDao.forDomainEquals(domain).findAllLazy();
            result = Iterables.any((Iterable)growingPlans, (Predicate)new Predicate<GrowingPlan>(){

                public boolean apply(GrowingPlan input) {
                    return BusinessAuthorizationServiceImpl.this.isGrowingPlanAdministrable(input.getCode());
                }
            });
        }
        return result;
    }

    public boolean isDomainAdministrable(String domainCode) {
        String userId = this.getUserId();
        boolean result = this.isAdmin() || this.hasObjectPermissionAdmin(userId, PermissionObjectType.DOMAIN_CODE, domainCode);
        return result;
    }

    protected boolean isDomainCodeWritable(String domainCode) {
        String userId = this.getUserId();
        boolean result = this.isAdmin() || this.hasObjectPermissionWritable(userId, PermissionObjectType.DOMAIN_CODE, domainCode);
        return result;
    }

    public boolean isGrowingPlanWritable(String growingPlanId) {
        boolean result;
        String userId = this.getUserId();
        boolean bl = result = this.isAdmin() || this.hasObjectPermissionWritable(userId, PermissionObjectType.GROWING_PLAN_ID, growingPlanId);
        if (!result) {
            GrowingPlan growingPlan = (GrowingPlan)this.growingPlanDao.forTopiaIdEquals(growingPlanId).findUnique();
            result = this.hasObjectPermissionWritable(userId, PermissionObjectType.GROWING_PLAN_CODE, growingPlan.getCode());
        }
        return result;
    }

    public boolean isGrowingPlanAdministrable(String growingPlanCode) {
        String userId = this.getUserId();
        boolean result = this.isAdmin() || this.hasObjectPermissionAdmin(userId, PermissionObjectType.GROWING_PLAN_CODE, growingPlanCode);
        return result;
    }

    public boolean isGrowingSystemWritable(String growingSystemId) {
        boolean result;
        String userId = this.getUserId();
        boolean bl = result = this.isAdmin() || this.hasObjectPermissionWritable(userId, PermissionObjectType.GROWING_SYSTEM_ID, growingSystemId);
        if (!result) {
            GrowingSystem growingSystem = (GrowingSystem)this.growingSystemDao.forTopiaIdEquals(growingSystemId).findUnique();
            result = this.hasObjectPermissionWritable(userId, PermissionObjectType.GROWING_SYSTEM_CODE, growingSystem.getCode());
        }
        return result;
    }

    public boolean isGrowingSystemAdministrable(String growingSystemCode) {
        String userId = this.getUserId();
        boolean result = this.isAdmin() || this.hasObjectPermissionAdmin(userId, PermissionObjectType.GROWING_SYSTEM_CODE, growingSystemCode);
        return result;
    }

    public boolean isPracticedSystemWritable(String practicedSystemId) {
        PracticedSystem practicedSystem = (PracticedSystem)this.practicedSystemDao.forTopiaIdEquals(practicedSystemId).findUnique();
        String growingSystemId = practicedSystem.getGrowingSystem().getTopiaId();
        boolean result = this.isGrowingSystemWritable(growingSystemId);
        return result;
    }

    public boolean isNetworkWritable(String networkId) {
        String userId = this.getUserId();
        boolean result = this.isAdmin() || this.hasObjectPermissionWritable(userId, PermissionObjectType.NETWORK_ID, networkId);
        return result;
    }

    public boolean isManagementModeWritable(String managementModeId) {
        ManagementMode managementMode = (ManagementMode)this.managementModeDao.forTopiaIdEquals(managementModeId).findUnique();
        String growingSystemId = managementMode.getGrowingSystem().getTopiaId();
        boolean result = this.isGrowingSystemWritable(growingSystemId);
        return result;
    }

    public boolean isManagementModeReadable(String managementModeId) {
        ManagementMode managementMode = (ManagementMode)this.managementModeDao.forTopiaIdEquals(managementModeId).findUnique();
        String growingSystemId = managementMode.getGrowingSystem().getTopiaId();
        boolean result = this.isGrowingSystemReadable(growingSystemId);
        return result;
    }

    public boolean isDecisionRuleWritable(String decisionRuleId) {
        DecisionRule decisionRule = (DecisionRule)this.decisionRuleDao.forTopiaIdEquals(decisionRuleId).findUnique();
        boolean result = this.isDomainCodeWritable(decisionRule.getDomainCode());
        if (!result) {
            List domains = this.domainDao.forCodeEquals(decisionRule.getDomainCode()).findAll();
            List growingPlans = this.growingPlanDao.forDomainIn(domains).findAll();
            for (GrowingPlan growingPlan : growingPlans) {
                String growingPlanId = growingPlan.getTopiaId();
                if (!this.isGrowingPlanWritable(growingPlanId)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean isDecisionRuleReadable(String decisionRuleId) {
        DecisionRule decisionRule = (DecisionRule)this.decisionRuleDao.forTopiaIdEquals(decisionRuleId).findUnique();
        boolean result = this.isDomainCodeReadable(decisionRule.getDomainCode());
        if (!result) {
            List domains = this.domainDao.forCodeEquals(decisionRule.getDomainCode()).findAll();
            List growingPlans = this.growingPlanDao.forDomainIn(domains).findAll();
            for (GrowingPlan growingPlan : growingPlans) {
                String growingPlanId = growingPlan.getTopiaId();
                if (!this.isGrowingPlanReadable(growingPlanId)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean isZoneWritable(String zoneId) {
        boolean result;
        Zone zone = (Zone)this.zoneDao.forTopiaIdEquals(zoneId).findUnique();
        GrowingSystem growingSystem = zone.getPlot().getGrowingSystem();
        if (growingSystem == null) {
            String domainId = zone.getPlot().getDomain().getTopiaId();
            result = this.isDomainWritable(domainId);
        } else {
            result = this.isGrowingSystemWritable(growingSystem.getTopiaId());
        }
        return result;
    }

    public void domainCreated(Domain domain) {
        String userId = this.getUserId();
        AgrosystUser user = (AgrosystUser)this.agrosystUserDao.forTopiaIdEquals(userId).findUnique();
        this.userRoleDao.create("agrosystUser", user, new Object[]{"type", RoleType.DOMAIN_RESPONSIBLE, "domainCode", domain.getCode()});
        this.dropComputedPermissions0(userId);
        this.cacheService.clear("hasRole");
    }

    public void growingPlanCreated(GrowingPlan growingPlan) {
        String userId = this.getUserId();
        AgrosystUser user = (AgrosystUser)this.agrosystUserDao.forTopiaIdEquals(userId).findUnique();
        this.userRoleDao.create("agrosystUser", user, new Object[]{"type", RoleType.GROWING_PLAN_RESPONSIBLE, "growingPlanCode", growingPlan.getCode()});
        this.dropComputedPermissions0(userId);
        Domain domain = growingPlan.getDomain();
        this.domainIsDirty(domain);
        this.cacheService.clear("hasRole");
    }

    public void growingSystemCreated(GrowingSystem growingSystem) {
        GrowingPlan growingPlan = growingSystem.getGrowingPlan();
        this.growingPlanIsDirty(growingPlan);
        this.cacheService.clear();
    }

    public void networkCreated(Network network) {
        String userId = this.getUserId();
        this.resetNetworkManagers(network);
        this.dropComputedPermissions0(userId);
        this.cacheService.clear("hasRole");
    }

    public void networkUpdated(Network network) {
        this.resetNetworkManagers(network);
        this.objectsAreDirty(PermissionObjectType.NETWORK_ID);
    }

    protected void resetNetworkManagers(Network network) {
        ArrayList existingRoles = Lists.newArrayList((Iterable)this.userRoleDao.forProperties("type", RoleType.NETWORK_RESPONSIBLE, new Object[]{"networkId", network.getTopiaId()}).findAll());
        this.userRoleDao.deleteAll(existingRoles);
        Iterable activeNetworkManagers = Iterables.filter((Iterable)network.getManagers(), IS_ACTIVE_NETWORK_MANAGER);
        ArrayList newRoles = Lists.newArrayList();
        for (NetworkManager manager : activeNetworkManagers) {
            UserRole newRole = (UserRole)this.userRoleDao.create("agrosystUser", manager.getAgrosystUser(), new Object[]{"type", RoleType.NETWORK_RESPONSIBLE, "networkId", network.getTopiaId()});
            Iterator existingRolesIt = existingRoles.iterator();
            boolean found = false;
            while (existingRolesIt.hasNext() && !found) {
                UserRole existingRole = (UserRole)existingRolesIt.next();
                if (!existingRole.getAgrosystUser().equals(newRole.getAgrosystUser())) continue;
                existingRolesIt.remove();
                found = true;
            }
            if (found) continue;
            newRoles.add(newRole);
        }
        for (UserRole existingRole : existingRoles) {
            this.trackerService.roleRemoved(existingRole);
        }
        for (UserRole newRole : newRoles) {
            this.trackerService.roleAdded(newRole);
        }
    }

    protected void growingPlanIsDirty(GrowingPlan growingPlan) {
        this.objectIsDirty(PermissionObjectType.GROWING_PLAN_ID, growingPlan.getTopiaId());
        this.objectIsDirty(PermissionObjectType.GROWING_PLAN_CODE, growingPlan.getCode());
        this.domainIsDirty(growingPlan.getDomain());
    }

    protected void domainIsDirty(Domain domain) {
        this.objectIsDirty(PermissionObjectType.DOMAIN_ID, domain.getTopiaId());
        this.objectIsDirty(PermissionObjectType.DOMAIN_CODE, domain.getCode());
    }

    public void checkIsAdmin() throws AgrosystAccessDeniedException {
        if (!this.isAdmin()) {
            throw new AgrosystAccessDeniedException();
        }
    }

    public void checkDomainReadable(String domainId) throws AgrosystAccessDeniedException {
        boolean result = this.isDomainReadable(domainId);
        if (!result) {
            throw new AgrosystAccessDeniedException();
        }
    }

    protected boolean isDomainReadable(String domainId) {
        boolean result;
        String userId = this.getUserId();
        boolean bl = result = this.isAdmin() || this.hasObjectPermissionReadable(userId, PermissionObjectType.DOMAIN_ID, domainId);
        if (!result) {
            Domain domain = (Domain)this.domainDao.forTopiaIdEquals(domainId).findUnique();
            result = this.hasObjectPermissionReadable(userId, PermissionObjectType.DOMAIN_CODE, domain.getCode());
        }
        return result;
    }

    @Deprecated
    protected void checkDomainCodeReadable(String domainCode) throws AgrosystAccessDeniedException {
        boolean result = this.isDomainCodeReadable(domainCode);
        if (!result) {
            throw new AgrosystAccessDeniedException();
        }
    }

    protected boolean isDomainCodeReadable(String domainCode) {
        String userId = this.getUserId();
        return this.isAdmin() || this.hasObjectPermissionReadable(userId, PermissionObjectType.DOMAIN_CODE, domainCode);
    }

    public boolean shouldAnonymizeDomain(String domainId) {
        boolean result = (Boolean)this.shouldAnonymizeDomain(domainId, false).getLeft();
        return result;
    }

    public Pair<Boolean, Boolean> shouldAnonymizeDomain(String domainId, boolean allowUnreadable) {
        boolean canRead = true;
        boolean result = false;
        if (!this.isAdmin()) {
            String userId = this.getUserId();
            int highestPermissionLevel = this.getHighestPermissionLevel(userId, PermissionObjectType.DOMAIN_ID, domainId);
            if (highestPermissionLevel == 0) {
                Domain domain = (Domain)this.domainDao.forTopiaIdEquals(domainId).findUnique();
                highestPermissionLevel = this.getHighestPermissionLevel(userId, PermissionObjectType.DOMAIN_CODE, domain.getCode());
            }
            Preconditions.checkState((allowUnreadable || highestPermissionLevel > 0 ? 1 : 0) != 0);
            result = highestPermissionLevel < 3;
            canRead = highestPermissionLevel >= 1;
        }
        return Pair.of((Object)result, (Object)canRead);
    }

    public boolean shouldAnonymizeGrowingPlan(String growingPlanId) {
        boolean result = (Boolean)this.shouldAnonymizeGrowingPlan(growingPlanId, false).getLeft();
        return result;
    }

    public Pair<Boolean, Boolean> shouldAnonymizeGrowingPlan(String growingPlanId, boolean allowUnreadable) {
        boolean canRead = true;
        boolean result = false;
        if (!this.isAdmin()) {
            String userId = this.getUserId();
            int highestPermissionLevel = this.getHighestPermissionLevel(userId, PermissionObjectType.GROWING_PLAN_ID, growingPlanId);
            if (highestPermissionLevel == 0) {
                GrowingPlan growingPlan = (GrowingPlan)this.growingPlanDao.forTopiaIdEquals(growingPlanId).findUnique();
                highestPermissionLevel = this.getHighestPermissionLevel(userId, PermissionObjectType.GROWING_PLAN_CODE, growingPlan.getCode());
            }
            Preconditions.checkState((allowUnreadable || highestPermissionLevel > 0 ? 1 : 0) != 0);
            result = highestPermissionLevel < 3;
            canRead = highestPermissionLevel >= 1;
        }
        return Pair.of((Object)result, (Object)canRead);
    }

    public void checkGrowingPlanReadable(String growingPlanId) throws AgrosystAccessDeniedException {
        boolean result = this.isGrowingPlanReadable(growingPlanId);
        if (!result) {
            throw new AgrosystAccessDeniedException();
        }
    }

    protected boolean isGrowingPlanReadable(String growingPlanId) {
        boolean result;
        String userId = this.getUserId();
        boolean bl = result = this.isAdmin() || this.hasObjectPermissionReadable(userId, PermissionObjectType.GROWING_PLAN_ID, growingPlanId);
        if (!result) {
            GrowingPlan growingPlan = (GrowingPlan)this.growingPlanDao.forTopiaIdEquals(growingPlanId).findUnique();
            result = this.hasObjectPermissionReadable(userId, PermissionObjectType.GROWING_PLAN_CODE, growingPlan.getCode());
        }
        return result;
    }

    public boolean isGrowingSystemReadable(String growingSystemId) {
        boolean result;
        String userId = this.getUserId();
        boolean bl = result = this.isAdmin() || this.hasObjectPermissionReadable(userId, PermissionObjectType.GROWING_SYSTEM_ID, growingSystemId);
        if (!result) {
            GrowingSystem growingSystem = (GrowingSystem)this.growingSystemDao.forTopiaIdEquals(growingSystemId).findUnique();
            result = this.hasObjectPermissionReadable(userId, PermissionObjectType.GROWING_SYSTEM_CODE, growingSystem.getCode());
        }
        return result;
    }

    public void checkGrowingSystemReadable(String growingSystemId) throws AgrosystAccessDeniedException {
        if (!this.isGrowingSystemReadable(growingSystemId)) {
            throw new AgrosystAccessDeniedException();
        }
    }

    public void checkPracticedSystemReadable(String practicedSystemId) throws AgrosystAccessDeniedException {
        PracticedSystem practicedSystem = (PracticedSystem)this.practicedSystemDao.forTopiaIdEquals(practicedSystemId).findUnique();
        String growingSystemId = practicedSystem.getGrowingSystem().getTopiaId();
        this.checkGrowingSystemReadable(growingSystemId);
    }

    public void checkDecisionRuleReadable(String decisionRuleId) throws AgrosystAccessDeniedException {
        DecisionRule decisionRule = (DecisionRule)this.decisionRuleDao.forTopiaIdEquals(decisionRuleId).findUnique();
        this.checkDomainCodeReadable(decisionRule.getDomainCode());
    }

    public void checkManagementModeReadable(String managementModeId) throws AgrosystAccessDeniedException {
        ManagementMode managementMode = (ManagementMode)this.managementModeDao.forTopiaIdEquals(managementModeId).findUnique();
        String growingSystemId = managementMode.getGrowingSystem().getTopiaId();
        this.checkGrowingSystemReadable(growingSystemId);
    }

    public void checkEffectiveCropCyclesReadable(String zoneId) throws AgrosystAccessDeniedException {
        boolean result = this.isZoneReadable(zoneId);
        if (!result) {
            throw new AgrosystAccessDeniedException();
        }
    }

    protected boolean isZoneReadable(String zoneId) {
        boolean result;
        Zone zone = (Zone)this.zoneDao.forTopiaIdEquals(zoneId).findUnique();
        if (zone.getPlot().getGrowingSystem() == null) {
            String domainId = zone.getPlot().getDomain().getTopiaId();
            result = this.isDomainReadable(domainId);
        } else {
            String growingSystemId = zone.getPlot().getGrowingSystem().getTopiaId();
            result = this.isGrowingSystemReadable(growingSystemId);
        }
        return result;
    }

    public void checkCreateOrUpdateDomain(String domainId) throws AgrosystAccessDeniedException {
        if (!Strings.isNullOrEmpty((String)domainId) && !this.isDomainWritable(domainId)) {
            throw new AgrosystAccessDeniedException();
        }
    }

    public void checkCreateOrUpdateGrowingPlan(String growingPlanId) throws AgrosystAccessDeniedException {
        if (!Strings.isNullOrEmpty((String)growingPlanId) && !this.isGrowingPlanWritable(growingPlanId)) {
            throw new AgrosystAccessDeniedException();
        }
    }

    public void checkCreateOrUpdateGrowingSystem(String growingSystemId) throws AgrosystAccessDeniedException {
        if (!Strings.isNullOrEmpty((String)growingSystemId) && !this.isGrowingSystemWritable(growingSystemId)) {
            throw new AgrosystAccessDeniedException();
        }
    }

    public void checkCreateOrUpdateNetwork(String networkId) throws AgrosystAccessDeniedException {
        if (!Strings.isNullOrEmpty((String)networkId) && !this.isNetworkWritable(networkId)) {
            throw new AgrosystAccessDeniedException();
        }
    }

    public void checkCreateOrUpdatePracticedSystem(String practicedSystemTopiaId) throws AgrosystAccessDeniedException {
        if (!Strings.isNullOrEmpty((String)practicedSystemTopiaId) && !this.isPracticedSystemWritable(practicedSystemTopiaId)) {
            throw new AgrosystAccessDeniedException();
        }
    }

    public void checkCreateOrUpdateDecisionRule(String decisionRuleId) throws AgrosystAccessDeniedException {
        if (!Strings.isNullOrEmpty((String)decisionRuleId) && !this.isDecisionRuleWritable(decisionRuleId)) {
            throw new AgrosystAccessDeniedException();
        }
    }

    public void checkCreateOrUpdateManagementMode(String managementModeId) throws AgrosystAccessDeniedException {
        if (!Strings.isNullOrEmpty((String)managementModeId) && !this.isManagementModeWritable(managementModeId)) {
            throw new AgrosystAccessDeniedException();
        }
    }

    public void checkCreateOrUpdateEffectiveCropCycles(String zoneId) throws AgrosystAccessDeniedException {
        if (!Strings.isNullOrEmpty((String)zoneId) && !this.isZoneWritable(zoneId)) {
            throw new AgrosystAccessDeniedException();
        }
    }

    public boolean isDomainValidable(String domainId) {
        return this.isDomainWritable(domainId);
    }

    public void checkValidateDomain(String domainId) throws AgrosystAccessDeniedException {
        if (!this.isDomainValidable(domainId)) {
            throw new AgrosystAccessDeniedException();
        }
    }

    public boolean isGrowingPlanValidable(String growingPlanId) {
        return this.isGrowingPlanWritable(growingPlanId);
    }

    public void checkValidateGrowingPlan(String growingPlanId) throws AgrosystAccessDeniedException {
        if (!this.isGrowingPlanWritable(growingPlanId)) {
            throw new AgrosystAccessDeniedException();
        }
    }

    public boolean isGrowingSystemValidable(String growingSystemId) {
        return this.isGrowingSystemWritable(growingSystemId);
    }

    public void checkValidateGrowingSystem(String growingSystemId) throws AgrosystAccessDeniedException {
        if (!this.isGrowingSystemWritable(growingSystemId)) {
            throw new AgrosystAccessDeniedException();
        }
    }

    public boolean isPracticedSystemValidable(String practicedSystemId) {
        PracticedSystem practicedSystem = (PracticedSystem)this.practicedSystemDao.forTopiaIdEquals(practicedSystemId).findUnique();
        String growingSystemId = practicedSystem.getGrowingSystem().getTopiaId();
        boolean result = this.isGrowingSystemWritable(growingSystemId);
        return result;
    }

    public void checkValidatePracticedSystem(String practicedSystemId) throws AgrosystAccessDeniedException {
        if (!this.isPracticedSystemValidable(practicedSystemId)) {
            throw new AgrosystAccessDeniedException();
        }
    }

    public boolean areAttachmentsAddableOrDeletable(String objectReferenceId) {
        boolean result = this.canCreateOrDeleteAttachment(objectReferenceId);
        return result;
    }

    public void checkAddAttachment(String objectReferenceId) {
        if (!this.canCreateOrDeleteAttachment(objectReferenceId)) {
            throw new AgrosystAccessDeniedException();
        }
    }

    public void checkDeleteAttachment(String attachmentMetadataId) {
        AttachmentMetadata attachmentMetadata = (AttachmentMetadata)this.attachmentMetadataDao.forTopiaIdEquals(attachmentMetadataId).findUnique();
        String objectReferenceId = attachmentMetadata.getObjectReferenceId();
        if (!this.canCreateOrDeleteAttachment(objectReferenceId)) {
            throw new AgrosystAccessDeniedException();
        }
    }

    protected boolean canCreateOrDeleteAttachment(String referenceId) {
        String userId = this.getUserId();
        boolean result = this.isAdmin() || this.hasObjectPermissionWritable(userId, referenceId);
        TopiaIdFactory topiaIdFactory = this.context.getPersistenceContext().getTopiaIdFactory();
        if (!result && topiaIdFactory.isTopiaId(referenceId) && ManagementMode.class.equals((Object)topiaIdFactory.getClassName(referenceId))) {
            result = this.isManagementModeWritable(referenceId);
        }
        if (!result && topiaIdFactory.isTopiaId(referenceId) && Performance.class.equals((Object)topiaIdFactory.getClassName(referenceId))) {
            result = this.isPerformanceWritable(referenceId);
        }
        if (!result) {
            if (referenceId.endsWith("-measurement")) {
                referenceId = referenceId.substring(0, referenceId.lastIndexOf("-measurement"));
            }
            if (topiaIdFactory.isTopiaId(referenceId) && Zone.class.equals((Object)topiaIdFactory.getClassName(referenceId))) {
                result = this.isZoneWritable(referenceId);
            }
        }
        if (!result) {
            Iterable decisionRules = this.decisionRuleDao.forCodeEquals(referenceId).findAllLazy();
            Iterator iterator = decisionRules.iterator();
            while (!result && iterator.hasNext()) {
                DecisionRule decisionRule = (DecisionRule)iterator.next();
                result = this.isDecisionRuleWritable(decisionRule.getTopiaId());
            }
        }
        return result;
    }

    public void checkReadAttachment(String attachmentMetadataId) {
        Iterator iterator;
        AttachmentMetadata attachmentMetadata = (AttachmentMetadata)this.attachmentMetadataDao.forTopiaIdEquals(attachmentMetadataId).findUnique();
        String referenceId = attachmentMetadata.getObjectReferenceId();
        String userId = this.getUserId();
        boolean result = this.isAdmin() || this.hasObjectPermissionReadable(userId, referenceId);
        TopiaIdFactory topiaIdFactory = this.context.getPersistenceContext().getTopiaIdFactory();
        if (!result && topiaIdFactory.isTopiaId(referenceId) && ManagementMode.class.equals((Object)topiaIdFactory.getClassName(referenceId))) {
            result = this.isManagementModeReadable(referenceId);
        }
        if (!result && topiaIdFactory.isTopiaId(referenceId) && Performance.class.equals((Object)topiaIdFactory.getClassName(referenceId))) {
            result = this.isPerformanceReadable(referenceId);
        }
        if (!result) {
            if (referenceId.endsWith("-measurement")) {
                referenceId = referenceId.substring(0, referenceId.lastIndexOf("-measurement"));
            }
            if (topiaIdFactory.isTopiaId(referenceId) && Zone.class.equals((Object)topiaIdFactory.getClassName(referenceId))) {
                result = this.isZoneReadable(referenceId);
            }
        }
        if (!result) {
            Iterable growingSystems = this.growingSystemDao.forCodeEquals(referenceId).findAllLazy();
            iterator = growingSystems.iterator();
            while (!result && iterator.hasNext()) {
                GrowingSystem growingSystem = (GrowingSystem)iterator.next();
                result = this.hasObjectPermissionReadable(userId, growingSystem.getTopiaId());
            }
        }
        if (!result) {
            Iterable decisionRules = this.decisionRuleDao.forCodeEquals(referenceId).findAllLazy();
            iterator = decisionRules.iterator();
            while (!result && iterator.hasNext()) {
                DecisionRule decisionRule = (DecisionRule)iterator.next();
                result = this.isDecisionRuleReadable(decisionRule.getTopiaId());
            }
        }
        if (!result) {
            throw new AgrosystAccessDeniedException();
        }
    }

    public boolean isPerformanceWritable(String performanceId) {
        boolean result = this.isAdmin();
        if (!result) {
            String userId = this.getUserId();
            AgrosystUser user = (AgrosystUser)this.agrosystUserDao.forTopiaIdEquals(userId).findUnique();
            long count = this.performanceDao.forProperties("topiaId", performanceId, new Object[]{"author", user}).count();
            result = count == 1L;
        }
        return result;
    }

    public void checkPerformanceReadable(String performanceId) throws AgrosystAccessDeniedException {
        if (!this.isPerformanceReadable(performanceId)) {
            throw new AgrosystAccessDeniedException();
        }
    }

    protected boolean isPerformanceReadable(String performanceId) {
        return this.isPerformanceWritable(performanceId);
    }

    public void checkCreateOrUpdatePerformance(String performanceId) throws AgrosystAccessDeniedException {
        if (!Strings.isNullOrEmpty((String)performanceId) && !this.isPerformanceWritable(performanceId)) {
            throw new AgrosystAccessDeniedException();
        }
    }

    public boolean isPlotWritable(String plotId) {
        Plot plot = (Plot)this.plotDao.forTopiaIdEquals(plotId).findUnique();
        String domainId = plot.getDomain().getTopiaId();
        boolean result = this.isDomainWritable(domainId);
        return result;
    }

    public void checkPlotReadable(String plotId) throws AgrosystAccessDeniedException {
        Plot plot = (Plot)this.plotDao.forTopiaIdEquals(plotId).findUnique();
        String domainId = plot.getDomain().getTopiaId();
        this.checkDomainReadable(domainId);
    }

    public void checkCreateOrUpdatePlot(String plotId) throws AgrosystAccessDeniedException {
        if (!Strings.isNullOrEmpty((String)plotId) && !this.isPlotWritable(plotId)) {
            throw new AgrosystAccessDeniedException();
        }
    }

    public void checkPracticedPlotReadable(String practicedPlotId) throws AgrosystAccessDeniedException {
        PracticedPlot practicedPlot = (PracticedPlot)this.practicedPlotDao.forTopiaIdEquals(practicedPlotId).findUnique();
        String practicedSystemId = practicedPlot.getPracticedSystem().getTopiaId();
        this.checkPracticedSystemReadable(practicedSystemId);
    }

    public boolean isPracticedPlotWritable(String practicedPlotId) {
        PracticedPlot practicedPlot = (PracticedPlot)this.practicedPlotDao.forTopiaIdEquals(practicedPlotId).findUnique();
        String practicedSystemId = practicedPlot.getPracticedSystem().getTopiaId();
        boolean result = this.isPracticedSystemWritable(practicedSystemId);
        return result;
    }

    public void checkCreateOrUpdatePracticedPlot(String practicedPlotId, String practicedSystemId) throws AgrosystAccessDeniedException {
        if (Strings.isNullOrEmpty((String)practicedPlotId)) {
            this.checkCreateOrUpdatePracticedSystem(practicedSystemId);
        } else if (!this.isPracticedPlotWritable(practicedPlotId)) {
            throw new AgrosystAccessDeniedException();
        }
    }
}

