/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.security;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainTopiaDao;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingPlanTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.GrowingSystemTopiaDao;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.entities.NetworkTopiaDao;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.entities.security.AgrosystUserTopiaDao;
import fr.inra.agrosyst.api.entities.security.ComputedUserPermission;
import fr.inra.agrosyst.api.entities.security.ComputedUserPermissionTopiaDao;
import fr.inra.agrosyst.api.entities.security.PermissionObjectType;
import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.entities.security.UserRole;
import fr.inra.agrosyst.api.entities.security.UserRoleTopiaDao;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanFilter;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemFilter;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.network.NetworkFilter;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.security.UsersRolesAndDependencies;
import fr.inra.agrosyst.api.services.referential.ImportResult;
import fr.inra.agrosyst.api.services.security.AuthenticationService;
import fr.inra.agrosyst.api.services.security.AuthorizationService;
import fr.inra.agrosyst.api.services.security.InvalidTokenException;
import fr.inra.agrosyst.api.services.security.UserRoleDto;
import fr.inra.agrosyst.api.services.security.UserRoleEntityDto;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.Users;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.CacheService;
import fr.inra.agrosyst.services.security.ImportUserRoleDto;
import fr.inra.agrosyst.services.security.TrackerServiceImpl;
import fr.inra.agrosyst.services.security.UserRolesImportModel;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.topia.persistence.TopiaEntity;

public class AuthorizationServiceImpl
extends AbstractAgrosystService
implements AuthorizationService {
    private static final Log log = LogFactory.getLog(AuthorizationServiceImpl.class);
    public static final Function<Domain, String> GET_DOMAIN_ENTITY_LABEL = new Function<Domain, String>(){

        public String apply(Domain domain) {
            if (domain == null) {
                return "n/c";
            }
            return String.format("%s (%s)", domain.getName(), domain.getLocation().getCodePostal());
        }
    };
    public static final Function<GrowingPlan, String> GET_GROWING_PLAN_ENTITY_LABEL = new Function<GrowingPlan, String>(){

        public String apply(GrowingPlan growingPlan) {
            if (growingPlan == null) {
                return "n/c";
            }
            return String.format("%s (%s)", growingPlan.getName(), growingPlan.getDomain().getName());
        }
    };
    public static final Function<GrowingSystem, String> GET_GROWING_SYSTEM_ENTITY_LABEL = new Function<GrowingSystem, String>(){

        public String apply(GrowingSystem growingSystem) {
            if (growingSystem == null) {
                return "n/c";
            }
            return String.format("%s (%s)", growingSystem.getName(), growingSystem.getGrowingPlan().getDomain().getName());
        }
    };
    protected AuthenticationService authenticationService;
    protected GrowingSystemService growingSystemService;
    protected DomainService domainService;
    protected NetworkService networkService;
    protected GrowingPlanService growingPlanService;
    protected TrackerServiceImpl trackerService;
    protected CacheService cacheService;
    protected UserRoleTopiaDao userRoleDao;
    protected AgrosystUserTopiaDao agrosystUserDao;
    protected ComputedUserPermissionTopiaDao computedUserPermissionDao;
    protected NetworkTopiaDao networkDao;
    protected DomainTopiaDao domainDao;
    protected GrowingPlanTopiaDao growingPlanDao;
    protected GrowingSystemTopiaDao growingSystemDao;

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    public void setTrackerService(TrackerServiceImpl trackerService) {
        this.trackerService = trackerService;
    }

    public void setUserRoleDao(UserRoleTopiaDao userRoleDao) {
        this.userRoleDao = userRoleDao;
    }

    public void setAgrosystUserDao(AgrosystUserTopiaDao agrosystUserDao) {
        this.agrosystUserDao = agrosystUserDao;
    }

    public void setComputedUserPermissionDao(ComputedUserPermissionTopiaDao computedUserPermissionDao) {
        this.computedUserPermissionDao = computedUserPermissionDao;
    }

    public void setNetworkDao(NetworkTopiaDao networkDao) {
        this.networkDao = networkDao;
    }

    public void setDomainDao(DomainTopiaDao domainDao) {
        this.domainDao = domainDao;
    }

    public void setGrowingPlanDao(GrowingPlanTopiaDao growingPlanDao) {
        this.growingPlanDao = growingPlanDao;
    }

    public void setGrowingSystemDao(GrowingSystemTopiaDao growingSystemDao) {
        this.growingSystemDao = growingSystemDao;
    }

    protected String getUserId() {
        String token = this.getSecurityContext().getAuthenticationToken();
        String userId = this.checkComputedPermissions(token);
        return userId;
    }

    protected String getUserIdOrFail(String authenticationToken) {
        String result = this.authenticationService.getAuthenticatedUserId(authenticationToken);
        if (Strings.isNullOrEmpty((String)result)) {
            throw new InvalidTokenException("The given authentication token is invalid, no user associated with it");
        }
        return result;
    }

    protected boolean hasRole(final String authenticationToken, final RoleType roleType) {
        Callable<Boolean> loader = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String userId = AuthorizationServiceImpl.this.getUserIdOrFail(authenticationToken);
                UserRole role = AuthorizationServiceImpl.this.userRoleDao.findRole(userId, roleType);
                boolean result = role != null;
                return result;
            }
        };
        boolean result = this.cacheService.get("hasRole", authenticationToken + "_" + roleType, loader);
        return result;
    }

    public boolean isAdmin() {
        String token = this.getSecurityContext().getAuthenticationToken();
        boolean result = this.isAdmin(token);
        return result;
    }

    public boolean isAdmin(String authenticationToken) {
        boolean result = this.hasRole(authenticationToken, RoleType.ADMIN);
        return result;
    }

    public boolean isIsDataProcessor() {
        String authenticationToken = this.getSecurityContext().getAuthenticationToken();
        boolean result = this.isIsDataProcessor(authenticationToken);
        return result;
    }

    public boolean isIsDataProcessor(String authenticationToken) {
        boolean result = this.hasRole(authenticationToken, RoleType.IS_DATA_PROCESSOR);
        return result;
    }

    public boolean canCreateUser(String authenticationToken) {
        String userId = this.getUserIdOrFail(authenticationToken);
        boolean result = this.hasRole(authenticationToken, RoleType.ADMIN);
        if (!result) {
            UserRole networkManagerRole = this.userRoleDao.findNetworkResponsibleRole(userId);
            result = networkManagerRole != null;
        }
        return result;
    }

    public void dropComputedPermissions(String authenticationToken) {
        String userId = this.getUserIdOrFail(authenticationToken);
        this.dropComputedPermissions0(userId);
        this.getTransaction().commit();
    }

    protected void dropComputedPermissions0(String userId) {
        List permissions = this.computedUserPermissionDao.forUserIdEquals(userId).findAll();
        if (permissions != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("%d permission(s) are about to be deleted for user '%s'", permissions.size(), userId));
            }
            this.computedUserPermissionDao.deleteAll(permissions);
        }
    }

    public String checkComputedPermissions(String authenticationToken, String doAsUserId) {
        if (!Strings.isNullOrEmpty((String)doAsUserId) && this.isAdmin(authenticationToken)) {
            return this.checkComputedPermissionFromUserId(doAsUserId);
        }
        return this.checkComputedPermissions(authenticationToken);
    }

    public String checkComputedPermissions(String authenticationToken) {
        String userId = this.getUserIdOrFail(authenticationToken);
        return this.checkComputedPermissionFromUserId(userId);
    }

    protected String checkComputedPermissionFromUserId(String userId) {
        long start = System.currentTimeMillis();
        long usersPermissionCount = this.computedUserPermissionDao.getUsersPermissionCount(userId);
        boolean hasDeletion = false;
        int newPermissionsCount = 0;
        if (usersPermissionCount == 0L || this.computedUserPermissionDao.getUsersDirtyCount(userId) >= 1L) {
            if (usersPermissionCount >= 1L) {
                this.dropComputedPermissions0(userId);
                hasDeletion = true;
            }
            Set<ComputedUserPermission> permissions = this.computeUserPermissions(userId);
            newPermissionsCount = permissions.size();
            for (ComputedUserPermission permission : permissions) {
                this.computedUserPermissionDao.create((TopiaEntity)permission);
            }
        }
        if (hasDeletion || newPermissionsCount > 0) {
            this.getTransaction().commit();
        }
        if (log.isTraceEnabled()) {
            long duration = System.currentTimeMillis() - start;
            String text = "User's permissions computation took %dms. %d new permission(s) created.";
            String message = String.format(text, duration, newPermissionsCount);
            log.trace((Object)message);
        }
        return userId;
    }

    protected Function<UserRole, UserRoleDto> getUserRoleToDtoFunction(final boolean includeEntity, final boolean includeUser) {
        Function<UserRole, UserRoleDto> function = new Function<UserRole, UserRoleDto>(){

            public UserRoleDto apply(UserRole input) {
                UserRoleEntityDto entityDto;
                UserRoleDto result = new UserRoleDto();
                result.setTopiaId(input.getTopiaId());
                result.setType(input.getType());
                if (includeEntity) {
                    if (!RoleType.IS_DATA_PROCESSOR.equals((Object)input.getType()) && !RoleType.ADMIN.equals((Object)input.getType())) {
                        String label;
                        String identifier;
                        entityDto = new UserRoleEntityDto();
                        result.setEntity(entityDto);
                        Integer campaign = null;
                        switch (input.getType()) {
                            case NETWORK_RESPONSIBLE: {
                                identifier = input.getNetworkId();
                                label = ((Network)AuthorizationServiceImpl.this.networkDao.forTopiaIdEquals(identifier).findUnique()).getName();
                                break;
                            }
                            case DOMAIN_RESPONSIBLE: {
                                identifier = input.getDomainCode();
                                Domain domain = (Domain)AuthorizationServiceImpl.this.domainDao.forCodeEquals(identifier).findAny();
                                label = (String)GET_DOMAIN_ENTITY_LABEL.apply((Object)domain);
                                break;
                            }
                            case GROWING_PLAN_RESPONSIBLE: {
                                identifier = input.getGrowingPlanCode();
                                GrowingPlan growingPlan = (GrowingPlan)AuthorizationServiceImpl.this.growingPlanDao.forCodeEquals(identifier).findAny();
                                label = (String)GET_GROWING_PLAN_ENTITY_LABEL.apply((Object)growingPlan);
                                break;
                            }
                            case GS_DATA_PROCESSOR: {
                                GrowingSystem growingSystem;
                                if (!Strings.isNullOrEmpty((String)input.getGrowingSystemId())) {
                                    growingSystem = (GrowingSystem)AuthorizationServiceImpl.this.growingSystemDao.forTopiaIdEquals(input.getGrowingSystemId()).findUnique();
                                    campaign = growingSystem.getGrowingPlan().getDomain().getCampaign();
                                } else {
                                    growingSystem = (GrowingSystem)AuthorizationServiceImpl.this.growingSystemDao.forCodeEquals(input.getGrowingSystemCode()).findAny();
                                }
                                identifier = growingSystem.getCode();
                                label = (String)GET_GROWING_SYSTEM_ENTITY_LABEL.apply((Object)growingSystem);
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("Not supposed to happen");
                            }
                        }
                        entityDto.setIdentifier(identifier);
                        entityDto.setLabel(label);
                        entityDto.setCampaign(campaign);
                    }
                } else if (RoleType.GS_DATA_PROCESSOR.equals((Object)input.getType()) && !Strings.isNullOrEmpty((String)input.getGrowingSystemId())) {
                    entityDto = new UserRoleEntityDto();
                    GrowingSystem growingSystem = (GrowingSystem)AuthorizationServiceImpl.this.growingSystemDao.forTopiaIdEquals(input.getGrowingSystemId()).findUnique();
                    Integer campaign = growingSystem.getGrowingPlan().getDomain().getCampaign();
                    entityDto.setCampaign(campaign);
                    result.setEntity(entityDto);
                }
                if (includeUser) {
                    AgrosystUser user = input.getAgrosystUser();
                    UserDto userDto = (UserDto)Users.TO_USER_DTO.apply((Object)user);
                    result.setUser(userDto);
                }
                return result;
            }
        };
        return function;
    }

    public List<UserRoleDto> getUserRoles(String userId) {
        LinkedList result = Lists.newLinkedList();
        List<UserRole> roles = this.userRoleDao.findAllForUserId(userId);
        Iterables.addAll((Collection)result, (Iterable)Iterables.transform(roles, this.getUserRoleToDtoFunction(true, false)));
        return result;
    }

    public List<UserRoleDto> getEntityRoles(RoleType roleType, String entityCode) {
        LinkedList result = Lists.newLinkedList();
        List<UserRole> roles = this.getUserRoles0(roleType, entityCode);
        Iterables.addAll((Collection)result, (Iterable)Iterables.transform(roles, this.getUserRoleToDtoFunction(false, true)));
        return result;
    }

    protected List<UserRole> getUserRoles0(RoleType roleType, String entityCode) {
        HashMap properties = Maps.newHashMap();
        properties.put("type", roleType);
        switch (roleType) {
            case DOMAIN_RESPONSIBLE: {
                properties.put("domainCode", entityCode);
                break;
            }
            case GROWING_PLAN_RESPONSIBLE: {
                properties.put("growingPlanCode", entityCode);
                break;
            }
            case GS_DATA_PROCESSOR: {
                properties.put("growingSystemCode", entityCode);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexcpected role type: " + roleType);
            }
        }
        List roles = this.userRoleDao.forProperties(properties).findAll();
        if (RoleType.GS_DATA_PROCESSOR.equals((Object)roleType)) {
            List relatedGrowingSystemIds = this.growingSystemDao.forCodeEquals(entityCode).findAllIds();
            List gsCampaignRoles = this.userRoleDao.newQueryBuilder().addEquals("type", (Object)RoleType.GS_DATA_PROCESSOR).addIn("growingSystemId", (Collection)relatedGrowingSystemIds).findAll();
            Iterables.addAll((Collection)roles, (Iterable)gsCampaignRoles);
        }
        return roles;
    }

    public List<UserRoleEntityDto> searchPossibleEntities(RoleType roleType, String termRaw) {
        String term = Strings.emptyToNull((String)termRaw);
        LinkedList dtos = Lists.newLinkedList();
        switch (roleType) {
            case ADMIN: 
            case IS_DATA_PROCESSOR: {
                break;
            }
            case DOMAIN_RESPONSIBLE: {
                DomainFilter domainFilter = new DomainFilter();
                domainFilter.setDomainName(term);
                domainFilter.setPageSize(-1);
                ResultList filteredDomains = this.domainService.getFilteredDomains(domainFilter);
                Iterables.addAll((Collection)dtos, (Iterable)Iterables.transform((Iterable)filteredDomains, (Function)new Function<Domain, UserRoleEntityDto>(){

                    public UserRoleEntityDto apply(Domain input) {
                        UserRoleEntityDto result = new UserRoleEntityDto();
                        result.setIdentifier(input.getCode());
                        result.setLabel((String)GET_DOMAIN_ENTITY_LABEL.apply((Object)input));
                        return result;
                    }
                }));
                break;
            }
            case NETWORK_RESPONSIBLE: {
                NetworkFilter networkFilter = new NetworkFilter();
                networkFilter.setNetworkName(term);
                networkFilter.setPageSize(-1);
                ResultList filteredNetworks = this.networkService.getFilteredNetworks(networkFilter);
                Iterables.addAll((Collection)dtos, (Iterable)Iterables.transform((Iterable)filteredNetworks, (Function)new Function<Network, UserRoleEntityDto>(){

                    public UserRoleEntityDto apply(Network input) {
                        UserRoleEntityDto result = new UserRoleEntityDto();
                        result.setIdentifier(input.getTopiaId());
                        result.setLabel(input.getName());
                        return result;
                    }
                }));
                break;
            }
            case GROWING_PLAN_RESPONSIBLE: {
                GrowingPlanFilter growingPlanFilter = new GrowingPlanFilter();
                growingPlanFilter.setGrowingPlanName(term);
                growingPlanFilter.setPageSize(-1);
                ResultList filteredGrowingPlans = this.growingPlanService.getFilteredGrowingPlans(growingPlanFilter);
                Iterables.addAll((Collection)dtos, (Iterable)Iterables.transform((Iterable)filteredGrowingPlans, (Function)new Function<GrowingPlan, UserRoleEntityDto>(){

                    public UserRoleEntityDto apply(GrowingPlan input) {
                        UserRoleEntityDto result = new UserRoleEntityDto();
                        result.setIdentifier(input.getCode());
                        result.setLabel((String)GET_GROWING_PLAN_ENTITY_LABEL.apply((Object)input));
                        return result;
                    }
                }));
                break;
            }
            case GS_DATA_PROCESSOR: {
                GrowingSystemFilter growingSystemFilter = new GrowingSystemFilter();
                growingSystemFilter.setGrowingSystemName(term);
                growingSystemFilter.setPageSize(-1);
                ResultList filteredGrowingSystems = this.growingSystemService.getFilteredGrowingSystems(growingSystemFilter);
                Iterables.addAll((Collection)dtos, (Iterable)Iterables.transform((Iterable)filteredGrowingSystems, (Function)new Function<GrowingSystem, UserRoleEntityDto>(){

                    public UserRoleEntityDto apply(GrowingSystem input) {
                        UserRoleEntityDto result = new UserRoleEntityDto();
                        result.setIdentifier(input.getCode());
                        result.setLabel((String)GET_GROWING_SYSTEM_ENTITY_LABEL.apply((Object)input));
                        return result;
                    }
                }));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected type: " + roleType);
            }
        }
        ImmutableListMultimap index = Multimaps.index((Iterable)dtos, (Function)new Function<UserRoleEntityDto, String>(){

            public String apply(UserRoleEntityDto input) {
                return input.getIdentifier();
            }
        });
        Set keySet = index.keySet();
        ArrayList result = Lists.newArrayListWithCapacity((int)keySet.size());
        for (String identifier : keySet) {
            Collection identifierEntities = index.get((Object)identifier);
            UserRoleEntityDto entity = (UserRoleEntityDto)Iterables.getFirst((Iterable)identifierEntities, null);
            result.add(entity);
        }
        return result;
    }

    public List<UserRoleEntityDto> searchEntities(RoleType roleType, String termRaw, Integer campaign) {
        LinkedList dtos = Lists.newLinkedList();
        switch (roleType) {
            case ADMIN: 
            case IS_DATA_PROCESSOR: {
                break;
            }
            case DOMAIN_RESPONSIBLE: {
                List filteredDomains = this.domainService.getDomainWithName(termRaw);
                Iterables.addAll((Collection)dtos, (Iterable)Iterables.transform((Iterable)filteredDomains, (Function)new Function<Domain, UserRoleEntityDto>(){

                    public UserRoleEntityDto apply(Domain input) {
                        UserRoleEntityDto result = new UserRoleEntityDto();
                        result.setIdentifier(input.getCode());
                        result.setLabel((String)GET_DOMAIN_ENTITY_LABEL.apply((Object)input));
                        return result;
                    }
                }));
                break;
            }
            case NETWORK_RESPONSIBLE: {
                List filteredNetworks = this.networkService.getNteworkWithName(termRaw);
                Iterables.addAll((Collection)dtos, (Iterable)Iterables.transform((Iterable)filteredNetworks, (Function)new Function<Network, UserRoleEntityDto>(){

                    public UserRoleEntityDto apply(Network input) {
                        UserRoleEntityDto result = new UserRoleEntityDto();
                        result.setIdentifier(input.getTopiaId());
                        result.setLabel(input.getName());
                        return result;
                    }
                }));
                break;
            }
            case GROWING_PLAN_RESPONSIBLE: {
                List filteredGrowingPlans = this.growingPlanService.getGrowingPlanWithName(termRaw);
                Iterables.addAll((Collection)dtos, (Iterable)Iterables.transform((Iterable)filteredGrowingPlans, (Function)new Function<GrowingPlan, UserRoleEntityDto>(){

                    public UserRoleEntityDto apply(GrowingPlan input) {
                        UserRoleEntityDto result = new UserRoleEntityDto();
                        result.setIdentifier(input.getCode());
                        result.setLabel((String)GET_GROWING_PLAN_ENTITY_LABEL.apply((Object)input));
                        return result;
                    }
                }));
                break;
            }
            case GS_DATA_PROCESSOR: {
                List filteredGrowingSystems = this.growingSystemService.getGrowingSystemWithNameAndCampaign(termRaw, campaign);
                HashMap orderedGrowingSystems = Maps.newHashMap();
                for (GrowingSystem growingSystem : filteredGrowingSystems) {
                    GrowingSystem gs = (GrowingSystem)orderedGrowingSystems.get(growingSystem.getCode());
                    if (gs != null) continue;
                    orderedGrowingSystems.put(growingSystem.getCode(), growingSystem);
                }
                if (orderedGrowingSystems.size() != 1) break;
                Iterables.addAll((Collection)dtos, (Iterable)Iterables.transform(orderedGrowingSystems.values(), (Function)new Function<GrowingSystem, UserRoleEntityDto>(){

                    public UserRoleEntityDto apply(GrowingSystem input) {
                        UserRoleEntityDto result = new UserRoleEntityDto();
                        result.setIdentifier(input.getCode());
                        result.setLabel((String)GET_GROWING_SYSTEM_ENTITY_LABEL.apply((Object)input));
                        return result;
                    }
                }));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected type: " + roleType);
            }
        }
        ImmutableListMultimap index = Multimaps.index((Iterable)dtos, (Function)new Function<UserRoleEntityDto, String>(){

            public String apply(UserRoleEntityDto input) {
                return input.getIdentifier();
            }
        });
        Set keySet = index.keySet();
        ArrayList result = Lists.newArrayListWithCapacity((int)keySet.size());
        for (String identifier : keySet) {
            Collection identifierEntities = index.get((Object)identifier);
            UserRoleEntityDto entity = (UserRoleEntityDto)Iterables.getFirst((Iterable)identifierEntities, null);
            result.add(entity);
        }
        return result;
    }

    public void saveUserRoles(String userId, List<UserRoleDto> userRoles) {
        this.createOrUpdateUserRoles(userId, userRoles, true);
    }

    public void addUserRoles(String userId, List<UserRoleDto> userRoles) {
        this.createOrUpdateUserRoles(userId, userRoles, false);
    }

    protected void createOrUpdateUserRoles(String userId, List<UserRoleDto> userRoles, Boolean removePreviousRoles) {
        List<UserRole> roles = this.userRoleDao.findAllForUserId(userId);
        AgrosystUser agrosystUser = (AgrosystUser)this.agrosystUserDao.forTopiaIdEquals(userId).findUnique();
        ImmutableMap rolesIndex = Maps.uniqueIndex(roles, (Function)Entities.GET_TOPIA_ID);
        HashSet rolesIds = Sets.newHashSet((Iterable)rolesIndex.keySet());
        this.doCreateOrUpdateUserRoles(userRoles, agrosystUser, (ImmutableMap<String, UserRole>)rolesIndex, rolesIds);
        this.removePreviousRoles(removePreviousRoles, (ImmutableMap<String, UserRole>)rolesIndex, rolesIds);
        this.dropComputedPermissions0(userId);
        this.getTransaction().commit();
        this.cacheService.clear("hasRole");
    }

    protected void removePreviousRoles(Boolean removePreviousRoles, ImmutableMap<String, UserRole> rolesIndex, Set<String> rolesIds) {
        if (removePreviousRoles.booleanValue()) {
            for (String rolesId : rolesIds) {
                UserRole userRole = (UserRole)rolesIndex.get((Object)rolesId);
                this.userRoleDao.delete(userRole);
                this.trackerService.roleRemoved(userRole);
            }
        }
    }

    protected void doCreateOrUpdateUserRoles(List<UserRoleDto> userRoles, AgrosystUser agrosystUser, ImmutableMap<String, UserRole> rolesIndex, Set<String> rolesIds) {
        if (userRoles != null) {
            for (UserRoleDto userRole : userRoles) {
                UserRole roleEntity;
                String roleId = userRole.getTopiaId();
                if (Strings.isNullOrEmpty((String)roleId)) {
                    roleEntity = (UserRole)this.userRoleDao.newInstance();
                    roleEntity.setAgrosystUser(agrosystUser);
                } else {
                    roleEntity = (UserRole)rolesIndex.get((Object)roleId);
                    Preconditions.checkState((boolean)roleEntity.getAgrosystUser().equals(agrosystUser));
                    rolesIds.remove(roleId);
                }
                String identifier = null;
                if (userRole.getEntity() != null) {
                    identifier = userRole.getEntity().getIdentifier();
                }
                RoleType type = userRole.getType();
                roleEntity.setType(type);
                switch (type) {
                    case ADMIN: 
                    case IS_DATA_PROCESSOR: {
                        break;
                    }
                    case DOMAIN_RESPONSIBLE: {
                        Preconditions.checkState((identifier != null ? 1 : 0) != 0);
                        roleEntity.setDomainCode(identifier);
                        break;
                    }
                    case NETWORK_RESPONSIBLE: {
                        Preconditions.checkState((identifier != null ? 1 : 0) != 0);
                        roleEntity.setNetworkId(identifier);
                        break;
                    }
                    case GROWING_PLAN_RESPONSIBLE: {
                        Preconditions.checkState((identifier != null ? 1 : 0) != 0);
                        roleEntity.setGrowingPlanCode(identifier);
                        break;
                    }
                    case GS_DATA_PROCESSOR: {
                        Preconditions.checkState((identifier != null ? 1 : 0) != 0);
                        Integer campaign = userRole.getEntity().getCampaign();
                        if (campaign == null) {
                            roleEntity.setGrowingSystemCode(identifier);
                            roleEntity.setGrowingSystemId(null);
                            break;
                        }
                        HashSet set = Sets.newHashSet((Object[])new Integer[]{campaign});
                        List<GrowingSystem> list = this.growingSystemDao.findAllByCodeAndCampaign(identifier, set);
                        GrowingSystem growingSystem = list.iterator().next();
                        roleEntity.setGrowingSystemCode(null);
                        roleEntity.setGrowingSystemId(growingSystem.getTopiaId());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unexpected type: " + type);
                    }
                }
                if (Strings.isNullOrEmpty((String)roleId)) {
                    this.userRoleDao.create((TopiaEntity)roleEntity);
                    this.trackerService.roleAdded(roleEntity);
                    continue;
                }
                this.userRoleDao.update((TopiaEntity)roleEntity);
            }
        }
    }

    public void saveEntityUserRoles(RoleType roleType, String entityCode, List<UserRoleDto> roleDtos) {
        List<UserRole> roles = this.getUserRoles0(roleType, entityCode);
        ImmutableMap rolesIndex = Maps.uniqueIndex(roles, (Function)Entities.GET_TOPIA_ID);
        HashSet rolesIds = Sets.newHashSet((Iterable)rolesIndex.keySet());
        for (UserRoleDto userRole : roleDtos) {
            UserRole roleEntity;
            String userId = userRole.getUser().getTopiaId();
            AgrosystUser user = (AgrosystUser)this.agrosystUserDao.forTopiaIdEquals(userId).findUnique();
            String roleId = userRole.getTopiaId();
            if (Strings.isNullOrEmpty((String)roleId)) {
                roleEntity = (UserRole)this.userRoleDao.newInstance();
            } else {
                roleEntity = (UserRole)rolesIndex.get((Object)roleId);
                rolesIds.remove(roleId);
            }
            roleEntity.setAgrosystUser(user);
            RoleType type = userRole.getType();
            roleEntity.setType(type);
            switch (type) {
                case DOMAIN_RESPONSIBLE: {
                    roleEntity.setDomainCode(entityCode);
                    break;
                }
                case GROWING_PLAN_RESPONSIBLE: {
                    roleEntity.setGrowingPlanCode(entityCode);
                    break;
                }
                case GS_DATA_PROCESSOR: {
                    Integer campaign = null;
                    if (userRole.getEntity() != null) {
                        campaign = userRole.getEntity().getCampaign();
                    }
                    if (campaign == null) {
                        roleEntity.setGrowingSystemCode(entityCode);
                        roleEntity.setGrowingSystemId(null);
                        break;
                    }
                    HashSet set = Sets.newHashSet((Object[])new Integer[]{campaign});
                    List<GrowingSystem> list = this.growingSystemDao.findAllByCodeAndCampaign(entityCode, set);
                    GrowingSystem growingSystem = list.iterator().next();
                    roleEntity.setGrowingSystemCode(null);
                    roleEntity.setGrowingSystemId(growingSystem.getTopiaId());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unexpected type: " + type);
                }
            }
            if (Strings.isNullOrEmpty((String)roleId)) {
                this.userRoleDao.create((TopiaEntity)roleEntity);
                this.trackerService.roleAdded(roleEntity);
            } else {
                this.userRoleDao.update((TopiaEntity)roleEntity);
            }
            this.dropComputedPermissions0(userId);
        }
        for (String rolesId : rolesIds) {
            UserRole userRole = (UserRole)rolesIndex.get((Object)rolesId);
            this.userRoleDao.delete(userRole);
            this.trackerService.roleRemoved(userRole);
        }
        this.getTransaction().commit();
        this.cacheService.clear("hasRole");
    }

    public List<UserDto> getDomainResponsibles(String domainCode) {
        List<AgrosystUser> users = this.userRoleDao.findAllRoleUsers(RoleType.DOMAIN_RESPONSIBLE, "domainCode", domainCode);
        List result = Lists.transform(users, (Function)Users.TO_USER_DTO);
        return result;
    }

    public List<UserDto> getGrowingPlanResponsibles(String growingPlanCode) {
        List<AgrosystUser> users = this.userRoleDao.findAllRoleUsers(RoleType.GROWING_PLAN_RESPONSIBLE, "growingPlanCode", growingPlanCode);
        List result = Lists.transform(users, (Function)Users.TO_USER_DTO);
        return result;
    }

    protected Set<ComputedUserPermission> computeUserPermissions(String userId) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        List<UserRole> roles = this.userRoleDao.findAllForUserId(userId);
        if (roles != null) {
            block8: for (UserRole role : roles) {
                switch (role.getType()) {
                    case ADMIN: {
                        continue block8;
                    }
                    case IS_DATA_PROCESSOR: {
                        List<ComputedUserPermission> permissions = this.computeIsDataProcessorPermissions(userId);
                        result.addAll(permissions);
                        continue block8;
                    }
                    case DOMAIN_RESPONSIBLE: {
                        List<ComputedUserPermission> permissions = this.computeDomainResponsiblePermissions(userId, role);
                        result.addAll(permissions);
                        continue block8;
                    }
                    case GROWING_PLAN_RESPONSIBLE: {
                        List<ComputedUserPermission> permissions = this.computeGrowingPlanResponsiblePermissions(userId, role);
                        result.addAll(permissions);
                        continue block8;
                    }
                    case GS_DATA_PROCESSOR: {
                        List<ComputedUserPermission> permissions = this.computeGrowingSystemDataProcessorPermissions(userId, role);
                        result.addAll(permissions);
                        continue block8;
                    }
                    case NETWORK_RESPONSIBLE: {
                        List<ComputedUserPermission> permissions = this.computeNetworkResponsiblePermissions(userId, role);
                        result.addAll(permissions);
                        continue block8;
                    }
                }
                throw new UnsupportedOperationException("Unexpected type: " + role);
            }
        }
        return result;
    }

    protected List<ComputedUserPermission> computeIsDataProcessorPermissions(String userId) {
        LinkedList result = Lists.newLinkedList();
        Set<String> domains = this.domainDao.getAllDomainCodes();
        for (String domain : domains) {
            ComputedUserPermission permission = this.computedUserPermissionDao.newDomainReadValidatedPermission(userId, domain);
            result.add(permission);
        }
        Set<String> growingPlans = this.growingPlanDao.getAllGrowingPlanCodes();
        for (String growingPlan : growingPlans) {
            ComputedUserPermission permission = this.computedUserPermissionDao.newGrowingPlanReadValidatedPermission(userId, growingPlan);
            result.add(permission);
        }
        Set<String> growingSystems = this.growingSystemDao.getAllGrowingSystemCodes();
        for (String growingSystem : growingSystems) {
            ComputedUserPermission permission = this.computedUserPermissionDao.newGrowingSystemReadValidatedPermission(userId, growingSystem);
            result.add(permission);
        }
        return result;
    }

    protected List<ComputedUserPermission> computeGrowingSystemDataProcessorPermissions(String userId, UserRole role) {
        ComputedUserPermission domainPermission;
        ComputedUserPermission growingPlanPermission;
        LinkedList result = Lists.newLinkedList();
        String growingSystemCode = role.getGrowingSystemCode();
        String growingSystemId = role.getGrowingSystemId();
        Preconditions.checkState((!Strings.isNullOrEmpty((String)growingSystemCode) || !Strings.isNullOrEmpty((String)growingSystemId) ? 1 : 0) != 0);
        ComputedUserPermission permission = !Strings.isNullOrEmpty((String)growingSystemCode) ? this.computedUserPermissionDao.newGrowingSystemReadValidatedPermission(userId, growingSystemCode) : this.computedUserPermissionDao.newSpecificGrowingSystemReadValidatedPermission(userId, growingSystemId);
        result.add(permission);
        if (!Strings.isNullOrEmpty((String)growingSystemCode)) {
            GrowingSystem growingSystem = (GrowingSystem)this.growingSystemDao.forCodeEquals(growingSystemCode).findAny();
            GrowingPlan growingPlan = growingSystem.getGrowingPlan();
            String growingPlanCode = growingPlan.getCode();
            growingPlanPermission = this.computedUserPermissionDao.newGrowingPlanReadValidatedPermission(userId, growingPlanCode);
            String domainCode = growingPlan.getDomain().getCode();
            domainPermission = this.computedUserPermissionDao.newDomainReadValidatedPermission(userId, domainCode);
        } else {
            GrowingSystem growingSystem = (GrowingSystem)this.growingSystemDao.forTopiaIdEquals(growingSystemId).findUnique();
            GrowingPlan growingPlan = growingSystem.getGrowingPlan();
            String growingPlanId = growingPlan.getTopiaId();
            growingPlanPermission = this.computedUserPermissionDao.newSpecificGrowingPlanReadValidatedPermission(userId, growingPlanId);
            String domainId = growingPlan.getDomain().getTopiaId();
            domainPermission = this.computedUserPermissionDao.newSpecificDomainReadValidatedPermission(userId, domainId);
        }
        result.add(growingPlanPermission);
        result.add(domainPermission);
        return result;
    }

    protected List<ComputedUserPermission> computeGrowingPlanResponsiblePermissions(String userId, UserRole role) {
        LinkedList result = Lists.newLinkedList();
        String growingPlanCode = role.getGrowingPlanCode();
        Preconditions.checkState((!Strings.isNullOrEmpty((String)growingPlanCode) ? 1 : 0) != 0);
        ImmutableSet growingPlanCodes = ImmutableSet.of((Object)growingPlanCode);
        ComputedUserPermission permission = this.computedUserPermissionDao.newGrowingPlanAdminPermission(userId, growingPlanCode);
        result.add(permission);
        GrowingPlan growingPlan = (GrowingPlan)this.growingPlanDao.forCodeEquals(growingPlanCode).findAny();
        String domainCode = growingPlan.getDomain().getCode();
        ComputedUserPermission permission2 = this.computedUserPermissionDao.newDomainReadPermission(userId, domainCode);
        result.add(permission2);
        Callable<LinkedHashSet<String>> gp2gsLoader = new Callable<LinkedHashSet<String>>((Set)growingPlanCodes){
            final /* synthetic */ Set val$growingPlanCodes;
            {
                this.val$growingPlanCodes = set;
            }

            @Override
            public LinkedHashSet<String> call() throws Exception {
                LinkedHashSet<String> result = AuthorizationServiceImpl.this.computedUserPermissionDao.getProjectionHelper().growingPlansToGrowingSystemsCode(this.val$growingPlanCodes);
                return result;
            }
        };
        LinkedHashSet<String> growingSystemCodes = this.cacheService.get("growingPlansToGrowingSystemsCode", growingPlanCodes, gp2gsLoader);
        if (growingSystemCodes != null) {
            for (String growingSystemCode : growingSystemCodes) {
                ComputedUserPermission permission3 = this.computedUserPermissionDao.newGrowingSystemAdminPermission(userId, growingSystemCode);
                result.add(permission3);
            }
        }
        return result;
    }

    protected List<ComputedUserPermission> computeDomainResponsiblePermissions(String userId, UserRole role) {
        Callable<LinkedHashSet<String>> d2gsLoader;
        LinkedHashSet<String> growingSystemCodes;
        LinkedList result = Lists.newLinkedList();
        String domainCode = role.getDomainCode();
        Preconditions.checkState((!Strings.isNullOrEmpty((String)domainCode) ? 1 : 0) != 0);
        ImmutableSet domainCodes = ImmutableSet.of((Object)domainCode);
        ComputedUserPermission permission = this.computedUserPermissionDao.newDomainAdminPermission(userId, domainCode);
        result.add(permission);
        Callable<LinkedHashSet<String>> d2gpLoader = new Callable<LinkedHashSet<String>>((Set)domainCodes){
            final /* synthetic */ Set val$domainCodes;
            {
                this.val$domainCodes = set;
            }

            @Override
            public LinkedHashSet<String> call() throws Exception {
                LinkedHashSet<String> result = AuthorizationServiceImpl.this.growingPlanDao.domainsToGrowingPlansCode(this.val$domainCodes);
                return result;
            }
        };
        Set growingPlanCodes = this.cacheService.get("domainToGrowingPlanCodes", domainCodes, d2gpLoader);
        if (growingPlanCodes != null) {
            for (String growingPlanCode : growingPlanCodes) {
                ComputedUserPermission permission2 = this.computedUserPermissionDao.newGrowingPlanReadPermission(userId, growingPlanCode);
                result.add(permission2);
            }
        }
        if ((growingSystemCodes = this.cacheService.get("domainToGrowingSystemCodes", domainCodes, d2gsLoader = new Callable<LinkedHashSet<String>>((Set)domainCodes){
            final /* synthetic */ Set val$domainCodes;
            {
                this.val$domainCodes = set;
            }

            @Override
            public LinkedHashSet<String> call() throws Exception {
                LinkedHashSet<String> result = AuthorizationServiceImpl.this.growingPlanDao.getProjectionHelper().domainsToGrowingSystemsCode(this.val$domainCodes);
                return result;
            }
        })) != null) {
            for (String growingSystemCode : growingSystemCodes) {
                ComputedUserPermission permission3 = this.computedUserPermissionDao.newGrowingSystemReadPermission(userId, growingSystemCode);
                result.add(permission3);
            }
        }
        return result;
    }

    protected List<ComputedUserPermission> computeNetworkResponsiblePermissions(String userId, UserRole role) {
        Set<String> growingSystemCodes;
        Set<String> growingPlanCodes;
        LinkedList result = Lists.newLinkedList();
        String networkId = role.getNetworkId();
        Preconditions.checkState((!Strings.isNullOrEmpty((String)networkId) ? 1 : 0) != 0);
        ImmutableSet networkIdSet = ImmutableSet.of((Object)networkId);
        ComputedUserPermission permission = this.computedUserPermissionDao.newNetworkAdminPermission(userId, networkId);
        result.add(permission);
        Set<String> domainCodes = this.computedUserPermissionDao.getProjectionHelper().networksToDomainsCode((Set<String>)networkIdSet);
        if (domainCodes != null) {
            for (String domainCode : domainCodes) {
                ComputedUserPermission permission2 = this.computedUserPermissionDao.newDomainReadPermission(userId, domainCode);
                result.add(permission2);
            }
        }
        if ((growingPlanCodes = this.computedUserPermissionDao.getProjectionHelper().networksToGrowingPlansCode((Set<String>)networkIdSet)) != null) {
            for (String growingPlanCode : growingPlanCodes) {
                ComputedUserPermission permission3 = this.computedUserPermissionDao.newGrowingPlanReadPermission(userId, growingPlanCode);
                result.add(permission3);
            }
        }
        if ((growingSystemCodes = this.computedUserPermissionDao.getProjectionHelper().networksToGrowingSystemsCode((Set<String>)networkIdSet)) != null) {
            for (String growingSystemCode : growingSystemCodes) {
                ComputedUserPermission permission4 = this.computedUserPermissionDao.newGrowingSystemReadPermission(userId, growingSystemCode);
                result.add(permission4);
            }
        }
        return result;
    }

    protected void markPermissionsAsDirty(ComputedUserPermissionTopiaDao cupDAO, Iterable<ComputedUserPermission> toDirty) {
        for (ComputedUserPermission permission : toDirty) {
            permission.setDirty(true);
            cupDAO.update((TopiaEntity)permission);
        }
    }

    protected void objectsAreDirty(PermissionObjectType type) {
        List toDirty = this.computedUserPermissionDao.forProperties("type", type, new Object[]{"dirty", false}).findAll();
        this.markPermissionsAsDirty(this.computedUserPermissionDao, toDirty);
    }

    protected void objectIsDirty(PermissionObjectType type, String object) {
        List toDirty = this.computedUserPermissionDao.forProperties("type", type, new Object[]{"object", object, "dirty", false}).findAll();
        this.markPermissionsAsDirty(this.computedUserPermissionDao, toDirty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportResult importRoles(InputStream rolesFileStream) {
        Import importer = null;
        ImportResult result = new ImportResult();
        try {
            UserRolesImportModel model = new UserRolesImportModel();
            importer = Import.newImport((ImportModel)model, (InputStream)rolesFileStream);
            HashMap userRolesDtoMap = Maps.newHashMap();
            for (ImportUserRoleDto entity : importer) {
                String email = entity.getUserEmail();
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)email) ? 1 : 0) != 0);
                email = entity.getUserEmail().toLowerCase();
                AgrosystUser agrosystUser = (AgrosystUser)this.agrosystUserDao.forEmailEquals(email).findAnyOrNull();
                if (agrosystUser == null) {
                    result.incIgnored();
                    continue;
                }
                if (entity.getType() == RoleType.ADMIN || entity.getType() == RoleType.IS_DATA_PROCESSOR) {
                    List userRoleDtos = (List)userRolesDtoMap.get(agrosystUser.getTopiaId());
                    if (userRoleDtos == null) {
                        userRoleDtos = Lists.newArrayList();
                        userRolesDtoMap.put(agrosystUser.getTopiaId(), userRoleDtos);
                    }
                    UserRoleDto userRoleDto = new UserRoleDto();
                    userRoleDto.setType(entity.getType());
                    userRoleDtos.add(userRoleDto);
                    continue;
                }
                String term = entity.getTargetedEntity();
                ArrayList userRoleEntityDtos = Lists.newArrayList();
                userRoleEntityDtos.addAll(this.searchEntities(entity.getType(), term, entity.getCampaign()));
                if (userRoleEntityDtos.size() == 1) {
                    List userRoleDtos = (List)userRolesDtoMap.get(agrosystUser.getTopiaId());
                    if (userRoleDtos == null) {
                        userRoleDtos = Lists.newArrayList();
                        userRolesDtoMap.put(agrosystUser.getTopiaId(), userRoleDtos);
                    }
                    UserRoleDto userRoleDto = new UserRoleDto();
                    userRoleDto.setType(entity.getType());
                    UserRoleEntityDto userRoleEntityDto = (UserRoleEntityDto)userRoleEntityDtos.get(0);
                    userRoleEntityDto.setCampaign(entity.getCampaign());
                    userRoleDto.setEntity(userRoleEntityDto);
                    userRoleDtos.add(userRoleDto);
                    continue;
                }
                if (userRoleEntityDtos.isEmpty()) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Can't find any entity for term " + term));
                    }
                    result.incIgnored();
                    continue;
                }
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Too many entities founds for term " + term));
                }
                result.incIgnored();
            }
            for (Map.Entry entry : userRolesDtoMap.entrySet()) {
                String key = (String)entry.getKey();
                List userRoleDtos = (List)entry.getValue();
                this.saveUserRoles(key, userRoleDtos);
                result.incCreated();
            }
            this.getTransaction().commit();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(importer);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)importer);
        return result;
    }

    protected void importPz0UserRoles(String userId, List<UserRoleDto> userRoles) {
        List<UserRole> roles = this.userRoleDao.findAllForUserId(userId);
        AgrosystUser agrosystUser = (AgrosystUser)this.agrosystUserDao.forTopiaIdEquals(userId).findUnique();
        ImmutableMap rolesIndex = Maps.uniqueIndex(roles, (Function)Entities.GET_TOPIA_ID);
        HashSet rolesIds = Sets.newHashSet((Iterable)rolesIndex.keySet());
        this.doCreateOrUpdateUserRoles(userRoles, agrosystUser, (ImmutableMap<String, UserRole>)rolesIndex, rolesIds);
        this.dropComputedPermissions0(userId);
    }

    public void importPz0UsersRoles(Map<Class, ImportResults> allResults) {
        ImportResults importResults = allResults.remove(UserRoleDto.class);
        if (importResults != null) {
            UsersRolesAndDependencies usersRolesAndDependencies = (UsersRolesAndDependencies)importResults.getEntityAndDepsByCsvIds().get("usersRolesImport");
            Map allUsersRoles = usersRolesAndDependencies.getUsersRoles();
            int count = 1;
            int total = allUsersRoles.entrySet().size();
            for (Map.Entry stringListEntry : allUsersRoles.entrySet()) {
                String userId = (String)stringListEntry.getKey();
                long start = System.currentTimeMillis();
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("D\u00e9but sauvegarde du roles utilisateur %d/%d.", count++, total));
                }
                List userRole = (List)stringListEntry.getValue();
                this.importPz0UserRoles(userId, userRole);
                long p1 = System.currentTimeMillis();
                if (!log.isInfoEnabled()) continue;
                log.info((Object)String.format("Fin de sauvegarde du roles utilisateur en %d:", p1 - start));
            }
        }
        this.cacheService.clear("hasRole");
    }
}

