/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.security;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.entities.security.AgrosystUserTopiaDao;
import fr.inra.agrosyst.api.entities.security.StoredToken;
import fr.inra.agrosyst.api.entities.security.StoredTokenTopiaDao;
import fr.inra.agrosyst.api.services.security.AuthenticationService;
import fr.inra.agrosyst.api.services.security.AuthorizationService;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.Users;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.users.UserServiceImpl;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticationServiceImpl
extends AbstractAgrosystService
implements AuthenticationService {
    private static final Log log = LogFactory.getLog(AuthenticationServiceImpl.class);
    protected static final Map<String, String> USER_TOKENS = Maps.newConcurrentMap();
    protected AuthorizationService authorizationService;
    protected StoredTokenTopiaDao storedTokenDao;
    protected AgrosystUserTopiaDao agrosystUserDao;

    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public void setStoredTokenDao(StoredTokenTopiaDao storedTokenDao) {
        this.storedTokenDao = storedTokenDao;
    }

    public void setAgrosystUserDao(AgrosystUserTopiaDao agrosystUserDao) {
        this.agrosystUserDao = agrosystUserDao;
    }

    private void saveToken(String token, String userId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)token) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)userId) ? 1 : 0) != 0);
        if (this.getConfig().isTokenStorageEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Token will be stored directly in database");
            }
            this.storedTokenDao.create("token", token, new Object[]{"userId", userId});
            this.getTransaction().commit();
        } else {
            USER_TOKENS.put(token, userId);
        }
    }

    private String getTokenUserId(String token) {
        String result = null;
        if (this.getConfig().isTokenStorageEnabled()) {
            StoredToken storedToken = (StoredToken)this.storedTokenDao.forTokenEquals(token).findAnyOrNull();
            if (storedToken != null) {
                result = storedToken.getUserId();
            }
        } else {
            result = USER_TOKENS.get(token);
        }
        return result;
    }

    private void dropToken(String token) {
        if (this.getConfig().isTokenStorageEnabled()) {
            StoredToken storedToken = (StoredToken)this.storedTokenDao.forTokenEquals(token).findAnyOrNull();
            if (storedToken != null) {
                this.storedTokenDao.delete(storedToken);
                this.getTransaction().commit();
            }
        } else {
            USER_TOKENS.remove(token);
        }
    }

    public UserDto login(String email, String password) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)email) ? 1 : 0) != 0, (Object)"email cannot be empty");
        if (log.isInfoEnabled()) {
            String message = String.format("Check user authentication with email: '%s'", email);
            log.info((Object)message);
        }
        String encodedPassword = UserServiceImpl.hashPassword(password);
        AgrosystUser user = (AgrosystUser)this.agrosystUserDao.forProperties("email", email.toLowerCase(), new Object[]{"password", encodedPassword, "active", true}).findAnyOrNull();
        UserDto dto = null;
        if (user == null) {
            if (log.isWarnEnabled()) {
                String message = String.format("Could not authenticate user with email: '%s' and the given password", email);
                log.warn((Object)message);
            }
        } else {
            dto = (UserDto)Users.TO_USER_DTO.apply((Object)user);
        }
        if (dto != null) {
            String authenticationToken = UUID.randomUUID().toString();
            dto.setAuthenticationToken(authenticationToken);
            this.saveToken(authenticationToken, dto.getTopiaId());
        }
        return dto;
    }

    public void logout(String token) {
        if (!Strings.isNullOrEmpty((String)token)) {
            String userId = this.getTokenUserId(token);
            if (!Strings.isNullOrEmpty((String)userId)) {
                this.authorizationService.dropComputedPermissions(token);
            }
            this.dropToken(token);
        }
    }

    public String getAuthenticatedUserId(String token) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)token) ? 1 : 0) != 0, (Object)"token cannot be empty");
        String result = this.getTokenUserId(token);
        return result;
    }

    public UserDto getAuthenticatedUser(String token) {
        String userId = this.getAuthenticatedUserId(token);
        UserDto result = null;
        if (userId != null) {
            AgrosystUser user = (AgrosystUser)this.agrosystUserDao.forTopiaIdEquals(userId).findUnique();
            result = (UserDto)Users.TO_USER_DTO.apply((Object)user);
        }
        return result;
    }

    public long getConnectedUsersCount() {
        if (this.getConfig().isTokenStorageEnabled()) {
            return this.storedTokenDao.getConnectedUserCount(this.context.getCurrentDate());
        }
        return Integer.valueOf(USER_TOKENS.size()).longValue();
    }
}

