/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.security;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainImpl;
import fr.inra.agrosyst.api.entities.GeoPoint;
import fr.inra.agrosyst.api.entities.GeoPointImpl;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingPlanImpl;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.GrowingSystemImpl;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.PlotImpl;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.ZoneImpl;
import fr.inra.agrosyst.api.entities.managementmode.ManagementMode;
import fr.inra.agrosyst.api.entities.managementmode.ManagementModeImpl;
import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.entities.performance.PerformanceImpl;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlot;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystemImpl;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.entities.referential.RefLocationImpl;
import fr.inra.agrosyst.api.entities.security.HashedValueTopiaDao;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.DomainDto;
import fr.inra.agrosyst.api.services.domain.PlotDto;
import fr.inra.agrosyst.api.services.domain.ZoneDto;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanDto;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemDto;
import fr.inra.agrosyst.api.services.performance.PerformanceDto;
import fr.inra.agrosyst.api.services.practiced.PracticedPlotDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemDto;
import fr.inra.agrosyst.api.services.security.AnonymizeService;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import fr.inra.agrosyst.services.security.AnonymizeContext;
import fr.inra.agrosyst.services.security.AuthorizationServiceImpl;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class AnonymizeServiceImpl
extends AuthorizationServiceImpl
implements AnonymizeService {
    protected static final String XXXXX = "xxxxx";
    protected static final int XXXXX_INT = -88888;
    protected static final double XXXXX_DOUBLE = -8888.8;
    protected static final Function<RefLocation, RefLocation> ANONYMIZE_LOCATION = new Function<RefLocation, RefLocation>(){

        public RefLocation apply(RefLocation input) {
            Binder gpsDataBinder = BinderFactory.newBinder(RefLocation.class);
            RefLocationImpl result = new RefLocationImpl();
            gpsDataBinder.copyExcluding((Object)input, (Object)result, new String[]{"latitude", "longitude", "codeInsee", "codePostal", "commune"});
            result.setLongitude(-8888.8);
            result.setLatitude(-8888.8);
            result.setCodeInsee(AnonymizeServiceImpl.XXXXX);
            result.setCodePostal(AnonymizeServiceImpl.XXXXX);
            result.setCommune(AnonymizeServiceImpl.XXXXX);
            return result;
        }
    };
    protected BusinessAuthorizationService authorizationService;
    protected HashedValueTopiaDao hashedValuesDao;

    public void setAuthorizationService(BusinessAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public void setHashedValuesDao(HashedValueTopiaDao hashedValuesDao) {
        this.hashedValuesDao = hashedValuesDao;
    }

    public AnonymizeContext newContext() {
        AnonymizeContext result = new AnonymizeContext(this.authorizationService, this.getAnonymizeFunction());
        return result;
    }

    public Function<String, String> getAnonymizeFunction() {
        return new Function<String, String>(){

            public String apply(String input) {
                return AnonymizeServiceImpl.this.anonymize(input);
            }
        };
    }

    public String anonymize(String clear) {
        String userId = this.getUserId();
        Preconditions.checkState((!Strings.isNullOrEmpty((String)userId) ? 1 : 0) != 0);
        String hashed = Hashing.crc32().hashString((CharSequence)clear, Charsets.UTF_8).toString();
        if (this.hashedValuesDao.checkValue(clear, hashed)) {
            this.getTransaction().commit();
        }
        return hashed;
    }

    protected Function<Domain, Domain> getAnonymizeDomainFunction() {
        Function<Domain, Domain> result = this.getAnonymizeDomainFunction(false);
        return result;
    }

    protected Function<Domain, Domain> getAnonymizeDomainFunction(final boolean allowUnreadable) {
        Function<Domain, Domain> result = new Function<Domain, Domain>(){

            public Domain apply(Domain input) {
                Domain result;
                if (input == null) {
                    return null;
                }
                String domainId = input.getTopiaId();
                Pair anonymizeDomain = AnonymizeServiceImpl.this.authorizationService.shouldAnonymizeDomain(domainId, allowUnreadable);
                Boolean shouldAnonymizeDomain = (Boolean)anonymizeDomain.getLeft();
                if (shouldAnonymizeDomain.booleanValue()) {
                    Binder binder = BinderFactory.newBinder(Domain.class);
                    result = new DomainImpl();
                    binder.copyExcluding((Object)input, (Object)result, new String[]{"topiaId", "name", "mainContact", "siret", "location"});
                    result.setName(AnonymizeServiceImpl.this.anonymize(input.getName()));
                    result.setMainContact(AnonymizeServiceImpl.XXXXX);
                    result.setSiret(AnonymizeServiceImpl.XXXXX);
                    result.setLocation((RefLocation)ANONYMIZE_LOCATION.apply((Object)input.getLocation()));
                    Boolean canReadDomain = (Boolean)anonymizeDomain.getRight();
                    if (canReadDomain.booleanValue()) {
                        result.setTopiaId(input.getTopiaId());
                    }
                } else {
                    result = input;
                }
                return result;
            }
        };
        return result;
    }

    public Function<Domain, DomainDto> getDomainToDtoFunction(boolean includeResponsibles) {
        Function<Domain, DomainDto> result = this.newContext().includeDomainResponsibles(includeResponsibles).getDomainToDtoFunction();
        return result;
    }

    public Domain checkForDomainAnonymization(Domain domain) {
        Domain result = (Domain)this.getAnonymizeDomainFunction().apply((Object)domain);
        return result;
    }

    public Collection<Domain> checkForDomainsAnonymization(Collection<Domain> domains) {
        Collection result = Collections2.transform(domains, this.getAnonymizeDomainFunction());
        return result;
    }

    public ResultList<Domain> checkForDomainsAnonymization(ResultList<Domain> domains) {
        ResultList result = ResultList.transformLazy(domains, this.getAnonymizeDomainFunction());
        return result;
    }

    public Map<String, String> getDomainsAsMap(Iterable<Domain> domains) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Domain domain : domains) {
            String domainId = domain.getTopiaId();
            if (this.authorizationService.shouldAnonymizeDomain(domainId)) {
                result.put(domainId, this.anonymize(domain.getName()));
                continue;
            }
            result.put(domainId, domain.getName());
        }
        return result;
    }

    public Plot checkForPlotAnonymization(Plot plot) {
        Plot result = (Plot)this.getAnonymizePlotFunction().apply((Object)plot);
        return result;
    }

    public List<Plot> checkForPlotsAnonymization(List<Plot> plots) {
        List result = Lists.transform(plots, this.getAnonymizePlotFunction(true));
        return result;
    }

    protected Function<GeoPoint, GeoPoint> getAnonymizeGeoPointFunction() {
        Function<GeoPoint, GeoPoint> result = new Function<GeoPoint, GeoPoint>(){

            public GeoPoint apply(GeoPoint input) {
                GeoPoint result = null;
                if (input != null) {
                    Domain domain = input.getDomain();
                    String domainId = domain.getTopiaId();
                    if (AnonymizeServiceImpl.this.authorizationService.shouldAnonymizeDomain(domainId)) {
                        Binder binder = BinderFactory.newBinder(GeoPoint.class);
                        result = new GeoPointImpl();
                        binder.copyExcluding((Object)input, (Object)result, new String[]{"latitude", "longitude", "domain"});
                        result.setLatitude(-8888.8);
                        result.setLongitude(-8888.8);
                        result.setDomain(null);
                    } else {
                        result = input;
                    }
                }
                return result;
            }
        };
        return result;
    }

    public List<GeoPoint> checkForGeoPointAnonymization(List<GeoPoint> geoPoints) {
        List result = Lists.transform(geoPoints, this.getAnonymizeGeoPointFunction());
        return result;
    }

    protected Function<Plot, Plot> getAnonymizePlotFunction() {
        Function<Plot, Plot> result = this.getAnonymizePlotFunction(false);
        return result;
    }

    protected Function<Plot, Plot> getAnonymizePlotFunction(final boolean allowUnreadable) {
        final Function<Domain, Domain> anonymizeDomainFunction = this.getAnonymizeDomainFunction(allowUnreadable);
        final Function<GrowingSystem, GrowingSystem> anonymizeGrowingSystemFunction = this.getAnonymizeGrowingSystemFunction(allowUnreadable);
        Function<Plot, Plot> result = new Function<Plot, Plot>(){

            public Plot apply(Plot input) {
                Plot result = null;
                if (input != null) {
                    Domain domain = input.getDomain();
                    String domainId = domain.getTopiaId();
                    Pair domainReadableStatus = AnonymizeServiceImpl.this.authorizationService.shouldAnonymizeDomain(domainId, allowUnreadable);
                    boolean shouldAnonymizeDomain = (Boolean)domainReadableStatus.getLeft();
                    boolean shouldAnonymizeGrowingPlan = false;
                    boolean plotReadable = true;
                    if (input.getGrowingSystem() != null) {
                        String growingPlanId = input.getGrowingSystem().getGrowingPlan().getTopiaId();
                        Pair gpReadableStatus = AnonymizeServiceImpl.this.authorizationService.shouldAnonymizeGrowingPlan(growingPlanId, allowUnreadable);
                        shouldAnonymizeGrowingPlan = (Boolean)gpReadableStatus.getLeft();
                        plotReadable = AnonymizeServiceImpl.this.authorizationService.isGrowingSystemReadable(input.getGrowingSystem().getTopiaId());
                    }
                    if (shouldAnonymizeDomain || shouldAnonymizeGrowingPlan) {
                        Binder binder = BinderFactory.newBinder(Plot.class);
                        result = new PlotImpl();
                        binder.copyExcluding((Object)input, (Object)result, new String[]{"topiaId", "name", "pacIlotNumber", "location", "latitude", "longitude", "domain", "growingSystem"});
                        if (shouldAnonymizeDomain) {
                            result.setName(AnonymizeServiceImpl.this.anonymize(input.getName()));
                            result.setPacIlotNumber(-88888);
                            result.setLocation((RefLocation)ANONYMIZE_LOCATION.apply((Object)input.getLocation()));
                            result.setLatitude(Double.valueOf(-8888.8));
                            result.setLongitude(Double.valueOf(-8888.8));
                            result.setDomain((Domain)anonymizeDomainFunction.apply((Object)domain));
                        } else {
                            result.setName(input.getName());
                            result.setPacIlotNumber(input.getPacIlotNumber());
                            result.setLocation(input.getLocation());
                            result.setLatitude(input.getLatitude());
                            result.setLongitude(input.getLongitude());
                            result.setDomain(domain);
                        }
                        if (shouldAnonymizeGrowingPlan) {
                            result.setGrowingSystem((GrowingSystem)anonymizeGrowingSystemFunction.apply((Object)input.getGrowingSystem()));
                        } else {
                            result.setGrowingSystem(input.getGrowingSystem());
                        }
                        if (plotReadable) {
                            result.setTopiaId(input.getTopiaId());
                        }
                    } else {
                        result = input;
                    }
                }
                return result;
            }
        };
        return result;
    }

    public Function<Plot, PlotDto> getPlotToDtoFunction() {
        Function<Plot, PlotDto> result = this.newContext().getPlotToDtoFunction();
        return result;
    }

    protected Function<Zone, Zone> getAnonymizeZoneFunction() {
        final Function<Plot, Plot> anonymizePlotFunction = this.getAnonymizePlotFunction();
        Function<Zone, Zone> result = new Function<Zone, Zone>(){

            public Zone apply(Zone input) {
                Zone result;
                if (input == null) {
                    return null;
                }
                String domainId = input.getPlot().getDomain().getTopiaId();
                boolean shouldAnonymizeDomain = AnonymizeServiceImpl.this.authorizationService.shouldAnonymizeDomain(domainId);
                if (shouldAnonymizeDomain) {
                    Binder binder = BinderFactory.newBinder(Zone.class);
                    result = new ZoneImpl();
                    binder.copyExcluding((Object)input, (Object)result, new String[]{"plot"});
                    result.setPlot((Plot)anonymizePlotFunction.apply((Object)input.getPlot()));
                } else {
                    result = input;
                }
                return result;
            }
        };
        return result;
    }

    public Zone checkForZoneAnonymization(Zone zone) {
        Zone result = (Zone)this.getAnonymizeZoneFunction().apply((Object)zone);
        return result;
    }

    public Function<Zone, ZoneDto> getZoneToDtoFunction() {
        return this.getZoneToDtoFunction(true);
    }

    public Function<Zone, ZoneDto> getZoneToDtoFunction(boolean includePlot) {
        Function<Zone, ZoneDto> result = this.newContext().includeZonePlot(includePlot).getZoneToDtoFunction();
        return result;
    }

    protected Function<GrowingPlan, GrowingPlan> getAnonymizeGrowingPlanFunction() {
        Function<GrowingPlan, GrowingPlan> result = this.getAnonymizeGrowingPlanFunction(false);
        return result;
    }

    protected Function<GrowingPlan, GrowingPlan> getAnonymizeGrowingPlanFunction(final boolean allowUnreadable) {
        final Function<Domain, Domain> anonymizeDomainFunction = this.getAnonymizeDomainFunction(allowUnreadable);
        Function<GrowingPlan, GrowingPlan> result = new Function<GrowingPlan, GrowingPlan>(){

            public GrowingPlan apply(GrowingPlan input) {
                GrowingPlan result;
                if (input == null) {
                    return null;
                }
                String growingPlanId = input.getTopiaId();
                String domainId = input.getDomain().getTopiaId();
                Pair anonymizeGrowingPlan = AnonymizeServiceImpl.this.authorizationService.shouldAnonymizeGrowingPlan(growingPlanId, allowUnreadable);
                boolean shouldAnonymizeGrowingPlan = (Boolean)anonymizeGrowingPlan.getLeft();
                boolean canReadGrowingPlan = (Boolean)anonymizeGrowingPlan.getRight();
                boolean shouldAnonymizeDomain = (Boolean)AnonymizeServiceImpl.this.authorizationService.shouldAnonymizeDomain(domainId, allowUnreadable).getLeft();
                if (shouldAnonymizeGrowingPlan || shouldAnonymizeDomain) {
                    Binder binder = BinderFactory.newBinder(GrowingPlan.class);
                    result = new GrowingPlanImpl();
                    binder.copyExcluding((Object)input, (Object)result, new String[]{"topiaId", "name", "domain"});
                    if (shouldAnonymizeGrowingPlan) {
                        result.setName(AnonymizeServiceImpl.this.anonymize(input.getName()));
                    } else {
                        result.setName(input.getName());
                    }
                    if (canReadGrowingPlan) {
                        result.setTopiaId(input.getTopiaId());
                    }
                    result.setDomain((Domain)anonymizeDomainFunction.apply((Object)input.getDomain()));
                } else {
                    result = input;
                }
                return result;
            }
        };
        return result;
    }

    public GrowingPlan checkForGrowingPlanAnonymization(GrowingPlan growingPlan) {
        GrowingPlan result = (GrowingPlan)this.getAnonymizeGrowingPlanFunction().apply((Object)growingPlan);
        return result;
    }

    public Function<GrowingPlan, GrowingPlanDto> getGrowingPlanToDtoFunction(boolean includeResponsibles) {
        Function<GrowingPlan, GrowingPlanDto> result = this.newContext().includeGrowingPlanResponsibles(includeResponsibles).getGrowingPlanToDtoFunction();
        return result;
    }

    public Map<String, String> getGrowingPlansAsMap(Iterable<GrowingPlan> growingPlans) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (GrowingPlan growingPlan : growingPlans) {
            String growingPlanId = growingPlan.getTopiaId();
            if (this.authorizationService.shouldAnonymizeGrowingPlan(growingPlanId)) {
                result.put(growingPlanId, this.anonymize(growingPlan.getName()));
                continue;
            }
            result.put(growingPlanId, growingPlan.getName());
        }
        return result;
    }

    protected Function<GrowingSystem, GrowingSystem> getAnonymizeGrowingSystemFunction() {
        Function<GrowingSystem, GrowingSystem> result = this.getAnonymizeGrowingSystemFunction(false);
        return result;
    }

    protected Function<GrowingSystem, GrowingSystem> getAnonymizeGrowingSystemFunction(final boolean allowUnreadable) {
        final Function<GrowingPlan, GrowingPlan> anonymizeGrowingPlanFunction = this.getAnonymizeGrowingPlanFunction(allowUnreadable);
        Function<GrowingSystem, GrowingSystem> result = new Function<GrowingSystem, GrowingSystem>(){

            public GrowingSystem apply(GrowingSystem input) {
                GrowingSystem result;
                if (input == null) {
                    return null;
                }
                String growingPlanId = input.getGrowingPlan().getTopiaId();
                String domainId = input.getGrowingPlan().getDomain().getTopiaId();
                boolean shouldAnonymizeGrowingPlan = (Boolean)AnonymizeServiceImpl.this.authorizationService.shouldAnonymizeGrowingPlan(growingPlanId, allowUnreadable).getLeft();
                boolean shouldAnonymizeDomain = (Boolean)AnonymizeServiceImpl.this.authorizationService.shouldAnonymizeDomain(domainId, allowUnreadable).getLeft();
                if (shouldAnonymizeGrowingPlan || shouldAnonymizeDomain) {
                    Binder binder = BinderFactory.newBinder(GrowingSystem.class);
                    result = new GrowingSystemImpl();
                    binder.copyExcluding((Object)input, (Object)result, new String[]{"topiaId", "growingPlan"});
                    if (AnonymizeServiceImpl.this.authorizationService.isGrowingSystemReadable(input.getTopiaId())) {
                        result.setTopiaId(input.getTopiaId());
                    }
                    result.setGrowingPlan((GrowingPlan)anonymizeGrowingPlanFunction.apply((Object)input.getGrowingPlan()));
                } else {
                    result = input;
                }
                return result;
            }
        };
        return result;
    }

    public GrowingSystem checkForGrowingSystemAnonymization(GrowingSystem growingSystem) {
        GrowingSystem result = (GrowingSystem)this.getAnonymizeGrowingSystemFunction().apply((Object)growingSystem);
        return result;
    }

    public Function<GrowingSystem, GrowingSystemDto> getGrowingSystemToDtoFunction() {
        Function<GrowingSystem, GrowingSystemDto> result = this.newContext().getGrowingSystemToDtoFunction();
        return result;
    }

    protected Function<PracticedSystem, PracticedSystem> getAnonymizePracticedSystemFunction() {
        final Function<GrowingSystem, GrowingSystem> anonymizeGrowingSystemFunction = this.getAnonymizeGrowingSystemFunction();
        Function<PracticedSystem, PracticedSystem> result = new Function<PracticedSystem, PracticedSystem>(){

            public PracticedSystem apply(PracticedSystem input) {
                PracticedSystem result;
                if (input == null) {
                    return null;
                }
                String growingPlanId = input.getGrowingSystem().getGrowingPlan().getTopiaId();
                String domainId = input.getGrowingSystem().getGrowingPlan().getDomain().getTopiaId();
                boolean shouldAnonymizeGrowingPlan = AnonymizeServiceImpl.this.authorizationService.shouldAnonymizeGrowingPlan(growingPlanId);
                boolean shouldAnonymizeDomain = AnonymizeServiceImpl.this.authorizationService.shouldAnonymizeDomain(domainId);
                if (shouldAnonymizeGrowingPlan || shouldAnonymizeDomain) {
                    Binder binder = BinderFactory.newBinder(PracticedSystem.class);
                    result = new PracticedSystemImpl();
                    binder.copyExcluding((Object)input, (Object)result, new String[]{"growingSystem"});
                    result.setGrowingSystem((GrowingSystem)anonymizeGrowingSystemFunction.apply((Object)input.getGrowingSystem()));
                } else {
                    result = input;
                }
                return result;
            }
        };
        return result;
    }

    public PracticedSystem checkForPracticedSystemAnonymization(PracticedSystem practicedSystem) {
        PracticedSystem result = (PracticedSystem)this.getAnonymizePracticedSystemFunction().apply((Object)practicedSystem);
        return result;
    }

    public Function<PracticedSystem, PracticedSystemDto> getPracticedSystemToDtoFunction() {
        Function<PracticedSystem, PracticedSystemDto> result = this.newContext().getPracticedSystemToDtoFunction();
        return result;
    }

    protected Function<ManagementMode, ManagementMode> getAnonymizeManagementModeFunction() {
        final Function<GrowingSystem, GrowingSystem> anonymizeGrowingSystemFunction = this.getAnonymizeGrowingSystemFunction();
        Function<ManagementMode, ManagementMode> result = new Function<ManagementMode, ManagementMode>(){

            public ManagementMode apply(ManagementMode input) {
                ManagementMode result;
                if (input == null) {
                    return null;
                }
                String growingPlanId = input.getGrowingSystem().getGrowingPlan().getTopiaId();
                String domainId = input.getGrowingSystem().getGrowingPlan().getDomain().getTopiaId();
                boolean shouldAnonymizeGrowingPlan = AnonymizeServiceImpl.this.authorizationService.shouldAnonymizeGrowingPlan(growingPlanId);
                boolean shouldAnonymizeDomain = AnonymizeServiceImpl.this.authorizationService.shouldAnonymizeDomain(domainId);
                if (shouldAnonymizeGrowingPlan || shouldAnonymizeDomain) {
                    Binder binder = BinderFactory.newBinder(ManagementMode.class);
                    result = new ManagementModeImpl();
                    binder.copyExcluding((Object)input, (Object)result, new String[]{"growingSystem"});
                    result.setGrowingSystem((GrowingSystem)anonymizeGrowingSystemFunction.apply((Object)input.getGrowingSystem()));
                } else {
                    result = input;
                }
                return result;
            }
        };
        return result;
    }

    public ManagementMode checkForManagementModeAnonymization(ManagementMode managementMode) {
        ManagementMode result = (ManagementMode)this.getAnonymizeManagementModeFunction().apply((Object)managementMode);
        return result;
    }

    public Function<PracticedPlot, PracticedPlotDto> getPracticedPlotToDtoFunction() {
        Function<PracticedPlot, PracticedPlotDto> result = this.newContext().getPracticedPlotToDtoFunction();
        return result;
    }

    public ResultList<Performance> checkForPerformancesAnonymization(ResultList<Performance> performances) {
        ResultList result = ResultList.transformLazy(performances, this.getAnonymizePerformanceFunction());
        return result;
    }

    protected Function<Performance, Performance> getAnonymizePerformanceFunction() {
        final Function<Domain, Domain> anonymizeDomainFunction = this.getAnonymizeDomainFunction();
        final Function<GrowingSystem, GrowingSystem> anonymizeGrowingSystemFunction = this.getAnonymizeGrowingSystemFunction();
        final Function<Plot, Plot> anonymizePlotFunction = this.getAnonymizePlotFunction();
        final Function<Zone, Zone> anonymizeZoneFunction = this.getAnonymizeZoneFunction();
        Function<Performance, Performance> result = new Function<Performance, Performance>(){

            public Performance apply(Performance input) {
                PerformanceImpl result = null;
                if (input != null) {
                    Binder binder = BinderFactory.newBinder(Performance.class);
                    result = new PerformanceImpl();
                    binder.copyExcluding((Object)input, (Object)result, new String[]{"domains", "growingSystems", "plots", "zones"});
                    if (input.getDomains() != null) {
                        result.setDomains(Collections2.transform((Collection)input.getDomains(), (Function)anonymizeDomainFunction));
                    }
                    if (input.getGrowingSystems() != null) {
                        result.setGrowingSystems(Collections2.transform((Collection)input.getGrowingSystems(), (Function)anonymizeGrowingSystemFunction));
                    }
                    if (input.getPlots() != null) {
                        result.setPlots(Collections2.transform((Collection)input.getPlots(), (Function)anonymizePlotFunction));
                    }
                    if (input.getZones() != null) {
                        result.setZones(Collections2.transform((Collection)input.getZones(), (Function)anonymizeZoneFunction));
                    }
                }
                return result;
            }
        };
        return result;
    }

    public Function<Performance, PerformanceDto> getPerformanceToDtoFunction() {
        Function<Performance, PerformanceDto> result = this.newContext().includeZonePlot(false).limitPerformanceElements(Integer.MAX_VALUE).getPerformanceToDtoFunction();
        return result;
    }
}

