/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.security;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlot;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.services.domain.DomainDto;
import fr.inra.agrosyst.api.services.domain.PlotDto;
import fr.inra.agrosyst.api.services.domain.ZoneDto;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanDto;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemDto;
import fr.inra.agrosyst.api.services.performance.PerformanceDto;
import fr.inra.agrosyst.api.services.practiced.PracticedPlotDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemDto;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.persistence.TopiaEntity;

public class AnonymizeContext {
    protected static final String XXXXX = "xxxxx";
    protected BusinessAuthorizationService authorizationService;
    protected Function<String, String> anonymizeFunction;
    protected Function<Domain, DomainDto> domainToDtoFunction;
    protected Function<GrowingPlan, GrowingPlanDto> growingPlanToDtoFunction;
    protected Function<GrowingSystem, GrowingSystemDto> growingSystemToDtoFunction;
    protected Function<Plot, PlotDto> plotToDtoFunction;
    protected Function<Zone, ZoneDto> zoneToDtoFunction;
    protected Function<PracticedSystem, PracticedSystemDto> practicedSystemToDtoFunction;
    protected Function<PracticedPlot, PracticedPlotDto> practicedPlotToDtoFunction;
    protected Function<Performance, PerformanceDto> performanceToDtoFunction;
    protected Function<Domain, Boolean> shouldAnonymizeDomain;
    protected Function<GrowingPlan, Boolean> shouldAnonymizeGrowingPlan;
    protected boolean includeDomainResponsibles = false;
    protected boolean includeGrowingPlanResponsibles = false;
    protected boolean includeZonePlot = false;
    protected int limitPerformanceElements = Integer.MAX_VALUE;

    public <K, V> Function<K, V> cache(final Function<K, V> function) {
        final HashMap cache = Maps.newHashMap();
        Function result = new Function<K, V>(){

            public V apply(K input) {
                String key;
                if (input == null) {
                    return null;
                }
                if (input instanceof String) {
                    key = (String)input;
                } else if (input instanceof TopiaEntity) {
                    key = ((TopiaEntity)input).getTopiaId();
                } else {
                    throw new UnsupportedOperationException("Unsupported key type : " + input.getClass());
                }
                Object result = cache.get(key);
                if (result == null) {
                    result = function.apply(input);
                    cache.put(key, result);
                }
                return result;
            }
        };
        return result;
    }

    public AnonymizeContext(BusinessAuthorizationService authorizationService, Function<String, String> anonymizeFunction) {
        this.authorizationService = authorizationService;
        this.anonymizeFunction = this.cache(anonymizeFunction);
    }

    public AnonymizeContext includeDomainResponsibles(boolean b) {
        this.includeDomainResponsibles = b;
        return this;
    }

    public AnonymizeContext includeGrowingPlanResponsibles(boolean b) {
        this.includeGrowingPlanResponsibles = b;
        return this;
    }

    public AnonymizeContext includeZonePlot(boolean b) {
        this.includeZonePlot = b;
        return this;
    }

    public AnonymizeContext limitPerformanceElements(int i) {
        this.limitPerformanceElements = i;
        return this;
    }

    public Function<Domain, DomainDto> getDomainToDtoFunction() {
        if (this.domainToDtoFunction == null) {
            this.domainToDtoFunction = this.cache(this.newDomainToDtoFunction());
        }
        return this.domainToDtoFunction;
    }

    public Function<GrowingPlan, GrowingPlanDto> getGrowingPlanToDtoFunction() {
        if (this.growingPlanToDtoFunction == null) {
            this.growingPlanToDtoFunction = this.cache(this.newGrowingPlanToDtoFunction());
        }
        return this.growingPlanToDtoFunction;
    }

    public Function<GrowingSystem, GrowingSystemDto> getGrowingSystemToDtoFunction() {
        if (this.growingSystemToDtoFunction == null) {
            this.growingSystemToDtoFunction = this.cache(this.newGrowingSystemToDtoFunction());
        }
        return this.growingSystemToDtoFunction;
    }

    public Function<Plot, PlotDto> getPlotToDtoFunction() {
        if (this.plotToDtoFunction == null) {
            this.plotToDtoFunction = this.cache(this.newPlotToDtoFunction());
        }
        return this.plotToDtoFunction;
    }

    public Function<Zone, ZoneDto> getZoneToDtoFunction() {
        if (this.zoneToDtoFunction == null) {
            this.zoneToDtoFunction = this.cache(this.newZoneToDtoFunction());
        }
        return this.zoneToDtoFunction;
    }

    public Function<PracticedSystem, PracticedSystemDto> getPracticedSystemToDtoFunction() {
        if (this.practicedSystemToDtoFunction == null) {
            this.practicedSystemToDtoFunction = this.cache(this.newPracticedSystemToDtoFunction());
        }
        return this.practicedSystemToDtoFunction;
    }

    public Function<PracticedPlot, PracticedPlotDto> getPracticedPlotToDtoFunction() {
        if (this.practicedPlotToDtoFunction == null) {
            this.practicedPlotToDtoFunction = this.cache(this.newPracticedPlotToDtoFunction());
        }
        return this.practicedPlotToDtoFunction;
    }

    public Function<Performance, PerformanceDto> getPerformanceToDtoFunction() {
        if (this.performanceToDtoFunction == null) {
            this.performanceToDtoFunction = this.cache(this.newPerformanceToDtoFunction());
        }
        return this.performanceToDtoFunction;
    }

    public Function<Domain, Boolean> getShouldAnonymizeDomain() {
        if (this.shouldAnonymizeDomain == null) {
            this.shouldAnonymizeDomain = this.cache(new Function<Domain, Boolean>(){

                public Boolean apply(Domain input) {
                    return AnonymizeContext.this.authorizationService.shouldAnonymizeDomain(input.getTopiaId());
                }
            });
        }
        return this.shouldAnonymizeDomain;
    }

    public Function<GrowingPlan, Boolean> getShouldAnonymizeGrowingPlan() {
        if (this.shouldAnonymizeGrowingPlan == null) {
            this.shouldAnonymizeGrowingPlan = this.cache(new Function<GrowingPlan, Boolean>(){

                public Boolean apply(GrowingPlan input) {
                    return AnonymizeContext.this.authorizationService.shouldAnonymizeGrowingPlan(input.getTopiaId());
                }
            });
        }
        return this.shouldAnonymizeGrowingPlan;
    }

    protected Function<Domain, DomainDto> newDomainToDtoFunction() {
        return new Function<Domain, DomainDto>(){

            public DomainDto apply(Domain input) {
                if (input == null) {
                    return null;
                }
                DomainDto result = new DomainDto();
                result.setTopiaId(input.getTopiaId());
                result.setCode(input.getCode());
                result.setCampaign(input.getCampaign());
                result.setType(input.getType());
                result.setLocation(input.getLocation());
                result.setActive(input.isActive());
                boolean shouldAnonymizeDomain = (Boolean)AnonymizeContext.this.getShouldAnonymizeDomain().apply((Object)input);
                if (shouldAnonymizeDomain) {
                    result.setName((String)AnonymizeContext.this.anonymizeFunction.apply((Object)input.getName()));
                    result.setMainContact(AnonymizeContext.XXXXX);
                } else {
                    result.setName(input.getName());
                    result.setMainContact(input.getMainContact());
                }
                List responsibles = AnonymizeContext.this.includeDomainResponsibles ? AnonymizeContext.this.authorizationService.getDomainResponsibles(input.getCode()) : Lists.newArrayList();
                result.setResponsibles(responsibles);
                return result;
            }
        };
    }

    protected Function<GrowingPlan, GrowingPlanDto> newGrowingPlanToDtoFunction() {
        return new Function<GrowingPlan, GrowingPlanDto>(){

            public GrowingPlanDto apply(GrowingPlan input) {
                if (input == null) {
                    return null;
                }
                GrowingPlanDto result = new GrowingPlanDto();
                result.setTopiaId(input.getTopiaId());
                result.setCode(input.getCode());
                result.setDomain((DomainDto)AnonymizeContext.this.getDomainToDtoFunction().apply((Object)input.getDomain()));
                result.setType(input.getType());
                result.setActive(input.isActive());
                boolean shouldAnonymizeGrowingPlan = (Boolean)AnonymizeContext.this.getShouldAnonymizeGrowingPlan().apply((Object)input);
                if (shouldAnonymizeGrowingPlan) {
                    result.setName((String)AnonymizeContext.this.anonymizeFunction.apply((Object)input.getName()));
                } else {
                    result.setName(input.getName());
                }
                List responsibles = AnonymizeContext.this.includeGrowingPlanResponsibles ? AnonymizeContext.this.authorizationService.getGrowingPlanResponsibles(input.getCode()) : Lists.newArrayList();
                result.setResponsibles(responsibles);
                return result;
            }
        };
    }

    protected Function<GrowingSystem, GrowingSystemDto> newGrowingSystemToDtoFunction() {
        return new Function<GrowingSystem, GrowingSystemDto>(){

            public GrowingSystemDto apply(GrowingSystem input) {
                if (input == null) {
                    return null;
                }
                GrowingSystemDto result = new GrowingSystemDto();
                result.setTopiaId(input.getTopiaId());
                result.setCode(input.getCode());
                result.setName(input.getName());
                result.setValidated(input.isValidated());
                result.setActive(input.isActive());
                result.setDephyNumber(input.getDephyNumber());
                result.setSector(input.getSector());
                result.setGrowingPlan((GrowingPlanDto)AnonymizeContext.this.getGrowingPlanToDtoFunction().apply((Object)input.getGrowingPlan()));
                if (input.getNetworks() != null) {
                    LinkedHashMap networks = Maps.newLinkedHashMap();
                    result.setNetworks((Map)networks);
                    for (Network network : input.getNetworks()) {
                        networks.put(network.getTopiaId(), network.getName());
                    }
                }
                return result;
            }
        };
    }

    protected Function<Plot, PlotDto> newPlotToDtoFunction() {
        return new Function<Plot, PlotDto>(){

            public PlotDto apply(Plot input) {
                if (input == null) {
                    return null;
                }
                PlotDto result = new PlotDto();
                result.setTopiaId(input.getTopiaId());
                result.setCode(input.getCode());
                result.setArea(input.getArea());
                result.setGrowingSystem((GrowingSystemDto)AnonymizeContext.this.getGrowingSystemToDtoFunction().apply((Object)input.getGrowingSystem()));
                result.setDomain((DomainDto)AnonymizeContext.this.getDomainToDtoFunction().apply((Object)input.getDomain()));
                if (((Boolean)AnonymizeContext.this.getShouldAnonymizeDomain().apply((Object)input.getDomain())).booleanValue()) {
                    result.setName((String)AnonymizeContext.this.anonymizeFunction.apply((Object)input.getName()));
                } else {
                    result.setName(input.getName());
                }
                return result;
            }
        };
    }

    protected Function<Zone, ZoneDto> newZoneToDtoFunction() {
        return new Function<Zone, ZoneDto>(){

            public ZoneDto apply(Zone input) {
                if (input == null) {
                    return null;
                }
                ZoneDto result = new ZoneDto();
                result.setTopiaId(input.getTopiaId());
                result.setCode(input.getCode());
                result.setName(input.getName());
                Plot plot = input.getPlot();
                if (AnonymizeContext.this.includeZonePlot) {
                    result.setPlot((PlotDto)AnonymizeContext.this.getPlotToDtoFunction().apply((Object)plot));
                } else if (plot != null) {
                    PlotDto plotDto = new PlotDto();
                    plotDto.setTopiaId(plot.getTopiaId());
                    result.setPlot(plotDto);
                }
                return result;
            }
        };
    }

    protected Function<PracticedSystem, PracticedSystemDto> newPracticedSystemToDtoFunction() {
        return new Function<PracticedSystem, PracticedSystemDto>(){

            public PracticedSystemDto apply(PracticedSystem input) {
                if (input == null) {
                    return null;
                }
                PracticedSystemDto result = new PracticedSystemDto();
                result.setTopiaId(input.getTopiaId());
                result.setName(input.getName());
                result.setGrowingSystem((GrowingSystemDto)AnonymizeContext.this.getGrowingSystemToDtoFunction().apply((Object)input.getGrowingSystem()));
                result.setCampaigns(input.getCampaigns());
                result.setActive(input.isActive());
                result.setValidated(input.isValidated());
                return result;
            }
        };
    }

    protected Function<PracticedPlot, PracticedPlotDto> newPracticedPlotToDtoFunction() {
        return new Function<PracticedPlot, PracticedPlotDto>(){

            public PracticedPlotDto apply(PracticedPlot input) {
                if (input == null) {
                    return null;
                }
                PracticedPlotDto result = new PracticedPlotDto();
                result.setTopiaId(input.getTopiaId());
                result.setName(input.getName());
                result.setPracticedSystem((PracticedSystemDto)AnonymizeContext.this.getPracticedSystemToDtoFunction().apply((Object)input.getPracticedSystem()));
                return result;
            }
        };
    }

    protected Function<Performance, PerformanceDto> newPerformanceToDtoFunction() {
        return new Function<Performance, PerformanceDto>(){

            public PerformanceDto apply(Performance input) {
                if (input == null) {
                    return null;
                }
                PerformanceDto result = new PerformanceDto();
                result.setTopiaId(input.getTopiaId());
                result.setName(input.getName());
                result.setComputeStatus(input.getComputeStatus());
                result.setUpdateDate(input.getUpdateDate());
                if (input.getDomains() != null) {
                    result.setDomains((List)Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.limit((Iterable)input.getDomains(), (int)AnonymizeContext.this.limitPerformanceElements), AnonymizeContext.this.getDomainToDtoFunction())));
                }
                if (input.getGrowingSystems() != null) {
                    result.setGrowingSystems((List)Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.limit((Iterable)input.getGrowingSystems(), (int)AnonymizeContext.this.limitPerformanceElements), AnonymizeContext.this.getGrowingSystemToDtoFunction())));
                }
                if (input.getPlots() != null) {
                    result.setPlots((List)Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.limit((Iterable)input.getPlots(), (int)AnonymizeContext.this.limitPerformanceElements), AnonymizeContext.this.getPlotToDtoFunction())));
                }
                if (input.getZones() != null) {
                    result.setZones((List)Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.limit((Iterable)input.getZones(), (int)AnonymizeContext.this.limitPerformanceElements), AnonymizeContext.this.getZoneToDtoFunction())));
                }
                return result;
            }
        };
    }
}

