/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.referential.csv.iphy;

import fr.inra.agrosyst.api.entities.MaxSlope;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesuRunoffPotRulesParc;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesuRunoffPotRulesParcImpl;
import fr.inra.agrosyst.services.referential.csv.AbstractAgrosystModel;
import java.text.ParseException;
import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;

public class RefRcesuRunoffPotRulesParcModel
extends AbstractAgrosystModel<RefRcesuRunoffPotRulesParc>
implements ExportModel<RefRcesuRunoffPotRulesParc> {
    protected static final ValueParser<MaxSlope> MAX_SLOPE_PARSER = new ValueParser<MaxSlope>(){

        public MaxSlope parse(String value) throws ParseException {
            MaxSlope result = "0%".equals(value) ? MaxSlope.ZERO : ("0-2%".equals(value) ? MaxSlope.ZERO_TO_TWO : ("2-5%".equals(value) ? MaxSlope.TWO_TO_FIVE : MaxSlope.MORE_THAN_FIVE));
            return result;
        }
    };
    protected static final ValueFormatter<MaxSlope> MAX_SLOPE_FORMATTER = new ValueFormatter<MaxSlope>(){

        public String format(MaxSlope value) {
            String result;
            switch (value) {
                case ZERO: {
                    result = "0%";
                    break;
                }
                case ZERO_TO_TWO: {
                    result = "0-2%";
                    break;
                }
                case TWO_TO_FIVE: {
                    result = "2-5%";
                    break;
                }
                default: {
                    result = ">5%";
                }
            }
            return result;
        }
    };
    protected static final ValueParser<Boolean> OUI_NON_PARSER = new ValueParser<Boolean>(){

        public Boolean parse(String value) throws ParseException {
            boolean result = "oui".equalsIgnoreCase(value);
            return result;
        }
    };
    protected static final ValueFormatter<Boolean> OUI_NON_FORMATTER = new ValueFormatter<Boolean>(){

        public String format(Boolean value) {
            String result = value != null && value != false ? "oui" : "non";
            return result;
        }
    };

    public RefRcesuRunoffPotRulesParcModel() {
        super(';');
        this.newMandatoryColumn("Id r\u00e8gle", "id_regle", INT_PARSER);
        this.newMandatoryColumn("Soil texture", "soil_texture");
        this.newMandatoryColumn("Slope", "slope", MAX_SLOPE_PARSER);
        this.newMandatoryColumn("battance", "battance", OUI_NON_PARSER);
        this.newMandatoryColumn("hydromorphisms", "hydromorphisms", OUI_NON_PARSER);
        this.newMandatoryColumn("Runoff potential", "runoff_potential", DOUBLE_PARSER);
    }

    public RefRcesuRunoffPotRulesParc newEmptyInstance() {
        RefRcesuRunoffPotRulesParcImpl result = new RefRcesuRunoffPotRulesParcImpl();
        return result;
    }

    public Iterable<ExportableColumn<RefRcesuRunoffPotRulesParc, Object>> getColumnsForExport() {
        ModelBuilder modelBuilder = new ModelBuilder();
        modelBuilder.newColumnForExport("Id r\u00e8gle", "id_regle", INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("Soil texture", "soil_texture");
        modelBuilder.newColumnForExport("Slope", "slope", MAX_SLOPE_FORMATTER);
        modelBuilder.newColumnForExport("battance", "battance", OUI_NON_FORMATTER);
        modelBuilder.newColumnForExport("hydromorphisms", "hydromorphisms", OUI_NON_FORMATTER);
        modelBuilder.newColumnForExport("Runoff potential", "runoff_potential", DOUBLE_FORMATTER);
        return modelBuilder.getColumnsForExport();
    }
}

