/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.referential.csv;

import com.google.common.base.Strings;
import fr.inra.agrosyst.api.entities.VariableType;
import fr.inra.agrosyst.api.entities.measure.MeasurementType;
import fr.inra.agrosyst.api.entities.referential.RefMesure;
import fr.inra.agrosyst.api.entities.referential.RefMesureImpl;
import fr.inra.agrosyst.services.referential.csv.AbstractAgrosystModel;
import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;

public class RefMesureModel
extends AbstractAgrosystModel<RefMesure>
implements ExportModel<RefMesure> {
    protected static final ValueFormatter<MeasurementType> MEASUREMENT_TYPE_FORMATTER = new ValueFormatter<MeasurementType>(){

        public String format(MeasurementType value) {
            String result = value != null ? value.name().toLowerCase() : "";
            return result;
        }
    };
    protected static final ValueParser<MeasurementType> MEASUREMENT_TYPE_PARSER = new ValueParser<MeasurementType>(){

        public MeasurementType parse(String value) throws ParseException {
            MeasurementType result = null;
            if (!Strings.isNullOrEmpty((String)value)) {
                String strValue = StringUtils.stripAccents((String)value);
                strValue = strValue.replaceAll("\\W", "_");
                strValue = strValue.toUpperCase();
                result = MeasurementType.valueOf((String)strValue);
            }
            return result;
        }
    };
    protected static final ValueFormatter<VariableType> VARIABLE_TYPE_FORMATTER = new ValueFormatter<VariableType>(){

        public String format(VariableType value) {
            String result = value != null ? value.name().toLowerCase() : "";
            return result;
        }
    };
    protected static final ValueParser<VariableType> VARIABLE_TYPE_PARSER = new ValueParser<VariableType>(){

        public VariableType parse(String value) throws ParseException {
            VariableType result = null;
            if (!Strings.isNullOrEmpty((String)value)) {
                String strValue = StringUtils.stripAccents((String)value);
                strValue = strValue.replaceAll("\\W", "_");
                strValue = strValue.toUpperCase();
                result = VariableType.valueOf((String)strValue);
            }
            return result;
        }
    };

    public RefMesureModel() {
        super(';');
        this.newMandatoryColumn("Cat\u00e9gorie de mesure", "categorie_de_mesure", MEASUREMENT_TYPE_PARSER);
        this.newMandatoryColumn("Type variable mesur\u00e9e", "type_variable_mesuree", VARIABLE_TYPE_PARSER);
        this.newMandatoryColumn("variable mesur\u00e9e", "variable_mesuree");
        this.newMandatoryColumn("unit\u00e9", "unite");
        this.newMandatoryColumn("valeur attendue", "valeur_attendue");
        this.newMandatoryColumn("Remarque", "remarque");
    }

    public RefMesure newEmptyInstance() {
        return new RefMesureImpl();
    }

    public Iterable<ExportableColumn<RefMesure, Object>> getColumnsForExport() {
        ModelBuilder modelBuilder = new ModelBuilder();
        modelBuilder.newColumnForExport("Cat\u00e9gorie de mesure", "categorie_de_mesure", MEASUREMENT_TYPE_FORMATTER);
        modelBuilder.newColumnForExport("Type variable mesur\u00e9e", "type_variable_mesuree", VARIABLE_TYPE_FORMATTER);
        modelBuilder.newColumnForExport("variable mesur\u00e9e", "variable_mesuree");
        modelBuilder.newColumnForExport("unit\u00e9", "unite");
        modelBuilder.newColumnForExport("valeur attendue", "valeur_attendue");
        modelBuilder.newColumnForExport("Remarque", "remarque");
        return modelBuilder.getColumnsForExport();
    }
}

