/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.referential.csv;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.action.PhytoProductUnit;
import fr.inra.agrosyst.api.entities.referential.RefActaDosageSPC;
import fr.inra.agrosyst.api.entities.referential.RefActaDosageSPCImpl;
import fr.inra.agrosyst.services.referential.csv.AbstractAgrosystModel;
import java.text.ParseException;
import java.util.Map;
import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.ModelBuilder;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;

public class RefActaDosageSPCModel
extends AbstractAgrosystModel<RefActaDosageSPC>
implements ExportModel<RefActaDosageSPC> {
    protected static final Map<String, PhytoProductUnit> PHYTO_PRODUCT_UNIT_TO_ENUM = Maps.newLinkedHashMap();
    protected static final Map<PhytoProductUnit, String> PHYTO_PRODUCT_UNIT_ENUM_TO_STRING = Maps.newHashMap();
    protected static final ValueParser<PhytoProductUnit> PHYTO_PRODUCT_UNIT_PARSER;
    protected static final ValueFormatter<PhytoProductUnit> PHYTO_PRODUCT_UNIT_FORMATTER;

    public RefActaDosageSPCModel() {
        super(';');
        this.newMandatoryColumn("id_produit", "id_produit");
        this.newMandatoryColumn("nom_produit", "nom_produit");
        this.newMandatoryColumn("id_traitement", "id_traitement", INT_PARSER);
        this.newMandatoryColumn("code_traitement", "code_traitement");
        this.newMandatoryColumn("id_culture", "id_culture", INT_PARSER);
        this.newMandatoryColumn("nom_culture", "nom_culture");
        this.newMandatoryColumn("remarque_culture", "remarque_culture");
        this.newMandatoryColumn("dosage_spc_valeur", "dosage_spc_valeur", DOUBLE_WITH_NULL_PARSER);
        this.newMandatoryColumn("dosage_spc_unite", "dosage_spc_unite", PHYTO_PRODUCT_UNIT_PARSER);
        this.newMandatoryColumn("dosage_spc_commentaire", "dosage_spc_commentaire");
        this.newMandatoryColumn("Commentaire Agrosyst", "commentaire_agrosyst");
    }

    public Iterable<ExportableColumn<RefActaDosageSPC, Object>> getColumnsForExport() {
        ModelBuilder modelBuilder = new ModelBuilder();
        modelBuilder.newColumnForExport("id_produit", "id_produit");
        modelBuilder.newColumnForExport("nom_produit", "nom_produit");
        modelBuilder.newColumnForExport("id_traitement", "id_traitement", INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("code_traitement", "code_traitement");
        modelBuilder.newColumnForExport("id_culture", "id_culture", INTEGER_FORMATTER);
        modelBuilder.newColumnForExport("nom_culture", "nom_culture");
        modelBuilder.newColumnForExport("remarque_culture", "remarque_culture");
        modelBuilder.newColumnForExport("dosage_spc_valeur", "dosage_spc_valeur", DOUBLE_FORMATTER);
        modelBuilder.newColumnForExport("dosage_spc_unite", "dosage_spc_unite", PHYTO_PRODUCT_UNIT_FORMATTER);
        modelBuilder.newColumnForExport("dosage_spc_commentaire", "dosage_spc_commentaire");
        modelBuilder.newColumnForExport("Commentaire Agrosyst", "commentaire_agrosyst");
        return modelBuilder.getColumnsForExport();
    }

    public RefActaDosageSPC newEmptyInstance() {
        return new RefActaDosageSPCImpl();
    }

    static {
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("Aa/ha", PhytoProductUnit.AA_HA);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("adultes/m\u00b2", PhytoProductUnit.ADULTES_M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("adulte/m\u00b2", PhytoProductUnit.ADULTES_M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("Ana-line/semaine/ha", PhytoProductUnit.ANA_LINE_SEMAINE_HA);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("auxiliaires/m\u00b2", PhytoProductUnit.AUXILIAIRES_M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("auxiliaire/m\u00b2", PhytoProductUnit.AUXILIAIRES_M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("Di/ha", PhytoProductUnit.DI_HA);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("diffuseurs/ha", PhytoProductUnit.DIFFUSEURS_HA);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("doses/200 m\u00b2", PhytoProductUnit.DOSES_200M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("dose/200 m\u00b2", PhytoProductUnit.DOSES_200M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("Ds/m\u00b2", PhytoProductUnit.DS_M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("Ds/ha", PhytoProductUnit.DS_HA);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("\u00e9levages/500 m\u00b2", PhytoProductUnit.ELEVAGES_500M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("\u00e9levage/500 m\u00b2", PhytoProductUnit.ELEVAGES_500M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("g/100 kg", PhytoProductUnit.G_100KG);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("g/100 L d'eau", PhytoProductUnit.G_100L_D_EAU);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("g/100 m\u00b2", PhytoProductUnit.G_100M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("g/100 m2", PhytoProductUnit.G_100M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("g/160 m\u00b2", PhytoProductUnit.G_160M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("g/bouture", PhytoProductUnit.G_BOUTURE);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("g/ha", PhytoProductUnit.G_HA);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("g/hl", PhytoProductUnit.G_HL);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("g/kg", PhytoProductUnit.G_KG);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("g/L", PhytoProductUnit.G_L);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("g/m2", PhytoProductUnit.G_M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("g/m\u00b2", PhytoProductUnit.G_M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("g/m\u00b3", PhytoProductUnit.G_M3);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("g/m3", PhytoProductUnit.G_M3);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("g/pied", PhytoProductUnit.G_PIED);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("g/plant", PhytoProductUnit.G_PLANT);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("g/q", PhytoProductUnit.G_Q);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("g/t", PhytoProductUnit.G_T);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("g/unit\u00e9 de semences", PhytoProductUnit.G_UNITE_SEMENCES);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("Hm/m\u00b2", PhytoProductUnit.HM_M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("ind/m\u00b2", PhytoProductUnit.IND_M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("individus/arbre", PhytoProductUnit.INDIVIDUS_ARBRE);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("individus/foyer", PhytoProductUnit.INDIVIDUS_FOYER);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("individus/ha", PhytoProductUnit.INDIVIDUS_HA);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("individus/m\u00b2", PhytoProductUnit.INDIVIDUS_M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("kg/100 m\u00b2", PhytoProductUnit.KG_100M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("kg/hL", PhytoProductUnit.KG_HL);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("kg/ha", PhytoProductUnit.KG_HA);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("kg/hl", PhytoProductUnit.KG_HL);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("kg/m2", PhytoProductUnit.KG_M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("kg/q", PhytoProductUnit.KG_Q);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("kg/t", PhytoProductUnit.KG_T);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("kg/unit\u00e9", PhytoProductUnit.KG_UNITE);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("L/100 m\u00b3", PhytoProductUnit.L_100M3);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("L/ha", PhytoProductUnit.L_HA);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("L/hl", PhytoProductUnit.L_HL);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("L/hL", PhytoProductUnit.L_HL);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("L/m\u00b3", PhytoProductUnit.L_M3);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("L/q", PhytoProductUnit.L_Q);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("L/t", PhytoProductUnit.L_T);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("L/100 m\u00b2", PhytoProductUnit.L_100M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("L/100m\u00b2", PhytoProductUnit.L_100M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("L/unit\u00e9 de semences", PhytoProductUnit.L_UNITE_SEMENCES);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("L/m\u00b2", PhytoProductUnit.L_M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("L/10 m\u00b2", PhytoProductUnit.L_10M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("L/unit\u00e9", PhytoProductUnit.L_UNITE);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("L/T", PhytoProductUnit.L_T);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("L/100000 graines", PhytoProductUnit.L_100000_GRAINES);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("L/kg", PhytoProductUnit.L_KG);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("L/1000 plants", PhytoProductUnit.L_1000PLANTS);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("L/m2", PhytoProductUnit.L_M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("larves/50 pucerons", PhytoProductUnit.LARVES_50PUCERONS);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("larve/50 pucerons", PhytoProductUnit.LARVES_50PUCERONS);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("larves/m\u00b2", PhytoProductUnit.LARVES_M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("larves d'Ab/colonie de pucerons", PhytoProductUnit.LARVES_D_AB_COLONIE_DE_PUCERONS);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("larves/5 \u00e0 10 m\u00b2", PhytoProductUnit.LARVES_5_A_10M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("milliards/ha", PhytoProductUnit.MILLIARDS_HA);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("milliard/ha", PhytoProductUnit.MILLIARDS_HA);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("millions/100 m\u00b2", PhytoProductUnit.MILLIONS_100M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("millions/arbre", PhytoProductUnit.MILLIONS_ARBRE);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("millions/L de bouillie", PhytoProductUnit.MILLIONS_L_BOUILLIE);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("ml/100 m\u00b2", PhytoProductUnit.ML_100M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("ml/5000 graines", PhytoProductUnit.ML_5000GRAINES);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("ml/ha", PhytoProductUnit.ML_HA);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("ml/kg", PhytoProductUnit.ML_KG);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("ml/L", PhytoProductUnit.ML_L);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("ml/m2", PhytoProductUnit.ML_M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("ml/m\u00b2", PhytoProductUnit.ML_M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("ml/t", PhytoProductUnit.ML_T);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("momies/m\u00b2", PhytoProductUnit.MOMIES_M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("momie/m\u00b2", PhytoProductUnit.MOMIES_M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("momies/500 m\u00b2", PhytoProductUnit.MOMIES_500M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("/m\u00b2", PhytoProductUnit.PER_M2);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("%", PhytoProductUnit.PERCENT);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("pi\u00e8ges/ha", PhytoProductUnit.PIEGES_HA);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("Ta/ha", PhytoProductUnit.TA_HA);
        PHYTO_PRODUCT_UNIT_TO_ENUM.put("t/ha", PhytoProductUnit.T_HA);
        PHYTO_PRODUCT_UNIT_PARSER = new ValueParser<PhytoProductUnit>(){

            public PhytoProductUnit parse(String value) throws ParseException {
                PhytoProductUnit result = null;
                if (!Strings.isNullOrEmpty((String)value) && (result = PHYTO_PRODUCT_UNIT_TO_ENUM.get(value)) == null) {
                    throw new UnsupportedOperationException("Unexpected value: " + value);
                }
                return result;
            }
        };
        PHYTO_PRODUCT_UNIT_FORMATTER = new ValueFormatter<PhytoProductUnit>(){

            public String format(final PhytoProductUnit value) {
                String result;
                if (value != null) {
                    Optional optional;
                    result = PHYTO_PRODUCT_UNIT_ENUM_TO_STRING.get(value);
                    if (Strings.isNullOrEmpty((String)result) && (optional = Iterables.tryFind(PHYTO_PRODUCT_UNIT_TO_ENUM.entrySet(), (Predicate)new Predicate<Map.Entry<String, PhytoProductUnit>>(){

                        public boolean apply(Map.Entry<String, PhytoProductUnit> input) {
                            return value.equals((Object)input.getValue());
                        }
                    })).isPresent()) {
                        result = (String)((Map.Entry)optional.get()).getKey();
                        PHYTO_PRODUCT_UNIT_ENUM_TO_STRING.put(value, result);
                    }
                    if (result == null) {
                        throw new UnsupportedOperationException("Unexpected value: " + value);
                    }
                } else {
                    result = "";
                }
                return result;
            }
        };
    }
}

