/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.referential.csv;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.entities.MaterielTransportUnit;
import fr.inra.agrosyst.api.entities.MaterielWorkRateUnit;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.entities.action.FertiOrgaUnit;
import fr.inra.agrosyst.api.entities.referential.VitesseCouv;
import fr.inra.agrosyst.api.entities.security.RoleType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.ImportableColumn;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;
import org.nuiton.csv.ext.AbstractImportModel;

public abstract class AbstractAgrosystModel<E>
extends AbstractImportModel<E> {
    protected static final ValueParser<Integer> INT_PARSER = new ValueParser<Integer>(){

        public Integer parse(String value) throws ParseException {
            int result = 0;
            if (!Strings.isNullOrEmpty((String)value)) {
                result = Integer.valueOf(value);
            }
            return result;
        }
    };
    protected static final ValueParser<Integer> INTEGER_WITH_NULL_PARSER = new ValueParser<Integer>(){

        public Integer parse(String value) throws ParseException {
            Integer result = null;
            if (!Strings.isNullOrEmpty((String)value)) {
                result = Integer.valueOf(value);
            }
            return result;
        }
    };
    protected static final ValueParser<Double> DOUBLE_PARSER = new ValueParser<Double>(){

        public Double parse(String value) throws ParseException {
            double result = 0.0;
            if (!value.isEmpty()) {
                result = Double.valueOf(value.replace(',', '.').replace("\u00a0", ""));
            }
            return result;
        }
    };
    protected static final ValueParser<Double> DOUBLE_WITH_NULL_PARSER = new ValueParser<Double>(){

        public Double parse(String value) throws ParseException {
            Double result = null;
            if (!value.isEmpty()) {
                result = Double.valueOf(value.replace(',', '.').replace("\u00a0", ""));
            }
            return result;
        }
    };
    protected static final ValueParser<String> ZERO_TO_EMPTY_PARSER = new ValueParser<String>(){

        public String parse(String value) throws ParseException {
            String result = value.trim();
            if ((result = result.replaceAll("\\s{2,}", " ")).equals("0")) {
                result = "";
            }
            return result;
        }
    };
    protected static final ValueParser<Date> DATE_PARSER = new ValueParser<Date>(){

        public Date parse(String value) throws ParseException {
            Date result = null;
            if (!Strings.isNullOrEmpty((String)value)) {
                SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
                result = format.parse(value);
            }
            return result;
        }
    };
    protected static final ValueParser<Boolean> O_N_PARSER = new ValueParser<Boolean>(){

        public Boolean parse(String value) throws ParseException {
            Boolean result = "O".equalsIgnoreCase(value) ? Boolean.TRUE : Boolean.FALSE;
            return result;
        }
    };
    protected static final ValueFormatter<Boolean> O_N_FORMATTER = new ValueFormatter<Boolean>(){

        public String format(Boolean value) {
            String result = value != false ? "O" : "N";
            return result;
        }
    };
    protected static final ValueParser<Boolean> T_F_PARSER = new ValueParser<Boolean>(){

        public Boolean parse(String value) throws ParseException {
            Boolean result = "t".equalsIgnoreCase(value) ? Boolean.TRUE : Boolean.FALSE;
            return result;
        }
    };
    protected static final ValueFormatter<Boolean> T_F_FORMATTER = new ValueFormatter<Boolean>(){

        public String format(Boolean value) {
            String result = value != false ? "t" : "f";
            return result;
        }
    };
    protected static final ValueFormatter<Integer> INTEGER_FORMATTER = new ValueFormatter<Integer>(){

        public String format(Integer value) {
            String result = value != null ? String.valueOf(value) : "";
            return result;
        }
    };
    protected static final ValueFormatter<Double> DOUBLE_FORMATTER = new ValueFormatter<Double>(){

        public String format(Double value) {
            String result = value != null ? String.valueOf(value) : "";
            return result;
        }
    };
    protected static final ValueFormatter<Date> DATE_FORMATTER = new ValueFormatter<Date>(){

        public String format(Date value) {
            String result;
            if (value != null) {
                SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
                result = format.format(value);
            } else {
                result = "";
            }
            return result;
        }
    };
    protected static final ValueFormatter<AgrosystInterventionType> AGROSYST_INTERVENTION_TYPE_FORMATTER = new ValueFormatter<AgrosystInterventionType>(){

        public String format(AgrosystInterventionType value) {
            String result = value != null ? value.name().toLowerCase() : "";
            return result;
        }
    };
    protected static final ValueFormatter<BioAgressorType> AGROSYST_BIO_AGRESSOR_TYPE_FORMATTER = new ValueFormatter<BioAgressorType>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String format(BioAgressorType value) {
            if (value == null) return "";
            if (value == BioAgressorType.ACTION_SUR_LE_METABOLISME) {
                return "Action sur le m\u00e9tabolisme";
            }
            if (value == BioAgressorType.AUXILIAIRE_BIOLOGIQUE) {
                return "Auxiliaire biologique";
            }
            if (value == BioAgressorType.GENERIQUE) {
                return "G\u00e9n\u00e9rique";
            }
            if (value == BioAgressorType.MALADIE) {
                return "Maladie";
            }
            if (value == BioAgressorType.MALADIE_PHYSIOLOGIQUE) {
                return "Maladie physiologique";
            }
            if (value == BioAgressorType.PLANTE_PARASITE) {
                return "Plante parasite";
            }
            if (value == BioAgressorType.PLANTES_ENVAHISSANTES_ORIGINE_EXOTIQUE) {
                return "Plantes envahissantes d'origine exotique";
            }
            if (value == BioAgressorType.RAVAGEUR) {
                return "Ravageur";
            }
            if (value != BioAgressorType.VIRUS) throw new UnsupportedOperationException("type non support\u00e9 : " + value);
            return "Virus";
        }
    };
    protected static final ValueFormatter<FertiOrgaUnit> AGROSYST_FERTI_ORGA_UNIT_FORMATTER = new ValueFormatter<FertiOrgaUnit>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String format(FertiOrgaUnit fertiOrgaUnit) {
            if (fertiOrgaUnit == null) return "";
            if (fertiOrgaUnit == FertiOrgaUnit.KG_M_CUB) {
                return "kg/m3";
            }
            if (fertiOrgaUnit != FertiOrgaUnit.KG_T) throw new UnsupportedOperationException("unit\u00e9 non support\u00e9e : " + fertiOrgaUnit);
            return "kg/T";
        }
    };
    protected static final ValueParser<AgrosystInterventionType> AGROSYST_INTERVENTION_TYPE_PARSER = new ValueParser<AgrosystInterventionType>(){

        public AgrosystInterventionType parse(String value) throws ParseException {
            AgrosystInterventionType result = null;
            if (!Strings.isNullOrEmpty((String)value)) {
                result = AgrosystInterventionType.valueOf((String)value.toUpperCase());
            }
            return result;
        }
    };
    protected static final ValueParser<BioAgressorType> AGROSYST_BIO_AGRESSOR_TYPE_PARSER = new ValueParser<BioAgressorType>(){

        public BioAgressorType parse(String value) throws ParseException {
            BioAgressorType result = null;
            if (!Strings.isNullOrEmpty((String)value)) {
                if (value.equalsIgnoreCase("Action sur le m\u00e9tabolisme")) {
                    result = BioAgressorType.ACTION_SUR_LE_METABOLISME;
                } else if (value.equalsIgnoreCase("Auxiliaire biologique")) {
                    result = BioAgressorType.AUXILIAIRE_BIOLOGIQUE;
                } else if (value.equalsIgnoreCase("G\u00e9n\u00e9rique")) {
                    result = BioAgressorType.GENERIQUE;
                } else if (value.equalsIgnoreCase("Maladie")) {
                    result = BioAgressorType.MALADIE;
                } else if (value.equalsIgnoreCase("Maladie physiologique")) {
                    result = BioAgressorType.MALADIE_PHYSIOLOGIQUE;
                } else if (value.equalsIgnoreCase("Plante parasite")) {
                    result = BioAgressorType.PLANTE_PARASITE;
                } else if (value.equalsIgnoreCase("Plantes envahissantes d'origine exotique")) {
                    result = BioAgressorType.PLANTES_ENVAHISSANTES_ORIGINE_EXOTIQUE;
                } else if (value.equalsIgnoreCase("Ravageur")) {
                    result = BioAgressorType.RAVAGEUR;
                } else if (value.equalsIgnoreCase("Virus")) {
                    result = BioAgressorType.VIRUS;
                } else {
                    throw new UnsupportedOperationException("type non support\u00e9 : " + value);
                }
            }
            return result;
        }
    };
    protected static final ValueParser<FertiOrgaUnit> AGROSYST_FERTI_ORGA_UNIT_PARSER = new ValueParser<FertiOrgaUnit>(){

        public FertiOrgaUnit parse(String value) throws ParseException {
            FertiOrgaUnit result = null;
            if (!Strings.isNullOrEmpty((String)value)) {
                if (value.equalsIgnoreCase("kg/T")) {
                    result = FertiOrgaUnit.KG_T;
                } else if (value.equalsIgnoreCase("kg/m3")) {
                    result = FertiOrgaUnit.KG_M_CUB;
                } else {
                    throw new UnsupportedOperationException("Unit\u00e9 non support\u00e9 : " + value);
                }
            }
            return result;
        }
    };
    protected static final ValueParser<VitesseCouv> VITESSE_COUV_PARSER = new ValueParser<VitesseCouv>(){

        public VitesseCouv parse(String value) throws ParseException {
            VitesseCouv result = VitesseCouv.valueOf((String)value);
            return result;
        }
    };
    protected static final ValueFormatter<VitesseCouv> VITESSE_COUV_FORMATTER = new ValueFormatter<VitesseCouv>(){

        public String format(VitesseCouv value) {
            return value.name();
        }
    };
    protected static final ValueParser<Double> PERCENT_DOUBLE_PARSER = new ValueParser<Double>(){

        public Double parse(String value) throws ParseException {
            Double result = null;
            if (value != null && value.matches("\\d{1,2}([\\.,]\\d+)?\\s*%")) {
                String str = StringUtils.removeEnd((String)value, (String)"%").trim();
                str = str.replace(',', '.');
                result = Double.parseDouble(str) / 100.0;
            }
            return result;
        }
    };
    protected static final ValueFormatter<Double> PERCENT_DOUBLE_FORMATTER = new ValueFormatter<Double>(){

        public String format(Double value) {
            return String.format("%f%%", value);
        }
    };
    protected Map<String, String> headerMap;
    protected static final ValueParser<RoleType> ROLE_TYPE_PARSER = new ValueParser<RoleType>(){

        public RoleType parse(String value) throws ParseException {
            RoleType result = null;
            if (!Strings.isNullOrEmpty((String)value)) {
                result = RoleType.valueOf((String)value.toUpperCase());
            }
            return result;
        }
    };
    protected static final ValueParser<MaterielWorkRateUnit> AGROSYST_MATERIEL_WORK_RATE_UNIT_PARSER = new ValueParser<MaterielWorkRateUnit>(){

        public MaterielWorkRateUnit parse(String value) throws ParseException {
            MaterielWorkRateUnit result = null;
            if (!Strings.isNullOrEmpty((String)value)) {
                String valueTrim = StringUtils.remove((String)value, (char)' ');
                if (valueTrim.equalsIgnoreCase("bal/h")) {
                    result = MaterielWorkRateUnit.BAL_H;
                } else if (valueTrim.equalsIgnoreCase("ha/h")) {
                    result = MaterielWorkRateUnit.HA_H;
                } else if (valueTrim.equalsIgnoreCase("m3/h")) {
                    result = MaterielWorkRateUnit.M3_H;
                } else if (valueTrim.equalsIgnoreCase("qx/h")) {
                    result = MaterielWorkRateUnit.QX_H;
                } else if (valueTrim.equalsIgnoreCase("sacs/h")) {
                    result = MaterielWorkRateUnit.SACS_H;
                } else if (valueTrim.equalsIgnoreCase("t/benne")) {
                    result = MaterielWorkRateUnit.T_BENNE;
                } else if (valueTrim.equalsIgnoreCase("trous/h")) {
                    result = MaterielWorkRateUnit.TROUS_H;
                } else if (valueTrim.equalsIgnoreCase("voy/h")) {
                    result = MaterielWorkRateUnit.VOY_H;
                } else if (valueTrim.equalsIgnoreCase("t/ha")) {
                    result = MaterielWorkRateUnit.T_HA;
                } else if (valueTrim.equalsIgnoreCase("h/ha")) {
                    result = MaterielWorkRateUnit.H_HA;
                } else if (valueTrim.equalsIgnoreCase("t/h")) {
                    result = MaterielWorkRateUnit.T_H;
                } else if (valueTrim.equalsIgnoreCase("\u20ac/h")) {
                    result = MaterielWorkRateUnit.EURO_H;
                } else if (valueTrim.equalsIgnoreCase("0")) {
                    result = null;
                } else {
                    throw new UnsupportedOperationException("Unit\u00e9 non support\u00e9 : " + value);
                }
            }
            return result;
        }
    };
    protected static final ValueFormatter<MaterielWorkRateUnit> AGROSYST_MATERIEL_WORK_RATE_UNIT_FORMATTER = new ValueFormatter<MaterielWorkRateUnit>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String format(MaterielWorkRateUnit materielWorkRateUnit) {
            if (materielWorkRateUnit == null) return "";
            if (materielWorkRateUnit == MaterielWorkRateUnit.BAL_H) {
                return "bal/h";
            }
            if (materielWorkRateUnit == MaterielWorkRateUnit.HA_H) {
                return "ha/h";
            }
            if (materielWorkRateUnit == MaterielWorkRateUnit.M3_H) {
                return "m3/h";
            }
            if (materielWorkRateUnit == MaterielWorkRateUnit.QX_H) {
                return "qx/h";
            }
            if (materielWorkRateUnit == MaterielWorkRateUnit.SACS_H) {
                return "sacs/h";
            }
            if (materielWorkRateUnit == MaterielWorkRateUnit.T_BENNE) {
                return "t/benne";
            }
            if (materielWorkRateUnit == MaterielWorkRateUnit.TROUS_H) {
                return "trous/h";
            }
            if (materielWorkRateUnit == MaterielWorkRateUnit.VOY_H) {
                return "voy/h";
            }
            if (materielWorkRateUnit == MaterielWorkRateUnit.T_HA) {
                return "t/ha";
            }
            if (materielWorkRateUnit == MaterielWorkRateUnit.H_HA) {
                return "h/ha";
            }
            if (materielWorkRateUnit == MaterielWorkRateUnit.T_H) {
                return "t/h";
            }
            if (materielWorkRateUnit != MaterielWorkRateUnit.EURO_H) throw new UnsupportedOperationException("unit\u00e9 non support\u00e9e : " + materielWorkRateUnit);
            return "\u20ac/h";
        }
    };
    protected static final ValueParser<MaterielTransportUnit> AGROSYST_MATERIEL_TRANSPORT_UNIT_PARSER = new ValueParser<MaterielTransportUnit>(){

        public MaterielTransportUnit parse(String value) throws ParseException {
            MaterielTransportUnit result = null;
            if (!Strings.isNullOrEmpty((String)value)) {
                if ((value = StringUtils.remove((String)value, (char)' ')).equalsIgnoreCase("l") || value.equalsIgnoreCase("litres")) {
                    result = MaterielTransportUnit.L;
                } else if (value.equalsIgnoreCase("m3")) {
                    result = MaterielTransportUnit.M3;
                } else if (value.equalsIgnoreCase("t")) {
                    result = MaterielTransportUnit.T;
                } else {
                    throw new UnsupportedOperationException("Unit\u00e9 non support\u00e9 : " + value);
                }
            }
            return result;
        }
    };
    protected static final ValueFormatter<MaterielTransportUnit> AGROSYST_MATERIEL_TRANSPORT_UNIT_FORMATTER = new ValueFormatter<MaterielTransportUnit>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String format(MaterielTransportUnit materielTransportUnit) {
            if (materielTransportUnit == null) return "";
            if (materielTransportUnit == MaterielTransportUnit.L) {
                return "l";
            }
            if (materielTransportUnit == MaterielTransportUnit.M3) {
                return "m3";
            }
            if (materielTransportUnit != MaterielTransportUnit.T) throw new UnsupportedOperationException("unit\u00e9 non support\u00e9e : " + materielTransportUnit);
            return "T";
        }
    };
    public static final ValueParser<TypeDEPHY> TYPE_DEPHY_PARSER = new ValueParser<TypeDEPHY>(){

        public TypeDEPHY parse(String value) throws ParseException {
            Object result = null;
            if (!Strings.isNullOrEmpty((String)value)) {
                result = value.equalsIgnoreCase("DEPHY-FERME") ? TypeDEPHY.DEPHY_FERME : (value.equalsIgnoreCase("DEPHY-EXPE") ? TypeDEPHY.DEPHY_EXPE : (value.equalsIgnoreCase("Hors DEPHY") ? TypeDEPHY.NOT_DEPHY : null));
            }
            return result;
        }
    };

    protected AbstractAgrosystModel(char separator) {
        super(separator);
    }

    protected String getHeaderId(String header) {
        return header.toLowerCase();
    }

    public void pushCsvHeaderNames(List<String> headerNames) {
        this.headerMap = Maps.uniqueIndex(headerNames, (Function)new Function<String, String>(){

            public String apply(String input) {
                return AbstractAgrosystModel.this.getHeaderId(input);
            }
        });
    }

    protected String getRealHeader(String header) {
        String result = null;
        if (this.headerMap != null) {
            result = this.headerMap.get(this.getHeaderId(header));
        }
        if (result == null) {
            result = header;
        }
        return result;
    }

    protected boolean hasHeader(String header) {
        return this.headerMap.containsKey(this.getHeaderId(header));
    }

    public <T> ImportableColumn<E, T> newIgnoredColumn(String headerName) {
        return super.newIgnoredColumn(this.getRealHeader(headerName));
    }

    public ImportableColumn<E, String> newMandatoryColumn(String headerName) {
        return super.newMandatoryColumn(this.getRealHeader(headerName));
    }

    public ImportableColumn<E, String> newMandatoryColumn(String headerName, String propertyName) {
        return super.newMandatoryColumn(this.getRealHeader(headerName), propertyName);
    }

    public <T> ImportableColumn<E, T> newMandatoryColumn(String headerName, String propertyName, ValueParser<T> valueParser) {
        return super.newMandatoryColumn(this.getRealHeader(headerName), propertyName, valueParser);
    }
}

