/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.referential;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.MaterielType;
import fr.inra.agrosyst.api.entities.action.PhytoProductUnit;
import fr.inra.agrosyst.api.entities.referential.AbstractRefMaterielTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefActaDosageSPC;
import fr.inra.agrosyst.api.entities.referential.RefActaGroupeCultures;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduit;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduitsCategTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefBioAgressor;
import fr.inra.agrosyst.api.entities.referential.RefClonePlantGrape;
import fr.inra.agrosyst.api.entities.referential.RefDepartmentShape;
import fr.inra.agrosyst.api.entities.referential.RefElementVoisinage;
import fr.inra.agrosyst.api.entities.referential.RefEspece;
import fr.inra.agrosyst.api.entities.referential.RefEspeceToVariete;
import fr.inra.agrosyst.api.entities.referential.RefFertiEngraisorg;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFA;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFATopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefFertiOrga;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLienCulturesEdiActa;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.entities.referential.RefMateriel;
import fr.inra.agrosyst.api.entities.referential.RefOrientationEDI;
import fr.inra.agrosyst.api.entities.referential.RefParcelleZonageEDI;
import fr.inra.agrosyst.api.entities.referential.RefSolArvalis;
import fr.inra.agrosyst.api.entities.referential.RefSolCaracteristiqueIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolProfondeurIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolTextureGeppa;
import fr.inra.agrosyst.api.entities.referential.RefStationMeteo;
import fr.inra.agrosyst.api.entities.referential.RefTraitSdC;
import fr.inra.agrosyst.api.entities.referential.RefUniteEDI;
import fr.inra.agrosyst.api.entities.referential.RefVariete;
import fr.inra.agrosyst.api.entities.referential.RefVarieteGeves;
import fr.inra.agrosyst.api.entities.referential.RefVarietePlantGrape;
import fr.inra.agrosyst.api.services.itk.Itk;
import fr.inra.agrosyst.api.services.practiced.RefStadeEdiDto;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.referential.MineralProductType;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.api.services.referential.TypeMaterielFilter;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.CacheService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;

public class ReferentialServiceImpl
extends AbstractAgrosystService
implements ReferentialService {
    private static final Log log = LogFactory.getLog(ReferentialServiceImpl.class);
    protected RefFertiMinUNIFATopiaDao refFertiMinUNIFATopiaDao;
    protected final String DEFAULT_SOURCE = "AGROSYST_USER";
    protected static final Predicate<RefEspeceToVariete> IS_GEVES = new Predicate<RefEspeceToVariete>(){

        public boolean apply(RefEspeceToVariete input) {
            return "geves".equalsIgnoreCase(input.getReferentiel_source());
        }
    };
    protected static final Function<RefEspeceToVariete, Integer> TO_VARIETE_GEVES_SPECIES_ID = new Function<RefEspeceToVariete, Integer>(){

        public Integer apply(RefEspeceToVariete input) {
            Integer result = Integer.valueOf(input.getCode_espece_autre_referentiel());
            return result;
        }
    };
    protected static final Function<RefEspeceToVariete, String> TO_VARIETE_PLANT_GRAPE_SPECIES_ID = new Function<RefEspeceToVariete, String>(){

        public String apply(RefEspeceToVariete input) {
            String result = input.getCode_espece_autre_referentiel();
            return result;
        }
    };
    protected static final Function<RefActaGroupeCultures, Integer> GET_GROUPE_ID_CULTURE = new Function<RefActaGroupeCultures, Integer>(){

        public Integer apply(RefActaGroupeCultures input) {
            return input.getId_groupe_culture();
        }
    };
    protected static final Comparator<RefStadeEdiDto> STADE_EDI_DTO_COMPARATOR = new Comparator<RefStadeEdiDto>(){

        @Override
        public int compare(RefStadeEdiDto o1, RefStadeEdiDto o2) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
    };
    protected static final Function<CroppingPlanSpecies, String> GET_REF_ESPECE_VARIETY_KEY = new Function<CroppingPlanSpecies, String>(){

        public String apply(CroppingPlanSpecies input) {
            String id = input.getSpecies().getTopiaId();
            if (input.getVariety() != null) {
                id = id + "_" + input.getVariety().getTopiaId();
            }
            return id;
        }
    };
    protected CacheService cacheService;

    public void setRefFertiMinUNIFATopiaDao(RefFertiMinUNIFATopiaDao refFertiMinUNIFATopiaDao) {
        this.refFertiMinUNIFATopiaDao = refFertiMinUNIFATopiaDao;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public Map<MaterielType, List<String>> getTypeMateriel1List() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        result.put(MaterielType.TRACTEUR, this.getPersistenceContext().getRefMaterielTractionDao().findTypeMateriel1Values());
        result.put(MaterielType.AUTOMOTEUR, this.getPersistenceContext().getRefMaterielAutomoteurDao().findTypeMateriel1Values());
        result.put(MaterielType.OUTIL, this.getPersistenceContext().getRefMaterielOutilDao().findTypeMateriel1Values());
        result.put(MaterielType.IRRIGATION, this.getPersistenceContext().getRefMaterielIrrigationDao().findTypeMateriel1Values());
        return result;
    }

    protected AbstractRefMaterielTopiaDao getRefMaterielDao(MaterielType type) {
        AbstractRefMaterielTopiaDao dao;
        switch (type) {
            case TRACTEUR: {
                dao = this.getPersistenceContext().getRefMaterielTractionDao();
                break;
            }
            case AUTOMOTEUR: {
                dao = this.getPersistenceContext().getRefMaterielAutomoteurDao();
                break;
            }
            case OUTIL: {
                dao = this.getPersistenceContext().getRefMaterielOutilDao();
                break;
            }
            case IRRIGATION: {
                dao = this.getPersistenceContext().getRefMaterielIrrigationDao();
                break;
            }
            default: {
                dao = this.getPersistenceContext().getRefMaterielDao();
            }
        }
        return dao;
    }

    public List<String> getTypeMateriel2List(TypeMaterielFilter filter) {
        MaterielType type = filter.getType();
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type de mat\u00e9riel inconnu");
        AbstractRefMaterielTopiaDao dao = this.getRefMaterielDao(type);
        List<String> result = dao.findPropertyValues("typeMateriel2", filter.getTypeMateriel1(), null, null);
        return result;
    }

    public List<String> getTypeMateriel3List(TypeMaterielFilter filter) {
        MaterielType type = filter.getType();
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type de mat\u00e9riel inconnu");
        AbstractRefMaterielTopiaDao dao = this.getRefMaterielDao(type);
        List<String> result = dao.findPropertyValues("typeMateriel3", filter.getTypeMateriel1(), filter.getTypeMateriel2(), null);
        return result;
    }

    public List<String> getTypeMateriel4List(TypeMaterielFilter filter) {
        MaterielType type = filter.getType();
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type de mat\u00e9riel inconnu");
        AbstractRefMaterielTopiaDao dao = this.getRefMaterielDao(type);
        List<String> result = dao.findPropertyValues("typeMateriel4", filter.getTypeMateriel1(), filter.getTypeMateriel2(), filter.getTypeMateriel3());
        return result;
    }

    public Map<String, String[]> getMaterielUniteMap(TypeMaterielFilter filter) {
        MaterielType type = filter.getType();
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type de mat\u00e9riel inconnu");
        AbstractRefMaterielTopiaDao dao = this.getRefMaterielDao(type);
        Map<String, String[]> result = dao.findPropertyValuesAsMap("uniteParAn", "unite", filter.getTypeMateriel1(), filter.getTypeMateriel2(), filter.getTypeMateriel3(), filter.getTypeMateriel4());
        return result;
    }

    public RefMateriel findMateriel(String materielTopiaId) {
        RefMateriel result = (RefMateriel)this.getPersistenceContext().getRefMaterielDao().forTopiaIdEquals(materielTopiaId).findUnique();
        return result;
    }

    public Map<Integer, String> getSolArvalisRegions() {
        Map<Integer, String> result = this.getPersistenceContext().getRefSolArvalisDao().getAllSolArvalisRegions();
        return result;
    }

    public List<RefSolArvalis> getSolArvalis(Integer regionCode) {
        List<Object> result = regionCode == null ? Lists.newArrayList() : this.getPersistenceContext().getRefSolArvalisDao().findAllForRegion(regionCode);
        return result;
    }

    public RefSolArvalis findSolArvalis(String solArvalisTopiaId) {
        RefSolArvalis result = (RefSolArvalis)this.getPersistenceContext().getRefSolArvalisDao().forTopiaIdEquals(solArvalisTopiaId).findUnique();
        return result;
    }

    public List<RefEspece> findSpecies(String filter) {
        List<RefEspece> result = this.getPersistenceContext().getRefEspeceDao().findActiveEspeces(filter, 20);
        return result;
    }

    public List<RefVariete> findVarietes(String speciesId, String filter) {
        RefEspece species = (RefEspece)this.getPersistenceContext().getRefEspeceDao().forTopiaIdEquals(speciesId).findUnique();
        List varietes = this.getPersistenceContext().getRefEspeceToVarieteDao().forCode_espece_ediEquals(species.getCode_espece_botanique()).findAll();
        ArrayList result = Lists.newArrayList();
        int maxResults = 20;
        Iterable gevesVarietes = Iterables.filter((Iterable)varietes, IS_GEVES);
        HashSet varietesGevesIds = Sets.newHashSet((Iterable)Iterables.transform((Iterable)gevesVarietes, TO_VARIETE_GEVES_SPECIES_ID));
        List<RefVarieteGeves> varietesGeves = this.getPersistenceContext().getRefVarieteGevesDao().findAllActiveVarietes(varietesGevesIds, filter, maxResults);
        result.addAll(varietesGeves);
        Iterable plantGrapeVarietes = Iterables.filter((Iterable)varietes, (Predicate)Predicates.not(IS_GEVES));
        HashSet varietesPlantGrapeIds = Sets.newHashSet((Iterable)Iterables.transform((Iterable)plantGrapeVarietes, TO_VARIETE_PLANT_GRAPE_SPECIES_ID));
        List<RefVarietePlantGrape> varietesPlantGrappe = this.getPersistenceContext().getRefVarietePlantGrapeDao().findAllVarietes(varietesPlantGrapeIds, filter, maxResults - result.size() - 1);
        result.addAll(varietesPlantGrappe);
        return result;
    }

    public boolean validVarietesFromSpeciesId(RefVariete variete, String speciesId) {
        RefEspece species = (RefEspece)this.getPersistenceContext().getRefEspeceDao().forTopiaIdEquals(speciesId).findUnique();
        boolean result = this.validVarietesFromCodeEspeceEdi(variete, species.getCode_espece_botanique());
        return result;
    }

    public boolean validVarietesFromCodeEspeceEdi(RefVariete variete, String code_espece_botanique) {
        Preconditions.checkArgument((variete != null ? 1 : 0) != 0, (Object)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{code_espece_botanique}));
        List varietes = this.getPersistenceContext().getRefEspeceToVarieteDao().forCode_espece_ediEquals(code_espece_botanique).findAll();
        ArrayList speciesVariety = Lists.newArrayList();
        Iterable gevesVarietes = Iterables.filter((Iterable)varietes, IS_GEVES);
        HashSet varietesGevesIds = Sets.newHashSet((Iterable)Iterables.transform((Iterable)gevesVarietes, TO_VARIETE_GEVES_SPECIES_ID));
        List<RefVarieteGeves> varietesGeves = this.getPersistenceContext().getRefVarieteGevesDao().findAllActiveVarietes(varietesGevesIds, null, Integer.MAX_VALUE);
        speciesVariety.addAll(varietesGeves);
        Iterable plantGrapeVarietes = Iterables.filter((Iterable)varietes, (Predicate)Predicates.not(IS_GEVES));
        HashSet varietesPlantGrapeIds = Sets.newHashSet((Iterable)Iterables.transform((Iterable)plantGrapeVarietes, TO_VARIETE_PLANT_GRAPE_SPECIES_ID));
        List<RefVarietePlantGrape> varietesPlantGrappe = this.getPersistenceContext().getRefVarietePlantGrapeDao().findAllVarietes(varietesPlantGrapeIds, null, Integer.MAX_VALUE);
        speciesVariety.addAll(varietesPlantGrappe);
        boolean result = speciesVariety.contains(variete);
        return result;
    }

    public RefEspece getSpecies(String speciesId) {
        RefEspece result = (RefEspece)this.getPersistenceContext().getRefEspeceDao().forTopiaIdEquals(speciesId).findUnique();
        return result;
    }

    public RefVariete getVariete(String varieteId) {
        RefVariete result = (RefVariete)this.getPersistenceContext().getRefVarieteDao().forTopiaIdEquals(varieteId).findUnique();
        return result;
    }

    public RefClonePlantGrape getClonePlantGrape(String clonePlantGrapeId) {
        RefClonePlantGrape result = (RefClonePlantGrape)this.getPersistenceContext().getRefClonePlantGrapeDao().forTopiaIdEquals(clonePlantGrapeId).findUnique();
        return result;
    }

    public List<RefVariete> findGraftSupports(String filter) {
        ArrayList result = Lists.newArrayList();
        int maxResults = 20;
        int graftSupportCodeSection = this.getConfig().getSpeciesGraftSupportCodeSection();
        List<RefVarieteGeves> gevesVarietes = this.getPersistenceContext().getRefVarieteGevesDao().findActiveGraftSupport(filter, graftSupportCodeSection, maxResults);
        result.addAll(gevesVarietes);
        if (result.size() < maxResults) {
            String speciesGraftSupportUtilisation = this.getConfig().getSpeciesGraftSupportUtilisation();
            List<RefVarietePlantGrape> plantGrapeVarietes = this.getPersistenceContext().getRefVarietePlantGrapeDao().findGraftSupport(filter, speciesGraftSupportUtilisation, maxResults - result.size());
            result.addAll(plantGrapeVarietes);
        }
        return result;
    }

    public List<RefClonePlantGrape> findGraftClones(String speciesId, String varietyId, String filter) {
        Preconditions.checkArgument((speciesId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((varietyId != null ? 1 : 0) != 0);
        RefVarietePlantGrape variety = (RefVarietePlantGrape)this.getPersistenceContext().getRefVarietePlantGrapeDao().forTopiaIdEquals(varietyId).findUniqueOrNull();
        ArrayList result = Lists.newArrayList();
        if (variety != null) {
            List<RefClonePlantGrape> gevesVarietes = this.getPersistenceContext().getRefClonePlantGrapeDao().findGraftClones(filter, variety.getCodeVar(), 20);
            result.addAll(gevesVarietes);
        }
        return result;
    }

    public RefLocation getRefLocation(String refLocationArvalisId) {
        RefLocation result = (RefLocation)this.getPersistenceContext().getRefLocationDao().forTopiaIdEquals(refLocationArvalisId).findUnique();
        return result;
    }

    public List<RefLocation> findActiveCommunes(String filter) {
        List<RefLocation> result = this.getPersistenceContext().getRefLocationDao().findActiveLocations(filter, 20);
        return result;
    }

    public Map<Integer, String> findAllActiveOtex18Code() {
        Map<Integer, String> result = this.getPersistenceContext().getRefOTEXDao().findAllActiveOtex18Code();
        return result;
    }

    public Map<Integer, String> findAllActiveCodeOtex70ByOtex18code(Integer otex18code) {
        Map<Integer, String> result = this.getPersistenceContext().getRefOTEXDao().findAllActiveCodeOtex70ByOtex18code(otex18code);
        return result;
    }

    public List<RefOrientationEDI> findAllReferentielEDI() {
        List result = this.getPersistenceContext().getRefOrientationEDIDao().newQueryBuilder().setOrderByArguments(new String[]{"reference_label"}).findAll();
        return result;
    }

    public RefOrientationEDI findOrientation(String orientationTopiaId) {
        RefOrientationEDI result = (RefOrientationEDI)this.getPersistenceContext().getRefOrientationEDIDao().forTopiaIdEquals(orientationTopiaId).findUnique();
        return result;
    }

    public List<RefInterventionAgrosystTravailEDI> findAllActiveAgrosystActions() {
        List<RefInterventionAgrosystTravailEDI> result = this.findAllActiveAgrosystActions(null);
        return result;
    }

    public List<RefInterventionAgrosystTravailEDI> findAllActiveAgrosystActions(final AgrosystInterventionType interventionType) {
        Callable<LinkedList<RefInterventionAgrosystTravailEDI>> loader = new Callable<LinkedList<RefInterventionAgrosystTravailEDI>>(){

            @Override
            public LinkedList<RefInterventionAgrosystTravailEDI> call() throws Exception {
                RefInterventionAgrosystTravailEDITopiaDao refInterventionAgrosystTravailEDIDao = ReferentialServiceImpl.this.getPersistenceContext().getRefInterventionAgrosystTravailEDIDao();
                LinkedList<RefInterventionAgrosystTravailEDI> result = refInterventionAgrosystTravailEDIDao.findAllActive(interventionType);
                return result;
            }
        };
        List result = this.cacheService.get("activeAgrosystActions", interventionType, loader);
        return result;
    }

    public RefInterventionAgrosystTravailEDI getRefInterventionAgrosystTravailEDI(String topiaId) {
        RefInterventionAgrosystTravailEDI result = (RefInterventionAgrosystTravailEDI)this.getPersistenceContext().getRefInterventionAgrosystTravailEDIDao().forTopiaIdEquals(topiaId).findUnique();
        return result;
    }

    public List<RefParcelleZonageEDI> getAllActiveParcelleZonage() {
        List result = this.getPersistenceContext().getRefParcelleZonageEDIDao().forActiveEquals(true).findAll();
        return result;
    }

    public List<RefSolTextureGeppa> getAllActiveSolTextures() {
        List result = this.getPersistenceContext().getRefSolTextureGeppaDao().forActiveEquals(true).findAll();
        return result;
    }

    public List<RefSolProfondeurIndigo> getAllActiveSolProfondeurs() {
        List result = this.getPersistenceContext().getRefSolProfondeurIndigoDao().forActiveEquals(true).findAll();
        return result;
    }

    public List<RefSolCaracteristiqueIndigo> getAllActiveSolCaracteristiques() {
        List result = this.getPersistenceContext().getRefSolCaracteristiqueIndigoDao().forActiveEquals(true).findAll();
        return result;
    }

    public List<MineralProductType> findAllActiveMineralProductTypes() {
        List<MineralProductType> result = this.getPersistenceContext().getRefFertiMinUNIFADao().findAllActiveFertiMinProductType();
        return result;
    }

    public List<String> findAllActiveFertiMinShape(Integer categ) {
        List<String> result = this.getPersistenceContext().getRefFertiMinUNIFADao().findAllActiveFertiMinShape(categ);
        return result;
    }

    public List<RefFertiMinUNIFA> findAllActiveRefFertiMinUnifaByCategAndShape(Integer categ, String fertilizerShape, String productId) {
        List<RefFertiMinUNIFA> result = this.getPersistenceContext().getRefFertiMinUNIFADao().findAllActiveRefFertiMinUnifaByCategAndShape(categ, fertilizerShape, productId);
        return result;
    }

    public List<RefUniteEDI> findAllActiveRefUnitesEDI() {
        List result = this.getPersistenceContext().getRefUniteEDIDao().forActiveEquals(true).findAll();
        return result;
    }

    public List<RefFertiOrga> findAllActiveOrganicProductTypes() {
        List<RefFertiOrga> result = this.getPersistenceContext().getRefFertiOrgaDao().findAllActive();
        return result;
    }

    public List<RefFertiEngraisorg> findAllActiveRefFertiorgs() {
        List result = this.getPersistenceContext().getRefFertiEngraisorgDao().forActiveEquals(true).findAll();
        return result;
    }

    public List<RefStadeEdiDto> getRefStadesEdi(Integer vegetativeProfileRaw) {
        int vegetativeProfile = (Integer)MoreObjects.firstNonNull((Object)vegetativeProfileRaw, (Object)9999);
        List entities = this.getPersistenceContext().getRefStadeEDIDao().forProperties("profil_vegetatif", vegetativeProfile, new Object[]{"active", true}).findAll();
        ArrayList result = Lists.newArrayList((Iterable)Iterables.transform((Iterable)entities, (Function)Itk.STADE_EDI_TO_DTO));
        Collections.sort(result, STADE_EDI_DTO_COMPARATOR);
        return result;
    }

    public Map<String, String> getActaTreatementCodesAndNames() {
        Map<String, String> result = this.getPersistenceContext().getRefActaTraitementsProduitDao().findAllTreatementCodesAndNames();
        return result;
    }

    public Map<AgrosystInterventionType, List<String>> getAllActiveActaTreatmentProductTypes() {
        Callable<LinkedHashMap<AgrosystInterventionType, List<String>>> loader = new Callable<LinkedHashMap<AgrosystInterventionType, List<String>>>(){

            @Override
            public LinkedHashMap<AgrosystInterventionType, List<String>> call() throws Exception {
                RefActaTraitementsProduitsCategTopiaDao dao = ReferentialServiceImpl.this.getPersistenceContext().getRefActaTraitementsProduitsCategDao();
                LinkedHashMap<AgrosystInterventionType, List<String>> result = dao.findAllActiveActaTreatmentProductType();
                return result;
            }
        };
        Map result = this.cacheService.get("activeActaTreatmentProductTypes", loader);
        return result;
    }

    public List<RefElementVoisinage> getAllActiveElementVoisinages() {
        List result = this.getPersistenceContext().getRefElementVoisinageDao().forActiveEquals(true).setOrderByArguments(new String[]{"iae_nom"}).findAll();
        return result;
    }

    public List<RefBioAgressor> getTreatmentTargets(BioAgressorType category) {
        ArrayList result = Lists.newArrayList();
        if (BioAgressorType.ADVENTICE.equals((Object)category)) {
            Iterables.addAll((Collection)result, (Iterable)this.getPersistenceContext().getRefAdventiceDao().forProperties("active", true, new Object[0]).findAll());
        } else {
            Iterables.addAll((Collection)result, (Iterable)this.getPersistenceContext().getRefNuisibleEDIDao().forProperties("reference_param", category, new Object[]{"active", true}).findAll());
        }
        return result;
    }

    protected Integer getActaSpeciesId(String speciesId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)speciesId) ? 1 : 0) != 0);
        RefEspece espece = (RefEspece)this.getPersistenceContext().getRefEspeceDao().forTopiaIdEquals(speciesId).findAny();
        RefLienCulturesEdiActa acta = (RefLienCulturesEdiActa)this.getPersistenceContext().getRefLienCulturesEdiActaDao().forProperties("code_espece_botanique", espece.getCode_espece_botanique(), new Object[]{"code_qualifiant_aee", espece.getCode_qualifiant_AEE(), "code_type_saisonnier_aee", espece.getCode_type_saisonnier_AEE(), "code_destination_aee", espece.getCode_destination_AEE(), "active", true}).findAnyOrNull();
        Integer speciesActaId = acta == null ? null : Integer.valueOf(acta.getId_culture());
        return speciesActaId;
    }

    public RefActaDosageSPC computeActaReferenceDose(String phytoProductId, String speciesId) {
        RefActaDosageSPC result;
        block3: {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)phytoProductId) ? 1 : 0) != 0);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)speciesId) ? 1 : 0) != 0);
            result = null;
            try {
                Integer actaSpeciesId = this.getActaSpeciesId(speciesId);
                HashSet actaSpeciesIds = actaSpeciesId == null ? Sets.newHashSet() : Sets.newHashSet((Object[])new Integer[]{actaSpeciesId});
                List culturesList = this.getPersistenceContext().getRefActaGroupeCulturesDao().forProperties("active", true, new Object[]{"id_culture", actaSpeciesId}).findAll();
                Iterable ids = Iterables.transform((Iterable)culturesList, GET_GROUPE_ID_CULTURE);
                Iterables.addAll((Collection)actaSpeciesIds, (Iterable)ids);
                actaSpeciesIds.remove(this.getConfig().getActaDosageSpcCroppingZonesGroupId());
                result = this.getPersistenceContext().getRefActaDosageSPCDao().findMinimalValue(phytoProductId, actaSpeciesIds);
                if (result == null) {
                    result = (RefActaDosageSPC)this.getPersistenceContext().getRefActaDosageSPCDao().forProperties("active", true, new Object[]{"id_produit", phytoProductId, "id_culture", this.getConfig().getActaDosageSpcCroppingZonesGroupId()}).addNotNull("dosage_spc_valeur").findUniqueOrNull();
                }
            }
            catch (Exception eee) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)"Exception during reference dose computation", (Throwable)eee);
            }
        }
        return result;
    }

    public RefActaDosageSPC computeActaReferenceDose(String phytoId_Produit, Set<String> speciesIds) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)phytoId_Produit) ? 1 : 0) != 0);
        Preconditions.checkArgument((!speciesIds.isEmpty() && !Strings.isNullOrEmpty((String)speciesIds.iterator().next()) ? 1 : 0) != 0);
        RefActaDosageSPC result = null;
        for (String speciesId : speciesIds) {
            RefActaDosageSPC dose = this.computeActaReferenceDose(phytoId_Produit, speciesId);
            if (result != null && (dose == null || !(dose.getDosage_spc_valeur() < result.getDosage_spc_valeur()))) continue;
            result = dose;
        }
        return result;
    }

    protected RefActaDosageSPC computeActaReferenceDoseAndValidUnit(String phytoId_Produit, Set<String> speciesIds) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)phytoId_Produit) ? 1 : 0) != 0);
        Preconditions.checkArgument((!speciesIds.isEmpty() && !Strings.isNullOrEmpty((String)speciesIds.iterator().next()) ? 1 : 0) != 0);
        RefActaDosageSPC result = null;
        PhytoProductUnit commonUnit = null;
        for (String speciesId : speciesIds) {
            RefActaDosageSPC dose = this.computeActaReferenceDose(phytoId_Produit, speciesId);
            if (dose == null) continue;
            PhytoProductUnit unit = dose.getDosage_spc_unite();
            PhytoProductUnit phytoProductUnit = commonUnit = commonUnit == null ? unit : commonUnit;
            if (unit == commonUnit) {
                if (result != null && !(dose.getDosage_spc_valeur() < result.getDosage_spc_valeur())) continue;
                result = dose;
                continue;
            }
            result = null;
            break;
        }
        return result;
    }

    public List<RefTraitSdC> getAllActiveGrowingSystemCharacteristics() {
        List result = this.getPersistenceContext().getRefTraitSdCDao().forActiveEquals(true).setOrderByArguments(new String[]{"type_trait_sdc", "nom_trait"}).findAll();
        return result;
    }

    public List<RefActaTraitementsProduit> getActaTraitementsProduits(AgrosystInterventionType interventionType, String productType) {
        List<RefActaTraitementsProduit> result = this.getPersistenceContext().getRefActaTraitementsProduitDao().findAllActiveTreatmentTypesForProductType(interventionType, productType);
        return result;
    }

    public RefBioAgressor getBioAgressor(String bioAgressorId) {
        RefBioAgressor result = (RefBioAgressor)this.getPersistenceContext().getRefBioAgressorDao().forTopiaIdEquals(bioAgressorId).findUnique();
        return result;
    }

    public RefDepartmentShape getDepartmentShape(String departmentCode) {
        RefDepartmentShape result = (RefDepartmentShape)this.getPersistenceContext().getRefDepartmentShapeDao().forDepartmentEquals(departmentCode).findAnyOrNull();
        return result;
    }

    public Map<String, String> getAllRefStationMeteoMap() {
        List list = this.getPersistenceContext().getRefStationMeteoDao().newQueryBuilder().addEquals("active", (Object)true).setOrderByArguments(new String[]{"communeSite"}).findAll();
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (RefStationMeteo station : list) {
            result.put(station.getTopiaId(), station.getCommuneSite());
        }
        return result;
    }

    public RefFertiMinUNIFA getNewRefFertiMinUNIFA() {
        RefFertiMinUNIFA fertiMinUNIFA = (RefFertiMinUNIFA)this.refFertiMinUNIFATopiaDao.newInstance();
        return fertiMinUNIFA;
    }

    public boolean isValidRefFertiMinProduct(RefFertiMinUNIFA product) {
        Preconditions.checkState((product != null ? 1 : 0) != 0);
        double totalWeight = 0.0;
        totalWeight += product.getN() != null ? product.getN() : 0.0;
        totalWeight += product.getP2O5() != null ? product.getP2O5() : 0.0;
        totalWeight += product.getBore() != null ? product.getBore() : 0.0;
        totalWeight += product.getCalcium() != null ? product.getCalcium() : 0.0;
        totalWeight += product.getCuivre() != null ? product.getCuivre() : 0.0;
        totalWeight += product.getFer() != null ? product.getFer() : 0.0;
        totalWeight += product.getK2O() != null ? product.getK2O() : 0.0;
        totalWeight += product.getManganese() != null ? product.getManganese() : 0.0;
        totalWeight += product.getMgO() != null ? product.getMgO() : 0.0;
        totalWeight += product.getMolybdene() != null ? product.getMolybdene() : 0.0;
        totalWeight += product.getOxyde_de_sodium() != null ? product.getOxyde_de_sodium() : 0.0;
        totalWeight += product.getsO3() != null ? product.getsO3() : 0.0;
        boolean result = (totalWeight += product.getZinc() != null ? product.getZinc() : 0.0) <= 100.0;
        return result;
    }

    public RefFertiMinUNIFA createOrUpdateRefMineralProductToInput(RefFertiMinUNIFA product) {
        RefFertiMinUNIFA result;
        Preconditions.checkState((product != null ? 1 : 0) != 0, (Object)this.isValidRefFertiMinProduct(product));
        RefFertiMinUNIFA existingProduct = (RefFertiMinUNIFA)this.refFertiMinUNIFATopiaDao.forNaturalId(product.getCateg(), product.getForme(), product.getN(), product.getP2O5(), product.getK2O(), product.getBore(), product.getCalcium(), product.getFer(), product.getManganese(), product.getMolybdene(), product.getMgO(), product.getOxyde_de_sodium(), product.getsO3(), product.getCuivre(), product.getZinc()).findUniqueOrNull();
        if (existingProduct == null) {
            product.setTopiaId(null);
            String source = StringUtils.isNotBlank((CharSequence)product.getSource()) ? product.getSource() : "AGROSYST_USER";
            product.setSource(source);
            product.setActive(true);
            result = (RefFertiMinUNIFA)this.refFertiMinUNIFATopiaDao.create((TopiaEntity)product);
        } else if (!existingProduct.isActive()) {
            existingProduct.setActive(true);
            result = (RefFertiMinUNIFA)this.refFertiMinUNIFATopiaDao.update((TopiaEntity)existingProduct);
        } else {
            result = existingProduct;
        }
        return result;
    }

    public void importRefFertiMinUnifaPz0(Map<Class, ImportResults> allResults) {
        ImportResults results = allResults.remove(RefFertiMinUNIFA.class);
        if (results != null && results.getIgnoredRecords() == 0) {
            Collection products = results.getEntityAndDepsByCsvIds().values();
            int count = 1;
            int total = products.size();
            for (EntityAndDependencies product : products) {
                long start = System.currentTimeMillis();
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("D\u00e9but sauvegarde d'un produit fertilisant min\u00e9ral %d/%d.", count++, total));
                }
                RefFertiMinUNIFA entity = (RefFertiMinUNIFA)product.getEntity();
                this.createOrUpdateRefMineralProductToInput(entity);
                long p1 = System.currentTimeMillis();
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Fin de sauvegarde d'un produit fertilisant min\u00e9ral, traitement r\u00e9alis\u00e9 en:" + (p1 - start)));
            }
        }
    }

    public Map<String, String> getCroppingPlanSpeciesCodeByRefEspeceAndVarietyKey(Collection<CroppingPlanSpecies> allCroppingPlanSpecies) {
        HashMap speciesKeyToCode = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(allCroppingPlanSpecies)) {
            for (CroppingPlanSpecies croppingPlanSpecies : allCroppingPlanSpecies) {
                speciesKeyToCode.put(GET_REF_ESPECE_VARIETY_KEY.apply((Object)croppingPlanSpecies), croppingPlanSpecies.getCode());
            }
        }
        return speciesKeyToCode;
    }

    public Map<String, String> getRefEspeceAndVarietyKeyByCroppingPlanSpeciesCode(Collection<CroppingPlanSpecies> allCroppingPlanSpecies) {
        HashMap speciesKeyToCode = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(allCroppingPlanSpecies)) {
            for (CroppingPlanSpecies croppingPlanSpecies : allCroppingPlanSpecies) {
                speciesKeyToCode.put(croppingPlanSpecies.getCode(), GET_REF_ESPECE_VARIETY_KEY.apply((Object)croppingPlanSpecies));
            }
        }
        return speciesKeyToCode;
    }
}

