/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.referential;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.Price;
import fr.inra.agrosyst.api.entities.PriceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefActaDosageSPC;
import fr.inra.agrosyst.api.entities.referential.RefActaGroupeCultures;
import fr.inra.agrosyst.api.entities.referential.RefActaSubstanceActive;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduit;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduitsCateg;
import fr.inra.agrosyst.api.entities.referential.RefAdventice;
import fr.inra.agrosyst.api.entities.referential.RefClonePlantGrape;
import fr.inra.agrosyst.api.entities.referential.RefCouvSolAnnuelle;
import fr.inra.agrosyst.api.entities.referential.RefCouvSolPerenne;
import fr.inra.agrosyst.api.entities.referential.RefCultureEdiGroupeCouvSol;
import fr.inra.agrosyst.api.entities.referential.RefDepartmentShape;
import fr.inra.agrosyst.api.entities.referential.RefElementVoisinage;
import fr.inra.agrosyst.api.entities.referential.RefEspece;
import fr.inra.agrosyst.api.entities.referential.RefEspeceToVariete;
import fr.inra.agrosyst.api.entities.referential.RefFertiEngraisorg;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFA;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFATopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefFertiOrga;
import fr.inra.agrosyst.api.entities.referential.RefGesCarburant;
import fr.inra.agrosyst.api.entities.referential.RefGesEngrais;
import fr.inra.agrosyst.api.entities.referential.RefGesPhyto;
import fr.inra.agrosyst.api.entities.referential.RefGesSemence;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefLegalStatus;
import fr.inra.agrosyst.api.entities.referential.RefLienCulturesEdiActa;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.entities.referential.RefLocationTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefMaterielAutomoteur;
import fr.inra.agrosyst.api.entities.referential.RefMaterielIrrigation;
import fr.inra.agrosyst.api.entities.referential.RefMaterielOutil;
import fr.inra.agrosyst.api.entities.referential.RefMaterielTraction;
import fr.inra.agrosyst.api.entities.referential.RefMesure;
import fr.inra.agrosyst.api.entities.referential.RefNrjCarburant;
import fr.inra.agrosyst.api.entities.referential.RefNrjEngrais;
import fr.inra.agrosyst.api.entities.referential.RefNrjGesOutil;
import fr.inra.agrosyst.api.entities.referential.RefNrjPhyto;
import fr.inra.agrosyst.api.entities.referential.RefNrjSemence;
import fr.inra.agrosyst.api.entities.referential.RefNuisibleEDI;
import fr.inra.agrosyst.api.entities.referential.RefOTEX;
import fr.inra.agrosyst.api.entities.referential.RefOrientationEDI;
import fr.inra.agrosyst.api.entities.referential.RefParcelleZonageEDI;
import fr.inra.agrosyst.api.entities.referential.RefPhytoSubstanceActiveIphy;
import fr.inra.agrosyst.api.entities.referential.RefProtocoleVgObs;
import fr.inra.agrosyst.api.entities.referential.RefSaActaIphy;
import fr.inra.agrosyst.api.entities.referential.RefSolArvalis;
import fr.inra.agrosyst.api.entities.referential.RefSolArvalisTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSolCaracteristiqueIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolProfondeurIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolTextureGeppa;
import fr.inra.agrosyst.api.entities.referential.RefStadeEDI;
import fr.inra.agrosyst.api.entities.referential.RefStadeNuisibleEDI;
import fr.inra.agrosyst.api.entities.referential.RefStationMeteo;
import fr.inra.agrosyst.api.entities.referential.RefSupportOrganeEDI;
import fr.inra.agrosyst.api.entities.referential.RefTraitSdC;
import fr.inra.agrosyst.api.entities.referential.RefTypeAgriculture;
import fr.inra.agrosyst.api.entities.referential.RefTypeNotationEDI;
import fr.inra.agrosyst.api.entities.referential.RefTypeTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefUniteEDI;
import fr.inra.agrosyst.api.entities.referential.RefUnitesQualifiantEDI;
import fr.inra.agrosyst.api.entities.referential.RefValeurQualitativeEDI;
import fr.inra.agrosyst.api.entities.referential.RefVarieteGeves;
import fr.inra.agrosyst.api.entities.referential.RefVarietePlantGrape;
import fr.inra.agrosyst.api.entities.referential.RefZoneClimatiqueIphy;
import fr.inra.agrosyst.api.entities.referential.ReferentialEntity;
import fr.inra.agrosyst.api.entities.referential.Referentials;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoCaseGroundWater;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoFuzzySetGroundWater;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoRulesGroundWater;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesuRunoffPotRulesParc;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.referential.ImportResult;
import fr.inra.agrosyst.api.services.referential.ImportService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.CacheService;
import fr.inra.agrosyst.services.referential.csv.CommuneInseeModel;
import fr.inra.agrosyst.services.referential.csv.CommunePostCodeModel;
import fr.inra.agrosyst.services.referential.csv.CommuneRegionAgricoleModel;
import fr.inra.agrosyst.services.referential.csv.CommunesPostCodeOsmModel;
import fr.inra.agrosyst.services.referential.csv.RefActaDosageSPCModel;
import fr.inra.agrosyst.services.referential.csv.RefActaGroupeCulturesModel;
import fr.inra.agrosyst.services.referential.csv.RefActaSubstanceActiveModel;
import fr.inra.agrosyst.services.referential.csv.RefActaTraitementsProduitModel;
import fr.inra.agrosyst.services.referential.csv.RefActaTraitementsProduitsCategModel;
import fr.inra.agrosyst.services.referential.csv.RefAdventiceModel;
import fr.inra.agrosyst.services.referential.csv.RefClonePlantGrapeModel;
import fr.inra.agrosyst.services.referential.csv.RefCouvSolAnnuelleModel;
import fr.inra.agrosyst.services.referential.csv.RefCouvSolPerenneModel;
import fr.inra.agrosyst.services.referential.csv.RefCultureEdiGroupeCouvSolModel;
import fr.inra.agrosyst.services.referential.csv.RefDepartmentShapeModel;
import fr.inra.agrosyst.services.referential.csv.RefElementVoisinageModel;
import fr.inra.agrosyst.services.referential.csv.RefEspeceModel;
import fr.inra.agrosyst.services.referential.csv.RefEspeceToVarieteModel;
import fr.inra.agrosyst.services.referential.csv.RefFertiEngraisOrgModel;
import fr.inra.agrosyst.services.referential.csv.RefFertiMinUNIFAModel;
import fr.inra.agrosyst.services.referential.csv.RefFertiOrgaModel;
import fr.inra.agrosyst.services.referential.csv.RefGesCarburantModel;
import fr.inra.agrosyst.services.referential.csv.RefGesEngraisModel;
import fr.inra.agrosyst.services.referential.csv.RefGesPhytoModel;
import fr.inra.agrosyst.services.referential.csv.RefGesSemenceModel;
import fr.inra.agrosyst.services.referential.csv.RefInterventionAgrosystTravailEDIModel;
import fr.inra.agrosyst.services.referential.csv.RefLegalStatusModel;
import fr.inra.agrosyst.services.referential.csv.RefLienCulturesEdiActaModel;
import fr.inra.agrosyst.services.referential.csv.RefLocationDto;
import fr.inra.agrosyst.services.referential.csv.RefMaterielAutomoteurModel;
import fr.inra.agrosyst.services.referential.csv.RefMaterielIrrigationModel;
import fr.inra.agrosyst.services.referential.csv.RefMaterielOutilModel;
import fr.inra.agrosyst.services.referential.csv.RefMaterielTracteurModel;
import fr.inra.agrosyst.services.referential.csv.RefMesureModel;
import fr.inra.agrosyst.services.referential.csv.RefNrjCarburantModel;
import fr.inra.agrosyst.services.referential.csv.RefNrjEngraisModel;
import fr.inra.agrosyst.services.referential.csv.RefNrjGesOutilModel;
import fr.inra.agrosyst.services.referential.csv.RefNrjPhytoModel;
import fr.inra.agrosyst.services.referential.csv.RefNrjSemenceModel;
import fr.inra.agrosyst.services.referential.csv.RefNuisibleEDIModel;
import fr.inra.agrosyst.services.referential.csv.RefOTEXModel;
import fr.inra.agrosyst.services.referential.csv.RefOrientationEdiModel;
import fr.inra.agrosyst.services.referential.csv.RefParcelleZonageEdiModel;
import fr.inra.agrosyst.services.referential.csv.RefPhytoSubstanceActiveIphyModel;
import fr.inra.agrosyst.services.referential.csv.RefProtocoleVgObsModel;
import fr.inra.agrosyst.services.referential.csv.RefSaActaIphyModel;
import fr.inra.agrosyst.services.referential.csv.RefSolArvalisModel;
import fr.inra.agrosyst.services.referential.csv.RefSolCaracteristiqueIndigoModel;
import fr.inra.agrosyst.services.referential.csv.RefSolProfondeurIndigoModel;
import fr.inra.agrosyst.services.referential.csv.RefSolTextureGeppaModel;
import fr.inra.agrosyst.services.referential.csv.RefStadeEDIModel;
import fr.inra.agrosyst.services.referential.csv.RefStadeNuisibleEDIModel;
import fr.inra.agrosyst.services.referential.csv.RefStationMeteoModel;
import fr.inra.agrosyst.services.referential.csv.RefSupportOrganeEDIModel;
import fr.inra.agrosyst.services.referential.csv.RefTraitSdCModel;
import fr.inra.agrosyst.services.referential.csv.RefTypeAgricultureModel;
import fr.inra.agrosyst.services.referential.csv.RefTypeNotationEDIModel;
import fr.inra.agrosyst.services.referential.csv.RefTypeTravailEDIModel;
import fr.inra.agrosyst.services.referential.csv.RefUniteEDIModel;
import fr.inra.agrosyst.services.referential.csv.RefUnitesQualifiantEDIModel;
import fr.inra.agrosyst.services.referential.csv.RefValeurQualitativeEDIModel;
import fr.inra.agrosyst.services.referential.csv.RefVarieteGevesModel;
import fr.inra.agrosyst.services.referential.csv.RefVarietePlantGrapeModel;
import fr.inra.agrosyst.services.referential.csv.RefZoneClimatiqueIphyModel;
import fr.inra.agrosyst.services.referential.csv.RegionDto;
import fr.inra.agrosyst.services.referential.csv.SolsArvalisRegionsModel;
import fr.inra.agrosyst.services.referential.csv.iphy.RefRcesoCaseGroundWaterModel;
import fr.inra.agrosyst.services.referential.csv.iphy.RefRcesoFuzzySetGroundWaterModel;
import fr.inra.agrosyst.services.referential.csv.iphy.RefRcesoRulesGroundWaterModel;
import fr.inra.agrosyst.services.referential.csv.iphy.RefRcesuRunoffPotRulesParcModel;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class ImportServiceImpl
extends AbstractAgrosystService
implements ImportService {
    private static final Log log = LogFactory.getLog(ImportServiceImpl.class);
    public static final Function<RefLocationDto, String> GET_REF_LOCATION_DTO_CODE_INSEE = new Function<RefLocationDto, String>(){

        public String apply(RefLocationDto input) {
            String rawCodeInsee = input.getCodeInsee();
            if (rawCodeInsee == null) {
                String codeDepartement = input.getDepartement();
                String codeCommune = input.getCodeCommune();
                codeCommune = codeDepartement.length() == 3 ? Strings.padStart((String)codeCommune, (int)2, (char)'0') : Strings.padStart((String)codeCommune, (int)3, (char)'0');
                rawCodeInsee = codeDepartement + codeCommune;
            }
            String result = Strings.padStart((String)rawCodeInsee, (int)5, (char)'0');
            return result;
        }
    };
    public static final Function<RefLocationDto, String> GET_REF_LOCATION_DTO_PRETTY_COMMUNE = new Function<RefLocationDto, String>(){

        public String apply(RefLocationDto input) {
            String result = input.getNomCommune();
            String article = input.getArticleCommune();
            if (StringUtils.isNotBlank((CharSequence)article)) {
                if ((article = article.trim()).startsWith("(")) {
                    article = article.substring(1);
                }
                if (article.endsWith(")")) {
                    article = article.substring(0, article.length() - 1);
                }
                if (!article.endsWith("'")) {
                    article = article + " ";
                }
                result = article + result;
            }
            return result;
        }
    };
    protected static final Function<RegionDto, String> GET_REGION_NAME = new Function<RegionDto, String>(){

        public String apply(RegionDto input) {
            return input.getName();
        }
    };
    protected RefLocationTopiaDao refLocationDao;
    protected RefSolArvalisTopiaDao refSolArvalisDao;
    protected RefFertiMinUNIFATopiaDao refFertiMinUNIFATopiaDao;
    protected PriceTopiaDao priceTopiaDao;
    protected CacheService cacheService;

    public void setRefLocationDao(RefLocationTopiaDao refLocationDao) {
        this.refLocationDao = refLocationDao;
    }

    public void setRefSolArvalisDao(RefSolArvalisTopiaDao refSolArvalisDao) {
        this.refSolArvalisDao = refSolArvalisDao;
    }

    public void setRefFertiMinUNIFATopiaDao(RefFertiMinUNIFATopiaDao refFertiMinUNIFATopiaDao) {
        this.refFertiMinUNIFATopiaDao = refFertiMinUNIFATopiaDao;
    }

    public void setPriceTopiaDao(PriceTopiaDao priceTopiaDao) {
        this.priceTopiaDao = priceTopiaDao;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends ReferentialEntity> ImportResult runSimpleImport(InputStream input, Class<T> entityClass, ImportModel<T> model, Function<T, String> getNaturalIdFunction) {
        String entityClassName;
        long start;
        ImportResult result;
        block13: {
            Import importer = null;
            result = new ImportResult();
            start = System.currentTimeMillis();
            entityClassName = entityClass.getSimpleName();
            try {
                TopiaDao dao = this.context.getDaoSupplier().getDao(entityClass);
                List all = dao.findAll();
                ImmutableMap map = Maps.uniqueIndex((Iterable)all, getNaturalIdFunction);
                HashSet alreadyDone = Sets.newHashSet();
                importer = Import.newImport(model, (InputStream)input);
                Binder binder = BinderFactory.newBinder(entityClass);
                int line = 0;
                for (ReferentialEntity entity : importer) {
                    entity.setActive(true);
                    String id = (String)getNaturalIdFunction.apply((Object)entity);
                    if (alreadyDone.contains(id)) {
                        if (log.isWarnEnabled()) {
                            String message = String.format("Duplicate entry found (type=%s, L%d): %s", entityClassName, line, id);
                            log.warn((Object)message);
                        }
                        result.incIgnored();
                    } else {
                        alreadyDone.add(id);
                        if (map.containsKey(id)) {
                            ReferentialEntity existing = (ReferentialEntity)map.get(id);
                            binder.copyExcluding((Object)entity, (Object)existing, new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
                            dao.update((TopiaEntity)existing);
                            result.incUpdated();
                        } else {
                            dao.create((TopiaEntity)entity);
                            result.incCreated();
                        }
                    }
                    ++line;
                }
                this.getTransaction().commit();
                IOUtils.closeQuietly((Closeable)importer);
            }
            catch (Exception eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Error during import: " + eee.getMessage()), (Throwable)eee);
                }
                result.addError(eee.getMessage());
                break block13;
            }
            finally {
                IOUtils.closeQuietly(importer);
                IOUtils.closeQuietly((InputStream)input);
            }
            IOUtils.closeQuietly((InputStream)input);
        }
        long end = System.currentTimeMillis();
        result.setDuration(end - start);
        if (log.isInfoEnabled()) {
            String message = String.format("Import finished (type=%s). Result: %s", entityClassName, result);
            log.info((Object)message);
        }
        this.cacheService.clear();
        return result;
    }

    public ImportResult importMaterielTracteursCSV(InputStream contentStream) {
        RefMaterielTracteurModel csvModel = new RefMaterielTracteurModel();
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefMaterielTraction.class, (ImportModel)csvModel, (Function)Referentials.GET_MATERIEL_TRACTION_NATURAL_ID);
        return result;
    }

    public ImportResult importMaterielAutomoteursCSV(InputStream contentStream) {
        RefMaterielAutomoteurModel csvModel = new RefMaterielAutomoteurModel();
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefMaterielAutomoteur.class, (ImportModel)csvModel, (Function)Referentials.GET_MATERIEL_AUTOMOTEUR_NATURAL_ID);
        return result;
    }

    public ImportResult importMaterielOutilsCSV(InputStream contentStream) {
        RefMaterielOutilModel csvModel = new RefMaterielOutilModel();
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefMaterielOutil.class, (ImportModel)csvModel, (Function)Referentials.GET_MATERIEL_OUTIL_NATURAL_ID);
        return result;
    }

    public ImportResult importMaterielIrrigationCSV(InputStream contentStream) {
        RefMaterielIrrigationModel csvModel = new RefMaterielIrrigationModel();
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefMaterielIrrigation.class, (ImportModel)csvModel, (Function)Referentials.GET_MATERIEL_IRRIGATION_NATURAL_ID);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportResult importCommuneInseeCSV(InputStream communesStream, InputStream postCodesStream, InputStream raStream) {
        CommuneInseeModel csvModel = new CommuneInseeModel();
        Import importer = null;
        ImportResult result = new ImportResult();
        long start = System.currentTimeMillis();
        try {
            ImmutableMap<String, RefLocationDto> postCodes = this.importCommunePostCodesCSV(postCodesStream);
            ImmutableMultimap<String, RefLocationDto> regionsAgricoles = this.importCommuneRegionAgricoleCSV(raStream);
            List all = this.refLocationDao.findAll();
            ImmutableMap map = Maps.uniqueIndex((Iterable)all, (Function)Referentials.GET_LOCATION_CODE_INSEE);
            importer = Import.newImport((ImportModel)csvModel, (Reader)new InputStreamReader(communesStream, this.getConfig().getFileEncoding()));
            for (RefLocationDto dto : importer) {
                String codeInsee = (String)GET_REF_LOCATION_DTO_CODE_INSEE.apply((Object)dto);
                dto.setCodeInsee(codeInsee);
                RefLocation location = map.containsKey(codeInsee) ? (RefLocation)map.get(codeInsee) : (RefLocation)this.refLocationDao.newInstance();
                location.setCodeInsee(codeInsee);
                location.setActive(true);
                String commune = (String)GET_REF_LOCATION_DTO_PRETTY_COMMUNE.apply((Object)dto);
                location.setCommune(commune);
                int region = dto.getRegion();
                String departement = dto.getDepartement();
                location.setRegion(region);
                location.setDepartement(departement);
                String codeInseeForPostCodes = codeInsee.replace("2A", "20").replace("2B", "20");
                if (postCodes.containsKey(codeInseeForPostCodes)) {
                    RefLocationDto codePostalDto = (RefLocationDto)postCodes.get(codeInseeForPostCodes);
                    location.setCodePostal(Strings.padStart((String)codePostalDto.getCodePostal(), (int)5, (char)'0'));
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)("Pas de code postal pour la commune: " + dto));
                }
                if (regionsAgricoles.containsKey((Object)codeInsee)) {
                    Collection raDtos = regionsAgricoles.get((Object)codeInsee);
                    if (raDtos.size() > 1 && log.isWarnEnabled()) {
                        log.warn((Object)("Plusieurs r\u00e9gions agricoles pour ce code INSEE. On prend la premi\u00e8re." + raDtos));
                    }
                    RefLocationDto raDto = (RefLocationDto)raDtos.iterator().next();
                    location.setPetiteRegionAgricoleCode(raDto.getCodePetiteRegionAgricole());
                    location.setPetiteRegionAgricoleNom(raDto.getNomPetiteRegionAgricole());
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)("Pas de r\u00e9gion agricole pour la commune: " + dto));
                }
                if (location.isPersisted()) {
                    this.refLocationDao.update((TopiaEntity)location);
                    result.incUpdated();
                    continue;
                }
                this.refLocationDao.create((TopiaEntity)location);
                result.incCreated();
            }
            this.getTransaction().commit();
            IOUtils.closeQuietly((Closeable)importer);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Error during import: " + eee.getMessage()), (Throwable)eee);
            }
            result.addError(eee.getMessage());
        }
        finally {
            IOUtils.closeQuietly(importer);
        }
        long end = System.currentTimeMillis();
        result.setDuration(end - start);
        if (log.isInfoEnabled()) {
            log.info((Object)("Import communes INSEE termin\u00e9: " + result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportResult importCommuneOsmCSV(InputStream communesAndPostCodesStream, InputStream raStream) {
        CommunesPostCodeOsmModel csvModel = new CommunesPostCodeOsmModel();
        Import importer = null;
        ImportResult result = new ImportResult();
        long start = System.currentTimeMillis();
        try {
            ImmutableMultimap<String, RefLocationDto> regionsAgricoles = this.importCommuneRegionAgricoleCSV(raStream);
            List all = this.refLocationDao.findAll();
            ImmutableMap map = Maps.uniqueIndex((Iterable)all, (Function)Referentials.GET_LOCATION_CODE_INSEE);
            importer = Import.newImport((ImportModel)csvModel, (Reader)new InputStreamReader(communesAndPostCodesStream, this.getConfig().getFileEncoding()));
            for (RefLocationDto dto : importer) {
                String codeInsee = (String)GET_REF_LOCATION_DTO_CODE_INSEE.apply((Object)dto);
                dto.setCodeInsee(codeInsee);
                RefLocation location = map.containsKey(codeInsee) ? (RefLocation)map.get(codeInsee) : (RefLocation)this.refLocationDao.newInstance();
                location.setCodeInsee(codeInsee);
                location.setActive(true);
                location.setLatitude(dto.getLatitude());
                location.setLongitude(dto.getLongitude());
                String commune = (String)GET_REF_LOCATION_DTO_PRETTY_COMMUNE.apply((Object)dto);
                location.setCommune(commune);
                int region = dto.getRegion();
                String departement = dto.getDepartement();
                String codePostal = dto.getCodePostal();
                location.setRegion(region);
                location.setDepartement(departement);
                codePostal = codePostal.split(";")[0];
                location.setCodePostal(Strings.padStart((String)codePostal, (int)5, (char)'0'));
                if (regionsAgricoles.containsKey((Object)codeInsee)) {
                    Collection raDtos = regionsAgricoles.get((Object)codeInsee);
                    if (raDtos.size() > 1 && log.isWarnEnabled()) {
                        log.warn((Object)("Plusieurs r\u00e9gions agricoles pour ce code INSEE. On prend la premi\u00e8re." + raDtos));
                    }
                    RefLocationDto raDto = (RefLocationDto)raDtos.iterator().next();
                    location.setPetiteRegionAgricoleCode(raDto.getCodePetiteRegionAgricole());
                    location.setPetiteRegionAgricoleNom(raDto.getNomPetiteRegionAgricole());
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)("Pas de r\u00e9gion agricole pour la commune: " + dto));
                }
                if (location.isPersisted()) {
                    this.refLocationDao.update((TopiaEntity)location);
                    result.incUpdated();
                    continue;
                }
                this.refLocationDao.create((TopiaEntity)location);
                result.incCreated();
            }
            this.getTransaction().commit();
            IOUtils.closeQuietly((Closeable)importer);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Error during import: " + eee.getMessage()), (Throwable)eee);
            }
            result.addError(eee.getMessage());
        }
        finally {
            IOUtils.closeQuietly(importer);
        }
        long end = System.currentTimeMillis();
        result.setDuration(end - start);
        if (log.isInfoEnabled()) {
            log.info((Object)("Import communes OSM termin\u00e9: " + result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImmutableMap<String, RefLocationDto> importCommunePostCodesCSV(InputStream postCodesStream) throws UnsupportedEncodingException {
        ImmutableMap immutableMap;
        CommunePostCodeModel csvModel = new CommunePostCodeModel();
        Import importer = null;
        try {
            ImmutableMap result;
            importer = Import.newImport((ImportModel)csvModel, (Reader)new InputStreamReader(postCodesStream, this.getConfig().getFileEncoding()));
            immutableMap = result = Maps.uniqueIndex((Iterable)importer, GET_REF_LOCATION_DTO_CODE_INSEE);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(importer);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)importer);
        return immutableMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImmutableMultimap<String, RefLocationDto> importCommuneRegionAgricoleCSV(InputStream raStream) throws UnsupportedEncodingException {
        ImmutableListMultimap immutableListMultimap;
        CommuneRegionAgricoleModel csvModel = new CommuneRegionAgricoleModel();
        Import importer = null;
        try {
            ImmutableListMultimap result;
            importer = Import.newImport((ImportModel)csvModel, (Reader)new InputStreamReader(raStream, this.getConfig().getFileEncoding()));
            immutableListMultimap = result = Multimaps.index((Iterable)importer, GET_REF_LOCATION_DTO_CODE_INSEE);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(importer);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)importer);
        return immutableListMultimap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportResult importSolArvalisCSV(InputStream solsStream, InputStream regionsStreamRaw) {
        ImportResult result = new ImportResult();
        Import importRegion = null;
        Import importerSol = null;
        InputStream regionsStream = null;
        long start = System.currentTimeMillis();
        try {
            regionsStream = regionsStreamRaw;
            if (regionsStream == null) {
                regionsStream = ImportServiceImpl.class.getResourceAsStream("/referentiels/sols_regions.csv");
            }
            SolsArvalisRegionsModel csvModelRegion = new SolsArvalisRegionsModel();
            importRegion = Import.newImport((ImportModel)csvModelRegion, (InputStream)regionsStream);
            ImmutableMap regionMaps = Maps.uniqueIndex((Iterable)importRegion, GET_REGION_NAME);
            List all = this.refSolArvalisDao.findAll();
            ImmutableMap map = Maps.uniqueIndex((Iterable)all, (Function)Referentials.GET_SOL_ARVALIS_NATURAL_ID);
            RefSolArvalisModel csvModelSol = new RefSolArvalisModel();
            importerSol = Import.newImport((ImportModel)csvModelSol, (Reader)new InputStreamReader(solsStream, this.getConfig().getFileEncoding()));
            Binder binder = BinderFactory.newBinder(RefSolArvalis.class);
            for (RefSolArvalis refSolsArvalis : importerSol) {
                refSolsArvalis.setActive(true);
                RegionDto region = (RegionDto)regionMaps.get(refSolsArvalis.getSol_region());
                if (region == null) {
                    throw new AgrosystTechnicalException("No such region " + refSolsArvalis.getSol_region() + " in sols region file");
                }
                refSolsArvalis.setSol_region_code(region.getCode());
                String id = (String)Referentials.GET_SOL_ARVALIS_NATURAL_ID.apply((Object)refSolsArvalis);
                if (map.containsKey(id)) {
                    RefSolArvalis existingSol = (RefSolArvalis)map.get(id);
                    binder.copyExcluding((Object)refSolsArvalis, (Object)existingSol, new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
                    this.refSolArvalisDao.update((TopiaEntity)existingSol);
                    result.incUpdated();
                    continue;
                }
                this.refSolArvalisDao.create((TopiaEntity)refSolsArvalis);
                result.incCreated();
            }
            this.getTransaction().commit();
        }
        catch (Exception eee) {
            try {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Error during import: " + eee.getMessage()), (Throwable)eee);
                }
                result.addError(eee.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)regionsStream);
                IOUtils.closeQuietly(importerSol);
                IOUtils.closeQuietly(importRegion);
                IOUtils.closeQuietly((InputStream)solsStream);
                IOUtils.closeQuietly((InputStream)regionsStreamRaw);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)regionsStream);
            IOUtils.closeQuietly(importerSol);
            IOUtils.closeQuietly((Closeable)importRegion);
            IOUtils.closeQuietly((InputStream)solsStream);
            IOUtils.closeQuietly((InputStream)regionsStreamRaw);
        }
        IOUtils.closeQuietly((InputStream)regionsStream);
        IOUtils.closeQuietly((Closeable)importerSol);
        IOUtils.closeQuietly((Closeable)importRegion);
        IOUtils.closeQuietly((InputStream)solsStream);
        IOUtils.closeQuietly((InputStream)regionsStreamRaw);
        long end = System.currentTimeMillis();
        result.setDuration(end - start);
        if (log.isInfoEnabled()) {
            log.info((Object)("Import Sols Arvalis: " + result));
        }
        return result;
    }

    public ImportResult importLegalStatusCSV(InputStream statusStream) {
        ImportResult result = this.runSimpleImport(statusStream, (Class)RefLegalStatus.class, (ImportModel)new RefLegalStatusModel(), (Function)Referentials.GET_LEGAL_STATUS_NATURAL_ID);
        return result;
    }

    public ImportResult importEspeces(InputStream stream) {
        ImportResult result = this.runSimpleImport(stream, (Class)RefEspece.class, (ImportModel)new RefEspeceModel(), (Function)Referentials.GET_ESPECE_NATURAL_ID);
        return result;
    }

    public ImportResult importVarietesGeves(InputStream stream) {
        ImportResult result = this.runSimpleImport(stream, (Class)RefVarieteGeves.class, (ImportModel)new RefVarieteGevesModel(), (Function)Referentials.GET_VARIETE_GEVES_NATURAL_ID);
        return result;
    }

    public ImportResult importVarietesPlantGrape(InputStream stream) {
        ImportResult result = this.runSimpleImport(stream, (Class)RefVarietePlantGrape.class, (ImportModel)new RefVarietePlantGrapeModel(), (Function)Referentials.GET_VARIETE_PLANT_GRAPE_NATURAL_ID);
        return result;
    }

    public ImportResult importClonesPlantGrape(InputStream stream) {
        ImportResult result = this.runSimpleImport(stream, (Class)RefClonePlantGrape.class, (ImportModel)new RefClonePlantGrapeModel(), (Function)Referentials.GET_CLONE_PLANT_GRAPE_NATURAL_ID);
        return result;
    }

    public ImportResult importEspecesToVarietes(InputStream stream) {
        ImportResult result = this.runSimpleImport(stream, (Class)RefEspeceToVariete.class, (ImportModel)new RefEspeceToVarieteModel(), (Function)Referentials.GET_ESPECE_TO_VARIETE_NATURAL_ID);
        return result;
    }

    public ImportResult importOtexCSV(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefOTEX.class, (ImportModel)new RefOTEXModel(), (Function)Referentials.GET_OTEX_NATURAL_ID);
        return result;
    }

    public ImportResult importOrientationEdiCSV(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefOrientationEDI.class, (ImportModel)new RefOrientationEdiModel(), (Function)Referentials.GET_ORIENTATION_EDI_NATURAL_ID);
        return result;
    }

    public ImportResult importInterventionAgrosystTravailEdiCSV(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefInterventionAgrosystTravailEDI.class, (ImportModel)new RefInterventionAgrosystTravailEDIModel(), (Function)Referentials.GET_INTERVENTION_AGROSYST_TRAVAIL_EDI_NATURAL_ID);
        return result;
    }

    public ImportResult importTypeTravailEdiCSV(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefTypeTravailEDI.class, (ImportModel)new RefTypeTravailEDIModel(), (Function)Referentials.GET_TYPE_TRAVAIL_EDI_NATURAL_ID);
        return result;
    }

    public ImportResult importStadesEdiCSV(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefStadeEDI.class, (ImportModel)new RefStadeEDIModel(), (Function)Referentials.GET_STADE_EDI_NATURAL_ID);
        return result;
    }

    public ImportResult importSolTextureGeppa(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefSolTextureGeppa.class, (ImportModel)new RefSolTextureGeppaModel(), (Function)Referentials.GET_SOL_TEXTURE_GEPPA_NATURAL_ID);
        return result;
    }

    public ImportResult importZonageParcelleEdi(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefParcelleZonageEDI.class, (ImportModel)new RefParcelleZonageEdiModel(), (Function)Referentials.GET_PARCELLE_ZONAGE_NATURAL_ID);
        return result;
    }

    public ImportResult importSolProfondeurIndigo(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefSolProfondeurIndigo.class, (ImportModel)new RefSolProfondeurIndigoModel(), (Function)Referentials.GET_SOL_PROFONDEUR_INDIGO_NATURAL_ID);
        return result;
    }

    public ImportResult importSolCarateristiquesIndigo(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefSolCaracteristiqueIndigo.class, (ImportModel)new RefSolCaracteristiqueIndigoModel(), (Function)Referentials.GET_SOL_CARACTERISTIQUES_INDIGO_NATURAL_ID);
        return result;
    }

    public ImportResult importUniteEDI(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefUniteEDI.class, (ImportModel)new RefUniteEDIModel(), (Function)Referentials.GET_UNITES_EDI_NATURAL_ID);
        return result;
    }

    protected Map<String, List<Price>> getRefFertiMinIndexedPrices() {
        HashMap<String, List<Price>> result = new HashMap<String, List<Price>>();
        List<Price> prices = this.priceTopiaDao.getPricesForObjectIdLike("categ%");
        for (Price price : prices) {
            List objectPrices = (List)result.get(price.getObjectId());
            if (objectPrices == null) {
                objectPrices = Lists.newArrayList();
                result.put(price.getObjectId(), objectPrices);
            }
            objectPrices.add(price);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportResult importFertiMinUNIFA(InputStream contentStream) {
        ImportResult result = new ImportResult();
        long start = System.currentTimeMillis();
        try {
            RefFertiMinUNIFAModel csvModelRefFertiMinUNIFAModel = new RefFertiMinUNIFAModel();
            Import importerRefFertiMinUNIFA = Import.newImport((ImportModel)csvModelRefFertiMinUNIFAModel, (Reader)new InputStreamReader(contentStream, this.getConfig().getFileEncoding()));
            List persistedFertiMinUnifas = this.refFertiMinUNIFATopiaDao.findAll();
            HashMap fertiMinUNIFAMapWithNull = Maps.newHashMap((Map)Maps.uniqueIndex((Iterable)persistedFertiMinUnifas, (Function)Referentials.GET_FERTI_MIN_UNIFA_NATURAL_ID_WITH_NULL));
            Binder binder = BinderFactory.newBinder(RefFertiMinUNIFA.class);
            ArrayList productToCreates = Lists.newArrayList();
            ArrayList productToUpdates = Lists.newArrayList();
            ArrayList pricesToUpdates = Lists.newArrayList();
            Map<String, List<Price>> objectPrices = this.getRefFertiMinIndexedPrices();
            for (RefFertiMinUNIFA importedData : importerRefFertiMinUNIFA) {
                RefFertiMinUNIFA validProduct = (RefFertiMinUNIFA)fertiMinUNIFAMapWithNull.get(Referentials.GET_FERTI_MIN_UNIFA_NATURAL_ID_WITH_NULL.apply((Object)importedData));
                if (validProduct != null) {
                    binder.copyExcluding((Object)importedData, (Object)validProduct, new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
                    validProduct.setActive(true);
                    productToUpdates.add(validProduct);
                    result.incUpdated();
                    List<Price> prices = objectPrices.get(validProduct.getTopiaId());
                    if (prices == null) continue;
                    for (Price price : prices) {
                        price.setObjectId(StringUtils.stripAccents((String)((String)Referentials.GET_FERTI_MIN_UNIFA_NATURAL_ID_WITH_NULL.apply((Object)importedData))));
                        pricesToUpdates.add(price);
                    }
                    continue;
                }
                productToCreates.add(importedData);
                result.incCreated();
                fertiMinUNIFAMapWithNull.put(Referentials.GET_FERTI_MIN_UNIFA_NATURAL_ID_WITH_NULL.apply((Object)importedData), importedData);
            }
            this.refFertiMinUNIFATopiaDao.updateAll(productToUpdates);
            this.refFertiMinUNIFATopiaDao.createAll(productToCreates);
            this.priceTopiaDao.updateAll(pricesToUpdates);
            this.getTransaction().commit();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Error during import: " + e.getMessage()), (Throwable)e);
            }
            result.addError(e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        long end = System.currentTimeMillis();
        result.setDuration(end - start);
        if (log.isInfoEnabled()) {
            log.info((Object)("Import FertiMinUnifa: " + result));
        }
        return result;
    }

    public ImportResult importAdventices(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefAdventice.class, (ImportModel)new RefAdventiceModel(), (Function)Referentials.GET_ADVENTICES_NATURAL_ID);
        return result;
    }

    public ImportResult importNuisiblesEDI(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefNuisibleEDI.class, (ImportModel)new RefNuisibleEDIModel(), (Function)Referentials.GET_NUISIBLES_EDI_NATURAL_ID);
        return result;
    }

    public ImportResult importFertiOrga(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefFertiOrga.class, (ImportModel)new RefFertiOrgaModel(), (Function)Referentials.GET_FERTI_ORGA_NATURAL_ID);
        return result;
    }

    public ImportResult importFertiEngraisOrg(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefFertiEngraisorg.class, (ImportModel)new RefFertiEngraisOrgModel(), (Function)Referentials.GET_FERTI_ENGRAISORG_NATURAL_ID);
        return result;
    }

    public ImportResult importStationMeteo(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefStationMeteo.class, (ImportModel)new RefStationMeteoModel(), (Function)Referentials.GET_STATION_METEO_NATURAL_ID);
        return result;
    }

    public ImportResult importTypeAgriculture(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefTypeAgriculture.class, (ImportModel)new RefTypeAgricultureModel(), (Function)Referentials.GET_TYPE_AGRICULTURE_NATURAL_ID);
        return result;
    }

    public ImportResult importGesCarburants(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefGesCarburant.class, (ImportModel)new RefGesCarburantModel(), (Function)Referentials.GET_GES_CARBURANTS_NATURAL_ID);
        return result;
    }

    public ImportResult importGesEngrais(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefGesEngrais.class, (ImportModel)new RefGesEngraisModel(), (Function)Referentials.GET_GES_ENGRAIS_NATURAL_ID);
        return result;
    }

    public ImportResult importGesPhyto(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefGesPhyto.class, (ImportModel)new RefGesPhytoModel(), (Function)Referentials.GET_GES_PHYTO_NATURAL_ID);
        return result;
    }

    public ImportResult importGesSemences(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefGesSemence.class, (ImportModel)new RefGesSemenceModel(), (Function)Referentials.GET_GES_SEMENCES_NATURAL_ID);
        return result;
    }

    public ImportResult importNrjCarburants(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefNrjCarburant.class, (ImportModel)new RefNrjCarburantModel(), (Function)Referentials.GET_NRJ_CARBURANTS_NATURAL_ID);
        return result;
    }

    public ImportResult importNrjEngrais(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefNrjEngrais.class, (ImportModel)new RefNrjEngraisModel(), (Function)Referentials.GET_NRJ_ENGRAIS_NATURAL_ID);
        return result;
    }

    public ImportResult importNrjPhyto(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefNrjPhyto.class, (ImportModel)new RefNrjPhytoModel(), (Function)Referentials.GET_NRJ_PHYTO_NATURAL_ID);
        return result;
    }

    public ImportResult importNrjSemences(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefNrjSemence.class, (ImportModel)new RefNrjSemenceModel(), (Function)Referentials.GET_NRJ_SEMENCES_NATURAL_ID);
        return result;
    }

    public ImportResult importNrjGesOutils(InputStream contentStream) {
        ImportResult result = this.runSimpleImport(contentStream, (Class)RefNrjGesOutil.class, (ImportModel)new RefNrjGesOutilModel(), (Function)Referentials.GET_NRJ_GES_OUTILS_NATURAL_ID);
        return result;
    }

    public ImportResult importMesure(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefMesure.class, (ImportModel)new RefMesureModel(), (Function)Referentials.GET_MESURE_NATURAL_ID);
    }

    public ImportResult importSupportOrganeEDI(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefSupportOrganeEDI.class, (ImportModel)new RefSupportOrganeEDIModel(), (Function)Referentials.GET_SUPPORT_ORGANE_EDI_NATURAL_ID);
    }

    public ImportResult importStadeNuisibleEDI(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefStadeNuisibleEDI.class, (ImportModel)new RefStadeNuisibleEDIModel(), (Function)Referentials.GET_STADE_NUISIBLE_EDI_NATURAL_ID);
    }

    public ImportResult importTypeNotationEDI(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefTypeNotationEDI.class, (ImportModel)new RefTypeNotationEDIModel(), (Function)Referentials.GET_TYPE_NOTATION_EDI_NATURAL_ID);
    }

    public ImportResult importValeurQualitativeEDI(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefValeurQualitativeEDI.class, (ImportModel)new RefValeurQualitativeEDIModel(), (Function)Referentials.GET_VALEUR_QUALITATIVE_EDI_NATURAL_ID);
    }

    public ImportResult importUnitesQualifiantEDI(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefUnitesQualifiantEDI.class, (ImportModel)new RefUnitesQualifiantEDIModel(), (Function)Referentials.GET_UNITES_QUALIFIANT_EDI_NATURAL_ID);
    }

    public ImportResult importActaTraitementsProduits(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefActaTraitementsProduit.class, (ImportModel)new RefActaTraitementsProduitModel(), (Function)Referentials.GET_ACTA_TRAITEMENTS_PRODUITS_NATURAL_ID);
    }

    public ImportResult importActaTraitementsProduitsCateg(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefActaTraitementsProduitsCateg.class, (ImportModel)new RefActaTraitementsProduitsCategModel(), (Function)Referentials.GET_ACTA_TRAITEMENTS_PRODUITS_CATEG_NATURAL_ID);
    }

    public ImportResult importActaSubstanceActive(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefActaSubstanceActive.class, (ImportModel)new RefActaSubstanceActiveModel(), (Function)Referentials.GET_ACTA_SUBSTANCE_ACTIVE_NATURAL_ID);
    }

    public ImportResult importProtocoleVgObs(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefProtocoleVgObs.class, (ImportModel)new RefProtocoleVgObsModel(), (Function)Referentials.GET_PROTOCOLE_VG_OBS_NATURAL_ID);
    }

    public ImportResult importElementVoisinage(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefElementVoisinage.class, (ImportModel)new RefElementVoisinageModel(), (Function)Referentials.GET_ELEMENT_VOISINAGE_NATURAL_ID);
    }

    public ImportResult importRcesoRulesGroundWater(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefRcesoRulesGroundWater.class, (ImportModel)new RefRcesoRulesGroundWaterModel(), (Function)Referentials.GET_RCESO_RULES_GROUND_WATER_NATURAL_ID);
    }

    public ImportResult importRcesoFuzzySetGroundWater(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefRcesoFuzzySetGroundWater.class, (ImportModel)new RefRcesoFuzzySetGroundWaterModel(), (Function)Referentials.GET_RCESO_FUZZYSET_GROUND_WATER_NATURAL_ID);
    }

    public ImportResult importRcesoCaseGroundWater(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefRcesoCaseGroundWater.class, (ImportModel)new RefRcesoCaseGroundWaterModel(), (Function)Referentials.GET_RCESO_CASE_GROUND_WATER_NATURAL_ID);
    }

    public ImportResult importRcesuRunoffPotRulesParc(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefRcesuRunoffPotRulesParc.class, (ImportModel)new RefRcesuRunoffPotRulesParcModel(), (Function)Referentials.GET_RCESU_RUNOFF_POT_RULES_PARC_NATURAL_ID);
    }

    public ImportResult importPhytoSubstanceActiveIphy(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefPhytoSubstanceActiveIphy.class, (ImportModel)new RefPhytoSubstanceActiveIphyModel(), (Function)Referentials.GET_PHYTO_SUBSTANCE_ACTIVE_IPHY_NATURAL_ID);
    }

    public ImportResult importActaDosageSpc(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefActaDosageSPC.class, (ImportModel)new RefActaDosageSPCModel(), (Function)Referentials.GET_ACTA_DOSAGE_SPC_NATURAL_ID);
    }

    public ImportResult importActaGroupeCultures(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefActaGroupeCultures.class, (ImportModel)new RefActaGroupeCulturesModel(), (Function)Referentials.GET_ACTA_GROUPE_CULTURES_NATURAL_ID);
    }

    public ImportResult importLienCulturesEdiActa(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefLienCulturesEdiActa.class, (ImportModel)new RefLienCulturesEdiActaModel(), (Function)Referentials.GET_LIEN_CULTURES_EDI_ACTA_NATURAL_ID);
    }

    public ImportResult importSaActaIphy(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefSaActaIphy.class, (ImportModel)new RefSaActaIphyModel(), (Function)Referentials.GET_SA_ACTA_IPHY_NATURAL_ID);
    }

    public ImportResult importTraitSdC(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefTraitSdC.class, (ImportModel)new RefTraitSdCModel(), (Function)Referentials.GET_TRAIT_SDC_NATURAL_ID);
    }

    public ImportResult importCouvSolAnnuelle(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefCouvSolAnnuelle.class, (ImportModel)new RefCouvSolAnnuelleModel(), (Function)Referentials.GET_COUV_SOL_ANNUELLE_NATURAL_ID);
    }

    public ImportResult importCultureEdiGroupeCouvSol(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefCultureEdiGroupeCouvSol.class, (ImportModel)new RefCultureEdiGroupeCouvSolModel(), (Function)Referentials.GET_CULTURE_EDI_GROUP_COUV_SOL_NATURAL_ID);
    }

    public ImportResult importCouvSolPerenne(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefCouvSolPerenne.class, (ImportModel)new RefCouvSolPerenneModel(), (Function)Referentials.GET_COUV_SOL_PERENNE_NATURAL_ID);
    }

    public ImportResult importDepartmentShapes(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefDepartmentShape.class, (ImportModel)new RefDepartmentShapeModel(), (Function)Referentials.GET_DEPARTMENT_SHAPE_NATURAL_ID);
    }

    public ImportResult importZoneClimatiqueIphy(InputStream stream) {
        return this.runSimpleImport(stream, (Class)RefZoneClimatiqueIphy.class, (ImportModel)new RefZoneClimatiqueIphyModel(), (Function)Referentials.GET_ZONE_CLIMATIQUE_NATURAL_ID);
    }
}

