/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.referential;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import fr.inra.agrosyst.api.entities.referential.RefActaDosageSPC;
import fr.inra.agrosyst.api.entities.referential.RefActaGroupeCultures;
import fr.inra.agrosyst.api.entities.referential.RefActaSubstanceActive;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduit;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduitsCateg;
import fr.inra.agrosyst.api.entities.referential.RefAdventice;
import fr.inra.agrosyst.api.entities.referential.RefClonePlantGrape;
import fr.inra.agrosyst.api.entities.referential.RefCouvSolAnnuelle;
import fr.inra.agrosyst.api.entities.referential.RefCouvSolPerenne;
import fr.inra.agrosyst.api.entities.referential.RefCultureEdiGroupeCouvSol;
import fr.inra.agrosyst.api.entities.referential.RefElementVoisinage;
import fr.inra.agrosyst.api.entities.referential.RefEspece;
import fr.inra.agrosyst.api.entities.referential.RefEspeceToVariete;
import fr.inra.agrosyst.api.entities.referential.RefFertiEngraisorg;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFA;
import fr.inra.agrosyst.api.entities.referential.RefFertiOrga;
import fr.inra.agrosyst.api.entities.referential.RefGesCarburant;
import fr.inra.agrosyst.api.entities.referential.RefGesEngrais;
import fr.inra.agrosyst.api.entities.referential.RefGesPhyto;
import fr.inra.agrosyst.api.entities.referential.RefGesSemence;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefLegalStatus;
import fr.inra.agrosyst.api.entities.referential.RefLienCulturesEdiActa;
import fr.inra.agrosyst.api.entities.referential.RefMaterielAutomoteur;
import fr.inra.agrosyst.api.entities.referential.RefMaterielIrrigation;
import fr.inra.agrosyst.api.entities.referential.RefMaterielOutil;
import fr.inra.agrosyst.api.entities.referential.RefMaterielTraction;
import fr.inra.agrosyst.api.entities.referential.RefMesure;
import fr.inra.agrosyst.api.entities.referential.RefNrjCarburant;
import fr.inra.agrosyst.api.entities.referential.RefNrjEngrais;
import fr.inra.agrosyst.api.entities.referential.RefNrjGesOutil;
import fr.inra.agrosyst.api.entities.referential.RefNrjPhyto;
import fr.inra.agrosyst.api.entities.referential.RefNrjSemence;
import fr.inra.agrosyst.api.entities.referential.RefNuisibleEDI;
import fr.inra.agrosyst.api.entities.referential.RefOTEX;
import fr.inra.agrosyst.api.entities.referential.RefOrientationEDI;
import fr.inra.agrosyst.api.entities.referential.RefParcelleZonageEDI;
import fr.inra.agrosyst.api.entities.referential.RefPhytoSubstanceActiveIphy;
import fr.inra.agrosyst.api.entities.referential.RefProtocoleVgObs;
import fr.inra.agrosyst.api.entities.referential.RefSaActaIphy;
import fr.inra.agrosyst.api.entities.referential.RefSolArvalis;
import fr.inra.agrosyst.api.entities.referential.RefSolCaracteristiqueIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolProfondeurIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolTextureGeppa;
import fr.inra.agrosyst.api.entities.referential.RefStadeEDI;
import fr.inra.agrosyst.api.entities.referential.RefStadeNuisibleEDI;
import fr.inra.agrosyst.api.entities.referential.RefStationMeteo;
import fr.inra.agrosyst.api.entities.referential.RefSupportOrganeEDI;
import fr.inra.agrosyst.api.entities.referential.RefTraitSdC;
import fr.inra.agrosyst.api.entities.referential.RefTypeAgriculture;
import fr.inra.agrosyst.api.entities.referential.RefTypeNotationEDI;
import fr.inra.agrosyst.api.entities.referential.RefTypeTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefUniteEDI;
import fr.inra.agrosyst.api.entities.referential.RefUnitesQualifiantEDI;
import fr.inra.agrosyst.api.entities.referential.RefValeurQualitativeEDI;
import fr.inra.agrosyst.api.entities.referential.RefVarieteGeves;
import fr.inra.agrosyst.api.entities.referential.RefVarietePlantGrape;
import fr.inra.agrosyst.api.entities.referential.RefZoneClimatiqueIphy;
import fr.inra.agrosyst.api.entities.referential.ReferentialEntity;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.referential.ExportService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.referential.csv.RefActaDosageSPCModel;
import fr.inra.agrosyst.services.referential.csv.RefActaGroupeCulturesModel;
import fr.inra.agrosyst.services.referential.csv.RefActaSubstanceActiveModel;
import fr.inra.agrosyst.services.referential.csv.RefActaTraitementsProduitModel;
import fr.inra.agrosyst.services.referential.csv.RefActaTraitementsProduitsCategModel;
import fr.inra.agrosyst.services.referential.csv.RefAdventiceModel;
import fr.inra.agrosyst.services.referential.csv.RefClonePlantGrapeModel;
import fr.inra.agrosyst.services.referential.csv.RefCouvSolAnnuelleModel;
import fr.inra.agrosyst.services.referential.csv.RefCouvSolPerenneModel;
import fr.inra.agrosyst.services.referential.csv.RefCultureEdiGroupeCouvSolModel;
import fr.inra.agrosyst.services.referential.csv.RefElementVoisinageModel;
import fr.inra.agrosyst.services.referential.csv.RefEspeceModel;
import fr.inra.agrosyst.services.referential.csv.RefEspeceToVarieteModel;
import fr.inra.agrosyst.services.referential.csv.RefFertiEngraisOrgModel;
import fr.inra.agrosyst.services.referential.csv.RefFertiMinUNIFAModel;
import fr.inra.agrosyst.services.referential.csv.RefFertiOrgaModel;
import fr.inra.agrosyst.services.referential.csv.RefGesCarburantModel;
import fr.inra.agrosyst.services.referential.csv.RefGesEngraisModel;
import fr.inra.agrosyst.services.referential.csv.RefGesPhytoModel;
import fr.inra.agrosyst.services.referential.csv.RefGesSemenceModel;
import fr.inra.agrosyst.services.referential.csv.RefInterventionAgrosystTravailEDIModel;
import fr.inra.agrosyst.services.referential.csv.RefLegalStatusModel;
import fr.inra.agrosyst.services.referential.csv.RefLienCulturesEdiActaModel;
import fr.inra.agrosyst.services.referential.csv.RefMaterielAutomoteurModel;
import fr.inra.agrosyst.services.referential.csv.RefMaterielIrrigationModel;
import fr.inra.agrosyst.services.referential.csv.RefMaterielOutilModel;
import fr.inra.agrosyst.services.referential.csv.RefMaterielTracteurModel;
import fr.inra.agrosyst.services.referential.csv.RefMesureModel;
import fr.inra.agrosyst.services.referential.csv.RefNrjCarburantModel;
import fr.inra.agrosyst.services.referential.csv.RefNrjEngraisModel;
import fr.inra.agrosyst.services.referential.csv.RefNrjGesOutilModel;
import fr.inra.agrosyst.services.referential.csv.RefNrjPhytoModel;
import fr.inra.agrosyst.services.referential.csv.RefNrjSemenceModel;
import fr.inra.agrosyst.services.referential.csv.RefNuisibleEDIModel;
import fr.inra.agrosyst.services.referential.csv.RefOTEXModel;
import fr.inra.agrosyst.services.referential.csv.RefOrientationEdiModel;
import fr.inra.agrosyst.services.referential.csv.RefParcelleZonageEdiModel;
import fr.inra.agrosyst.services.referential.csv.RefPhytoSubstanceActiveIphyModel;
import fr.inra.agrosyst.services.referential.csv.RefProtocoleVgObsModel;
import fr.inra.agrosyst.services.referential.csv.RefSaActaIphyModel;
import fr.inra.agrosyst.services.referential.csv.RefSolArvalisModel;
import fr.inra.agrosyst.services.referential.csv.RefSolCaracteristiqueIndigoModel;
import fr.inra.agrosyst.services.referential.csv.RefSolProfondeurIndigoModel;
import fr.inra.agrosyst.services.referential.csv.RefSolTextureGeppaModel;
import fr.inra.agrosyst.services.referential.csv.RefStadeEDIModel;
import fr.inra.agrosyst.services.referential.csv.RefStadeNuisibleEDIModel;
import fr.inra.agrosyst.services.referential.csv.RefStationMeteoModel;
import fr.inra.agrosyst.services.referential.csv.RefSupportOrganeEDIModel;
import fr.inra.agrosyst.services.referential.csv.RefTraitSdCModel;
import fr.inra.agrosyst.services.referential.csv.RefTypeAgricultureModel;
import fr.inra.agrosyst.services.referential.csv.RefTypeNotationEDIModel;
import fr.inra.agrosyst.services.referential.csv.RefTypeTravailEDIModel;
import fr.inra.agrosyst.services.referential.csv.RefUniteEDIModel;
import fr.inra.agrosyst.services.referential.csv.RefUnitesQualifiantEDIModel;
import fr.inra.agrosyst.services.referential.csv.RefValeurQualitativeEDIModel;
import fr.inra.agrosyst.services.referential.csv.RefVarieteGevesModel;
import fr.inra.agrosyst.services.referential.csv.RefVarietePlantGrapeModel;
import fr.inra.agrosyst.services.referential.csv.RefZoneClimatiqueIphyModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.topia.persistence.TopiaDao;

public class ExportServiceImpl
extends AbstractAgrosystService
implements ExportService {
    protected <E extends ReferentialEntity> InputStream runSimpleExport(Iterable<String> entityIds, Class<E> clazz, ExportModel<E> exportModel) {
        FileInputStream result;
        try {
            final TopiaDao classDao = this.context.getDaoSupplier().getDao(clazz);
            Iterable entities = entityIds != null ? Iterables.transform(entityIds, (Function)new Function<String, E>(){

                public E apply(String input) {
                    ReferentialEntity result = (ReferentialEntity)classDao.forTopiaIdEquals(input).findUnique();
                    return result;
                }
            }) : classDao.findAll();
            File tempFile = File.createTempFile("export-" + clazz.getSimpleName() + "-", ".csv");
            Export.exportToFile(exportModel, (Iterable)entities, (File)tempFile, (Charset)Charsets.UTF_8);
            result = new FileInputStream(tempFile);
        }
        catch (Exception ex) {
            throw new AgrosystTechnicalException("Can't export", (Throwable)ex);
        }
        return result;
    }

    public InputStream exportOrientationEdiCSV(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefOrientationEDI.class, new RefOrientationEdiModel());
        return result;
    }

    public InputStream exportSolArvalisCSV(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefSolArvalis.class, new RefSolArvalisModel());
        return result;
    }

    public InputStream exportMaterielTracteursCSV(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefMaterielTraction.class, new RefMaterielTracteurModel());
        return result;
    }

    public InputStream exportMaterielAutomoteursCSV(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefMaterielAutomoteur.class, new RefMaterielAutomoteurModel());
        return result;
    }

    public InputStream exportMaterielOutilsCSV(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefMaterielOutil.class, new RefMaterielOutilModel());
        return result;
    }

    public InputStream exportMaterielIrrigationCSV(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefMaterielIrrigation.class, new RefMaterielIrrigationModel());
        return result;
    }

    public InputStream exportLegalStatusCSV(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefLegalStatus.class, new RefLegalStatusModel());
        return result;
    }

    public InputStream exportEspeces(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefEspece.class, new RefEspeceModel());
        return result;
    }

    public InputStream exportVarietesGeves(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefVarieteGeves.class, new RefVarieteGevesModel());
        return result;
    }

    public InputStream exportVarietesPlantGrape(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefVarietePlantGrape.class, new RefVarietePlantGrapeModel());
        return result;
    }

    public InputStream exportClonesPlantGrape(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefClonePlantGrape.class, new RefClonePlantGrapeModel());
        return result;
    }

    public InputStream exportEspecesToVarietes(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefEspeceToVariete.class, new RefEspeceToVarieteModel());
        return result;
    }

    public InputStream exportOtexCSV(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefOTEX.class, new RefOTEXModel());
        return result;
    }

    public InputStream exportInterventionAgrosystTravailEdiCSV(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefInterventionAgrosystTravailEDI.class, new RefInterventionAgrosystTravailEDIModel());
        return result;
    }

    public InputStream exportTypeTravailEdiCSV(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefTypeTravailEDI.class, new RefTypeTravailEDIModel());
        return result;
    }

    public InputStream exportStadesEdiCSV(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefStadeEDI.class, new RefStadeEDIModel());
        return result;
    }

    public InputStream exportSolTextureGeppa(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefSolTextureGeppa.class, new RefSolTextureGeppaModel());
        return result;
    }

    public InputStream exportZonageParcelleEdi(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefParcelleZonageEDI.class, new RefParcelleZonageEdiModel());
        return result;
    }

    public InputStream exportSolProfondeurIndigo(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefSolProfondeurIndigo.class, new RefSolProfondeurIndigoModel());
        return result;
    }

    public InputStream exportSolCarateristiquesIndigo(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefSolCaracteristiqueIndigo.class, new RefSolCaracteristiqueIndigoModel());
        return result;
    }

    public InputStream exportUniteEDI(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefUniteEDI.class, new RefUniteEDIModel());
        return result;
    }

    public InputStream exportFertiMinUNIFA(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefFertiMinUNIFA.class, new RefFertiMinUNIFAModel());
        return result;
    }

    public InputStream exportAdventices(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefAdventice.class, new RefAdventiceModel());
        return result;
    }

    public InputStream exportNuisiblesEDI(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefNuisibleEDI.class, new RefNuisibleEDIModel());
        return result;
    }

    public InputStream exportFertiOrga(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefFertiOrga.class, new RefFertiOrgaModel());
        return result;
    }

    public InputStream exportFertiEngraisOrg(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefFertiEngraisorg.class, new RefFertiEngraisOrgModel());
        return result;
    }

    public InputStream exportStationMeteo(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefStationMeteo.class, new RefStationMeteoModel());
        return result;
    }

    public InputStream exportGesCarburants(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefGesCarburant.class, new RefGesCarburantModel());
        return result;
    }

    public InputStream exportGesEngrais(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefGesEngrais.class, new RefGesEngraisModel());
        return result;
    }

    public InputStream exportGesPhyto(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefGesPhyto.class, new RefGesPhytoModel());
        return result;
    }

    public InputStream exportGesSemences(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefGesSemence.class, new RefGesSemenceModel());
        return result;
    }

    public InputStream exportNrjCarburants(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefNrjCarburant.class, new RefNrjCarburantModel());
        return result;
    }

    public InputStream exportNrjEngrais(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefNrjEngrais.class, new RefNrjEngraisModel());
        return result;
    }

    public InputStream exportNrjPhyto(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefNrjPhyto.class, new RefNrjPhytoModel());
        return result;
    }

    public InputStream exportNrjSemences(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefNrjSemence.class, new RefNrjSemenceModel());
        return result;
    }

    public InputStream exportNrjGesOutils(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefNrjGesOutil.class, new RefNrjGesOutilModel());
        return result;
    }

    public InputStream exportMesure(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefMesure.class, new RefMesureModel());
        return result;
    }

    public InputStream exportSupportOrganeEDI(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefSupportOrganeEDI.class, new RefSupportOrganeEDIModel());
        return result;
    }

    public InputStream exportStadeNuisibleEDI(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefStadeNuisibleEDI.class, new RefStadeNuisibleEDIModel());
        return result;
    }

    public InputStream exportTypeNotationEDI(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefTypeNotationEDI.class, new RefTypeNotationEDIModel());
        return result;
    }

    public InputStream exportValeurQualitativeEDI(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefValeurQualitativeEDI.class, new RefValeurQualitativeEDIModel());
        return result;
    }

    public InputStream exportUnitesQualifiantEDI(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefUnitesQualifiantEDI.class, new RefUnitesQualifiantEDIModel());
        return result;
    }

    public InputStream exportActaTraitementsProducts(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefActaTraitementsProduit.class, new RefActaTraitementsProduitModel());
        return result;
    }

    public InputStream exportActaSubstanceActive(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefActaSubstanceActive.class, new RefActaSubstanceActiveModel());
        return result;
    }

    public InputStream exportProtocoleVgObs(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefProtocoleVgObs.class, new RefProtocoleVgObsModel());
        return result;
    }

    public InputStream exportElementVoisinage(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefElementVoisinage.class, new RefElementVoisinageModel());
        return result;
    }

    public InputStream exportPhytoSubstanceActiveIphy(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefPhytoSubstanceActiveIphy.class, new RefPhytoSubstanceActiveIphyModel());
        return result;
    }

    public InputStream exportTypeAgriculture(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefTypeAgriculture.class, new RefTypeAgricultureModel());
        return result;
    }

    public InputStream exportActaDosageSpc(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefActaDosageSPC.class, new RefActaDosageSPCModel());
        return result;
    }

    public InputStream exportActaGroupeCultures(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefActaGroupeCultures.class, new RefActaGroupeCulturesModel());
        return result;
    }

    public InputStream exportLienCulturesEdiActa(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefLienCulturesEdiActa.class, new RefLienCulturesEdiActaModel());
        return result;
    }

    public InputStream exportSaActaIphy(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefSaActaIphy.class, new RefSaActaIphyModel());
        return result;
    }

    public InputStream exportTraitSdC(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefTraitSdC.class, new RefTraitSdCModel());
        return result;
    }

    public InputStream exportCultureEdiGroupeCouvSol(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefCultureEdiGroupeCouvSol.class, new RefCultureEdiGroupeCouvSolModel());
        return result;
    }

    public InputStream exportCouvSolPerenne(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefCouvSolPerenne.class, new RefCouvSolPerenneModel());
        return result;
    }

    public InputStream exportCouvSolAnnuelle(Iterable<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefCouvSolAnnuelle.class, new RefCouvSolAnnuelleModel());
        return result;
    }

    public InputStream exportActaTraitementsProductsCateg(List<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefActaTraitementsProduitsCateg.class, new RefActaTraitementsProduitsCategModel());
        return result;
    }

    public InputStream exportZoneClimatiqueIphy(List<String> entityIds) {
        InputStream result = this.runSimpleExport(entityIds, RefZoneClimatiqueIphy.class, new RefZoneClimatiqueIphyModel());
        return result;
    }
}

