/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.practiced;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.CropCyclePhaseType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.CroppingPlanSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.GrowingSystemTopiaDao;
import fr.inra.agrosyst.api.entities.Price;
import fr.inra.agrosyst.api.entities.SolHorizon;
import fr.inra.agrosyst.api.entities.SolHorizonTopiaDao;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.ToolsCouplingTopiaDao;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.AbstractInput;
import fr.inra.agrosyst.api.entities.action.AbstractInputTopiaDao;
import fr.inra.agrosyst.api.entities.action.BiologicalControlActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.HarvestingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.IrrigationActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.MaintenancePruningVinesActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.MineralFertilizersSpreadingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.MineralProductInput;
import fr.inra.agrosyst.api.entities.action.OrganicFertilizersSpreadingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.OrganicProductInput;
import fr.inra.agrosyst.api.entities.action.OtherActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.OtherProductInput;
import fr.inra.agrosyst.api.entities.action.PesticidesSpreadingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.PhytoProductInput;
import fr.inra.agrosyst.api.entities.action.SeedingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.TillageActionTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleConnection;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleConnectionTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNode;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNodeTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhase;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhaseTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleSpecies;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedInterventionTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycleImpl;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlot;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlotTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedSeasonalCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSpeciesStade;
import fr.inra.agrosyst.api.entities.practiced.PracticedSpeciesStadeTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystemTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefClonePlantGrape;
import fr.inra.agrosyst.api.entities.referential.RefClonePlantGrapeTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefOrientationEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefStadeEDI;
import fr.inra.agrosyst.api.entities.referential.RefStadeEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefTypeTravailEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefVariete;
import fr.inra.agrosyst.api.entities.referential.RefVarieteTopiaDao;
import fr.inra.agrosyst.api.exceptions.AgrosystDuplicationException;
import fr.inra.agrosyst.api.exceptions.AgrosystImportException;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.action.ActionService;
import fr.inra.agrosyst.api.services.common.PricesService;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlanSpeciesDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlans;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.domain.Equipments;
import fr.inra.agrosyst.api.services.domain.ToolsCouplingDto;
import fr.inra.agrosyst.api.services.input.InputService;
import fr.inra.agrosyst.api.services.itk.SpeciesStadeDto;
import fr.inra.agrosyst.api.services.practiced.CropCycleGraftDto;
import fr.inra.agrosyst.api.services.practiced.CropCycleModelDto;
import fr.inra.agrosyst.api.services.practiced.DuplicateCropCyclesContext;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleConnectionDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleNodeDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCyclePhaseDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleSpeciesDto;
import fr.inra.agrosyst.api.services.practiced.PracticedInterventionDto;
import fr.inra.agrosyst.api.services.practiced.PracticedPerennialCropCycleDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSeasonalCropCycleDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemFilter;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.api.services.practiced.PracticedSystems;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.PracticedSystemAndDependencies;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.Pz0PracticedPerennialCropCycle;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.Pz0PracticedSeasonalCropCycle;
import fr.inra.agrosyst.api.services.security.AnonymizeService;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.CommonService;
import fr.inra.agrosyst.services.common.export.EntityExportExtra;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;
import fr.inra.agrosyst.services.common.export.EntityExporter;
import fr.inra.agrosyst.services.common.export.ExportUtils;
import fr.inra.agrosyst.services.practiced.export.PracticedSeasonalEntityExport;
import fr.inra.agrosyst.services.practiced.export.PracticedSystemEntity;
import fr.inra.agrosyst.services.practiced.export.PracticedSystemMetadata;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class PracticedSystemServiceImpl
extends AbstractAgrosystService
implements PracticedSystemService {
    protected BusinessAuthorizationService authorizationService;
    protected DomainService domainService;
    protected PricesService pricesService;
    protected ActionService actionService;
    protected InputService inputService;
    protected AnonymizeService anonymizeService;
    protected PracticedSystemTopiaDao practicedSystemDao;
    protected GrowingSystemTopiaDao growingSystemDao;
    protected PracticedInterventionTopiaDao practicedInterventionDao;
    protected MineralFertilizersSpreadingActionTopiaDao mineralFertilizersSpreadingActionDao;
    protected PracticedCropCycleSpeciesTopiaDao practicedCropCycleSpeciesDao;
    protected PracticedCropCycleTopiaDao praticedCropCycleDao;
    protected PracticedPerennialCropCycleTopiaDao practicedPerennialCropCycleDao;
    protected PracticedSeasonalCropCycleTopiaDao practicedSeasonalCropCycleDao;
    protected PracticedCropCycleConnectionTopiaDao practicedCropCycleConnectionDao;
    protected PracticedCropCycleNodeTopiaDao practicedCropCycleNodeDao;
    protected AbstractActionTopiaDao abstractActionDao;
    protected CroppingPlanEntryTopiaDao croppingPlanEntryDao;
    protected PracticedCropCyclePhaseTopiaDao practicedCropCyclePhaseDao;
    protected CroppingPlanSpeciesTopiaDao croppingPlanSpeciesDao;
    protected ToolsCouplingTopiaDao toolsCouplingDao;
    protected OtherActionTopiaDao otherActionDao;
    protected SeedingActionTopiaDao seedingActionDao;
    protected HarvestingActionTopiaDao harvestingActionDao;
    protected PesticidesSpreadingActionTopiaDao pesticidesSpreadingActionDao;
    protected IrrigationActionTopiaDao irrigationActionDao;
    protected OrganicFertilizersSpreadingActionTopiaDao organicFertilizersSpreadingActionDao;
    protected MaintenancePruningVinesActionTopiaDao maintenancePruningVinesActionDao;
    protected BiologicalControlActionTopiaDao biologicalControlActionDao;
    protected TillageActionTopiaDao tillageActionDao;
    protected PracticedSpeciesStadeTopiaDao practicedSpeciesStadeDao;
    protected AbstractInputTopiaDao inputTopiaDao;
    protected PracticedPlotTopiaDao practicedPlotDao;
    protected SolHorizonTopiaDao solHorizonDao;
    protected RefTypeTravailEDITopiaDao refTypeTravailEDIDao;
    protected RefOrientationEDITopiaDao refOrientationEDIDao;
    protected RefClonePlantGrapeTopiaDao refClonePlantGrapeDao;
    protected RefVarieteTopiaDao varieteDao;
    protected RefStadeEDITopiaDao refStadeEDIDao;
    private static final Log log = LogFactory.getLog(PracticedSystemServiceImpl.class);
    private static final String NEW_NODE = "new-node-";
    protected static Binder<PracticedIntervention, PracticedInterventionDto> PRACTICED_INTERVENTION_TO_DTO_BINDER = BinderFactory.newBinder(PracticedIntervention.class, PracticedInterventionDto.class);
    protected static final Function<CroppingPlanEntryDto, CropCycleModelDto> CROPPING_PLAN_ENTRY_TO_DTO = new Function<CroppingPlanEntryDto, CropCycleModelDto>(){

        public CropCycleModelDto apply(CroppingPlanEntryDto input) {
            CropCycleModelDto result = new CropCycleModelDto();
            result.setCroppingPlanEntryCode(input.getCode());
            result.setLabel(input.getName());
            result.setCroppingPlanSellingPrice(input.getSellingPrice());
            result.setIntermediate(input.isIntermediate());
            return result;
        }
    };
    protected static final Function<CroppingPlanEntryDto, String> GET_CROPPING_PLAN_ENTRY_CODE = new Function<CroppingPlanEntryDto, String>(){

        public String apply(CroppingPlanEntryDto input) {
            return input.getCode();
        }
    };

    protected static List<PracticedInterventionDto> practicedInterventionToInterventionDtos(final String domainCode, List<PracticedIntervention> interventions, final Map<String, List<AbstractAction>> actionsByInterventionId, final Map<String, List<AbstractInput>> inputsByInterventionId) {
        Iterable view = Iterables.transform(interventions, (Function)new Function<PracticedIntervention, PracticedInterventionDto>(){

            public PracticedInterventionDto apply(PracticedIntervention intervention) {
                PracticedInterventionDto interventionDto = new PracticedInterventionDto();
                PracticedSystemServiceImpl.bindInterventionToInterventionDto(PRACTICED_INTERVENTION_TO_DTO_BINDER, intervention, interventionDto);
                interventionDto.setSpeciesStadesDtos(PracticedSystemServiceImpl.getInterventionSpeciesStadeDtos(intervention));
                interventionDto.setActions((List)actionsByInterventionId.get(intervention.getTopiaId()));
                interventionDto.setInputs((List)inputsByInterventionId.get(intervention.getTopiaId()));
                interventionDto.setDomainId(domainCode);
                return interventionDto;
            }
        });
        ArrayList interventionDtos = Lists.newArrayList((Iterable)view);
        return interventionDtos;
    }

    public void setAuthorizationService(BusinessAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public void setAnonymizeService(AnonymizeService anonymizeService) {
        this.anonymizeService = anonymizeService;
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setPricesService(PricesService pricesService) {
        this.pricesService = pricesService;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setPracticedSystemDao(PracticedSystemTopiaDao practicedSystemDao) {
        this.practicedSystemDao = practicedSystemDao;
    }

    public void setGrowingSystemDao(GrowingSystemTopiaDao growingSystemDao) {
        this.growingSystemDao = growingSystemDao;
    }

    public void setPracticedInterventionDao(PracticedInterventionTopiaDao practicedInterventionDao) {
        this.practicedInterventionDao = practicedInterventionDao;
    }

    public void setPraticedCropCycleDao(PracticedCropCycleTopiaDao praticedCropCycleDao) {
        this.praticedCropCycleDao = praticedCropCycleDao;
    }

    public void setPracticedPerennialCropCycleDao(PracticedPerennialCropCycleTopiaDao practicedPerennialCropCycleDao) {
        this.practicedPerennialCropCycleDao = practicedPerennialCropCycleDao;
    }

    public void setPracticedSeasonalCropCycleDao(PracticedSeasonalCropCycleTopiaDao practicedSeasonalCropCycleDao) {
        this.practicedSeasonalCropCycleDao = practicedSeasonalCropCycleDao;
    }

    public void setPracticedCropCycleConnectionDao(PracticedCropCycleConnectionTopiaDao practicedCropCycleConnectionDao) {
        this.practicedCropCycleConnectionDao = practicedCropCycleConnectionDao;
    }

    public void setPracticedCropCycleNodeDao(PracticedCropCycleNodeTopiaDao practicedCropCycleNodeDao) {
        this.practicedCropCycleNodeDao = practicedCropCycleNodeDao;
    }

    public void setRefOrientationEDIDao(RefOrientationEDITopiaDao refOrientationEDIDao) {
        this.refOrientationEDIDao = refOrientationEDIDao;
    }

    public void setRefClonePlantGrapeDao(RefClonePlantGrapeTopiaDao refClonePlantGrapeDao) {
        this.refClonePlantGrapeDao = refClonePlantGrapeDao;
    }

    public void setVarieteDao(RefVarieteTopiaDao varieteDao) {
        this.varieteDao = varieteDao;
    }

    public void setAbstractActionDao(AbstractActionTopiaDao abstractActionDao) {
        this.abstractActionDao = abstractActionDao;
    }

    public void setCroppingPlanEntryDao(CroppingPlanEntryTopiaDao croppingPlanEntryDao) {
        this.croppingPlanEntryDao = croppingPlanEntryDao;
    }

    public void setPracticedCropCyclePhaseDao(PracticedCropCyclePhaseTopiaDao practicedCropCyclePhaseDao) {
        this.practicedCropCyclePhaseDao = practicedCropCyclePhaseDao;
    }

    public void setCroppingPlanSpeciesDao(CroppingPlanSpeciesTopiaDao croppingPlanSpeciesDao) {
        this.croppingPlanSpeciesDao = croppingPlanSpeciesDao;
    }

    public void setToolsCouplingDao(ToolsCouplingTopiaDao toolsCouplingDao) {
        this.toolsCouplingDao = toolsCouplingDao;
    }

    public void setSolHorizonDao(SolHorizonTopiaDao solHorizonDao) {
        this.solHorizonDao = solHorizonDao;
    }

    public void setOtherActionDao(OtherActionTopiaDao otherActionDao) {
        this.otherActionDao = otherActionDao;
    }

    public void setSeedingActionDao(SeedingActionTopiaDao seedingActionDao) {
        this.seedingActionDao = seedingActionDao;
    }

    public void setHarvestingActionDao(HarvestingActionTopiaDao harvestingActionDao) {
        this.harvestingActionDao = harvestingActionDao;
    }

    public void setMineralFertilizersSpreadingActionDao(MineralFertilizersSpreadingActionTopiaDao mineralFertilizersSpreadingActionDao) {
        this.mineralFertilizersSpreadingActionDao = mineralFertilizersSpreadingActionDao;
    }

    public void setPracticedCropCycleSpeciesDao(PracticedCropCycleSpeciesTopiaDao practicedCropCycleSpeciesDao) {
        this.practicedCropCycleSpeciesDao = practicedCropCycleSpeciesDao;
    }

    public void setPesticidesSpreadingActionDao(PesticidesSpreadingActionTopiaDao pesticidesSpreadingActionDao) {
        this.pesticidesSpreadingActionDao = pesticidesSpreadingActionDao;
    }

    public void setIrrigationActionDao(IrrigationActionTopiaDao irrigationActionDao) {
        this.irrigationActionDao = irrigationActionDao;
    }

    public void setOrganicFertilizersSpreadingActionDao(OrganicFertilizersSpreadingActionTopiaDao organicFertilizersSpreadingActionDao) {
        this.organicFertilizersSpreadingActionDao = organicFertilizersSpreadingActionDao;
    }

    public void setMaintenancePruningVinesActionDao(MaintenancePruningVinesActionTopiaDao maintenancePruningVinesActionDao) {
        this.maintenancePruningVinesActionDao = maintenancePruningVinesActionDao;
    }

    public void setBiologicalControlActionDao(BiologicalControlActionTopiaDao biologicalControlActionDao) {
        this.biologicalControlActionDao = biologicalControlActionDao;
    }

    public void setRefTypeTravailEDIDao(RefTypeTravailEDITopiaDao refTypeTravailEDIDao) {
        this.refTypeTravailEDIDao = refTypeTravailEDIDao;
    }

    public void setTillageActionDao(TillageActionTopiaDao tillageActionDao) {
        this.tillageActionDao = tillageActionDao;
    }

    public void setRefStadeEDIDao(RefStadeEDITopiaDao refStadeEDIDao) {
        this.refStadeEDIDao = refStadeEDIDao;
    }

    public void setPracticedSpeciesStadeDao(PracticedSpeciesStadeTopiaDao practicedSpeciesStadeDao) {
        this.practicedSpeciesStadeDao = practicedSpeciesStadeDao;
    }

    public void setInputService(InputService inputService) {
        this.inputService = inputService;
    }

    public void setInputTopiaDao(AbstractInputTopiaDao inputTopiaDao) {
        this.inputTopiaDao = inputTopiaDao;
    }

    public void setPracticedPlotDao(PracticedPlotTopiaDao practicedPlotDao) {
        this.practicedPlotDao = practicedPlotDao;
    }

    public PracticedSystem getPracticedSystem(String practicedSystemId) {
        PracticedSystem result;
        if (Strings.isNullOrEmpty((String)practicedSystemId)) {
            result = (PracticedSystem)this.practicedSystemDao.newInstance();
        } else {
            PracticedSystem practicedSystem = (PracticedSystem)this.practicedSystemDao.forTopiaIdEquals(practicedSystemId).findUnique();
            result = this.anonymizeService.checkForPracticedSystemAnonymization(practicedSystem);
        }
        return result;
    }

    public ResultList<PracticedSystem> getFilteredPracticedSystems(PracticedSystemFilter filter) {
        ResultList<PracticedSystem> result = this.practicedSystemDao.getFilteredPracticedSystems(filter, this.getSecurityContext());
        return result;
    }

    public ResultList<PracticedSystemDto> getFilteredPracticedSystemsDto(PracticedSystemFilter filter) {
        ResultList<PracticedSystem> practicedSystems = this.practicedSystemDao.getFilteredPracticedSystems(filter, this.getSecurityContext());
        ResultList result = ResultList.transform(practicedSystems, (Function)this.anonymizeService.getPracticedSystemToDtoFunction());
        for (PracticedSystemDto practicedSystem : result.getElements()) {
            boolean canValidate = this.authorizationService.isPracticedSystemValidable(practicedSystem.getTopiaId());
            practicedSystem.setUserCanValidate(canValidate);
        }
        return result;
    }

    protected List<CroppingPlanEntryDto> getCropCycleCroppingPlans(String growingSystemId, String campaigns, boolean includeCropsFromInactiveDomains) {
        List<String> domainIds = this.getDomainIdsForCampaigns(growingSystemId, campaigns, includeCropsFromInactiveDomains);
        ArrayList croppingPlans = Lists.newArrayList();
        for (String domainId : domainIds) {
            List croppingPlan = this.domainService.getCroppingPlanDtos(domainId);
            croppingPlans.addAll(croppingPlan);
        }
        return croppingPlans;
    }

    public List<String> getToolsCouplingsFromGrowingSystemAndCampaigns(String growingSystemId, String campaigns) {
        String domainCode = this.getdomainCode(growingSystemId);
        Set<Integer> intCampaigns = this.getIntCampaigns(campaigns);
        List result = this.domainService.getToolsCouplingCodeForDomainsAndCampaigns(domainCode, intCampaigns);
        return result;
    }

    public List<String> getToolsCouplingsCodesFromDomainAndCampaigns(String domainCode, String campaigns) {
        Set<Integer> intCampaigns = this.getIntCampaigns(campaigns);
        List result = this.domainService.getToolsCouplingCodeForDomainsAndCampaigns(domainCode, intCampaigns);
        return result;
    }

    private List<String> getDomainIdsForCampaigns(String growingSystemId, String campaigns, boolean includeCropsFromInactiveDomains) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)growingSystemId) ? 1 : 0) != 0);
        String domainCode = this.domainService.getDomainCodeForGrowingSystem(growingSystemId);
        Set<Integer> intCampaigns = this.getIntCampaigns(campaigns);
        List result = !intCampaigns.isEmpty() ? this.domainService.findDomainIdsForCodeAndCampaigns(domainCode, intCampaigns, includeCropsFromInactiveDomains) : Lists.newArrayList();
        return result;
    }

    public List<String> getCropCodesFromGrowingSystemIdForCampaigns(String growingSystemId, String campaigns) {
        Set<Integer> intCampaigns = this.getIntCampaigns(campaigns);
        String domainCode = this.domainService.getDomainCodeForGrowingSystem(growingSystemId);
        List result = this.domainService.getCroppingPlanCodeForDomainsAndCampaigns(domainCode, intCampaigns);
        return result;
    }

    public List<String> getCropCodesFromDomainCodeForCampaigns(String domainCode, String campaigns) {
        Set<Integer> intCampaigns = this.getIntCampaigns(campaigns);
        List result = this.domainService.getCroppingPlanCodeForDomainsAndCampaigns(domainCode, intCampaigns);
        return result;
    }

    public Map<CropCycleModelDto, List<CroppingPlanSpeciesDto>> getCropCycleModelMap(String growingSystemId, String campaigns, boolean includeIntermediate, boolean includeCropsFromInactiveDomains) {
        Map<CropCycleModelDto, List<CroppingPlanSpeciesDto>> result = this.getCropCycleModelMap0(growingSystemId, campaigns, true, includeIntermediate, includeCropsFromInactiveDomains);
        return result;
    }

    protected Map<CropCycleModelDto, List<CroppingPlanSpeciesDto>> getCropCycleModelMap0(String growingSystemId, String campaigns, boolean includeSpecies, boolean includeIntermediate, boolean includeCropsFromInactiveDomains) {
        List<CroppingPlanEntryDto> croppingPlans = this.getCropCycleCroppingPlans(growingSystemId, campaigns, includeCropsFromInactiveDomains);
        if (!includeIntermediate) {
            Iterables.removeIf(croppingPlans, (Predicate)CroppingPlans.IS_ENTRY_INTERMEDIATE);
        }
        ImmutableListMultimap index = Multimaps.index(croppingPlans, GET_CROPPING_PLAN_ENTRY_CODE);
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry entry : index.asMap().entrySet()) {
            Collection dtos = (Collection)entry.getValue();
            CroppingPlanEntryDto first = (CroppingPlanEntryDto)dtos.iterator().next();
            CropCycleModelDto modelDto = (CropCycleModelDto)CROPPING_PLAN_ENTRY_TO_DTO.apply((Object)first);
            LinkedHashMap species = Maps.newLinkedHashMap();
            for (CroppingPlanEntryDto dto : dtos) {
                if (dto.getSpecies() == null) continue;
                species.putAll(Maps.uniqueIndex((Iterable)dto.getSpecies(), (Function)CroppingPlans.GET_SPECIES_DTO_CODE));
            }
            result.put(modelDto, Lists.newArrayList(species.values()));
        }
        return result;
    }

    protected List<ToolsCoupling> getConcernedToolsCouplings(String growingSystemId, String campaigns) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)growingSystemId) && !Strings.isNullOrEmpty((String)campaigns) ? 1 : 0) != 0);
        List toolsCouplings = null;
        if (!campaigns.isEmpty()) {
            String domainCode = this.getdomainCode(growingSystemId);
            Set<Integer> intCampaigns = this.getIntCampaigns(campaigns);
            toolsCouplings = this.domainService.getToolsCouplingsForDomainCodeAndCampaigns(domainCode, intCampaigns);
        }
        return toolsCouplings;
    }

    private Set<Integer> getIntCampaigns(String campaigns) {
        Set campaignsInt;
        try {
            campaignsInt = (Set)CommonService.GET_CAMPAIGNS_SET.apply((Object)campaigns);
        }
        catch (Exception eee) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Unable to parse campaigns: " + campaigns), (Throwable)eee);
            }
            campaignsInt = Sets.newHashSet();
        }
        return campaignsInt;
    }

    public List<CropCycleModelDto> getCropCycleModel(String growingSystemId, String campaigns, boolean includeIntermediate, boolean includeCropsFromInactiveDomains) {
        Map<CropCycleModelDto, List<CroppingPlanSpeciesDto>> model = this.getCropCycleModelMap0(growingSystemId, campaigns, false, includeIntermediate, includeCropsFromInactiveDomains);
        ArrayList result = Lists.newArrayList(model.keySet());
        return result;
    }

    public PracticedSystem createOrUpdatePracticedSystem(PracticedSystem practicedSystem, List<PracticedPerennialCropCycleDto> practicedPerennialCropCycleDtos, List<PracticedSeasonalCropCycleDto> practicedSeasonalCropCycleDtos, List<Price> prices) {
        this.authorizationService.checkCreateOrUpdatePracticedSystem(practicedSystem.getTopiaId());
        this.createOrUpdatePracticedSystemWithoutCommit(practicedSystem, practicedPerennialCropCycleDtos, practicedSeasonalCropCycleDtos, prices);
        this.getTransaction().commit();
        return practicedSystem;
    }

    protected PracticedSystem createOrUpdatePracticedSystemWithoutCommit(PracticedSystem practicedSystem, List<PracticedPerennialCropCycleDto> practicedPerennialCropCycleDtos, List<PracticedSeasonalCropCycleDto> practicedSeasonalCropCycleDtos, List<Price> prices) {
        PracticedSystem result;
        practicedSystem.setCampaigns((String)CommonService.ARRANGE_CAMPAIGNS.apply((Object)practicedSystem.getCampaigns()));
        practicedSystem.setUpdateDate(this.context.getCurrentDate());
        if (StringUtils.isBlank((CharSequence)practicedSystem.getTopiaId())) {
            practicedSystem.setActive(true);
            result = (PracticedSystem)this.practicedSystemDao.create((TopiaEntity)practicedSystem);
        } else {
            result = (PracticedSystem)this.practicedSystemDao.update((TopiaEntity)practicedSystem);
        }
        List<String> practicedSystemCroppingPlanEntries = this.getCropCodesFromGrowingSystemIdForCampaigns(practicedSystem.getGrowingSystem().getTopiaId(), practicedSystem.getCampaigns());
        this.createOrUpdatePracticedPerennialCropCycle(practicedPerennialCropCycleDtos, result, Lists.newArrayList(practicedSystemCroppingPlanEntries));
        this.createOrUpdatePracticedSeasonalCropCycle(practicedSeasonalCropCycleDtos, result, Lists.newArrayList(practicedSystemCroppingPlanEntries));
        this.updatePracticedPrices(practicedSystem, prices);
        return result;
    }

    protected void createOrUpdatePracticedSeasonalCropCycle(List<PracticedSeasonalCropCycleDto> practicedSeasonalCropCycleDtos, PracticedSystem practicedSystem, List<String> practicedSystemCroppingPlanEntries) {
        List practicedSeasonalCropCycles = this.practicedSeasonalCropCycleDao.forPracticedSystemEquals(practicedSystem).findAll();
        HashMap practicedSeasonalCropCyclesById = Maps.newHashMap((Map)Maps.uniqueIndex((Iterable)practicedSeasonalCropCycles, (Function)TopiaEntities.getTopiaIdFunction()));
        if (practicedSeasonalCropCycleDtos != null) {
            for (PracticedSeasonalCropCycleDto practicedSeasonalCropCycleDto : practicedSeasonalCropCycleDtos) {
                String topiaId = practicedSeasonalCropCycleDto.getTopiaId();
                PracticedSeasonalCropCycle cycle = StringUtils.isBlank((CharSequence)topiaId) ? (PracticedSeasonalCropCycle)this.practicedSeasonalCropCycleDao.newInstance() : (PracticedSeasonalCropCycle)practicedSeasonalCropCyclesById.remove(topiaId);
                List nodes = practicedSeasonalCropCycleDto.getCropCycleNodeDtos();
                List connections = practicedSeasonalCropCycleDto.getCropCycleConnectionDtos();
                this.createOrUpdatePracticedSeasonalCropCycle(cycle, practicedSystem, nodes, connections, practicedSystemCroppingPlanEntries);
            }
        }
        for (PracticedSeasonalCropCycle practicedSeasonalCropCycle : practicedSeasonalCropCyclesById.values()) {
            List<PracticedCropCycleConnection> practicedCropCycleConnections = this.practicedCropCycleConnectionDao.findAllByCropCycle(practicedSeasonalCropCycle.getTopiaId());
            this.removePracticedCropCycleConnections(practicedCropCycleConnections);
            this.practicedSeasonalCropCycleDao.delete(practicedSeasonalCropCycle);
        }
    }

    protected void createOrUpdatePracticedPerennialCropCycle(List<PracticedPerennialCropCycleDto> practicedPerennialCropCycleDtos, PracticedSystem practicedSystem, List<String> practicedSystemCroppingPlanEntries) {
        if (practicedPerennialCropCycleDtos != null) {
            List practicedPerennialCropCycles = this.practicedPerennialCropCycleDao.forPracticedSystemEquals(practicedSystem).findAll();
            if (practicedPerennialCropCycles == null) {
                practicedPerennialCropCycles = Lists.newArrayList();
            }
            ImmutableMap immutCurrentPracticedPerennialCropCycles = Maps.uniqueIndex((Iterable)practicedPerennialCropCycles, (Function)Entities.GET_TOPIA_ID);
            HashMap currentPracticedPerennialCropCycles = Maps.newHashMap((Map)immutCurrentPracticedPerennialCropCycles);
            String domainName = practicedSystem.getGrowingSystem().getGrowingPlan().getDomain().getName();
            for (PracticedPerennialCropCycleDto practicedPerennialCropCycleDto : practicedPerennialCropCycleDtos) {
                PracticedPerennialCropCycle newPracticedPerennialCropCycle = practicedPerennialCropCycleDto.getPracticedPerennialCropCycle();
                Preconditions.checkArgument((newPracticedPerennialCropCycle != null && StringUtils.isNotBlank((CharSequence)newPracticedPerennialCropCycle.getCroppingPlanEntryCode()) && practicedSystemCroppingPlanEntries.contains(newPracticedPerennialCropCycle.getCroppingPlanEntryCode()) ? 1 : 0) != 0, (Object)String.format("The croppingPlanEntry with the code %s was not found on domain %s for campaigns %s", newPracticedPerennialCropCycle == null ? "unknown" : newPracticedPerennialCropCycle.getCroppingPlanEntryCode(), domainName, practicedSystem.getCampaigns()));
                String cycleTopiaId = newPracticedPerennialCropCycle.getTopiaId();
                PracticedPerennialCropCycle cycle = (PracticedPerennialCropCycle)currentPracticedPerennialCropCycles.remove(cycleTopiaId);
                if (cycle == null) {
                    cycle = (PracticedPerennialCropCycle)this.practicedPerennialCropCycleDao.newInstance();
                }
                List cropCyclePhaseDtos = practicedPerennialCropCycleDto.getCropCyclePhaseDtos();
                List croppingPlanSpeciesIds = practicedPerennialCropCycleDto.getCroppingPlanSpeciesIds();
                List cropCyclePerennialSpeciesDto = practicedPerennialCropCycleDto.getSpeciesDto();
                Binder binder = BinderFactory.newBinder(PracticedPerennialCropCycle.class);
                binder.copyExcluding((Object)newPracticedPerennialCropCycle, (Object)cycle, new String[]{"topiaId", "cropCyclePhases", "practicedCropCycleSpecies"});
                this.createOrUpdatePracticedPerenniaCropCycle(cycle, practicedSystem, cropCyclePhaseDtos, croppingPlanSpeciesIds, cropCyclePerennialSpeciesDto);
            }
            for (PracticedPerennialCropCycle practicedPerennialCropCycle : currentPracticedPerennialCropCycles.values()) {
                this.removePracticedCropCyclePhasesChildrenObjects(practicedPerennialCropCycle.getCropCyclePhases());
            }
            this.practicedPerennialCropCycleDao.deleteAll(currentPracticedPerennialCropCycles.values());
        } else {
            this.removePracticedPerenniaCropCycle(practicedSystem);
        }
    }

    protected void updatePracticedPrices(PracticedSystem practicedSystem, List<Price> prices) {
        this.pricesService.updatePrices(prices, null, practicedSystem);
    }

    public List<ToolsCouplingDto> getToolsCouplingModel(String growingSystemId, String campaigns, AgrosystInterventionType interventionType) {
        HashMap allCampaignsToolsCouplings = Maps.newHashMap();
        List<ToolsCoupling> toolsCouplings = this.getConcernedToolsCouplings(growingSystemId, campaigns);
        if (toolsCouplings != null) {
            for (ToolsCoupling toolsCoupling : toolsCouplings) {
                String code;
                boolean found = false;
                for (RefInterventionAgrosystTravailEDI mainAction : toolsCoupling.getMainsActions()) {
                    if (mainAction.getIntervention_agrosyst() != interventionType) continue;
                    found = true;
                    break;
                }
                if (!found || allCampaignsToolsCouplings.containsKey(code = toolsCoupling.getCode())) continue;
                ToolsCouplingDto dto = (ToolsCouplingDto)Equipments.TOOLS_COUPLING_TO_TOOLS_COUPLING_DTO.apply((Object)toolsCoupling);
                allCampaignsToolsCouplings.put(code, dto);
            }
        }
        ArrayList result = Lists.newArrayList(allCampaignsToolsCouplings.values());
        return result;
    }

    public List<PracticedPerennialCropCycleDto> getAllPracticedPerennialCropCycles(String practicedSystemId) {
        PracticedSystem practicedSystem = (PracticedSystem)this.practicedSystemDao.forTopiaIdEquals(practicedSystemId).findUnique();
        List perennialCropCycles = this.practicedPerennialCropCycleDao.forPracticedSystemEquals(practicedSystem).findAll();
        List<PracticedPerennialCropCycleDto> result = this.convertPerennialCropCyclesToDto(perennialCropCycles, practicedSystem);
        return result;
    }

    protected List<PracticedPerennialCropCycleDto> convertPerennialCropCyclesToDto(List<PracticedPerennialCropCycle> practicedPerennialCropCycles, PracticedSystem practicedSystem) {
        ArrayList result = Lists.newArrayList();
        for (PracticedPerennialCropCycle perennialCropCycle : practicedPerennialCropCycles) {
            PracticedPerennialCropCycleDto dto = new PracticedPerennialCropCycleDto();
            PracticedPerennialCropCycleImpl lightPracticedPerennialCropCycle = new PracticedPerennialCropCycleImpl();
            Binder binder = BinderFactory.newBinder(PracticedPerennialCropCycle.class);
            binder.copyExcluding((Object)perennialCropCycle, (Object)lightPracticedPerennialCropCycle, new String[]{"cropCyclePhases", "practicedCropCycleSpecies"});
            dto.setPracticedPerennialCropCycle((PracticedPerennialCropCycle)lightPracticedPerennialCropCycle);
            String cpEntryCode = perennialCropCycle.getCroppingPlanEntryCode();
            dto.setCroppingPlanEntryName(this.getCroppingPlanEntryName(cpEntryCode));
            List<PracticedCropCyclePhaseDto> phases = this.getPhasesDTOs(perennialCropCycle);
            dto.setCropCyclePhaseDtos(phases);
            List<PracticedCropCycleSpeciesDto> species = this.getCropCyclePerennialSpecies(cpEntryCode, perennialCropCycle, practicedSystem.getCampaigns());
            dto.setSpeciesDto(species);
            result.add(dto);
        }
        return result;
    }

    public List<PracticedSeasonalCropCycleDto> getAllPracticedSeasonalCropCycles(String practicedSystemId) {
        PracticedSystem practicedSystem = (PracticedSystem)this.practicedSystemDao.forTopiaIdEquals(practicedSystemId).findUnique();
        List seasonalCropCycles = this.practicedSeasonalCropCycleDao.forPracticedSystemEquals(practicedSystem).findAll();
        List<PracticedSeasonalCropCycleDto> result = this.convertSeasonalCropCyclesToDto(seasonalCropCycles);
        return result;
    }

    protected static Map<PracticedCropCycleConnection, List<PracticedIntervention>> getInterventionsByConnection(List<PracticedIntervention> interventions) {
        HashMap interventionsByConnection = Maps.newHashMap();
        for (PracticedIntervention intervention : interventions) {
            List interventionsForConnection = (List)interventionsByConnection.get(intervention.getPracticedCropCycleConnection());
            if (interventionsForConnection == null) {
                interventionsForConnection = Lists.newArrayList();
                interventionsByConnection.put(intervention.getPracticedCropCycleConnection(), interventionsForConnection);
            }
            interventionsForConnection.add(intervention);
        }
        return interventionsByConnection;
    }

    protected static Map<String, List<PracticedCropCycleConnection>> getConnexionsByCycleId(List<PracticedCropCycleConnection> connections) {
        HashMap connectionsByCycleId = Maps.newHashMap();
        for (PracticedCropCycleConnection connection : connections) {
            String cycleId = connection.getTarget().getPracticedSeasonalCropCycle().getTopiaId();
            List cropCycleConnections = (List)connectionsByCycleId.get(cycleId);
            if (cropCycleConnections == null) {
                cropCycleConnections = Lists.newArrayList();
                connectionsByCycleId.put(cycleId, cropCycleConnections);
            }
            cropCycleConnections.add(connection);
        }
        return connectionsByCycleId;
    }

    protected List<PracticedSeasonalCropCycleDto> convertSeasonalCropCyclesToDto(List<PracticedSeasonalCropCycle> practicedSeasonalCropCycles) {
        long begin = System.currentTimeMillis();
        ArrayList result = Lists.newArrayList();
        ImmutableMap practicedSeasonalCropCycleByIds = Maps.uniqueIndex(practicedSeasonalCropCycles, (Function)Entities.GET_TOPIA_ID);
        Set<String> practicedSystemIds = practicedSeasonalCropCycleByIds.keySet();
        if (CollectionUtils.isNotEmpty(practicedSystemIds)) {
            List<PracticedCropCycleConnection> connections = this.practicedCropCycleConnectionDao.findAllByCropCycles(practicedSystemIds);
            Map<String, List<PracticedCropCycleConnection>> connectionsByCycleId = PracticedSystemServiceImpl.getConnexionsByCycleId(connections);
            List interventions = this.practicedInterventionDao.forPracticedCropCycleConnectionIn(connections).setOrderByArguments(new String[]{"practicedCropCycleConnection", "rank"}).findAll();
            Map<PracticedCropCycleConnection, List<PracticedIntervention>> interventionsByConnection = PracticedSystemServiceImpl.getInterventionsByConnection(interventions);
            List abstractActions = this.abstractActionDao.forPracticedInterventionIn(interventions).findAll();
            Map<String, List<AbstractAction>> actionsByInterventionId = PracticedSystemServiceImpl.getActionsByIntervention(abstractActions);
            HashMap inputsByInterventionId = Maps.newHashMap();
            for (PracticedIntervention intervention : interventions) {
                inputsByInterventionId.put(intervention.getTopiaId(), this.inputTopiaDao.findAllByPracticedIntervention(intervention));
            }
            for (PracticedSeasonalCropCycle practicedSeasonalCropCycle : practicedSeasonalCropCycles) {
                String domainCode = practicedSeasonalCropCycle.getPracticedSystem().getGrowingSystem().getGrowingPlan().getDomain().getCode();
                PracticedSeasonalCropCycleDto dto = new PracticedSeasonalCropCycleDto();
                dto.setTopiaId(practicedSeasonalCropCycle.getTopiaId());
                ArrayList nodes = Lists.newArrayList();
                Map<PracticedCropCycleNodeDto, List<CroppingPlanSpeciesDto>> nodesToSpecies = this.getNodesForCycle(practicedSeasonalCropCycle);
                for (Map.Entry<PracticedCropCycleNodeDto, List<CroppingPlanSpeciesDto>> entry : nodesToSpecies.entrySet()) {
                    PracticedCropCycleNodeDto cycleNodeDto = entry.getKey();
                    nodes.add(cycleNodeDto);
                }
                dto.setCropCycleNodeDtos((List)nodes);
                List<PracticedCropCycleConnection> cycleConnections = connectionsByCycleId.get(practicedSeasonalCropCycle.getTopiaId());
                ArrayList connectionDtos = Lists.newArrayList();
                for (PracticedCropCycleConnection connection : cycleConnections) {
                    PracticedCropCycleConnectionDto connectionDto = (PracticedCropCycleConnectionDto)PracticedSystems.CROP_CYCLE_CONNECTION_TO_DTO.apply((Object)connection);
                    List<PracticedIntervention> connectionInterventions = interventionsByConnection.get(connection);
                    if (connectionInterventions != null) {
                        List<PracticedInterventionDto> interventionDtos = PracticedSystemServiceImpl.practicedInterventionToInterventionDtos(domainCode, connectionInterventions, actionsByInterventionId, inputsByInterventionId);
                        connectionDto.setInterventions(interventionDtos);
                    }
                    connectionDtos.add(connectionDto);
                }
                dto.setCropCycleConnectionDtos((List)connectionDtos);
                result.add(dto);
            }
        }
        if (log.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            log.info((Object)("Ex\u00e9cution convertSeasonalCropCyclesToDto() en:" + (end - begin) + "ms"));
        }
        return result;
    }

    @Deprecated
    protected List<PracticedSeasonalCropCycleDto> convertSeasonalCropCyclesToDtoOriginal(List<PracticedSeasonalCropCycle> practicedSeasonalCropCycles) {
        long begin = System.currentTimeMillis();
        ArrayList result = Lists.newArrayList();
        for (PracticedSeasonalCropCycle practicedSeasonalCropCycle : practicedSeasonalCropCycles) {
            String domainCode = practicedSeasonalCropCycle.getPracticedSystem().getGrowingSystem().getGrowingPlan().getDomain().getCode();
            PracticedSeasonalCropCycleDto dto = new PracticedSeasonalCropCycleDto();
            dto.setTopiaId(practicedSeasonalCropCycle.getTopiaId());
            ArrayList nodes = Lists.newArrayList();
            Map<PracticedCropCycleNodeDto, List<CroppingPlanSpeciesDto>> nodesToSpecies = this.getNodes(practicedSeasonalCropCycle.getTopiaId());
            for (Map.Entry<PracticedCropCycleNodeDto, List<CroppingPlanSpeciesDto>> entry : nodesToSpecies.entrySet()) {
                PracticedCropCycleNodeDto cycleNodeDto = entry.getKey();
                nodes.add(cycleNodeDto);
            }
            dto.setCropCycleNodeDtos((List)nodes);
            List<PracticedCropCycleConnectionDto> connections = this.getConnectionDTOs(practicedSeasonalCropCycle.getTopiaId(), domainCode);
            dto.setCropCycleConnectionDtos(connections);
            result.add(dto);
        }
        if (log.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            log.info((Object)("Ex\u00e9cution convertSeasonalCropCyclesToDtoOriginal() en:" + (end - begin) + "ms"));
        }
        return result;
    }

    public PracticedSeasonalCropCycle getPracticedSeasonalCropCycle(String cycleId) {
        PracticedSeasonalCropCycle result = Strings.isNullOrEmpty((String)cycleId) ? (PracticedSeasonalCropCycle)this.practicedSeasonalCropCycleDao.newInstance() : (PracticedSeasonalCropCycle)this.practicedSeasonalCropCycleDao.forTopiaIdEquals(cycleId).findUniqueOrNull();
        Preconditions.checkState((result != null ? 1 : 0) != 0, (Object)("Expected PracticedSeasonalCropCycle not found: " + cycleId));
        return result;
    }

    public PracticedPerennialCropCycle getPracticedPerennialCropCycle(String cycleId) {
        PracticedPerennialCropCycle result = Strings.isNullOrEmpty((String)cycleId) ? (PracticedPerennialCropCycle)this.practicedPerennialCropCycleDao.newInstance() : (PracticedPerennialCropCycle)this.practicedPerennialCropCycleDao.forTopiaIdEquals(cycleId).findUnique();
        Preconditions.checkState((result != null ? 1 : 0) != 0, (Object)("Expected practicedPerennialCropCycle not found: " + cycleId));
        return result;
    }

    protected PracticedSeasonalCropCycle createOrUpdatePracticedSeasonalCropCycle(PracticedSeasonalCropCycle cycle, PracticedSystem practicedSystem, List<PracticedCropCycleNodeDto> nodes, List<PracticedCropCycleConnectionDto> connections, List<String> practicedSystemCroppingPlanEntries) {
        PracticedSeasonalCropCycle result;
        Preconditions.checkNotNull((Object)cycle);
        Preconditions.checkNotNull(nodes);
        Preconditions.checkNotNull(connections);
        MultiKeyMap cycleConnBySourceTarget = new MultiKeyMap();
        if (!cycle.isPersisted()) {
            Preconditions.checkNotNull((Object)practicedSystem);
            cycle.setPracticedSystem(practicedSystem);
            result = (PracticedSeasonalCropCycle)this.practicedSeasonalCropCycleDao.create((TopiaEntity)cycle);
        } else {
            result = (PracticedSeasonalCropCycle)this.practicedSeasonalCropCycleDao.update((TopiaEntity)cycle);
            List<PracticedCropCycleConnection> cycleConnections = this.practicedCropCycleConnectionDao.findAllByCropCycle(result.getTopiaId());
            for (PracticedCropCycleConnection conn : cycleConnections) {
                cycleConnBySourceTarget.put((Object)conn.getSource().getTopiaId(), (Object)conn.getTarget().getTopiaId(), (Object)conn);
            }
        }
        Domain domain = cycle.getPracticedSystem().getGrowingSystem().getGrowingPlan().getDomain();
        String domainCode = domain.getCode();
        if (cycle.getCropCycleNodes() == null) {
            cycle.setCropCycleNodes(new ArrayList());
        }
        HashMap nodeIdToEntity = Maps.newHashMap();
        Collection cycleNodes = cycle.getCropCycleNodes();
        if (cycleNodes == null) {
            cycleNodes = Lists.newArrayList();
            cycle.setCropCycleNodes(cycleNodes);
        }
        for (PracticedCropCycleNodeDto dtoNode : nodes) {
            PracticedCropCycleNode entityNode;
            String croppingPlanEntryCode = dtoNode.getCroppingPlanEntryCode();
            Preconditions.checkArgument((boolean)practicedSystemCroppingPlanEntries.contains(croppingPlanEntryCode), (Object)String.format("The croppingPlanEntry with the code %s was not found on domain %s for campaigns %s", croppingPlanEntryCode, domain.getName(), practicedSystem.getCampaigns()));
            String nodeId = (String)Entities.UNESCAPE_TOPIA_ID.apply((Object)dtoNode.getNodeId());
            if (nodeId.startsWith(NEW_NODE)) {
                entityNode = (PracticedCropCycleNode)this.practicedCropCycleNodeDao.newInstance();
                entityNode.setCroppingPlanEntryCode(croppingPlanEntryCode);
                result.addCropCycleNodes(entityNode);
            } else {
                entityNode = (PracticedCropCycleNode)TopiaEntities.findByTopiaId((Iterable)cycle.getCropCycleNodes(), (String)nodeId);
            }
            entityNode.setRank(dtoNode.getX());
            entityNode.setY(dtoNode.getY());
            entityNode.setEndCycle(dtoNode.isEndCycle());
            entityNode.setSameCampaignAsPreviousNode(dtoNode.isSameCampaignAsPreviousNode());
            entityNode.setInitNodeFrequency(dtoNode.getInitNodeFrequency());
            PracticedCropCycleNode persistentNode = entityNode.isPersisted() ? (PracticedCropCycleNode)this.practicedCropCycleNodeDao.update((TopiaEntity)entityNode) : (PracticedCropCycleNode)this.practicedCropCycleNodeDao.create((TopiaEntity)entityNode);
            nodeIdToEntity.put(nodeId, persistentNode);
        }
        for (PracticedCropCycleConnectionDto connectionDto : connections) {
            if (StringUtils.isNotBlank((CharSequence)connectionDto.getIntermediateCroppingPlanEntryCode())) {
                Preconditions.checkArgument((boolean)practicedSystemCroppingPlanEntries.contains(connectionDto.getIntermediateCroppingPlanEntryCode()), (Object)("The croppingPlanEntry with the code:" + connectionDto.getIntermediateCroppingPlanEntryCode() + " was not found"));
            }
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)connectionDto.getSourceId()));
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)connectionDto.getTargetId()));
            String sourceId = (String)Entities.UNESCAPE_TOPIA_ID.apply((Object)connectionDto.getSourceId());
            String targetId = (String)Entities.UNESCAPE_TOPIA_ID.apply((Object)connectionDto.getTargetId());
            List<Object> interventions = Lists.newArrayList();
            PracticedCropCycleConnection connection = (PracticedCropCycleConnection)cycleConnBySourceTarget.removeMultiKey((Object)sourceId, (Object)targetId);
            if (connection == null) {
                PracticedCropCycleNode targetNode;
                PracticedCropCycleNode sourceNode = (PracticedCropCycleNode)nodeIdToEntity.get(sourceId);
                if (sourceNode == null) {
                    sourceNode = (PracticedCropCycleNode)this.practicedCropCycleNodeDao.forTopiaIdEquals(sourceId).findUnique();
                }
                if ((targetNode = (PracticedCropCycleNode)nodeIdToEntity.get(targetId)) == null) {
                    targetNode = (PracticedCropCycleNode)this.practicedCropCycleNodeDao.forTopiaIdEquals(targetId).findUnique();
                }
                connection = (PracticedCropCycleConnection)this.practicedCropCycleConnectionDao.create("source", sourceNode, new Object[]{"target", targetNode});
            } else {
                interventions = this.getCropCycleNodeConnectionInterventions(connection);
            }
            connection.setIntermediateCroppingPlanEntryCode(connectionDto.getIntermediateCroppingPlanEntryCode());
            connection.setCroppingPlanEntryFrequency(connectionDto.getCroppingPlanEntryFrequency().doubleValue());
            connection.setNotUsedForThisCampaign(connectionDto.isNotUsedForThisCampaign());
            this.convertSeasonalInterventionDto(interventions, connection, connectionDto, domainCode);
        }
        HashSet<PracticedCropCycleConnection> unusedPracticedCropCycleConnections = new HashSet<PracticedCropCycleConnection>(cycleConnBySourceTarget.values());
        Collection toDeleteNodes = CollectionUtils.subtract((Iterable)cycleNodes, nodeIdToEntity.values());
        for (PracticedCropCycleNode nodeToDelete : toDeleteNodes) {
            unusedPracticedCropCycleConnections.addAll(this.practicedCropCycleConnectionDao.forTargetEquals(nodeToDelete).findAll());
            unusedPracticedCropCycleConnections.addAll(this.practicedCropCycleConnectionDao.forSourceEquals(nodeToDelete).findAll());
        }
        this.removePracticedCropCycleConnections(unusedPracticedCropCycleConnections);
        cycleNodes.retainAll(nodeIdToEntity.values());
        return result;
    }

    protected PracticedPerennialCropCycle createOrUpdatePracticedPerenniaCropCycle(PracticedPerennialCropCycle cycle, PracticedSystem practicedSystem, List<PracticedCropCyclePhaseDto> cropCyclePhaseDtos, List<String> croppingPlanSpeciesIds, List<PracticedCropCycleSpeciesDto> cropCyclePerennialSpeciesDtos) {
        Preconditions.checkNotNull((Object)cycle);
        Preconditions.checkNotNull((Object)practicedSystem);
        Preconditions.checkNotNull(cropCyclePhaseDtos);
        Preconditions.checkArgument((cropCyclePhaseDtos.size() > 0 ? 1 : 0) != 0);
        cycle.setPracticedSystem(practicedSystem);
        Map<PracticedCropCyclePhaseDto, PracticedCropCyclePhase> phasesDtoPhase = this.convertCropCyclePhaseDto(cropCyclePhaseDtos, cycle);
        PracticedPerennialCropCycle result = cycle.isPersisted() ? (PracticedPerennialCropCycle)this.practicedPerennialCropCycleDao.update((TopiaEntity)cycle) : (PracticedPerennialCropCycle)this.practicedPerennialCropCycleDao.create((TopiaEntity)cycle);
        this.convertCropCyclePerennialSpeciesDto(cropCyclePerennialSpeciesDtos, result);
        String domainCode = result.getPracticedSystem().getGrowingSystem().getGrowingPlan().getDomain().getCode();
        this.convertPerenialInterventionDto(phasesDtoPhase, domainCode);
        return result;
    }

    protected void removePracticedCropCycleConnections(Collection<PracticedCropCycleConnection> practicedCropCycleConnections) {
        if (practicedCropCycleConnections != null) {
            for (PracticedCropCycleConnection practicedCropCycleConnection : practicedCropCycleConnections) {
                List practicedInterventions = this.practicedInterventionDao.forPracticedCropCycleConnectionEquals(practicedCropCycleConnection).findAll();
                this.removePracticedInterventions(practicedInterventions);
            }
            this.practicedCropCycleConnectionDao.deleteAll(practicedCropCycleConnections);
        }
    }

    protected void removePracticedPerenniaCropCycle(PracticedSystem practicedSystem) {
        List practicedPerennialCropCycles = this.practicedPerennialCropCycleDao.forPracticedSystemEquals(practicedSystem).findAll();
        if (practicedPerennialCropCycles != null) {
            for (PracticedPerennialCropCycle practicedPerennialCropCycle : practicedPerennialCropCycles) {
                Collection practicedCropCyclePhases = practicedPerennialCropCycle.getCropCyclePhases();
                this.removePracticedCropCyclePhasesChildrenObjects(practicedCropCyclePhases);
            }
            this.practicedPerennialCropCycleDao.deleteAll(practicedPerennialCropCycles);
        }
    }

    protected void removePracticedCropCyclePhasesChildrenObjects(Collection<PracticedCropCyclePhase> practicedCropCyclePhases) {
        for (PracticedCropCyclePhase practicedCropCyclePhase : practicedCropCyclePhases) {
            List practicedInterventions = this.practicedInterventionDao.forPracticedCropCyclePhaseEquals(practicedCropCyclePhase).findAll();
            this.removePracticedInterventions(practicedInterventions);
        }
    }

    protected void removePracticedCropCycleSpecies(Collection<PracticedCropCycleSpecies> allPracticedCropCycleSpecies) {
        if (allPracticedCropCycleSpecies != null) {
            this.practicedCropCycleSpeciesDao.deleteAll(allPracticedCropCycleSpecies);
        }
    }

    protected void removePracticedInterventions(Collection<PracticedIntervention> practicedInterventions) {
        if (practicedInterventions != null) {
            ArrayList allInputsToRemove = Lists.newArrayList();
            ArrayList allActionsToRemove = Lists.newArrayList();
            for (PracticedIntervention practicedIntervention : practicedInterventions) {
                List<AbstractInput> abstractInputs = this.inputTopiaDao.findAllByPracticedIntervention(practicedIntervention);
                if (abstractInputs != null) {
                    allInputsToRemove.addAll(abstractInputs);
                }
                List abstractActions = this.abstractActionDao.forPracticedInterventionEquals(practicedIntervention).findAll();
                allActionsToRemove.addAll(abstractActions);
            }
            this.inputTopiaDao.deleteAll(allInputsToRemove);
            this.practicedInterventionDao.deleteAll(practicedInterventions);
            this.abstractActionDao.deleteAll(allActionsToRemove);
        }
    }

    protected void convertCropCyclePerennialSpeciesDto(List<PracticedCropCycleSpeciesDto> speciesDtos, PracticedPerennialCropCycle cycle) {
        Collection currentSpecies = cycle.getPracticedCropCycleSpecies();
        ArrayList nonDeleted = Lists.newArrayList();
        if (currentSpecies == null) {
            currentSpecies = Lists.newArrayList();
            cycle.setPracticedCropCycleSpecies(currentSpecies);
        }
        ImmutableMap currentSpeciesMap = Maps.uniqueIndex((Iterable)currentSpecies, (Function)new Function<PracticedCropCycleSpecies, String>(){

            public String apply(PracticedCropCycleSpecies input) {
                return input.getCroppingPlanSpeciesCode();
            }
        });
        if (speciesDtos != null) {
            for (PracticedCropCycleSpeciesDto cropCyclePerennialSpeciesDto : speciesDtos) {
                String graftTopiaId;
                String code = cropCyclePerennialSpeciesDto.getCode();
                PracticedCropCycleSpecies cropCyclePerennialSpecies = (PracticedCropCycleSpecies)currentSpeciesMap.get(code);
                if (cropCyclePerennialSpecies == null) {
                    cropCyclePerennialSpecies = (PracticedCropCycleSpecies)this.practicedCropCycleSpeciesDao.newInstance();
                    cropCyclePerennialSpecies.setCroppingPlanSpeciesCode(code);
                    cropCyclePerennialSpecies.setCycle(cycle);
                    cycle.addPracticedCropCycleSpecies(cropCyclePerennialSpecies);
                }
                cropCyclePerennialSpecies.setPlantsCertified(cropCyclePerennialSpeciesDto.isPlantCertified());
                cropCyclePerennialSpecies.setOverGraftDate(cropCyclePerennialSpeciesDto.getOverGraftDate());
                if (cropCyclePerennialSpeciesDto.getGraftClone() != null && StringUtils.isNotBlank((CharSequence)(graftTopiaId = cropCyclePerennialSpeciesDto.getGraftClone().getTopiaId()))) {
                    RefClonePlantGrape clonePlantGrape = (RefClonePlantGrape)this.refClonePlantGrapeDao.forTopiaIdEquals(graftTopiaId).findUnique();
                    cropCyclePerennialSpecies.setGraftClone(clonePlantGrape);
                }
                if (cropCyclePerennialSpeciesDto.getGraftSupport() != null && StringUtils.isNotBlank((CharSequence)(graftTopiaId = cropCyclePerennialSpeciesDto.getGraftSupport().getTopiaId()))) {
                    RefVariete variete = (RefVariete)this.varieteDao.forTopiaIdEquals(graftTopiaId).findUnique();
                    cropCyclePerennialSpecies.setGraftSupport(variete);
                }
                if (cropCyclePerennialSpecies.isPersisted()) {
                    this.practicedCropCycleSpeciesDao.update((TopiaEntity)cropCyclePerennialSpecies);
                } else {
                    this.practicedCropCycleSpeciesDao.create((TopiaEntity)cropCyclePerennialSpecies);
                }
                nonDeleted.add(cropCyclePerennialSpecies);
            }
        }
        currentSpecies.retainAll(nonDeleted);
    }

    protected Map<PracticedCropCyclePhaseDto, PracticedCropCyclePhase> convertCropCyclePhaseDto(List<PracticedCropCyclePhaseDto> cropCyclePhaseDtos, PracticedPerennialCropCycle cycle) {
        Collection currentPhases = cycle.getCropCyclePhases();
        if (currentPhases == null) {
            currentPhases = Lists.newArrayList();
            cycle.setCropCyclePhases(currentPhases);
        }
        HashMap result = Maps.newHashMap();
        ImmutableMap immutCurrentPhasesMap = Maps.uniqueIndex((Iterable)currentPhases, (Function)Entities.GET_TOPIA_ID);
        HashMap currentPhasesMap = Maps.newHashMap((Map)immutCurrentPhasesMap);
        for (PracticedCropCyclePhaseDto cropCyclePhaseDto : cropCyclePhaseDtos) {
            String phaseId = cropCyclePhaseDto.getTopiaId();
            PracticedCropCyclePhase phase = StringUtils.isBlank((CharSequence)phaseId) ? (PracticedCropCyclePhase)this.practicedCropCyclePhaseDao.newInstance() : (PracticedCropCyclePhase)currentPhasesMap.remove(phaseId);
            result.put(cropCyclePhaseDto, phase);
            phase.setType(cropCyclePhaseDto.getType());
            phase.setDuration(cropCyclePhaseDto.getDuration());
            if (!StringUtils.isBlank((CharSequence)phaseId)) continue;
            currentPhases.add(phase);
        }
        this.removePracticedCropCyclePhasesChildrenObjects(currentPhasesMap.values());
        currentPhases.removeAll(currentPhasesMap.values());
        return result;
    }

    protected void convertSeasonalInterventionDto(List<PracticedIntervention> interventions, PracticedCropCycleConnection persistentConnection, PracticedCropCycleConnectionDto connectionDto, String domainCode) {
        List interventionDtos = connectionDto.getInterventions();
        boolean intermediateCrop = !Strings.isNullOrEmpty((String)connectionDto.getIntermediateCroppingPlanEntryCode());
        this.convertIntervention(interventionDtos, interventions, null, persistentConnection, domainCode, intermediateCrop);
    }

    protected void convertPerenialInterventionDto(Map<PracticedCropCyclePhaseDto, PracticedCropCyclePhase> phaseDtosPhases, String domainCode) {
        for (Map.Entry<PracticedCropCyclePhaseDto, PracticedCropCyclePhase> phasesDtoEntry : phaseDtosPhases.entrySet()) {
            PracticedCropCyclePhaseDto phasesDto = phasesDtoEntry.getKey();
            PracticedCropCyclePhase phase = phasesDtoEntry.getValue();
            List interventionDtos = phasesDto.getInterventions();
            List<PracticedIntervention> interventions = this.getCropCyclePhaseInterventions(phase);
            this.convertIntervention(interventionDtos, interventions, phase, null, domainCode, false);
        }
    }

    protected Set<String> getInterventionSpecies(PracticedIntervention practicedIntervention) {
        Collection pss;
        HashSet<String> speciesCodes = new HashSet<String>();
        if (practicedIntervention != null && (pss = practicedIntervention.getSpeciesStades()) != null) {
            for (PracticedSpeciesStade ps : pss) {
                speciesCodes.add(ps.getSpeciesCode());
            }
        }
        return speciesCodes;
    }

    protected void convertIntervention(List<PracticedInterventionDto> interventionDtos, List<PracticedIntervention> interventions, PracticedCropCyclePhase phase, PracticedCropCycleConnection connection, String domainCode, boolean intermediateCrop) {
        if (interventions == null) {
            interventions = Lists.newArrayList();
        }
        if (interventionDtos != null) {
            Iterator<PracticedInterventionDto> validInterventionDtos = interventionDtos.iterator();
            while (validInterventionDtos.hasNext()) {
                PracticedInterventionDto interventionDto = validInterventionDtos.next();
                if (!Strings.isNullOrEmpty((String)interventionDto.getTopiaId()) || !Strings.isNullOrEmpty((String)interventionDto.getDomainId()) && interventionDto.getDomainId().equals(domainCode)) continue;
                validInterventionDtos.remove();
            }
        }
        ImmutableMap imutCurrentInterventionsMap = Maps.uniqueIndex((Iterable)interventions, (Function)Entities.GET_TOPIA_ID);
        HashMap currentInterventionsMap = Maps.newHashMap((Map)imutCurrentInterventionsMap);
        if (interventionDtos != null && !interventionDtos.isEmpty()) {
            for (int i = 0; i < interventionDtos.size(); ++i) {
                Map actions;
                Set<String> speciesCodes;
                PracticedIntervention persistedIntervention;
                PracticedInterventionDto interventionDto = interventionDtos.get(i);
                interventionDto.setRank(i);
                if (!intermediateCrop) {
                    interventionDto.setIntermediateCrop(false);
                }
                PracticedIntervention intervention = null;
                if (!StringUtils.isBlank((CharSequence)interventionDto.getTopiaId())) {
                    intervention = (PracticedIntervention)currentInterventionsMap.remove(interventionDto.getTopiaId());
                }
                if (intervention == null) {
                    intervention = (PracticedIntervention)this.practicedInterventionDao.newInstance();
                }
                this.addAllSpeciesStades(intervention, interventionDto);
                interventionDto.setPracticedCropCyclePhase(phase);
                interventionDto.setPracticedCropCycleConnection(connection);
                Binder binder = BinderFactory.newBinder(PracticedIntervention.class);
                binder.copyExcluding((Object)interventionDto, (Object)intervention, new String[]{"topiaId", "topiaCreateDate", "topiaVersion", "speciesStades"});
                if (intervention.isPersisted()) {
                    persistedIntervention = (PracticedIntervention)this.practicedInterventionDao.update((TopiaEntity)intervention);
                    speciesCodes = this.getInterventionSpecies(persistedIntervention);
                    actions = this.actionService.updatePracticedInterventionActions(persistedIntervention, interventionDto.getActions(), speciesCodes);
                    this.inputService.updateInterventionInputs(persistedIntervention, null, interventionDto.getInputs(), actions);
                    continue;
                }
                persistedIntervention = (PracticedIntervention)this.practicedInterventionDao.create((TopiaEntity)intervention);
                interventions.add(persistedIntervention);
                speciesCodes = this.getInterventionSpecies(persistedIntervention);
                actions = this.actionService.createPracticedInterventionActions(persistedIntervention, interventionDto.getActions(), speciesCodes);
                this.inputService.updateInterventionInputs(persistedIntervention, null, interventionDto.getInputs(), actions);
            }
        }
        this.removePracticedInterventions(currentInterventionsMap.values());
    }

    protected void addAllSpeciesStades(PracticedIntervention intervention, PracticedInterventionDto interventionDto) {
        List speciesStadesDtos = interventionDto.getSpeciesStadesDtos();
        Collection allOriginalSpeciesStades = intervention.getSpeciesStades();
        if (allOriginalSpeciesStades == null) {
            allOriginalSpeciesStades = Lists.newArrayList();
            intervention.setSpeciesStades(allOriginalSpeciesStades);
        }
        ArrayList nonDeleted = Lists.newArrayList();
        if (speciesStadesDtos != null && !speciesStadesDtos.isEmpty()) {
            ImmutableMap allOriginalSpeciesStadesMap = Maps.uniqueIndex((Iterable)allOriginalSpeciesStades, (Function)Entities.GET_TOPIA_ID);
            for (SpeciesStadeDto speciesStadeDto : speciesStadesDtos) {
                PracticedSpeciesStade editedSpeciesStades;
                if (StringUtils.isBlank((CharSequence)speciesStadeDto.getTopiaId())) {
                    editedSpeciesStades = (PracticedSpeciesStade)this.practicedSpeciesStadeDao.newInstance();
                    allOriginalSpeciesStades.add(editedSpeciesStades);
                } else {
                    editedSpeciesStades = (PracticedSpeciesStade)allOriginalSpeciesStadesMap.get(speciesStadeDto.getTopiaId());
                    if (editedSpeciesStades == null) {
                        editedSpeciesStades = (PracticedSpeciesStade)this.practicedSpeciesStadeDao.forTopiaIdEquals(speciesStadeDto.getTopiaId()).findUnique();
                        allOriginalSpeciesStades.add(editedSpeciesStades);
                    }
                }
                editedSpeciesStades.setSpeciesCode(speciesStadeDto.getSpeciesCode());
                if (speciesStadeDto.getStadeMin() == null) {
                    editedSpeciesStades.setStadeMin(null);
                } else {
                    String refStadeEdiTopiaIdMin = speciesStadeDto.getStadeMin().getTopiaId();
                    if (editedSpeciesStades.getStadeMin() == null || !editedSpeciesStades.getStadeMin().getTopiaId().contentEquals(refStadeEdiTopiaIdMin)) {
                        editedSpeciesStades.setStadeMin((RefStadeEDI)this.refStadeEDIDao.forTopiaIdEquals(refStadeEdiTopiaIdMin).findUnique());
                    }
                    if (speciesStadeDto.getStadeMax() == null) {
                        editedSpeciesStades.setStadeMax(null);
                    } else {
                        String refStadeEdiTopiaIdMax = speciesStadeDto.getStadeMax().getTopiaId();
                        if (editedSpeciesStades.getStadeMax() == null || !refStadeEdiTopiaIdMax.contentEquals(editedSpeciesStades.getStadeMax().getTopiaId())) {
                            if (!refStadeEdiTopiaIdMin.contentEquals(refStadeEdiTopiaIdMax)) {
                                editedSpeciesStades.setStadeMax((RefStadeEDI)this.refStadeEDIDao.forTopiaIdEquals(refStadeEdiTopiaIdMax).findUnique());
                            } else {
                                editedSpeciesStades.setStadeMax(editedSpeciesStades.getStadeMin());
                            }
                        }
                    }
                }
                PracticedSpeciesStade persistedSpeciesStade = editedSpeciesStades.isPersisted() ? (PracticedSpeciesStade)this.practicedSpeciesStadeDao.update((TopiaEntity)editedSpeciesStades) : (PracticedSpeciesStade)this.practicedSpeciesStadeDao.create((TopiaEntity)editedSpeciesStades);
                nonDeleted.add(persistedSpeciesStade);
            }
        }
        allOriginalSpeciesStades.retainAll(nonDeleted);
    }

    protected List<PracticedCropCyclePhaseDto> getPhasesDTOs(PracticedPerennialCropCycle cycle) {
        String domainCode = cycle.getPracticedSystem().getGrowingSystem().getGrowingPlan().getDomain().getCode();
        Collection currentPhases = cycle.getCropCyclePhases();
        ArrayList currentPhasesDtos = Lists.newArrayListWithCapacity((int)currentPhases.size());
        for (PracticedCropCyclePhase currentPhase : currentPhases) {
            PracticedCropCyclePhaseDto currentPhaseDto = new PracticedCropCyclePhaseDto();
            currentPhaseDto.setType(currentPhase.getType());
            currentPhaseDto.setDuration(currentPhase.getDuration());
            currentPhaseDto.setTopiaId(currentPhase.getTopiaId());
            List<PracticedIntervention> interventions = this.getCropCyclePhaseInterventions(currentPhase);
            if (interventions != null) {
                List<PracticedInterventionDto> interventionDtos = this.practicedInterventionToInterventionDtos(domainCode, interventions);
                currentPhaseDto.setInterventions(interventionDtos);
            }
            currentPhasesDtos.add(currentPhaseDto);
        }
        return currentPhasesDtos;
    }

    protected List<PracticedCropCycleConnectionDto> getConnectionDTOs(String cycleId, String domainCode) {
        List<PracticedCropCycleConnection> connections = this.practicedCropCycleConnectionDao.findAllByCropCycle(cycleId);
        ArrayList result = Lists.newArrayList();
        for (PracticedCropCycleConnection connection : connections) {
            PracticedCropCycleConnectionDto connectionDto = (PracticedCropCycleConnectionDto)PracticedSystems.CROP_CYCLE_CONNECTION_TO_DTO.apply((Object)connection);
            List interventions = this.practicedInterventionDao.forPracticedCropCycleConnectionEquals(connection).setOrderByArguments(new String[]{"rank"}).findAll();
            if (interventions != null) {
                List<PracticedInterventionDto> interventionDtos = this.practicedInterventionToInterventionDtos(domainCode, interventions);
                connectionDto.setInterventions(interventionDtos);
            }
            result.add(connectionDto);
        }
        return result;
    }

    protected List<PracticedInterventionDto> practicedInterventionToInterventionDtos(String domainCode, List<PracticedIntervention> interventions) {
        ArrayList interventionDtos = Lists.newArrayListWithCapacity((int)interventions.size());
        Binder binder = BinderFactory.newBinder(PracticedIntervention.class, PracticedInterventionDto.class);
        List abstractActions = this.abstractActionDao.forPracticedInterventionIn(interventions).findAll();
        Map<String, List<AbstractAction>> actionsByInterventionId = PracticedSystemServiceImpl.getActionsByIntervention(abstractActions);
        for (PracticedIntervention intervention : interventions) {
            PracticedInterventionDto interventionDto = new PracticedInterventionDto();
            interventionDtos.add(interventionDto);
            PracticedSystemServiceImpl.bindInterventionToInterventionDto((Binder<PracticedIntervention, PracticedInterventionDto>)binder, intervention, interventionDto);
            interventionDto.setSpeciesStadesDtos(PracticedSystemServiceImpl.getInterventionSpeciesStadeDtos(intervention));
            interventionDto.setActions(actionsByInterventionId.get(intervention.getTopiaId()));
            interventionDto.setInputs(this.inputTopiaDao.findAllByPracticedIntervention((PracticedIntervention)interventionDto));
            interventionDto.setDomainId(domainCode);
        }
        return interventionDtos;
    }

    protected static Map<String, List<AbstractAction>> getActionsByIntervention(List<AbstractAction> abstractActions) {
        HashMap actionsByInterventionId = Maps.newHashMap();
        for (AbstractAction abstractAction : abstractActions) {
            String interId = abstractAction.getPracticedIntervention().getTopiaId();
            List actions = (List)actionsByInterventionId.get(interId);
            if (actions == null) {
                actions = Lists.newArrayList();
                actionsByInterventionId.put(interId, actions);
            }
            actions.add(abstractAction);
        }
        return actionsByInterventionId;
    }

    protected static void bindInterventionToInterventionDto(Binder<PracticedIntervention, PracticedInterventionDto> binder, PracticedIntervention intervention, PracticedInterventionDto interventionDto) {
        binder.copyExcluding((Object)intervention, (Object)interventionDto, new String[]{"speciesStades", "practicedCropCyclePhase", "practicedCropCycleConnection"});
    }

    protected static List<SpeciesStadeDto> getInterventionSpeciesStadeDtos(PracticedIntervention intervention) {
        Collection speciesStades = intervention.getSpeciesStades();
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)speciesStades, (Function)PracticedSystems.SPECIES_STADE_TO_DTO));
    }

    public Map<PracticedCropCycleNodeDto, List<CroppingPlanSpeciesDto>> getNodes(String cycleId) {
        PracticedSeasonalCropCycle cycle = this.getPracticedSeasonalCropCycle(cycleId);
        Map<PracticedCropCycleNodeDto, List<CroppingPlanSpeciesDto>> result = this.getNodesForCycle(cycle);
        return result;
    }

    protected Map<PracticedCropCycleNodeDto, List<CroppingPlanSpeciesDto>> getNodesForCycle(PracticedSeasonalCropCycle cycle) {
        Collection allByPracticedCropCycle = cycle.getCropCycleNodes();
        LinkedHashMap result = Maps.newLinkedHashMap();
        if (allByPracticedCropCycle != null) {
            Iterable nodeDtos = Iterables.transform((Iterable)allByPracticedCropCycle, (Function)PracticedSystems.CROP_CYCLE_NODE_TO_DTO);
            ImmutableMap nodesById = Maps.uniqueIndex((Iterable)allByPracticedCropCycle, (Function)Entities.GET_TOPIA_ID);
            for (PracticedCropCycleNodeDto nodeDto : nodeDtos) {
                ArrayList speciesDtos = Lists.newArrayList();
                result.put(nodeDto, speciesDtos);
                String nodeId = (String)Entities.UNESCAPE_TOPIA_ID.apply((Object)nodeDto.getNodeId());
                PracticedCropCycleNode nodeEntity = (PracticedCropCycleNode)nodesById.get((Object)nodeId);
                Preconditions.checkState((nodeEntity != null ? 1 : 0) != 0, (Object)"Node Entity should not be null with ID: ");
                Pair<CroppingPlanEntry, Map<String, CroppingPlanSpecies>> entryAndSpecies = this.findEntryAndSpeciesFromCode(nodeEntity.getCroppingPlanEntryCode(), cycle.getPracticedSystem().getCampaigns());
                nodeDto.setLabel(((CroppingPlanEntry)entryAndSpecies.getLeft()).getName());
                Iterables.addAll((Collection)speciesDtos, (Iterable)Iterables.transform(((Map)entryAndSpecies.getRight()).values(), (Function)CroppingPlans.CROPPING_PLAN_SPECIES_TO_DTO));
            }
        }
        return result;
    }

    protected Pair<CroppingPlanEntry, Map<String, CroppingPlanSpecies>> findEntryAndSpeciesFromCode(String croppingPlanEntryCode, String campaigns) {
        Set<Integer> campaignsSet = this.getIntCampaigns(campaigns);
        Pair result = this.domainService.getEntryAndSpeciesFromCode(croppingPlanEntryCode, campaignsSet);
        return result;
    }

    protected List<PracticedIntervention> getCropCyclePhaseInterventions(PracticedCropCyclePhase cropCyclePhase) {
        List result = this.practicedInterventionDao.forPracticedCropCyclePhaseEquals(cropCyclePhase).setOrderByArguments(new String[]{"rank"}).findAll();
        return result;
    }

    protected List<PracticedIntervention> getCropCycleNodeConnectionInterventions(PracticedCropCycleConnection cropCycleNodeConnection) {
        List result = this.practicedInterventionDao.forPracticedCropCycleConnectionEquals(cropCycleNodeConnection).setOrderByArguments(new String[]{"rank"}).findAll();
        return result;
    }

    public List<PracticedCropCycleSpeciesDto> getCropCyclePerennialSpecies(String croppingPlanEntryCode, PracticedPerennialCropCycle cycle, String campaigns) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)croppingPlanEntryCode) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)campaigns) ? 1 : 0) != 0);
        final HashMap speciesCodeToCycleEntity = cycle == null ? Maps.newHashMap() : Maps.uniqueIndex((Iterable)cycle.getPracticedCropCycleSpecies(), (Function)PracticedSystems.GET_CROP_CYCLE_PERENNIAL_SPECIES_CODE);
        Pair<CroppingPlanEntry, Map<String, CroppingPlanSpecies>> entryAndSpeciesFromCode = this.findEntryAndSpeciesFromCode(croppingPlanEntryCode, campaigns);
        Function<CroppingPlanSpeciesDto, PracticedCropCycleSpeciesDto> decorateFunction = new Function<CroppingPlanSpeciesDto, PracticedCropCycleSpeciesDto>(){

            public PracticedCropCycleSpeciesDto apply(CroppingPlanSpeciesDto input) {
                String croppingPlanSpeciesCode = input.getCode();
                PracticedCropCycleSpeciesDto result = new PracticedCropCycleSpeciesDto(input);
                PracticedCropCycleSpecies cropCyclePerennialSpecies = (PracticedCropCycleSpecies)speciesCodeToCycleEntity.get(croppingPlanSpeciesCode);
                if (cropCyclePerennialSpecies != null) {
                    result.setOverGraftDate(cropCyclePerennialSpecies.getOverGraftDate());
                    result.setPlantCertified(cropCyclePerennialSpecies.isPlantsCertified());
                    result.setGraftSupport((CropCycleGraftDto)PracticedSystems.REF_VARIETE_TO_GRAPH_DTO.apply((Object)cropCyclePerennialSpecies.getGraftSupport()));
                    result.setGraftClone((CropCycleGraftDto)PracticedSystems.REF_CLONE_TO_GRAPH_DTO.apply((Object)cropCyclePerennialSpecies.getGraftClone()));
                }
                return result;
            }
        };
        Function transformFunction = Functions.compose((Function)decorateFunction, (Function)CroppingPlans.CROPPING_PLAN_SPECIES_TO_DTO);
        Iterable transformed = Iterables.transform(((Map)entryAndSpeciesFromCode.getRight()).values(), (Function)transformFunction);
        ArrayList result = Lists.newArrayList((Iterable)transformed);
        return result;
    }

    public String getCroppingPlanEntryName(String croppingPlanEntryCode) {
        CroppingPlanEntry croppingPlanEntry = (CroppingPlanEntry)this.croppingPlanEntryDao.forCodeEquals(croppingPlanEntryCode).findAny();
        return croppingPlanEntry.getName();
    }

    public List<Price> getPracticedPrices(String practicedSystemId) {
        List result = this.pricesService.getPracticedSystemPrices(practicedSystemId);
        return result;
    }

    public PracticedSystem duplicatePracticedSystem(String practicedSystemId, String growingSystemId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)practicedSystemId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)growingSystemId) ? 1 : 0) != 0);
        PracticedSystem fromPracticedSystem = (PracticedSystem)this.practicedSystemDao.forTopiaIdEquals(practicedSystemId).findUnique();
        GrowingSystem targetedGrowingSystem = (GrowingSystem)this.growingSystemDao.forTopiaIdEquals(growingSystemId).findUnique();
        Set<Integer> campaigns = this.getIntCampaigns(fromPracticedSystem.getCampaigns());
        String targetedDomainCode = targetedGrowingSystem.getGrowingPlan().getDomain().getCode();
        List croppingPlanCodes = this.domainService.getCroppingPlanCodeForDomainsAndCampaigns(targetedDomainCode, campaigns);
        Preconditions.checkArgument((!croppingPlanCodes.isEmpty() ? 1 : 0) != 0);
        PracticedSystem duplicatedPracticedSystem = this.bindPracticedSystemCommonData(fromPracticedSystem, targetedGrowingSystem);
        DuplicateCropCyclesContext duplicateContext = this.getDuplicateCropCyclesContext(fromPracticedSystem, campaigns, targetedDomainCode, croppingPlanCodes, duplicatedPracticedSystem);
        this.duplicatePracticedSystemPlot(fromPracticedSystem, duplicatedPracticedSystem);
        this.duplicateSeasonalCycles(fromPracticedSystem, targetedDomainCode, croppingPlanCodes, duplicatedPracticedSystem, duplicateContext);
        this.duplicatePerennialCropCycles(fromPracticedSystem, croppingPlanCodes, duplicatedPracticedSystem, duplicateContext);
        this.pricesService.duplicatePracticedSystemPrices(duplicateContext);
        this.getTransaction().commit();
        return duplicatedPracticedSystem;
    }

    protected PracticedSystem bindPracticedSystemCommonData(PracticedSystem practicedSystem, GrowingSystem targetedGrowingSystem) {
        Binder practicedSystemBinder = BinderFactory.newBinder(PracticedSystem.class);
        PracticedSystem duplicatedPracticedSystem = (PracticedSystem)this.practicedSystemDao.newInstance();
        practicedSystemBinder.copyExcluding((Object)practicedSystem, (Object)duplicatedPracticedSystem, new String[]{"topiaId", "topiaVersion", "topiaCreateDate", "validated", "validationDate", "growingSystem"});
        duplicatedPracticedSystem.setUpdateDate(this.context.getCurrentDate());
        duplicatedPracticedSystem.setGrowingSystem(targetedGrowingSystem);
        duplicatedPracticedSystem = (PracticedSystem)this.practicedSystemDao.create((TopiaEntity)duplicatedPracticedSystem);
        return duplicatedPracticedSystem;
    }

    protected DuplicateCropCyclesContext getDuplicateCropCyclesContext(PracticedSystem practicedSystem, Set<Integer> campaigns, String targetedDomainCode, List<String> croppingPlanCodes, PracticedSystem practicedSystemClone) {
        Map speciesByCrop = this.domainService.findSpeciesCodeByCropCodeForCampaigns(croppingPlanCodes, campaigns);
        List<String> toolsCouplingsCodes = this.getToolsCouplingsCodesFromDomainAndCampaigns(targetedDomainCode, practicedSystem.getCampaigns());
        DuplicateCropCyclesContext duplicateContext = new DuplicateCropCyclesContext();
        duplicateContext.setSpeciesByCropCode(speciesByCrop);
        duplicateContext.setToolsCouplingsCode(toolsCouplingsCodes);
        duplicateContext.setPracticedSystem(practicedSystem);
        duplicateContext.setPracticedSystemClone(practicedSystemClone);
        return duplicateContext;
    }

    protected void duplicatePerennialCropCycles(PracticedSystem practicedSystem, List<String> croppingPlanCodes, PracticedSystem practicedSystemClone, DuplicateCropCyclesContext duplicateContext) {
        List perennialCropCycles = this.practicedPerennialCropCycleDao.forPracticedSystemEquals(practicedSystem).findAll();
        Binder perennialCropCycleBinder = BinderFactory.newBinder(PracticedPerennialCropCycle.class);
        for (PracticedPerennialCropCycle cycle : perennialCropCycles) {
            Collection cycleSpecies;
            if (!croppingPlanCodes.contains(cycle.getCroppingPlanEntryCode())) continue;
            PracticedPerennialCropCycle cycleClone = (PracticedPerennialCropCycle)this.practicedPerennialCropCycleDao.newInstance();
            perennialCropCycleBinder.copyExcluding((Object)cycle, (Object)cycleClone, new String[]{"topiaId", "topiaVersion", "topiaCreateDate", "practicedSystem", "cropCyclePhases", "practicedCropCycleSpecies"});
            cycleClone.setPracticedSystem(practicedSystemClone);
            Collection phases = cycle.getCropCyclePhases();
            if (phases != null) {
                Binder phaseBinder = BinderFactory.newBinder(PracticedCropCyclePhase.class);
                for (PracticedCropCyclePhase phase : phases) {
                    PracticedCropCyclePhase phaseClone = (PracticedCropCyclePhase)this.practicedCropCyclePhaseDao.newInstance();
                    phaseBinder.copyExcluding((Object)phase, (Object)phaseClone, new String[]{"topiaId", "topiaVersion", "topiaCreateDate"});
                    cycleClone.addCropCyclePhases(phaseClone);
                    phaseClone = (PracticedCropCyclePhase)this.practicedCropCyclePhaseDao.create((TopiaEntity)phaseClone);
                    this.duplicateInterventions(duplicateContext, cycle.getCroppingPlanEntryCode(), phase, phaseClone, null, null);
                }
            }
            if ((cycleSpecies = cycle.getPracticedCropCycleSpecies()) != null && duplicateContext.getSpeciesByCropCode() != null && duplicateContext.getSpeciesByCropCode().get(cycle.getCroppingPlanEntryCode()) != null) {
                Pair pair = (Pair)duplicateContext.getSpeciesByCropCode().get(cycle.getCroppingPlanEntryCode());
                Map speciesByCode = (Map)pair.getValue();
                Binder speciesBinder = BinderFactory.newBinder(PracticedCropCycleSpecies.class);
                for (PracticedCropCycleSpecies species : cycleSpecies) {
                    if (speciesByCode == null || !speciesByCode.containsKey(species.getCroppingPlanSpeciesCode())) continue;
                    PracticedCropCycleSpecies speciesClone = (PracticedCropCycleSpecies)this.practicedCropCycleSpeciesDao.newInstance();
                    speciesBinder.copyExcluding((Object)species, (Object)speciesClone, new String[]{"topiaId", "topiaVersion", "topiaCreateDate"});
                    cycleClone.addPracticedCropCycleSpecies(speciesClone);
                }
            }
            this.practicedPerennialCropCycleDao.create((TopiaEntity)cycleClone);
        }
    }

    protected void duplicateSeasonalCycles(PracticedSystem practicedSystem, String targetedDomainCode, List<String> croppingPlanCodes, PracticedSystem practicedSystemClone, DuplicateCropCyclesContext duplicateContext) {
        List seasonalCropCycles = this.practicedSeasonalCropCycleDao.forPracticedSystemEquals(practicedSystem).findAll();
        Binder seasonalCropCycleBinder = BinderFactory.newBinder(PracticedSeasonalCropCycle.class);
        for (PracticedSeasonalCropCycle cycle : seasonalCropCycles) {
            PracticedSeasonalCropCycle duplicatedSeasonalCycle = this.bindPracticedSeasonalCropCycle((Binder<PracticedSeasonalCropCycle, PracticedSeasonalCropCycle>)seasonalCropCycleBinder, cycle);
            duplicatedSeasonalCycle.setPracticedSystem(practicedSystemClone);
            Map<PracticedCropCycleNode, PracticedCropCycleNode> nodeCache = this.duplicateSeasonalNodes(practicedSystem, targetedDomainCode, croppingPlanCodes, cycle, duplicatedSeasonalCycle);
            this.practicedSeasonalCropCycleDao.create((TopiaEntity)duplicatedSeasonalCycle);
            this.duplicateSeasonalConnection(croppingPlanCodes, duplicateContext, cycle, nodeCache);
        }
    }

    protected void duplicateSeasonalConnection(List<String> croppingPlanCodes, DuplicateCropCyclesContext duplicateContext, PracticedSeasonalCropCycle cycle, Map<PracticedCropCycleNode, PracticedCropCycleNode> nodeCache) {
        List<PracticedCropCycleConnection> seasonalConnections = this.practicedCropCycleConnectionDao.findAllByCropCycle(cycle.getTopiaId());
        Binder seasonalConnectionBinder = BinderFactory.newBinder(PracticedCropCycleConnection.class);
        for (PracticedCropCycleConnection seasonalConnection : seasonalConnections) {
            PracticedCropCycleConnection duplicatedConnection = this.bindPracticedCropCycleConnection((Binder<PracticedCropCycleConnection, PracticedCropCycleConnection>)seasonalConnectionBinder, seasonalConnection);
            duplicatedConnection.setSource(nodeCache.get(seasonalConnection.getSource()));
            duplicatedConnection.setTarget(nodeCache.get(seasonalConnection.getTarget()));
            this.setDuplicatedConnectionIntermediateCrop(croppingPlanCodes, seasonalConnection, duplicatedConnection);
            duplicatedConnection = (PracticedCropCycleConnection)this.practicedCropCycleConnectionDao.create((TopiaEntity)duplicatedConnection);
            this.duplicateInterventions(duplicateContext, null, null, null, seasonalConnection, duplicatedConnection);
        }
    }

    protected void setDuplicatedConnectionIntermediateCrop(List<String> croppingPlanCodes, PracticedCropCycleConnection seasonalConnection, PracticedCropCycleConnection duplicatedConnection) {
        if (seasonalConnection.getIntermediateCroppingPlanEntryCode() != null && croppingPlanCodes.contains(seasonalConnection.getIntermediateCroppingPlanEntryCode())) {
            duplicatedConnection.setIntermediateCroppingPlanEntryCode(seasonalConnection.getIntermediateCroppingPlanEntryCode());
        }
    }

    protected PracticedCropCycleConnection bindPracticedCropCycleConnection(Binder<PracticedCropCycleConnection, PracticedCropCycleConnection> seasonalConnectionBinder, PracticedCropCycleConnection seasonalConnection) {
        PracticedCropCycleConnection connectionClone = (PracticedCropCycleConnection)this.practicedCropCycleConnectionDao.newInstance();
        seasonalConnectionBinder.copyExcluding((Object)seasonalConnection, (Object)connectionClone, new String[]{"topiaId", "topiaVersion", "topiaCreateDate", "source", "target", "intermediateCroppingPlanEntryCode"});
        return connectionClone;
    }

    protected Map<PracticedCropCycleNode, PracticedCropCycleNode> duplicateSeasonalNodes(PracticedSystem practicedSystem, String targetedDomainCode, List<String> croppingPlanCodes, PracticedSeasonalCropCycle cycle, PracticedSeasonalCropCycle duplicatedSeasonalCycle) {
        Collection seasonalNodes = cycle.getCropCycleNodes();
        Binder seasonalNodeBinder = BinderFactory.newBinder(PracticedCropCycleNode.class);
        HashMap nodeCache = Maps.newHashMap();
        for (PracticedCropCycleNode seasonalNode : seasonalNodes) {
            if (croppingPlanCodes.contains(seasonalNode.getCroppingPlanEntryCode())) {
                PracticedCropCycleNode nodeClone = (PracticedCropCycleNode)this.practicedCropCycleNodeDao.newInstance();
                seasonalNodeBinder.copyExcluding((Object)seasonalNode, (Object)nodeClone, new String[]{"topiaId", "topiaVersion", "topiaCreateDate", "practicedSeasonalCropCycle"});
                nodeClone.setPracticedSeasonalCropCycle(duplicatedSeasonalCycle);
                duplicatedSeasonalCycle.addCropCycleNodes(nodeClone);
                nodeCache.put(seasonalNode, nodeClone);
                continue;
            }
            throw new AgrosystDuplicationException(String.format("Un noeud du cycle de culture saisonnaire n'a pu \u00eatre cr\u00e9\u00e9, la culture dont le code est '%s' n'a pu \u00eatre retrouv\u00e9e sur le domaine au code '%s' et les campagnes:%s", seasonalNode.getCroppingPlanEntryCode(), targetedDomainCode, practicedSystem.getCampaigns()));
        }
        return nodeCache;
    }

    protected PracticedSeasonalCropCycle bindPracticedSeasonalCropCycle(Binder<PracticedSeasonalCropCycle, PracticedSeasonalCropCycle> seasonalCropCycleBinder, PracticedSeasonalCropCycle cycle) {
        PracticedSeasonalCropCycle duplicatedSeasonalCycle = (PracticedSeasonalCropCycle)this.practicedSeasonalCropCycleDao.newInstance();
        seasonalCropCycleBinder.copyExcluding((Object)cycle, (Object)duplicatedSeasonalCycle, new String[]{"topiaId", "topiaVersion", "topiaCreateDate", "practicedSystem", "cropCycleNodes"});
        return duplicatedSeasonalCycle;
    }

    public void duplicatePracticedSystemPlot(PracticedSystem practicedSystem, PracticedSystem practicedSystemClone) {
        List practicedPlots = this.practicedPlotDao.forPracticedSystemEquals(practicedSystem).findAll();
        Binder practicedPlotBinder = BinderFactory.newBinder(PracticedPlot.class);
        for (PracticedPlot practicedPlot : practicedPlots) {
            PracticedPlot plotClone = (PracticedPlot)this.practicedPlotDao.newInstance();
            practicedPlotBinder.copyExcluding((Object)practicedPlot, (Object)plotClone, new String[]{"topiaId", "topiaVersion", "topiaCreateDate", "practicedSystem", "solHorizon", "plotZonings", "adjacentElements"});
            plotClone.setPracticedSystem(practicedSystemClone);
            if (practicedPlot.getSolHorizon() != null) {
                Binder binderSH = BinderFactory.newBinder(SolHorizon.class);
                for (SolHorizon solHorizon : practicedPlot.getSolHorizon()) {
                    SolHorizon solHorizonClone = (SolHorizon)this.solHorizonDao.newInstance();
                    binderSH.copyExcluding((Object)solHorizon, (Object)solHorizonClone, new String[]{"topiaId", "topiaVersion", "topiaCreateDate"});
                    plotClone.addSolHorizon(solHorizonClone);
                }
            }
            if (practicedPlot.getPlotZonings() != null) {
                plotClone.setPlotZonings((Collection)Lists.newArrayList((Iterable)practicedPlot.getPlotZonings()));
            }
            if (practicedPlot.getAdjacentElements() != null) {
                plotClone.setAdjacentElements((Collection)Lists.newArrayList((Iterable)practicedPlot.getAdjacentElements()));
            }
            this.practicedPlotDao.create((TopiaEntity)plotClone);
        }
    }

    public void unactivatePracticedSystem(List<String> practicedSystemIds, boolean activate) {
        if (practicedSystemIds != null && !practicedSystemIds.isEmpty()) {
            for (String practicedSystemId : practicedSystemIds) {
                PracticedSystem practicedSystem = (PracticedSystem)this.practicedSystemDao.forTopiaIdEquals(practicedSystemId).findUnique();
                practicedSystem.setActive(activate);
                this.practicedSystemDao.update((TopiaEntity)practicedSystem);
            }
            this.getTransaction().commit();
        }
    }

    protected void duplicateInterventions(DuplicateCropCyclesContext duplicateContext, String phaseTargetedCropCode, PracticedCropCyclePhase phase, PracticedCropCyclePhase phaseClone, PracticedCropCycleConnection connection, PracticedCropCycleConnection connectionClone) {
        Preconditions.checkArgument((boolean)(phase != null ^ connection != null));
        Preconditions.checkArgument((boolean)(phaseClone != null ^ connectionClone != null));
        Collection<PracticedIntervention> practicedInterventions = this.getPracticedSystemInterventions(phase, connection);
        Binder interventionBinder = BinderFactory.newBinder(PracticedIntervention.class);
        for (PracticedIntervention practicedIntervention : practicedInterventions) {
            PracticedIntervention interventionClone = this.bindPracticedIntervention((Binder<PracticedIntervention, PracticedIntervention>)interventionBinder, practicedIntervention);
            this.setInterventionIntermedaiteStatus(phaseClone, connectionClone, interventionClone);
            this.addToolsCouplingCodesToIntervention(duplicateContext, practicedIntervention, interventionClone);
            duplicateContext.setTargetedCropCode(this.getInterventionCropTarget(phaseTargetedCropCode, phaseClone, connectionClone, interventionClone));
            this.addSpeciesStadesToIntervention(duplicateContext, practicedIntervention, interventionClone);
            this.practicedInterventionDao.create((TopiaEntity)interventionClone);
            this.actionService.duplicatePracticedActions(duplicateContext, practicedIntervention, interventionClone);
        }
    }

    protected Collection<PracticedIntervention> getPracticedSystemInterventions(PracticedCropCyclePhase phase, PracticedCropCycleConnection connection) {
        List practicedInterventions = phase != null ? this.practicedInterventionDao.forPracticedCropCyclePhaseEquals(phase).findAll() : this.practicedInterventionDao.forPracticedCropCycleConnectionEquals(connection).findAll();
        return practicedInterventions;
    }

    protected void addSpeciesStadesToIntervention(DuplicateCropCyclesContext duplicateContext, PracticedIntervention practicedIntervention, PracticedIntervention interventionClone) {
        Pair pair;
        if (practicedIntervention.getSpeciesStades() != null && (pair = (Pair)duplicateContext.getSpeciesByCropCode().get(duplicateContext.getTargetedCropCode())) != null) {
            Map speciesByCode = (Map)pair.getValue();
            Binder speciesBinder = BinderFactory.newBinder(PracticedSpeciesStade.class);
            for (PracticedSpeciesStade speciesStade : practicedIntervention.getSpeciesStades()) {
                if (speciesByCode == null || !speciesByCode.containsKey(speciesStade.getSpeciesCode())) continue;
                PracticedSpeciesStade speciesClone = (PracticedSpeciesStade)this.practicedSpeciesStadeDao.newInstance();
                speciesBinder.copyExcluding((Object)speciesStade, (Object)speciesClone, new String[]{"topiaId", "topiaVersion", "topiaCreateDate"});
                interventionClone.addSpeciesStades(speciesClone);
            }
        }
    }

    protected void addToolsCouplingCodesToIntervention(DuplicateCropCyclesContext duplicateContext, PracticedIntervention practicedIntervention, PracticedIntervention interventionClone) {
        Collection practicedSystemToolsCouplingsCodes = duplicateContext.getToolsCouplingsCode();
        if (practicedIntervention.getToolsCouplingCodes() != null && practicedSystemToolsCouplingsCodes != null) {
            ArrayList interventionToolsCouplingCodes = Lists.newArrayList();
            for (String toolsCouplingCode : practicedIntervention.getToolsCouplingCodes()) {
                if (!practicedSystemToolsCouplingsCodes.contains(toolsCouplingCode)) continue;
                interventionToolsCouplingCodes.add(toolsCouplingCode);
            }
            interventionClone.setToolsCouplingCodes((Collection)interventionToolsCouplingCodes);
        }
    }

    protected PracticedIntervention bindPracticedIntervention(Binder<PracticedIntervention, PracticedIntervention> interventionBinder, PracticedIntervention practicedIntervention) {
        PracticedIntervention interventionClone = (PracticedIntervention)this.practicedInterventionDao.newInstance();
        interventionBinder.copyExcluding((Object)practicedIntervention, (Object)interventionClone, new String[]{"topiaId", "topiaVersion", "topiaCreateDate", "practicedCropCycleConnection", "practicedCropCyclePhase", "speciesStades", "toolsCouplingCodes"});
        return interventionClone;
    }

    protected void setInterventionIntermedaiteStatus(PracticedCropCyclePhase phaseClone, PracticedCropCycleConnection connectionClone, PracticedIntervention interventionClone) {
        if (phaseClone != null) {
            interventionClone.setPracticedCropCyclePhase(phaseClone);
        } else {
            if (connectionClone.getIntermediateCroppingPlanEntryCode() != null && interventionClone.isIntermediateCrop()) {
                interventionClone.setIntermediateCrop(true);
            } else {
                interventionClone.setIntermediateCrop(false);
            }
            interventionClone.setPracticedCropCycleConnection(connectionClone);
        }
    }

    protected String getInterventionCropTarget(String phaseTargetedCropCode, PracticedCropCyclePhase phaseClone, PracticedCropCycleConnection connectionClone, PracticedIntervention interventionClone) {
        String cropCode = phaseClone != null ? phaseTargetedCropCode : (connectionClone.getIntermediateCroppingPlanEntryCode() != null && interventionClone.isIntermediateCrop() ? connectionClone.getIntermediateCroppingPlanEntryCode() : connectionClone.getTarget().getCroppingPlanEntryCode());
        return cropCode;
    }

    public String getdomainCode(String growingSystemId) {
        String domainCode = this.domainService.getDomainCodeForGrowingSystem(growingSystemId);
        return domainCode;
    }

    public PracticedSystem validate(String practicedSystemId) {
        this.authorizationService.checkValidatePracticedSystem(practicedSystemId);
        this.practicedSystemDao.validatePracticedSystem(practicedSystemId, this.context.getCurrentDate());
        this.getTransaction().commit();
        this.getPersistenceContext().getHibernateSupport().getHibernateSession().clear();
        PracticedSystem practicedSystem = (PracticedSystem)this.practicedSystemDao.forTopiaIdEquals(practicedSystemId).findUnique();
        return practicedSystem;
    }

    public InputStream exportPracticedSystemsAsXlsStream(List<String> practicesSystemIds) {
        LinkedHashMap sheet = Maps.newLinkedHashMap();
        PracticedSystemMetadata.PracticedSystemMainBeanInfo practicedSystemMainTab = new PracticedSystemMetadata.PracticedSystemMainBeanInfo();
        PracticedSystemMetadata.PracticedSeasonalCropCycleBeanInfo seasonalCropCycleTab = new PracticedSystemMetadata.PracticedSeasonalCropCycleBeanInfo();
        PracticedSystemMetadata.PracticedPerennialCropCycleBeanInfo perennialCropCycleTab = new PracticedSystemMetadata.PracticedPerennialCropCycleBeanInfo();
        PracticedSystemMetadata.PracticedPerennialCropCycleSpeciesBeanInfo perennialCropCycleSpeciesTab = new PracticedSystemMetadata.PracticedPerennialCropCycleSpeciesBeanInfo();
        PracticedSystemMetadata.PracticedITKBeanInfo itkTab = new PracticedSystemMetadata.PracticedITKBeanInfo();
        ExportUtils.addAllBeanInfo(sheet, practicedSystemMainTab, seasonalCropCycleTab, perennialCropCycleTab, perennialCropCycleSpeciesTab, itkTab);
        try {
            if (CollectionUtils.isNotEmpty(practicesSystemIds)) {
                Iterable practicedSystems = this.practicedSystemDao.forTopiaIdIn(practicesSystemIds).findAllLazy(100);
                for (PracticedSystem practicedSystem : practicedSystems) {
                    practicedSystem = this.anonymizeService.checkForPracticedSystemAnonymization(practicedSystem);
                    PracticedSystemEntity model = new PracticedSystemEntity();
                    model.setPracticedSystemName(practicedSystem.getName());
                    model.setCampaigns(practicedSystem.getCampaigns());
                    model.setGrowingSystemName(practicedSystem.getGrowingSystem().getName());
                    model.setGrowingPlanName(practicedSystem.getGrowingSystem().getGrowingPlan().getName());
                    model.setDomainName(practicedSystem.getGrowingSystem().getGrowingPlan().getDomain().getName());
                    ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, practicedSystem, (EntityExportTabInfo)practicedSystemMainTab);
                    List<PracticedSeasonalCropCycleDto> seasonalCropCycleDtos = this.getAllPracticedSeasonalCropCycles(practicedSystem.getTopiaId());
                    List<PracticedPerennialCropCycleDto> perennialCycleDtos = this.getAllPracticedPerennialCropCycles(practicedSystem.getTopiaId());
                    List phaseEntities = (List)sheet.get(perennialCropCycleTab);
                    List speciesEntities = (List)sheet.get(perennialCropCycleSpeciesTab);
                    List itkEntities = (List)sheet.get(itkTab);
                    if (seasonalCropCycleDtos != null) {
                        for (PracticedSeasonalCropCycleDto seasonalCropCycleDto : seasonalCropCycleDtos) {
                            HashMap seasonalCropCycleEntityExports = Maps.newHashMap();
                            List nodeDtos = seasonalCropCycleDto.getCropCycleNodeDtos();
                            for (PracticedCropCycleNodeDto node : nodeDtos) {
                                PracticedSeasonalEntityExport entityExport = new PracticedSeasonalEntityExport();
                                entityExport.setLabel(node.getLabel());
                                entityExport.setEndCycle(node.isEndCycle());
                                entityExport.setSameCampaignAsPreviousNode(node.isSameCampaignAsPreviousNode());
                                entityExport.setInitNodeFrequency(node.getInitNodeFrequency());
                                entityExport.setX(node.getX());
                                seasonalCropCycleEntityExports.put(node.getNodeId(), entityExport);
                            }
                            List cropCycleConnectionDtos = seasonalCropCycleDto.getCropCycleConnectionDtos();
                            for (PracticedCropCycleConnectionDto connection : cropCycleConnectionDtos) {
                                if (StringUtils.isNotBlank((CharSequence)connection.getIntermediateCropName())) {
                                    PracticedSeasonalEntityExport entityExport = (PracticedSeasonalEntityExport)seasonalCropCycleEntityExports.get(connection.getTargetId());
                                    entityExport.setIntermediateCropName(connection.getIntermediateCropName());
                                }
                                if (StringUtils.isNotBlank((CharSequence)connection.getSourceId())) {
                                    PracticedSeasonalEntityExport sourceEntityExport = (PracticedSeasonalEntityExport)seasonalCropCycleEntityExports.get(connection.getSourceId());
                                    PracticedSeasonalEntityExport targetEntityExport = (PracticedSeasonalEntityExport)seasonalCropCycleEntityExports.get(connection.getTargetId());
                                    targetEntityExport.setPreviousCrop(sourceEntityExport.getLabel());
                                }
                                if (connection.getCroppingPlanEntryFrequency() == null) continue;
                                PracticedSeasonalEntityExport targetEntityExport = (PracticedSeasonalEntityExport)seasonalCropCycleEntityExports.get(connection.getTargetId());
                                targetEntityExport.setCroppingPlanEntryFrequency(connection.getCroppingPlanEntryFrequency());
                            }
                            for (PracticedSeasonalEntityExport entityExport : seasonalCropCycleEntityExports.values()) {
                                PracticedSystemEntity export = (PracticedSystemEntity)model.clone();
                                ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, export, entityExport, (EntityExportTabInfo)seasonalCropCycleTab);
                            }
                            for (PracticedCropCycleConnectionDto connection : cropCycleConnectionDtos) {
                                List itks = connection.getInterventions();
                                PracticedSeasonalEntityExport node = (PracticedSeasonalEntityExport)seasonalCropCycleEntityExports.get(connection.getTargetId());
                                String cropName = node.getLabel();
                                Integer rank = node.getX();
                                String previousCropName = node.getPreviousCrop();
                                if (itks == null) continue;
                                for (PracticedInterventionDto itk : itks) {
                                    PracticedSystemEntity export = this.exportCommonInterventionFields(model, true, cropName, previousCropName, rank, null, itk);
                                    this.exportToolsCouplingsSpeciesActionsInputsFields(itkEntities, itk, export);
                                }
                            }
                        }
                    }
                    if (!sheet.containsKey(perennialCropCycleTab)) {
                        sheet.put(perennialCropCycleTab, phaseEntities);
                    }
                    if (!sheet.containsKey(perennialCropCycleSpeciesTab)) {
                        sheet.put(perennialCropCycleSpeciesTab, speciesEntities);
                    }
                    if (!sheet.containsKey(itkTab)) {
                        sheet.put(itkTab, itkEntities);
                    }
                    if (perennialCycleDtos == null || perennialCycleDtos.isEmpty()) continue;
                    for (PracticedPerennialCropCycleDto cycleDto : perennialCycleDtos) {
                        String cropName = cycleDto.getCroppingPlanEntryName();
                        for (PracticedCropCyclePhaseDto phase : cycleDto.getCropCyclePhaseDtos()) {
                            PracticedSystemEntity export = (PracticedSystemEntity)model.clone();
                            ExportUtils.copyFields(cycleDto.getPracticedPerennialCropCycle(), (EntityExportExtra)export, null, "plantingYear", "plantingInterFurrow", "plantingSpacing", "plantingDensity", "orchardFrutalForm", "vineFrutalForm", "orientation", "plantingDeathRate", "plantingDeathRateMeasureYear", "weedType", "pollinator", "pollinatorPercent", "pollinatorSpreadMode", "otherCharacteristics");
                            ExportUtils.setExtraField(export, "label", cropName);
                            ExportUtils.setExtraField(export, "phaseType", phase.getType());
                            ExportUtils.setExtraField(export, "phaseDuration", phase.getDuration());
                            phaseEntities.add(export);
                            List itks = phase.getInterventions();
                            if (itks == null || itks.isEmpty()) continue;
                            for (PracticedInterventionDto itk : itks) {
                                export = this.exportCommonInterventionFields(model, true, cropName, null, null, phase.getType(), itk);
                                this.exportToolsCouplingsSpeciesActionsInputsFields(itkEntities, itk, export);
                            }
                        }
                        List speciesDtos = cycleDto.getSpeciesDto();
                        if (speciesDtos.isEmpty()) continue;
                        for (PracticedCropCyclePhaseDto phase : cycleDto.getCropCyclePhaseDtos()) {
                            for (PracticedCropCycleSpeciesDto speciesDto : speciesDtos) {
                                PracticedSystemEntity export = (PracticedSystemEntity)model.clone();
                                ExportUtils.setExtraField(export, "croppingPlanEntryName", cycleDto.getCroppingPlanEntryName());
                                ExportUtils.setExtraField(export, "phase", phase.getType());
                                ExportUtils.copyFields(speciesDto, (EntityExportExtra)export, null, "speciesEspece", "speciesQualifiant", "speciesTypeSaisonnier", "speciesDestination", "varietyLibelle", "profil_vegetatif_BBCH", "plantCertified", "overGraftDate");
                                String graftSupport = speciesDto.getGraftSupport() != null ? speciesDto.getGraftSupport().getLabel() : null;
                                ExportUtils.setExtraField(export, "graftSupport", graftSupport);
                                String graftClone = speciesDto.getGraftClone() != null ? speciesDto.getGraftClone().getLabel() : null;
                                ExportUtils.setExtraField(export, "graftClone", graftClone);
                                speciesEntities.add(export);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new AgrosystTechnicalException("Can't copy properties", (Throwable)ex);
        }
        EntityExporter exporter = new EntityExporter();
        InputStream stream = exporter.exportAsXlsStream(sheet);
        return stream;
    }

    public void importPZ0PracticedSystems(Map<Class, ImportResults> allResults) {
        ImportResults importResults = allResults.remove(PracticedSystem.class);
        if (importResults != null && importResults.getIgnoredRecords() == 0) {
            try {
                Map entitiesAndDependencies = importResults.getEntityAndDepsByCsvIds();
                for (EntityAndDependencies entityAndDependencies : entitiesAndDependencies.values()) {
                    PracticedSystemAndDependencies practicedSystemAndDependencies = (PracticedSystemAndDependencies)entityAndDependencies;
                    PracticedSystem practicedSystem = practicedSystemAndDependencies.getEntity();
                    List pz0PracticedPerennialCropCycles = practicedSystemAndDependencies.getPz0PracticedPerennialCropCycles();
                    List<PracticedPerennialCropCycleDto> practicedPerennialCropCycleDtos = this.getPracticedPerennialCropCycleDtos(pz0PracticedPerennialCropCycles);
                    List pz0PracticedSeasonalCropCycles = practicedSystemAndDependencies.getPz0PracticedSeasonalCropCycles();
                    List<PracticedSeasonalCropCycleDto> practicedSeasonalCropCycleDtos = this.getPracticedSeasonalCropCycleDtos(pz0PracticedSeasonalCropCycles);
                    List prices = practicedSystemAndDependencies.getPrices();
                    practicedSystem = this.createOrUpdatePracticedSystemWithoutCommit(practicedSystem, practicedPerennialCropCycleDtos, practicedSeasonalCropCycleDtos, prices);
                    practicedSystemAndDependencies.setEntity((TopiaEntity)practicedSystem);
                }
            }
            catch (Exception e) {
                throw new AgrosystImportException("Echec de persistance des syst\u00e8mes synth\u00e9tis\u00e9", (Throwable)e);
            }
        }
    }

    protected List<PracticedPerennialCropCycleDto> getPracticedPerennialCropCycleDtos(List<Pz0PracticedPerennialCropCycle> pz0PracticedPerennialCropCycles) {
        Iterable PracticedPerennialCropCycleDtoView = Iterables.transform(pz0PracticedPerennialCropCycles, this.Pz0PracticedPerennialCropCycleToPracticedPerennialCropCycleDto());
        return Lists.newArrayList((Iterable)PracticedPerennialCropCycleDtoView);
    }

    protected List<PracticedSeasonalCropCycleDto> getPracticedSeasonalCropCycleDtos(List<Pz0PracticedSeasonalCropCycle> pz0PracticedSeasonalCropCycles) {
        Iterable pz0PracticedSeasonalCropCyclesView = Iterables.transform(pz0PracticedSeasonalCropCycles, this.pz0PracticedSeasonalCropCycleToPracticedSeasonalCropCycleDto());
        return Lists.newArrayList((Iterable)pz0PracticedSeasonalCropCyclesView);
    }

    protected Function<Pz0PracticedPerennialCropCycle, PracticedPerennialCropCycleDto> Pz0PracticedPerennialCropCycleToPracticedPerennialCropCycleDto() {
        return new Function<Pz0PracticedPerennialCropCycle, PracticedPerennialCropCycleDto>(){

            public PracticedPerennialCropCycleDto apply(Pz0PracticedPerennialCropCycle input) {
                return input.getPracticedPerennialCropCycleDto();
            }
        };
    }

    protected Function<Pz0PracticedSeasonalCropCycle, PracticedSeasonalCropCycleDto> pz0PracticedSeasonalCropCycleToPracticedSeasonalCropCycleDto() {
        return new Function<Pz0PracticedSeasonalCropCycle, PracticedSeasonalCropCycleDto>(){

            public PracticedSeasonalCropCycleDto apply(Pz0PracticedSeasonalCropCycle input) {
                return input.getPracticedSeasonalCropCycleDto();
            }
        };
    }

    protected void exportToolsCouplingsSpeciesActionsInputsFields(List<PracticedSystemEntity> itkEntities, PracticedInterventionDto itk, PracticedSystemEntity model) throws CloneNotSupportedException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        if (itk.getToolsCouplingCodes() != null && !itk.getToolsCouplingCodes().isEmpty()) {
            Collection tcCodes = itk.getToolsCouplingCodes();
            for (String tcCode : tcCodes) {
                ToolsCoupling toolsCoupling = (ToolsCoupling)this.toolsCouplingDao.forProperties("code", tcCode, new Object[0]).findAny();
                ExportUtils.setExtraField(model, "toolsCouplings", toolsCoupling.getToolsCouplingName());
                this.exportSpeciesActionsInputsFields(itkEntities, itk, model);
            }
        } else {
            this.exportSpeciesActionsInputsFields(itkEntities, itk, model);
        }
    }

    protected void exportSpeciesActionsInputsFields(List<PracticedSystemEntity> itkEntities, PracticedInterventionDto itk, PracticedSystemEntity model) throws CloneNotSupportedException {
        if (itk.getSpeciesStadesDtos() != null && !itk.getSpeciesStadesDtos().isEmpty()) {
            for (SpeciesStadeDto stade : itk.getSpeciesStadesDtos()) {
                List actions = itk.getActions();
                for (AbstractAction action : actions) {
                    this.exportSpeciesStadeFields(stade, model);
                    this.exportActionFields(action, model);
                    this.exportInputsFields(itkEntities, itk, model);
                }
            }
        } else {
            List actions = itk.getActions();
            for (AbstractAction action : actions) {
                this.exportActionFields(action, model);
                this.exportInputsFields(itkEntities, itk, model);
            }
        }
    }

    protected void exportSpeciesStadeFields(SpeciesStadeDto speciesStadeDto, PracticedSystemEntity model) {
        ExportUtils.setExtraField(model, "species", speciesStadeDto.getSpeciesName());
        String stadeMin = speciesStadeDto.getStadeMin() != null ? speciesStadeDto.getStadeMin().getLabel() : null;
        ExportUtils.setExtraField(model, "stadeMin", stadeMin);
        String stadeMax = speciesStadeDto.getStadeMax() != null ? speciesStadeDto.getStadeMax().getLabel() : null;
        ExportUtils.setExtraField(model, "stadeMax", stadeMax);
    }

    protected void exportActionFields(AbstractAction action, PracticedSystemEntity export) {
        ExportUtils.setExtraField(export, "actionType", action.getMainAction().getIntervention_agrosyst());
        ExportUtils.setExtraField(export, "action", action.getMainAction().getReference_label());
        ExportUtils.setExtraField(export, "mainAction", StringUtils.isNotBlank((CharSequence)action.getToolsCouplingCode()));
    }

    protected void exportInputsFields(List<PracticedSystemEntity> itkEntities, PracticedInterventionDto itk, PracticedSystemEntity export) throws CloneNotSupportedException {
        List inputs = itk.getInputs();
        if (inputs != null && !inputs.isEmpty()) {
            for (AbstractInput input : inputs) {
                PracticedSystemEntity model = (PracticedSystemEntity)export.clone();
                String unit = "";
                AgrosystInterventionType actionType = input.getInputType();
                switch (actionType) {
                    case APPLICATION_DE_PRODUITS_FERTILISANTS_MINERAUX: {
                        unit = ((MineralProductInput)input).getMineralProductUnit().name();
                        break;
                    }
                    case EPANDAGES_ORGANIQUES: {
                        unit = ((OrganicProductInput)input).getOrganicProductUnit().name();
                        break;
                    }
                    case APPLICATION_DE_PRODUITS_PHYTOSANITAIRES: 
                    case LUTTE_BIOLOGIQUE: 
                    case SEMIS: {
                        if (((PhytoProductInput)input).getPhytoProductUnit() == null) break;
                        unit = ((PhytoProductInput)input).getPhytoProductUnit().name();
                        break;
                    }
                    case AUTRE: {
                        unit = ((OtherProductInput)input).getOtherProductQtUnit();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported input type: " + actionType);
                    }
                }
                ExportUtils.setExtraField(model, "inputType", input.getInputType());
                ExportUtils.setExtraField(model, "product", input.getProductName());
                ExportUtils.setExtraField(model, "qtMin", input.getQtMin());
                ExportUtils.setExtraField(model, "qtAvg", input.getQtAvg());
                ExportUtils.setExtraField(model, "qtMed", input.getQtMed());
                ExportUtils.setExtraField(model, "qtMax", input.getQtMax());
                ExportUtils.setExtraField(model, "unit", unit);
                itkEntities.add(model);
            }
        } else {
            PracticedSystemEntity model = (PracticedSystemEntity)export.clone();
            itkEntities.add(model);
        }
    }

    protected PracticedSystemEntity exportCommonInterventionFields(PracticedSystemEntity model, boolean isSeasonal, String cropName, String previousCropName, Integer rank, CropCyclePhaseType phaseType, PracticedInterventionDto itk) throws CloneNotSupportedException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        PracticedSystemEntity export = (PracticedSystemEntity)model.clone();
        String cycle = isSeasonal ? "Assol\u00e9" : "P\u00e9renne";
        ExportUtils.setExtraField(export, "itk_cycle", cycle);
        ExportUtils.setExtraField(export, "itk_crop", cropName);
        ExportUtils.setExtraField(export, "itk_previous_crop", previousCropName);
        ExportUtils.setExtraField(export, "itk_rank", rank == null ? null : Integer.valueOf(rank + 1));
        ExportUtils.setExtraField(export, "itk_phase", phaseType);
        ExportUtils.copyFields(itk, (EntityExportExtra)export, null, "name", "type", "startingPeriodDate", "endingPeriodDate", "spatialFrequency", "progressionSpeed", "involvedPeopleNumber", "workRate", "intermediateCrop", "comment");
        Double workRate = itk.getWorkRate();
        Double spendingTime = workRate != null && workRate != 0.0 ? Double.valueOf(1.0 / workRate * 1000.0 / 1000.0) : null;
        Double psci = itk.getTemporalFrequency() * itk.getSpatialFrequency();
        ExportUtils.setExtraField(export, "PSCi", psci);
        ExportUtils.setExtraField(export, "spendingTime", spendingTime);
        return export;
    }
}

