/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.practiced;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.SolHorizon;
import fr.inra.agrosyst.api.entities.SolHorizonTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlot;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlotTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystemTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefElementVoisinage;
import fr.inra.agrosyst.api.entities.referential.RefElementVoisinageTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.entities.referential.RefLocationTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefParcelleZonageEDI;
import fr.inra.agrosyst.api.entities.referential.RefParcelleZonageEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSolProfondeurIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolProfondeurIndigoTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSolTextureGeppa;
import fr.inra.agrosyst.api.entities.referential.RefSolTextureGeppaTopiaDao;
import fr.inra.agrosyst.api.exceptions.AgrosystImportException;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.plot.SolHorizonDto;
import fr.inra.agrosyst.api.services.practiced.PracticedPlotDto;
import fr.inra.agrosyst.api.services.practiced.PracticedPlotFilter;
import fr.inra.agrosyst.api.services.practiced.PracticedPlotService;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.practicedPlot.PracticedPlotAndDependencies;
import fr.inra.agrosyst.api.services.security.AnonymizeService;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;

public class PracticedPlotServiceImpl
extends AbstractAgrosystService
implements PracticedPlotService {
    protected AnonymizeService anonymizeService;
    protected BusinessAuthorizationService authorizationService;
    protected PracticedPlotTopiaDao practicedPlotTopiaDao;
    protected PracticedSystemTopiaDao practicedSystemDao;
    protected RefLocationTopiaDao locationDao;
    protected RefParcelleZonageEDITopiaDao parcelleZonageEDIDao;
    protected RefSolTextureGeppaTopiaDao refSolTextureGeppaDao;
    protected RefSolProfondeurIndigoTopiaDao refSolProfondeurIndigoDao;
    protected SolHorizonTopiaDao solHorizonDao;
    protected RefElementVoisinageTopiaDao refElementVoisinageTopiaDao;
    private static final Log log = LogFactory.getLog(PracticedPlotServiceImpl.class);

    public void setAnonymizeService(AnonymizeService anonymizeService) {
        this.anonymizeService = anonymizeService;
    }

    public void setAuthorizationService(BusinessAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public void setPracticedPlotTopiaDao(PracticedPlotTopiaDao practicedPlotTopiaDao) {
        this.practicedPlotTopiaDao = practicedPlotTopiaDao;
    }

    public void setPracticedSystemDao(PracticedSystemTopiaDao practicedSystemDao) {
        this.practicedSystemDao = practicedSystemDao;
    }

    public void setLocationDao(RefLocationTopiaDao locationDao) {
        this.locationDao = locationDao;
    }

    public void setParcelleZonageEDIDao(RefParcelleZonageEDITopiaDao parcelleZonageEDIDao) {
        this.parcelleZonageEDIDao = parcelleZonageEDIDao;
    }

    public void setRefSolTextureGeppaDao(RefSolTextureGeppaTopiaDao refSolTextureGeppaDao) {
        this.refSolTextureGeppaDao = refSolTextureGeppaDao;
    }

    public void setRefSolProfondeurIndigoDao(RefSolProfondeurIndigoTopiaDao refSolProfondeurIndigoDao) {
        this.refSolProfondeurIndigoDao = refSolProfondeurIndigoDao;
    }

    public void setSolHorizonDao(SolHorizonTopiaDao solHorizonDao) {
        this.solHorizonDao = solHorizonDao;
    }

    public void setRefElementVoisinageTopiaDao(RefElementVoisinageTopiaDao refElementVoisinageTopiaDao) {
        this.refElementVoisinageTopiaDao = refElementVoisinageTopiaDao;
    }

    public ResultList<PracticedPlot> getFilteredPracticedPlots(PracticedPlotFilter filter) {
        ResultList<PracticedPlot> result = this.practicedPlotTopiaDao.getFilteredPracticedPlots(filter, this.getSecurityContext());
        return result;
    }

    public ResultList<PracticedPlotDto> getFilteredPracticedPlotsDto(PracticedPlotFilter filter) {
        ResultList<PracticedPlot> practicedPlots = this.getFilteredPracticedPlots(filter);
        return ResultList.transform(practicedPlots, (Function)this.anonymizeService.getPracticedPlotToDtoFunction());
    }

    public PracticedPlot getPracticedPlot(String practicedPlotTopiaId) {
        PracticedPlot result = StringUtils.isBlank((CharSequence)practicedPlotTopiaId) ? (PracticedPlot)this.practicedPlotTopiaDao.newInstance() : (PracticedPlot)this.practicedPlotTopiaDao.forTopiaIdEquals(practicedPlotTopiaId).findUnique();
        return result;
    }

    public PracticedPlot createOrUpdatePracticedPlot(PracticedPlot practicedPlot, String practicedSystemId, String locationId, String selectedSurfaceTextureId, String selectedSubSoilTextureId, String selectedSolDepthId, List<String> selectedPlotZoningIds, List<SolHorizonDto> solHorizons, List<String> adjacentElementIds) {
        PracticedSystem practicedSystem = this.getPracticedSystemForPracticedPlot(practicedPlot, practicedSystemId);
        this.authorizationService.checkCreateOrUpdatePracticedPlot(practicedPlot.getTopiaId(), practicedSystem.getTopiaId());
        RefLocation location = this.getRefLocation(locationId);
        RefSolTextureGeppa surfaceTexture = this.getSurfaceTexture(practicedPlot, selectedSurfaceTextureId);
        RefSolTextureGeppa subSoilTexture = this.getSubSoilTexture(practicedPlot, selectedSubSoilTextureId);
        RefSolProfondeurIndigo solDepth = this.getSolDepth(practicedPlot, selectedSolDepthId);
        PracticedPlot result = this.createOrUpdatePracticedPlotWithoutCommit(practicedPlot, practicedSystem, location, surfaceTexture, subSoilTexture, solDepth, selectedPlotZoningIds, solHorizons, adjacentElementIds);
        this.getTransaction().commit();
        return result;
    }

    protected PracticedPlot createOrUpdatePracticedPlotWithoutCommit(PracticedPlot practicedPlot, PracticedSystem practicedSystem, RefLocation location, RefSolTextureGeppa surfaceTexture, RefSolTextureGeppa subSoilTexture, RefSolProfondeurIndigo solDepth, List<String> selectedPlotZoningIds, List<SolHorizonDto> solHorizons, List<String> adjacentElementIds) {
        this.validatePracticedPlot(practicedPlot, practicedSystem);
        practicedPlot.setPracticedSystem(practicedSystem);
        practicedPlot.setLocation(location);
        practicedPlot.setSurfaceTexture(surfaceTexture);
        practicedPlot.setSubSoilTexture(subSoilTexture);
        practicedPlot.setSolDepth(solDepth);
        this.managePracticePlotSolHorizon(practicedPlot, solHorizons);
        ArrayList<RefParcelleZonageEDI> plotZonings = practicedPlot.getPlotZonings() == null ? new ArrayList() : practicedPlot.getPlotZonings();
        practicedPlot.setPlotZonings(plotZonings);
        Collection<RefParcelleZonageEDI> nonDeletedPlotZonings = this.getPlotZonings(practicedPlot, selectedPlotZoningIds, plotZonings);
        plotZonings.retainAll(nonDeletedPlotZonings);
        PracticedPlot result = practicedPlot.isPersisted() ? (PracticedPlot)this.practicedPlotTopiaDao.update((TopiaEntity)practicedPlot) : (PracticedPlot)this.practicedPlotTopiaDao.create((TopiaEntity)practicedPlot);
        this.manageAdjacentElements(adjacentElementIds, result);
        return result;
    }

    protected void manageAdjacentElements(List<String> adjacentElementIds, PracticedPlot result) {
        Collection currentAdjacentElements = result.getAdjacentElements();
        if (currentAdjacentElements == null) {
            currentAdjacentElements = Lists.newArrayList();
            result.setAdjacentElements(currentAdjacentElements);
        }
        ArrayList nonDeletedAdjacentElements = Lists.newArrayList();
        if (adjacentElementIds != null) {
            for (String adjacentElementId : adjacentElementIds) {
                RefElementVoisinage refElementVoisinage = (RefElementVoisinage)this.refElementVoisinageTopiaDao.forTopiaIdEquals(adjacentElementId).findUnique();
                if (!currentAdjacentElements.contains(refElementVoisinage)) {
                    currentAdjacentElements.add(refElementVoisinage);
                }
                nonDeletedAdjacentElements.add(refElementVoisinage);
            }
        }
        currentAdjacentElements.retainAll(nonDeletedAdjacentElements);
    }

    protected void managePracticePlotSolHorizon(PracticedPlot practicedPlot, List<SolHorizonDto> solHorizons) {
        if (solHorizons != null) {
            Collection currentHorizons = practicedPlot.getSolHorizon();
            if (currentHorizons == null) {
                currentHorizons = Lists.newArrayList();
                practicedPlot.setSolHorizon(currentHorizons);
            }
            ImmutableMap currentHorizonMap = Maps.uniqueIndex((Iterable)currentHorizons, (Function)Entities.GET_TOPIA_ID);
            HashSet nonDeletedHorizon = Sets.newHashSet();
            for (SolHorizonDto solHorizonDto : solHorizons) {
                String topiaId = solHorizonDto.getTopiaId();
                SolHorizon solHorizon = StringUtils.isNotBlank((CharSequence)topiaId) ? (SolHorizon)currentHorizonMap.get(topiaId) : (SolHorizon)this.solHorizonDao.newInstance();
                solHorizon.setComment(solHorizonDto.getComment());
                solHorizon.setLowRating(solHorizonDto.getLowRating());
                solHorizon.setStoniness(solHorizonDto.getStoniness());
                String solTextureId = solHorizonDto.getSolTextureId();
                RefSolTextureGeppa horizonSolTexture = null;
                if (StringUtils.isNotBlank((CharSequence)solTextureId)) {
                    horizonSolTexture = (RefSolTextureGeppa)this.refSolTextureGeppaDao.forTopiaIdEquals(solTextureId).findUnique();
                }
                solHorizon.setSolTexture(horizonSolTexture);
                nonDeletedHorizon.add(solHorizon);
                currentHorizons.add(solHorizon);
            }
            currentHorizons.retainAll(nonDeletedHorizon);
        }
    }

    protected RefSolProfondeurIndigo getSolDepth(PracticedPlot practicedPlot, String selectedSolProfondeurId) {
        RefSolProfondeurIndigo solProfondeur = practicedPlot.getSolDepth();
        if (!(Strings.isNullOrEmpty((String)selectedSolProfondeurId) || solProfondeur != null && selectedSolProfondeurId.equals(solProfondeur.getTopiaId()))) {
            solProfondeur = (RefSolProfondeurIndigo)this.refSolProfondeurIndigoDao.forTopiaIdEquals(selectedSolProfondeurId).findUnique();
        }
        return solProfondeur;
    }

    protected RefSolTextureGeppa getSubSoilTexture(PracticedPlot practicedPlot, String selectedSubSoilTextureId) {
        RefSolTextureGeppa subSoilTexture = practicedPlot.getSubSoilTexture();
        if (!(Strings.isNullOrEmpty((String)selectedSubSoilTextureId) || subSoilTexture != null && selectedSubSoilTextureId.equals(subSoilTexture.getTopiaId()))) {
            subSoilTexture = (RefSolTextureGeppa)this.refSolTextureGeppaDao.forTopiaIdEquals(selectedSubSoilTextureId).findUnique();
        }
        return subSoilTexture;
    }

    protected RefSolTextureGeppa getSurfaceTexture(PracticedPlot practicedPlot, String selectedSurfaceTextureId) {
        RefSolTextureGeppa surfaceTexture = practicedPlot.getSurfaceTexture();
        if (!(Strings.isNullOrEmpty((String)selectedSurfaceTextureId) || surfaceTexture != null && selectedSurfaceTextureId.equals(surfaceTexture.getTopiaId()))) {
            surfaceTexture = (RefSolTextureGeppa)this.refSolTextureGeppaDao.forTopiaIdEquals(selectedSurfaceTextureId).findUnique();
        }
        return surfaceTexture;
    }

    protected Collection<RefParcelleZonageEDI> getPlotZonings(PracticedPlot practicedPlot, List<String> selectedPlotZoningIds, Collection<RefParcelleZonageEDI> plotZonings) {
        ArrayList nonDeletedPlotZonings = Lists.newArrayList();
        if (selectedPlotZoningIds != null) {
            List parcelleZonageEDIs;
            if (practicedPlot.isOutOfZoning()) {
                selectedPlotZoningIds.clear();
                parcelleZonageEDIs = Lists.newArrayList();
            } else {
                parcelleZonageEDIs = this.parcelleZonageEDIDao.forTopiaIdIn(selectedPlotZoningIds).findAll();
                Preconditions.checkArgument((parcelleZonageEDIs.size() == selectedPlotZoningIds.size() ? 1 : 0) != 0, (Object)"Parcelles de la zone non retouv\u00e9es !");
            }
            for (RefParcelleZonageEDI parcelleZonageEDI : parcelleZonageEDIs) {
                if (!plotZonings.contains(parcelleZonageEDI)) {
                    plotZonings.add(parcelleZonageEDI);
                }
                nonDeletedPlotZonings.add(parcelleZonageEDI);
            }
        }
        return nonDeletedPlotZonings;
    }

    protected RefLocation getRefLocation(String locationTopiaId) {
        RefLocation location = null;
        if (StringUtils.isNotBlank((CharSequence)locationTopiaId)) {
            location = (RefLocation)this.locationDao.forTopiaIdEquals(locationTopiaId).findUnique();
        }
        return location;
    }

    protected PracticedSystem getPracticedSystemForPracticedPlot(PracticedPlot practicedPlot, String practicedSystemTopiaId) {
        PracticedSystem practicedSystem;
        if (!practicedPlot.isPersisted()) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)practicedSystemTopiaId), (Object)"L'identifiant su sytst\u00e8me synth\u00e9tis\u00e9 est requis.");
            practicedSystem = (PracticedSystem)this.practicedSystemDao.forTopiaIdEquals(practicedSystemTopiaId).findUnique();
            practicedPlot.setPracticedSystem(practicedSystem);
        } else {
            practicedSystem = practicedPlot.getPracticedSystem();
        }
        return practicedSystem;
    }

    protected void validatePracticedPlot(PracticedPlot practicedPlot, PracticedSystem practicedSystem) {
        if (!practicedPlot.isPersisted()) {
            Preconditions.checkArgument((!this.practicedPlotTopiaDao.forPracticedSystemEquals(practicedSystem).exists() ? 1 : 0) != 0);
        }
        Preconditions.checkArgument((practicedPlot.getWaterFlowDistance() != null ? 1 : 0) != 0);
        Preconditions.checkArgument((practicedPlot.getBufferStrip() != null ? 1 : 0) != 0);
        Preconditions.checkArgument((practicedPlot.getMaxSlope() != null ? 1 : 0) != 0);
    }

    public List<PracticedSystem> getPracticedSystemsWithoutPracticedPlot(NavigationContext navigationContext) {
        List<PracticedSystem> result = this.practicedSystemDao.getPracticedSystemsWithoutPlot(navigationContext, this.getSecurityContext());
        return result;
    }

    public void importPZ0PracticedPlots(Map<Class, ImportResults> allResults) {
        ImportResults importResults = allResults.remove(PracticedPlot.class);
        if (importResults != null && importResults.getIgnoredRecords() == 0) {
            try {
                Map entitiesAndDependencies = importResults.getEntityAndDepsByCsvIds();
                int count = 1;
                int total = entitiesAndDependencies.values().size();
                for (EntityAndDependencies entityAndDependencies : entitiesAndDependencies.values()) {
                    PracticedPlotAndDependencies practicedPlotAndDependencies = (PracticedPlotAndDependencies)entityAndDependencies;
                    PracticedPlot practicedPlot = practicedPlotAndDependencies.getEntity();
                    PracticedSystem practicedSystem = practicedPlot.getPracticedSystem();
                    RefLocation location = practicedPlot.getLocation();
                    List selectedPlotZoningIds = practicedPlotAndDependencies.getSelectedPlotZoningIds();
                    RefSolTextureGeppa surfaceTexture = practicedPlot.getSurfaceTexture();
                    RefSolTextureGeppa subSoilTexture = practicedPlot.getSubSoilTexture();
                    RefSolProfondeurIndigo solDepth = practicedPlot.getSolDepth();
                    List solHorizons = practicedPlotAndDependencies.getSolHorizonDtos();
                    List adjacentElementIds = practicedPlotAndDependencies.getAdjacentElementIds();
                    long start = System.currentTimeMillis();
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("D\u00e9but sauvegarde de la parcelle du synth\u00e9tis\u00e9 %s, campagne %s - %d/%s.", practicedSystem.getName(), practicedSystem.getCampaigns(), count++, total));
                    }
                    PracticedPlot persistedPlot = this.createOrUpdatePracticedPlotWithoutCommit(practicedPlot, practicedSystem, location, surfaceTexture, subSoilTexture, solDepth, selectedPlotZoningIds, solHorizons, adjacentElementIds);
                    practicedPlotAndDependencies.setEntity((TopiaEntity)persistedPlot);
                    long p2 = System.currentTimeMillis();
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Fin de sauvegarde de la parcelle du synth\u00e9tis\u00e9, traitement r\u00e9alis\u00e9 en:" + (p2 - start)));
                }
            }
            catch (Exception e) {
                throw new AgrosystImportException("Echec de persistance des parcelle pour syst\u00e8mes synth\u00e9tis\u00e9", (Throwable)e);
            }
        }
    }
}

