/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.plot.export;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.FrostProtectionType;
import fr.inra.agrosyst.api.entities.HosesPositionning;
import fr.inra.agrosyst.api.entities.IrrigationSystemType;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.PompEngineType;
import fr.inra.agrosyst.api.entities.SolWaterPh;
import fr.inra.agrosyst.api.entities.ZoneType;
import fr.inra.agrosyst.api.entities.referential.RefElementVoisinage;
import fr.inra.agrosyst.api.entities.referential.RefElementVoisinageTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefParcelleZonageEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSolProfondeurIndigoTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSolTextureGeppaTopiaDao;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;
import fr.inra.agrosyst.services.common.export.ExportUtils;
import fr.inra.agrosyst.services.common.export.UniqueDualLinkedHashMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.BidiMap;

public class PlotExportMetadata {

    public static class PlotAdjacentBeanInfo
    extends PlotCommonBeanInfo {
        protected RefElementVoisinageTopiaDao refElementVoisinageTopiaDao;

        public void setRefElementVoisinageTopiaDao(RefElementVoisinageTopiaDao refElementVoisinageTopiaDao) {
            this.refElementVoisinageTopiaDao = refElementVoisinageTopiaDao;
        }

        @Override
        public String getBeanTitle() {
            return "\u00c9l\u00e9ments de voisinage";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"adjacentElements", (Object)"\u00c9l\u00e9ments de voisinage");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<String, Object>> result = super.getCustomFormatters();
            result.put("adjacentElements", new Function<K, Object>(){

                public Object apply(K input) {
                    Preconditions.checkArgument((boolean)(input instanceof RefElementVoisinage));
                    RefElementVoisinage refElementVoisinage = (RefElementVoisinage)input;
                    String result = refElementVoisinage.getIae_nom();
                    return result;
                }
            });
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put("solDepth", this.refElementVoisinageTopiaDao.findPropertyDistinctValues("iae_nom"));
            return result;
        }
    }

    public static class PlotZoneBeanInfo
    extends PlotCommonBeanInfo {
        @Override
        public String getBeanTitle() {
            return "Zones";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"name", (Object)"Nom de la zone");
            columns.put((Object)"type", (Object)"Type");
            columns.put((Object)"area", (Object)"Surface (ha)");
            columns.put((Object)"latitude", (Object)"Latitude du centre de la zone");
            columns.put((Object)"longitude", (Object)"Longitude du centre de la zone");
            columns.put((Object)"comment", (Object)"Commentaire");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map result = super.getCustomFormatters();
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put("type", ExportUtils.allStringOf(ZoneType.class));
            return result;
        }
    }

    public static class PlotGroundBeanInfo
    extends PlotCommonBeanInfo {
        protected RefSolTextureGeppaTopiaDao refSolTextureGeppaTopiaDao;
        protected RefSolProfondeurIndigoTopiaDao refSolProfondeurIndigoTopiaDao;

        public void setRefSolProfondeurIndigoTopiaDao(RefSolProfondeurIndigoTopiaDao refSolProfondeurIndigoTopiaDao) {
            this.refSolProfondeurIndigoTopiaDao = refSolProfondeurIndigoTopiaDao;
        }

        public void setRefSolTextureGeppaTopiaDao(RefSolTextureGeppaTopiaDao refSolTextureGeppaTopiaDao) {
            this.refSolTextureGeppaTopiaDao = refSolTextureGeppaTopiaDao;
        }

        @Override
        public String getBeanTitle() {
            return "Sols";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"ground", (Object)"Sol du domaine");
            columns.put((Object)"surfaceTexture", (Object)"Texture moyenne de la surface");
            columns.put((Object)"subSoilTexture", (Object)"Texture moyenne du sous-sol");
            columns.put((Object)"solStoniness", (Object)"Pierrosit\u00e9 moyenne");
            columns.put((Object)"solDepth", (Object)"Classe profondeur maxi enracinement");
            columns.put((Object)"solMaxDepth", (Object)"Profondeur maxi enracinement");
            columns.put((Object)"solOrganicMaterialPercent", (Object)"Pourcentage Mati\u00e8re Organique");
            columns.put((Object)"solBattance", (Object)"Battance");
            columns.put((Object)"solWaterPh", (Object)"PH eau");
            columns.put((Object)"solHydromorphisms", (Object)"Hydromorphie");
            columns.put((Object)"solLimestone", (Object)"Calcaire");
            columns.put((Object)"solActiveLimestone", (Object)"Proportion calcaire actif");
            columns.put((Object)"solTotalLimestone", (Object)"Proportion calcaire total");
            columns.put((Object)"solComment", (Object)"Commentaires");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<String, Object>> result = super.getCustomFormatters();
            result.put("ground", new Function<K, Object>(){

                public Object apply(K input) {
                    Preconditions.checkArgument((boolean)(input instanceof Plot));
                    Plot plot = (Plot)input;
                    String result = null;
                    if (plot.getGround() != null) {
                        result = plot.getGround().getName();
                    }
                    return result;
                }
            });
            result.put("surfaceTexture", new Function<K, Object>(){

                public Object apply(K input) {
                    Preconditions.checkArgument((boolean)(input instanceof Plot));
                    Plot plot = (Plot)input;
                    String result = null;
                    if (plot.getSurfaceTexture() != null) {
                        result = plot.getSurfaceTexture().getClasses_texturales_GEPAA();
                    }
                    return result;
                }
            });
            result.put("subSoilTexture", new Function<K, Object>(){

                public Object apply(K input) {
                    Preconditions.checkArgument((boolean)(input instanceof Plot));
                    Plot plot = (Plot)input;
                    String result = null;
                    if (plot.getSubSoilTexture() != null) {
                        result = plot.getSubSoilTexture().getClasses_texturales_GEPAA();
                    }
                    return result;
                }
            });
            result.put("solDepth", new Function<K, Object>(){

                public Object apply(K input) {
                    Preconditions.checkArgument((boolean)(input instanceof Plot));
                    Plot plot = (Plot)input;
                    String result = null;
                    if (plot.getSolDepth() != null) {
                        result = plot.getSolDepth().getLibelle_classe();
                    }
                    return result;
                }
            });
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put("solDepth", this.refSolProfondeurIndigoTopiaDao.findPropertyDistinctValues("libelle_classe"));
            result.put("surfaceTexture", this.refSolTextureGeppaTopiaDao.findPropertyDistinctValues("classes_texturales_GEPAA"));
            result.put("subSoilTexture", this.refSolTextureGeppaTopiaDao.findPropertyDistinctValues("classes_texturales_GEPAA"));
            result.put("solWaterPh", ExportUtils.allStringOf(SolWaterPh.class));
            return result;
        }
    }

    public static class PlotEquipmentBeanInfo
    extends PlotCommonBeanInfo {
        @Override
        public String getBeanTitle() {
            return "Equipements";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"irrigationSystem", (Object)"Syst\u00e8me d'irrigation");
            columns.put((Object)"irrigationSystemType", (Object)"Type de syst\u00e8me d'irrigation");
            columns.put((Object)"pompEngineType", (Object)"Type de moteur de pompe");
            columns.put((Object)"hosesPositionning", (Object)"Positionnement des tuyaux d'arrosage");
            columns.put((Object)"fertigationSystem", (Object)"Syst\u00e8me de fertirrigation");
            columns.put((Object)"waterOrigin", (Object)"Origine de l'eau");
            columns.put((Object)"drainage", (Object)"Drainage");
            columns.put((Object)"drainageYear", (Object)"Ann\u00e9e de r\u00e9alisation du drainage");
            columns.put((Object)"frostProtection", (Object)"Protection anti-gel");
            columns.put((Object)"frostProtectionType", (Object)"Type de protection anti-gel");
            columns.put((Object)"hailProtection", (Object)"Protection anti-gr\u00eale");
            columns.put((Object)"rainproofProtection", (Object)"Protection anti-pluie");
            columns.put((Object)"pestProtection", (Object)"Protection anti-insectes");
            columns.put((Object)"otherEquipment", (Object)"Autre \u00e9quipement");
            columns.put((Object)"equipmentComment", (Object)"Commentaire sur l\u2019\u00e9quipement de la parcelle");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map result = super.getCustomFormatters();
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put("irrigationSystemType", ExportUtils.allStringOf(IrrigationSystemType.class));
            result.put("pompEngineType", ExportUtils.allStringOf(PompEngineType.class));
            result.put("hosesPositionning", ExportUtils.allStringOf(HosesPositionning.class));
            result.put("frostProtectionType", ExportUtils.allStringOf(FrostProtectionType.class));
            return result;
        }
    }

    public static class PlotZoningBeanInfo
    extends PlotCommonBeanInfo {
        protected RefParcelleZonageEDITopiaDao refParcelleZonageEDITopiaDao;

        public void setRefParcelleZonageEDITopiaDao(RefParcelleZonageEDITopiaDao refParcelleZonageEDITopiaDao) {
            this.refParcelleZonageEDITopiaDao = refParcelleZonageEDITopiaDao;
        }

        @Override
        public String getBeanTitle() {
            return "Zonage";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"outOfZoning", (Object)"D\u00e9clarer la parcelle hors de tout zonage");
            columns.put((Object)"zonage", (Object)"Zonage");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map result = super.getCustomFormatters();
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put("plotZonings", this.refParcelleZonageEDITopiaDao.findPropertyDistinctValues("libelle_engagement_parcelle"));
            return result;
        }
    }

    public static class PlotMainBeanInfo
    extends PlotCommonBeanInfo {
        @Override
        public String getBeanTitle() {
            return "G\u00e9n\u00e9ralit\u00e9s";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put((Object)"codePostal", (Object)"Commune (Code Postal)");
            columns.put((Object)"commune", (Object)"Commune (Nom)");
            columns.put((Object)"growingSystemName", (Object)"Syst\u00e8me De Culture");
            columns.put((Object)"area", (Object)"Surface totale");
            columns.put((Object)"pacIlotNumber", (Object)"Num\u00e9ro d'il\u00f4t PAC");
            columns.put((Object)"maxSlope", (Object)"Pente maxi");
            columns.put((Object)"waterFlowDistance", (Object)"Distance \u00e0 un cours d'eau");
            columns.put((Object)"bufferStrip", (Object)"Bande enherb\u00e9e");
            columns.put((Object)"latitude", (Object)"Latitude GPS du centre de la parcelle");
            columns.put((Object)"longitude", (Object)"Longitude GPS du centre de la parcelle");
            columns.put((Object)"comment", (Object)"Commentaire sur la parcelle");
            columns.put((Object)"activityEndComment", (Object)"Motif de fin d'utilisation");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<String, Object>> result = super.getCustomFormatters();
            result.put("growingSystemName", new Function<K, Object>(){

                public Object apply(K input) {
                    Plot plot = (Plot)input;
                    String result = null;
                    if (plot.getGrowingSystem() != null) {
                        result = plot.getGrowingSystem().getName();
                    }
                    return result;
                }
            });
            result.put("codePostal", new Function<K, Object>(){

                public Object apply(K input) {
                    Plot plot = (Plot)input;
                    String result = null;
                    if (plot.getLocation() != null) {
                        result = plot.getLocation().getCodePostal();
                    }
                    return result;
                }
            });
            result.put("commune", new Function<K, Object>(){

                public Object apply(K input) {
                    Plot plot = (Plot)input;
                    String result = null;
                    if (plot.getLocation() != null) {
                        result = plot.getLocation().getCommune();
                    }
                    return result;
                }
            });
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            return result;
        }
    }

    public static abstract class PlotCommonBeanInfo
    implements EntityExportTabInfo {
        @Override
        public BidiMap<String, String> getCommonColumns() {
            UniqueDualLinkedHashMap result = new UniqueDualLinkedHashMap();
            result.put("plotName", "Parcelle");
            result.put("domainName", "Domaine");
            result.put("campaign", "Campagne");
            return result;
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            UniqueDualLinkedHashMap result = new UniqueDualLinkedHashMap();
            return result;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            LinkedHashMap result = Maps.newLinkedHashMap();
            return result;
        }

        @Override
        public Map<String, Function<String, Object>> getCustomParsers() {
            HashMap result = Maps.newHashMap();
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            HashMap result = Maps.newHashMap();
            return result;
        }
    }
}

