/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.plot;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainTopiaDao;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.Ground;
import fr.inra.agrosyst.api.entities.GroundTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingPlanTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.GrowingSystemTopiaDao;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.PlotTopiaDao;
import fr.inra.agrosyst.api.entities.SolHorizon;
import fr.inra.agrosyst.api.entities.SolHorizonTopiaDao;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.ZoneImpl;
import fr.inra.agrosyst.api.entities.ZoneTopiaDao;
import fr.inra.agrosyst.api.entities.ZoneType;
import fr.inra.agrosyst.api.entities.measure.MeasurementSession;
import fr.inra.agrosyst.api.entities.measure.MeasurementSessionTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefElementVoisinage;
import fr.inra.agrosyst.api.entities.referential.RefElementVoisinageTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.entities.referential.RefLocationTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefParcelleZonageEDI;
import fr.inra.agrosyst.api.entities.referential.RefParcelleZonageEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSolProfondeurIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolProfondeurIndigoTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSolTextureGeppa;
import fr.inra.agrosyst.api.entities.referential.RefSolTextureGeppaTopiaDao;
import fr.inra.agrosyst.api.exceptions.AgrosystImportException;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.common.UsageList;
import fr.inra.agrosyst.api.services.domain.ExtendContext;
import fr.inra.agrosyst.api.services.domain.PlotDto;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.api.services.plot.SolHorizonDto;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.plot.PlotAndDependencies;
import fr.inra.agrosyst.api.services.security.AnonymizeService;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.EntityUsageService;
import fr.inra.agrosyst.services.common.export.EntityExportExtra;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;
import fr.inra.agrosyst.services.common.export.EntityExporter;
import fr.inra.agrosyst.services.common.export.EntityImporter;
import fr.inra.agrosyst.services.common.export.ExportUtils;
import fr.inra.agrosyst.services.plot.export.PlotExportEntity;
import fr.inra.agrosyst.services.plot.export.PlotExportMetadata;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class PlotServiceImpl
extends AbstractAgrosystService
implements PlotService {
    private static final Log log = LogFactory.getLog(PlotServiceImpl.class);
    public static final String PLOT_DEFAULT_ZONE_NAME = "Zone principale";
    protected static final Function<Zone, String> GET_ZONE_CODE = new Function<Zone, String>(){

        public String apply(Zone zone) {
            String result = zone.getCode();
            return result;
        }
    };
    protected AnonymizeService anonymizeService;
    protected BusinessAuthorizationService authorizationService;
    protected EntityUsageService entityUsageService;
    protected PlotTopiaDao plotDao;
    protected RefLocationTopiaDao locationDao;
    protected DomainTopiaDao domainDao;
    protected RefParcelleZonageEDITopiaDao parcelleZonageEDIDao;
    protected GrowingSystemTopiaDao growingSystemDao;
    protected RefSolTextureGeppaTopiaDao refSolTextureGeppaDao;
    protected GroundTopiaDao solDao;
    protected RefSolProfondeurIndigoTopiaDao refSolProfondeurIndigoDao;
    protected SolHorizonTopiaDao solHorizonDao;
    protected ZoneTopiaDao zoneDao;
    protected GrowingPlanTopiaDao growingPlanDao;
    protected RefElementVoisinageTopiaDao refElementVoisinageDao;
    protected MeasurementSessionTopiaDao measurementSessionDao;

    public void setEntityUsageService(EntityUsageService entityUsageService) {
        this.entityUsageService = entityUsageService;
    }

    public void setAnonymizeService(AnonymizeService anonymizeService) {
        this.anonymizeService = anonymizeService;
    }

    public void setAuthorizationService(BusinessAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public void setPlotDao(PlotTopiaDao plotDao) {
        this.plotDao = plotDao;
    }

    public void setLocationDao(RefLocationTopiaDao locationDao) {
        this.locationDao = locationDao;
    }

    public void setDomainDao(DomainTopiaDao domainDao) {
        this.domainDao = domainDao;
    }

    public void setParcelleZonageEDIDao(RefParcelleZonageEDITopiaDao parcelleZonageEDIDao) {
        this.parcelleZonageEDIDao = parcelleZonageEDIDao;
    }

    public void setGrowingSystemDao(GrowingSystemTopiaDao growingSystemDao) {
        this.growingSystemDao = growingSystemDao;
    }

    public void setRefSolTextureGeppaDao(RefSolTextureGeppaTopiaDao refSolTextureGeppaDao) {
        this.refSolTextureGeppaDao = refSolTextureGeppaDao;
    }

    public void setSolDao(GroundTopiaDao solDao) {
        this.solDao = solDao;
    }

    public void setRefSolProfondeurIndigoDao(RefSolProfondeurIndigoTopiaDao refSolProfondeurIndigoDao) {
        this.refSolProfondeurIndigoDao = refSolProfondeurIndigoDao;
    }

    public void setSolHorizonDao(SolHorizonTopiaDao solHorizonDao) {
        this.solHorizonDao = solHorizonDao;
    }

    public void setZoneDao(ZoneTopiaDao zoneDao) {
        this.zoneDao = zoneDao;
    }

    public void setGrowingPlanDao(GrowingPlanTopiaDao growingPlanDao) {
        this.growingPlanDao = growingPlanDao;
    }

    public void setRefElementVoisinageDao(RefElementVoisinageTopiaDao refElementVoisinageDao) {
        this.refElementVoisinageDao = refElementVoisinageDao;
    }

    public void setMeasurementSessionDao(MeasurementSessionTopiaDao measurementSessionDao) {
        this.measurementSessionDao = measurementSessionDao;
    }

    public Plot getPlot(String plotTopiaId) {
        Plot result;
        if (StringUtils.isBlank((CharSequence)plotTopiaId)) {
            result = (Plot)this.plotDao.newInstance();
            result.setActive(true);
            result.setCode(UUID.randomUUID().toString());
        } else {
            result = (Plot)this.plotDao.forTopiaIdEquals(plotTopiaId).findUnique();
            result = this.anonymizeService.checkForPlotAnonymization(result);
        }
        return result;
    }

    public Plot createOrUpdatePlot(Plot plot, String domainId, String locationId, String growingSystemId, Collection<String> selectedPlotZoningIds, String selectedSolId, String selectedSurfaceTextureId, String selectedSubSoilTextureId, String selectedSolDepthId, List<SolHorizonDto> solHorizons, Collection<Zone> zones, List<String> adjacentElementIds) {
        this.authorizationService.checkCreateOrUpdatePlot(plot.getTopiaId());
        Plot result = this.doCreateOrUpdatePlot(plot, domainId, locationId, growingSystemId, selectedPlotZoningIds, selectedSolId, selectedSurfaceTextureId, selectedSubSoilTextureId, selectedSolDepthId, solHorizons, zones, adjacentElementIds);
        this.getTransaction().commit();
        return result;
    }

    protected Plot createOrUpdatePlotWithoutCommit(Plot plot, String domainId, String locationId, String growingSystemId, Collection<String> selectedPlotZoningIds, String selectedSolId, String selectedSurfaceTextureId, String selectedSubSoilTextureId, String selectedSolDepthId, List<SolHorizonDto> solHorizons, Collection<Zone> zones, List<String> adjacentElementIds) {
        Plot result = this.doCreateOrUpdatePlot(plot, domainId, locationId, growingSystemId, selectedPlotZoningIds, selectedSolId, selectedSurfaceTextureId, selectedSubSoilTextureId, selectedSolDepthId, solHorizons, zones, adjacentElementIds);
        return result;
    }

    protected void validPlotPreconditions(Plot plot, String domainId, String locationId, Collection<Zone> zones) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)plot.getName()), (Object)"Le nom de la parcelle et requis");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)domainId), (Object)"Aucun domaine renseign\u00e9 pour la parcelle");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)locationId), (Object)"La commune n'est pas renseign\u00e9e pour la parcelle");
        Preconditions.checkArgument((plot.getWaterFlowDistance() != null ? 1 : 0) != 0, (Object)"La distance \u00e0 un cours d'eau n'est renseign\u00e9e pour la parcelle");
        Preconditions.checkArgument((plot.getMaxSlope() != null ? 1 : 0) != 0, (Object)"la pente maximum n'est renseign\u00e9e pour la parcelle");
        Preconditions.checkArgument((plot.getBufferStrip() != null ? 1 : 0) != 0, (Object)"la bande enherb\u00e9e n'est renseign\u00e9e pour la parcelle");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(zones), (Object)"La liste des zones ne peut \u00eatre vide, une zone principale est requise !");
    }

    protected Plot doCreateOrUpdatePlot(Plot plot, String domainId, String locationId, String growingSystemId, Collection<String> selectedPlotZoningIds, String selectedSolId, String selectedSurfaceTextureId, String selectedSubSoilTextureId, String selectedSolDepthId, List<SolHorizonDto> solHorizons, Collection<Zone> zones, List<String> adjacentElementIds) {
        Plot result;
        this.validPlotPreconditions(plot, domainId, locationId, zones);
        this.addPlotDomain(plot, domainId);
        this.addPlotLocation(plot, locationId);
        this.addPlotGrowingSystem(plot, growingSystemId);
        this.addZoningsEntities(plot, selectedPlotZoningIds);
        this.addGround(plot, selectedSolId);
        RefSolTextureGeppa surfaceTexture = this.getRefSolTextureGeppa(selectedSurfaceTextureId);
        plot.setSurfaceTexture(surfaceTexture);
        RefSolTextureGeppa subSoilTexture = this.getRefSolTextureGeppa(selectedSubSoilTextureId);
        plot.setSubSoilTexture(subSoilTexture);
        this.addPlotSolProfondeurIndigo(plot, selectedSolDepthId);
        this.persistPlotSolHorizons(plot, solHorizons);
        this.addPlotAdjacentElements(plot, adjacentElementIds);
        if (plot.isPersisted()) {
            result = (Plot)this.plotDao.update((TopiaEntity)plot);
        } else {
            this.setPlotCode(plot);
            result = (Plot)this.plotDao.create((TopiaEntity)plot);
        }
        this.persistPlotZones(plot, zones, result);
        return result;
    }

    private void setPlotCode(Plot plot) {
        if (StringUtils.isBlank((CharSequence)plot.getCode())) {
            plot.setCode(UUID.randomUUID().toString());
        }
    }

    protected void addPlotDomain(Plot plot, String domainId) {
        Domain domain = plot.getDomain();
        if (domain != null && !domain.getTopiaId().equals(domainId)) {
            domain = (Domain)this.domainDao.forTopiaIdEquals(domainId).findUnique();
        } else if (domain == null) {
            domain = (Domain)this.domainDao.forTopiaIdEquals(domainId).findUnique();
        }
        plot.setDomain(domain);
    }

    protected void addPlotLocation(Plot plot, String locationId) {
        RefLocation location = (RefLocation)this.locationDao.forTopiaIdEquals(locationId).findUnique();
        plot.setLocation(location);
    }

    protected void addPlotGrowingSystem(Plot plot, String growingSystemId) {
        GrowingSystem previousGrowingSystem = plot.getGrowingSystem();
        String previousGrowingSystemId = null;
        if (previousGrowingSystem != null) {
            previousGrowingSystemId = previousGrowingSystem.getTopiaId();
        }
        if (StringUtils.isBlank((CharSequence)growingSystemId) && previousGrowingSystemId != null) {
            plot.setGrowingSystem(null);
        }
        if (!(StringUtils.isBlank((CharSequence)growingSystemId) || previousGrowingSystemId != null && previousGrowingSystemId.contentEquals(growingSystemId))) {
            GrowingSystem growingSystem = (GrowingSystem)this.growingSystemDao.forTopiaIdEquals(growingSystemId).findUnique();
            plot.setGrowingSystem(growingSystem);
        }
    }

    protected void addZoningsEntities(Plot plot, Collection<String> selectedPlotZoningIds) {
        Collection plotZonings = plot.getPlotZonings();
        if (plotZonings == null) {
            plotZonings = Lists.newArrayList();
            plot.setPlotZonings(plotZonings);
        }
        ArrayList nonDeletedPlotZonings = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(selectedPlotZoningIds)) {
            if (plot.isOutOfZoning()) {
                selectedPlotZoningIds.clear();
            }
            for (String selectedPlotZoningId : selectedPlotZoningIds) {
                RefParcelleZonageEDI parcelleZonageEDI = (RefParcelleZonageEDI)this.parcelleZonageEDIDao.forTopiaIdEquals(selectedPlotZoningId).findUnique();
                if (!plotZonings.contains(parcelleZonageEDI)) {
                    plotZonings.add(parcelleZonageEDI);
                }
                nonDeletedPlotZonings.add(parcelleZonageEDI);
            }
        }
        plotZonings.retainAll(nonDeletedPlotZonings);
    }

    protected void addGround(Plot plot, String selectedSolId) {
        Ground sol = StringUtils.isNotBlank((CharSequence)selectedSolId) ? (Ground)this.solDao.forTopiaIdEquals(selectedSolId).findUnique() : null;
        plot.setGround(sol);
    }

    protected RefSolTextureGeppa getRefSolTextureGeppa(String selectedSubSoilTextureId) {
        RefSolTextureGeppa subSoilTexture = StringUtils.isNotBlank((CharSequence)selectedSubSoilTextureId) ? (RefSolTextureGeppa)this.refSolTextureGeppaDao.forTopiaIdEquals(selectedSubSoilTextureId).findUnique() : null;
        return subSoilTexture;
    }

    protected void addPlotSolProfondeurIndigo(Plot plot, String selectedSolDepthId) {
        RefSolProfondeurIndigo solProfondeur = StringUtils.isNotBlank((CharSequence)selectedSolDepthId) ? (RefSolProfondeurIndigo)this.refSolProfondeurIndigoDao.forTopiaIdEquals(selectedSolDepthId).findUnique() : null;
        plot.setSolDepth(solProfondeur);
    }

    protected void persistPlotSolHorizons(Plot plot, List<SolHorizonDto> solHorizons) {
        if (solHorizons != null) {
            Collection currentHorizons = plot.getSolHorizon();
            if (currentHorizons == null) {
                currentHorizons = Lists.newArrayList();
                plot.setSolHorizon(currentHorizons);
            }
            ImmutableMap currentHorizonMap = Maps.uniqueIndex((Iterable)currentHorizons, (Function)Entities.GET_TOPIA_ID);
            HashSet nonDeletedHorizon = Sets.newHashSet();
            for (SolHorizonDto solHorizonDto : solHorizons) {
                String topiaId = solHorizonDto.getTopiaId();
                SolHorizon solHorizon = StringUtils.isNotBlank((CharSequence)topiaId) ? (SolHorizon)currentHorizonMap.get(topiaId) : (SolHorizon)this.solHorizonDao.newInstance();
                solHorizon.setComment(solHorizonDto.getComment());
                solHorizon.setLowRating(solHorizonDto.getLowRating());
                solHorizon.setStoniness(solHorizonDto.getStoniness());
                String solTextureId = solHorizonDto.getSolTextureId();
                RefSolTextureGeppa horizonSolTexture = null;
                if (StringUtils.isNotBlank((CharSequence)solTextureId)) {
                    horizonSolTexture = (RefSolTextureGeppa)this.refSolTextureGeppaDao.forTopiaIdEquals(solTextureId).findUnique();
                }
                solHorizon.setSolTexture(horizonSolTexture);
                nonDeletedHorizon.add(solHorizon);
                currentHorizons.add(solHorizon);
            }
            currentHorizons.retainAll(nonDeletedHorizon);
        }
    }

    protected void addPlotAdjacentElements(Plot plot, List<String> adjacentElementIds) {
        Collection currentAdjacentElements = plot.getAdjacentElements();
        if (currentAdjacentElements == null) {
            currentAdjacentElements = Lists.newArrayList();
            plot.setAdjacentElements(currentAdjacentElements);
        }
        ArrayList nonDeletedAdjacentElements = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(adjacentElementIds)) {
            for (String adjacentElementId : adjacentElementIds) {
                RefElementVoisinage refElementVoisinage = (RefElementVoisinage)this.refElementVoisinageDao.forTopiaIdEquals(adjacentElementId).findUnique();
                if (!currentAdjacentElements.contains(refElementVoisinage)) {
                    currentAdjacentElements.add(refElementVoisinage);
                }
                nonDeletedAdjacentElements.add(refElementVoisinage);
            }
        }
        currentAdjacentElements.retainAll(nonDeletedAdjacentElements);
    }

    protected void persistPlotZones(Plot plot, Collection<Zone> zones, Plot result) {
        List currentZones = this.zoneDao.forPlotEquals(result).findAll();
        HashMap currentZonesMap = Maps.newHashMap((Map)Maps.uniqueIndex((Iterable)currentZones, (Function)Entities.GET_TOPIA_ID));
        for (Zone zoneDto : zones) {
            Zone zone;
            String topiaId = zoneDto.getTopiaId();
            if (StringUtils.isBlank((CharSequence)topiaId)) {
                zone = (Zone)this.zoneDao.newInstance();
                zone.setPlot(plot);
                if (StringUtils.isBlank((CharSequence)zoneDto.getCode())) {
                    zone.setCode(UUID.randomUUID().toString());
                } else {
                    zone.setCode(zoneDto.getCode());
                }
            } else {
                zone = (Zone)currentZonesMap.remove(topiaId);
            }
            zone.setName(zoneDto.getName());
            zone.setType(zoneDto.getType());
            zone.setArea(zoneDto.getArea());
            zone.setLatitude(zoneDto.getLatitude());
            zone.setLongitude(zoneDto.getLongitude());
            zone.setComment(zoneDto.getComment());
            zone.setActive(zoneDto.isActive());
            if (StringUtils.isBlank((CharSequence)topiaId)) {
                this.zoneDao.create((TopiaEntity)zone);
                continue;
            }
            this.zoneDao.update((TopiaEntity)zone);
        }
        this.zoneDao.deleteAll(currentZonesMap.values());
        if (!currentZonesMap.isEmpty()) {
            plot.setDeletedZones(true);
        }
    }

    public void updatePlotsGrowingSystemRelationship(GrowingSystem growingSystem, Collection<String> plotIds) {
        Plot plot;
        String growingSystemTopiaId = growingSystem.getTopiaId();
        List plots = growingSystemTopiaId == null ? new ArrayList() : this.plotDao.forGrowingSystemEquals(growingSystem).findAll();
        ImmutableMap indexedPlots = Maps.uniqueIndex(plots, (Function)Entities.GET_TOPIA_ID);
        HashSet selectedPlotIds = plotIds != null ? Sets.newHashSet(plotIds) : Sets.newHashSet();
        Set originePlotIds = indexedPlots.keySet();
        Sets.SetView plotRemovedRelationships = Sets.difference(originePlotIds, (Set)selectedPlotIds);
        for (String plotRemovedRelationship : plotRemovedRelationships) {
            plot = (Plot)this.plotDao.forTopiaIdEquals(plotRemovedRelationship).findUnique();
            if (plot.getGrowingSystem() == null || !plot.getGrowingSystem().getTopiaId().contentEquals(growingSystemTopiaId)) continue;
            plot.setGrowingSystem(null);
        }
        if (plotIds != null) {
            for (String plotId : plotIds) {
                plot = (Plot)indexedPlots.get(plotId);
                if (plot != null || (plot = (Plot)this.plotDao.forTopiaIdEquals(plotId).findUnique()).getGrowingSystem() != null) continue;
                plot.setGrowingSystem(growingSystem);
                plot.setActive(true);
            }
        }
    }

    public List<Plot> findAllByGrowingSystem(GrowingSystem growingSystem) {
        List result = this.plotDao.forGrowingSystemEquals(growingSystem).findAll();
        return result;
    }

    public List<Plot> findAllFreeAndGrowingSystemPlots(GrowingSystem growingSystem, String growingPlanTopiaId) {
        GrowingPlan growingPlan = (GrowingPlan)this.growingPlanDao.forTopiaIdEquals(growingPlanTopiaId).findUnique();
        List<Plot> plots1 = this.plotDao.findAllFreePlotInDomain(growingPlan.getDomain().getTopiaId());
        ArrayList result = Lists.newArrayList(plots1);
        if (growingSystem != null) {
            List plots2 = this.plotDao.forGrowingSystemEquals(growingSystem).findAll();
            result.addAll(plots2);
        }
        return result;
    }

    public List<Plot> getFreePlotForGrowingPlan(String growingPlanTopiaId) {
        GrowingPlan growingPlan = (GrowingPlan)this.growingPlanDao.forTopiaIdEquals(growingPlanTopiaId).findUnique();
        List<Plot> plots = this.plotDao.findAllFreePlotInDomain(growingPlan.getDomain().getTopiaId());
        return plots;
    }

    public LinkedHashMap<Integer, String> getRelatedPlots(String plotCode) {
        LinkedHashMap<Integer, String> result = this.plotDao.findAllRelatedPlots(plotCode);
        return result;
    }

    public LinkedHashMap<Integer, String> getRelatedZones(String zoneCode) {
        LinkedHashMap<Integer, String> result = this.zoneDao.findAllRelatedZones(zoneCode);
        return result;
    }

    public boolean validMergingPlots(List<String> plotTopiaIds) {
        Long nbGS = this.plotDao.countAllGrowingSystemsForPlots(Sets.newConcurrentHashSet(plotTopiaIds));
        boolean result = nbGS == 0L || nbGS == 1L;
        return result;
    }

    public Plot mergePlots(List<String> plotTopiaIds) {
        Preconditions.checkArgument((plotTopiaIds.size() >= 2 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)this.validMergingPlots(plotTopiaIds));
        List plots = this.plotDao.forTopiaIdIn(plotTopiaIds).findAll();
        Plot remainPlot = (Plot)plots.get(0);
        for (int i = 1; i < plots.size(); ++i) {
            Plot loopPlot = (Plot)plots.get(i);
            if (!(loopPlot.getArea() > remainPlot.getArea())) continue;
            remainPlot = loopPlot;
        }
        for (Plot plot : plots) {
            if (plot.equals(remainPlot)) continue;
            List zones = this.zoneDao.forPlotEquals(plot).findAll();
            for (Zone zone : zones) {
                String name = zone.getName();
                name = name + " (" + plot.getName() + ")";
                zone.setName(name);
                zone.setPlot(remainPlot);
            }
            remainPlot.setArea(remainPlot.getArea() + plot.getArea());
            if (plot.getLineage() != null) {
                remainPlot.addAllLineage((Iterable)plot.getLineage());
            }
            remainPlot.addLineage(plot.getCode());
            this.plotDao.delete(plot);
        }
        this.getTransaction().commit();
        return remainPlot;
    }

    public Plot duplicatePlot(String topiaId) {
        Plot plot = (Plot)this.plotDao.forTopiaIdEquals(topiaId).findUnique();
        Plot result = this.extendPlot(new ExtendContext(true), plot.getDomain(), plot);
        this.getTransaction().commit();
        return result;
    }

    public Plot extendPlot(ExtendContext extendContext, Domain clonedDomain, Plot plot) {
        Binder binder = BinderFactory.newBinder(Plot.class);
        Plot clonedPlot = (Plot)this.plotDao.newInstance();
        binder.copyExcluding((Object)plot, (Object)clonedPlot, new String[]{"domain", "topiaId", "topiaVersion", "topiaCreateDate", "solHorizon", "plotZonings", "adjacentElements", "lineage", "ground"});
        clonedPlot.setDomain(clonedDomain);
        clonedPlot.setDeletedZones(false);
        if (extendContext.isDuplicateOnly()) {
            clonedPlot.setCode(UUID.randomUUID().toString());
            clonedPlot.addLineage(plot.getCode());
            clonedPlot.setGround(plot.getGround());
        } else {
            Preconditions.checkNotNull((Object)extendContext.getGroundCache(), (Object)"Dans le cas d'une prolongation, cette map ne peut pas \u00eatre null");
            Ground ground = (Ground)extendContext.getGroundCache().get(plot.getGround());
            clonedPlot.setGround(ground);
        }
        if (plot.getSolHorizon() != null) {
            Binder binderSH = BinderFactory.newBinder(SolHorizon.class);
            for (SolHorizon solHorizon : plot.getSolHorizon()) {
                SolHorizon solHorizonClone = (SolHorizon)this.solHorizonDao.newInstance();
                binderSH.copyExcluding((Object)solHorizon, (Object)solHorizonClone, new String[]{"topiaId", "topiaVersion", "topiaCreateDate"});
                clonedPlot.addSolHorizon(solHorizonClone);
            }
        }
        if (plot.getPlotZonings() != null) {
            clonedPlot.setPlotZonings((Collection)Lists.newArrayList((Iterable)plot.getPlotZonings()));
        }
        if (plot.getAdjacentElements() != null) {
            clonedPlot.setAdjacentElements((Collection)Lists.newArrayList((Iterable)plot.getAdjacentElements()));
        }
        clonedPlot = (Plot)this.plotDao.create((TopiaEntity)clonedPlot);
        List zones = this.zoneDao.forPlotEquals(plot).addEquals("active", (Object)true).findAll();
        Binder zoneBinder = BinderFactory.newBinder(Zone.class);
        for (Zone zone : zones) {
            Zone zoneClone = (Zone)this.zoneDao.newInstance();
            zoneBinder.copyExcluding((Object)zone, (Object)zoneClone, new String[]{"topiaId", "topiaVersion", "topiaCreateDate", "plot", "lineage"});
            zoneClone.setPlot(clonedPlot);
            if (extendContext.isDuplicateOnly()) {
                zoneClone.setCode(UUID.randomUUID().toString());
                zoneClone.addLineage(zone.getCode());
            }
            this.zoneDao.create((TopiaEntity)zoneClone);
        }
        return clonedPlot;
    }

    public List<Plot> findAllByDomain(Domain domain) {
        List result = this.plotDao.findAllByDomainOrderByName(domain);
        result = this.anonymizeService.checkForPlotsAnonymization(result);
        return result;
    }

    public List<Zone> getPlotZones(Plot plot) {
        ArrayList<Zone> result;
        if (plot.isPersisted()) {
            result = this.zoneDao.forPlotEquals(plot).findAll();
        } else {
            result = new ArrayList();
            Zone defaultZone = (Zone)this.zoneDao.newInstance();
            defaultZone.setName(PLOT_DEFAULT_ZONE_NAME);
            defaultZone.setType(ZoneType.PRINCIPALE);
            defaultZone.setActive(true);
            defaultZone.setCode(UUID.randomUUID().toString());
            result.add(defaultZone);
        }
        return result;
    }

    public List<MeasurementSession> getPlotMeasurementSessions(String plotTopiaId) {
        List result = this.measurementSessionDao.forProperties("zone.plot.topiaId", plotTopiaId, new Object[0]).setOrderByArguments(new String[]{"zone", "startDate", "endDate"}).findAll();
        return result;
    }

    public UsageList<Zone> getZonesAndUsages(String plotTopiaId) {
        List zones = this.zoneDao.forProperties("plot.topiaId", plotTopiaId, new Object[0]).findAll();
        UsageList<Zone> result = this.entityUsageService.getZonesUsageList(zones);
        return result;
    }

    public Plot unactivatePlot(String plotTopiaId, boolean activate) {
        Plot plot = (Plot)this.plotDao.forTopiaIdEquals(plotTopiaId).findUnique();
        plot.setActive(activate);
        this.getTransaction().commit();
        return plot;
    }

    public List<Zone> getZonesWithoutCycle(String zoneId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)zoneId) ? 1 : 0) != 0);
        Zone zone = (Zone)this.zoneDao.forTopiaIdEquals(zoneId).findUnique();
        List<Zone> result = this.zoneDao.findZonesWithoutCycle(zoneId, zone.getPlot().getDomain().getTopiaId());
        return result;
    }

    public List<PlotDto> getPlots(Collection<String> plotIds) {
        List plots = this.plotDao.forTopiaIdIn(plotIds).findAll();
        List result = Lists.transform((List)plots, (Function)this.anonymizeService.getPlotToDtoFunction());
        return result;
    }

    public InputStream exportPlotsAsXlsStream(List<String> plotIds) {
        LinkedHashMap sheet = Maps.newLinkedHashMap();
        PlotExportMetadata.PlotMainBeanInfo plotMainBeanInfo = this.newInstance(PlotExportMetadata.PlotMainBeanInfo.class);
        PlotExportMetadata.PlotZoningBeanInfo plotZoningBeanInfo = this.newInstance(PlotExportMetadata.PlotZoningBeanInfo.class);
        PlotExportMetadata.PlotEquipmentBeanInfo plotEquipmentBeanInfo = this.newInstance(PlotExportMetadata.PlotEquipmentBeanInfo.class);
        PlotExportMetadata.PlotGroundBeanInfo plotGroundBeanInfo = this.newInstance(PlotExportMetadata.PlotGroundBeanInfo.class);
        PlotExportMetadata.PlotAdjacentBeanInfo plotAdjacentBeanInfo = this.newInstance(PlotExportMetadata.PlotAdjacentBeanInfo.class);
        PlotExportMetadata.PlotZoneBeanInfo plotZoneBeanInfo = this.newInstance(PlotExportMetadata.PlotZoneBeanInfo.class);
        ExportUtils.addAllBeanInfo(sheet, plotMainBeanInfo, plotZoningBeanInfo, plotEquipmentBeanInfo, plotGroundBeanInfo, plotAdjacentBeanInfo, plotZoneBeanInfo);
        List zoningEntities = (List)sheet.get(plotZoningBeanInfo);
        try {
            if (CollectionUtils.isNotEmpty(plotIds)) {
                List plots = this.plotDao.forTopiaIdIn(plotIds).findAll();
                for (Plot plot : plots) {
                    plot = this.anonymizeService.checkForPlotAnonymization(plot);
                    PlotExportEntity model = new PlotExportEntity();
                    model.setCampaign(plot.getDomain().getCampaign());
                    model.setDomainName(plot.getDomain().getName());
                    model.setPlotName(plot.getName());
                    ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, plot, (EntityExportTabInfo)plotMainBeanInfo);
                    if (plot.isOutOfZoning()) {
                        PlotExportEntity export = (PlotExportEntity)model.clone();
                        ExportUtils.setExtraField(export, "outOfZoning", plot.isOutOfZoning());
                        zoningEntities.add(export);
                    } else {
                        Collection zonings = CollectionUtils.emptyIfNull((Collection)plot.getPlotZonings());
                        for (RefParcelleZonageEDI zoning : zonings) {
                            PlotExportEntity export = (PlotExportEntity)model.clone();
                            ExportUtils.setExtraField(export, "outOfZoning", plot.isOutOfZoning());
                            ExportUtils.setExtraField(export, "zonage", zoning.getLibelle_engagement_parcelle());
                            zoningEntities.add(export);
                        }
                    }
                    ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, plot, (EntityExportTabInfo)plotEquipmentBeanInfo);
                    ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, plot, (EntityExportTabInfo)plotGroundBeanInfo);
                    ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, CollectionUtils.emptyIfNull((Collection)plot.getAdjacentElements()), (EntityExportTabInfo)plotAdjacentBeanInfo);
                    List zones = this.zoneDao.forPlotEquals(plot).findAll();
                    ExportUtils.export((Map<EntityExportTabInfo, List<? extends EntityExportExtra>>)sheet, model, zones, (EntityExportTabInfo)plotZoneBeanInfo);
                }
            }
        }
        catch (Exception ex) {
            throw new AgrosystTechnicalException("Can't copy properties", (Throwable)ex);
        }
        EntityExporter exporter = new EntityExporter();
        InputStream stream = exporter.exportAsXlsStream(sheet);
        return stream;
    }

    public void importPlotsForXlsStream(InputStream is) {
        PlotExportMetadata.PlotMainBeanInfo plotMainBeanInfo = this.newInstance(PlotExportMetadata.PlotMainBeanInfo.class);
        PlotExportMetadata.PlotZoningBeanInfo plotZoningBeanInfo = this.newInstance(PlotExportMetadata.PlotZoningBeanInfo.class);
        PlotExportMetadata.PlotEquipmentBeanInfo plotEquipmentBeanInfo = this.newInstance(PlotExportMetadata.PlotEquipmentBeanInfo.class);
        PlotExportMetadata.PlotGroundBeanInfo plotGroundBeanInfo = this.newInstance(PlotExportMetadata.PlotGroundBeanInfo.class);
        PlotExportMetadata.PlotAdjacentBeanInfo plotAdjacentBeanInfo = this.newInstance(PlotExportMetadata.PlotAdjacentBeanInfo.class);
        PlotExportMetadata.PlotZoneBeanInfo plotZoneBeanInfo = this.newInstance(PlotExportMetadata.PlotZoneBeanInfo.class);
        EntityImporter importer = new EntityImporter();
        Map<EntityExportTabInfo, List<PlotExportEntity>> datas = importer.importFromStream(is, PlotExportEntity.class, plotMainBeanInfo, plotZoningBeanInfo, plotEquipmentBeanInfo, plotGroundBeanInfo, plotAdjacentBeanInfo, plotZoneBeanInfo);
        try {
            Plot plot;
            List<PlotExportEntity> mainBeanInfo = datas.get(plotMainBeanInfo);
            MultiKeyMap plotCache = new MultiKeyMap();
            for (PlotExportEntity beanInfo : mainBeanInfo) {
                String growingSystemName;
                Domain domain = (Domain)this.domainDao.forProperties("name", beanInfo.getDomainName(), new Object[]{"campaign", beanInfo.getCampaign()}).findUnique();
                plot = (Plot)this.plotDao.newInstance();
                plot.setName(beanInfo.getPlotName());
                plot.setDomain(domain);
                plot.setCode(UUID.randomUUID().toString());
                plot.setActive(true);
                ExportUtils.copyFields(beanInfo, plot, "area", "pacIlotNumber", "maxSlope", "waterFlowDistance", "bufferStrip", "latitude", "longitude", "comment", "activityEndComment");
                String codePostal = beanInfo.getExtraAsString("codePostal");
                if (StringUtils.isNotBlank((CharSequence)codePostal)) {
                    RefLocation location = (RefLocation)this.locationDao.forCodePostalEquals(codePostal).findAny();
                    plot.setLocation(location);
                }
                if (StringUtils.isNotBlank((CharSequence)(growingSystemName = beanInfo.getExtraAsString("growingSystemName")))) {
                    GrowingSystem growingSystem = (GrowingSystem)this.growingSystemDao.forProperties("name", growingSystemName, new Object[]{"growingPlan.domain", domain}).findUniqueOrNull();
                    plot.setGrowingSystem(growingSystem);
                }
                plot = (Plot)this.plotDao.create((TopiaEntity)plot);
                plotCache.put((Object)beanInfo.getDomainName(), (Object)beanInfo.getCampaign(), (Object)beanInfo.getPlotName(), (Object)plot);
            }
            List<PlotExportEntity> zoningBeanInfo = datas.get(plotZoningBeanInfo);
            for (PlotExportEntity beanInfo : zoningBeanInfo) {
                plot = (Plot)plotCache.get((Object)beanInfo.getDomainName(), (Object)beanInfo.getCampaign(), (Object)beanInfo.getPlotName());
                ExportUtils.copyFields(beanInfo, plot, "outOfZoning");
                String zoningElement = beanInfo.getExtraAsString("zonage");
                if (!StringUtils.isNotBlank((CharSequence)zoningElement)) continue;
                RefParcelleZonageEDI refParcelleZonageEDI = (RefParcelleZonageEDI)this.parcelleZonageEDIDao.forLibelle_engagement_parcelleEquals(zoningElement).findUnique();
                plot.addPlotZonings(refParcelleZonageEDI);
            }
            List<PlotExportEntity> equipementBeanInfo = datas.get(plotEquipmentBeanInfo);
            for (PlotExportEntity beanInfo : equipementBeanInfo) {
                Plot plot2 = (Plot)plotCache.get((Object)beanInfo.getDomainName(), (Object)beanInfo.getCampaign(), (Object)beanInfo.getPlotName());
                ExportUtils.copyFields(beanInfo, plot2, "irrigationSystem", "irrigationSystemType", "pompEngineType", "hosesPositionning", "fertigationSystem", "waterOrigin", "drainage", "drainageYear", "frostProtection", "frostProtectionType", "hailProtection", "rainproofProtection", "pestProtection", "otherEquipment", "equipmentComment");
            }
            List<PlotExportEntity> groundBeanInfo = datas.get(plotGroundBeanInfo);
            for (PlotExportEntity beanInfo : groundBeanInfo) {
                String solDepth;
                String subsolSurface;
                String solSurface;
                Plot plot3 = (Plot)plotCache.get((Object)beanInfo.getDomainName(), (Object)beanInfo.getCampaign(), (Object)beanInfo.getPlotName());
                ExportUtils.copyFields(beanInfo, plot3, "solStoniness", "solMaxDepth", "solOrganicMaterialPercent", "solBattance", "solWaterPh", "solHydromorphisms", "solLimestone", "solActiveLimestone", "solTotalLimestone", "solComment");
                String domainSol = beanInfo.getExtraAsString("ground");
                if (StringUtils.isNotBlank((CharSequence)domainSol)) {
                    Ground ground = (Ground)this.solDao.forProperties("domain", plot3.getDomain(), new Object[]{"name", domainSol}).findUnique();
                    plot3.setGround(ground);
                }
                if (StringUtils.isNotBlank((CharSequence)(solSurface = beanInfo.getExtraAsString("surfaceTexture")))) {
                    RefSolTextureGeppa refSolTextureGeppa = (RefSolTextureGeppa)this.refSolTextureGeppaDao.forClasses_texturales_GEPAAEquals(solSurface).findUnique();
                    plot3.setSurfaceTexture(refSolTextureGeppa);
                }
                if (StringUtils.isNotBlank((CharSequence)(subsolSurface = beanInfo.getExtraAsString("surfaceTexture")))) {
                    RefSolTextureGeppa refSolTextureGeppa = (RefSolTextureGeppa)this.refSolTextureGeppaDao.forClasses_texturales_GEPAAEquals(subsolSurface).findUnique();
                    plot3.setSubSoilTexture(refSolTextureGeppa);
                }
                if (!StringUtils.isNotBlank((CharSequence)(solDepth = beanInfo.getExtraAsString("solDepth")))) continue;
                RefSolProfondeurIndigo profondeur = (RefSolProfondeurIndigo)this.refSolProfondeurIndigoDao.forLibelle_classeEquals(solDepth).findUnique();
                plot3.setSolDepth(profondeur);
            }
            List<PlotExportEntity> adjacentBeanInfo = datas.get(plotAdjacentBeanInfo);
            for (PlotExportEntity beanInfo : adjacentBeanInfo) {
                Plot plot4 = (Plot)plotCache.get((Object)beanInfo.getDomainName(), (Object)beanInfo.getCampaign(), (Object)beanInfo.getPlotName());
                String adjacentElement = beanInfo.getExtraAsString("adjacentElements");
                if (!StringUtils.isNotBlank((CharSequence)adjacentElement)) continue;
                RefElementVoisinage refElementVoisinage = (RefElementVoisinage)this.refElementVoisinageDao.forIae_nomEquals(adjacentElement).findUnique();
                plot4.addAdjacentElements(refElementVoisinage);
            }
            List<PlotExportEntity> zoneBeanInfo = datas.get(plotZoneBeanInfo);
            for (PlotExportEntity beanInfo : zoneBeanInfo) {
                Plot plot5 = (Plot)plotCache.get((Object)beanInfo.getDomainName(), (Object)beanInfo.getCampaign(), (Object)beanInfo.getPlotName());
                ZoneImpl zone = new ZoneImpl();
                zone.setPlot(plot5);
                ExportUtils.copyFields(beanInfo, zone, "name", "type", "area", "latitude", "longitude", "comment");
                zone.setActive(true);
                zone.setCode(UUID.randomUUID().toString());
                this.zoneDao.create((TopiaEntity)zone);
            }
            for (Plot plot4 : plotCache.values()) {
                if (!plot4.isPersisted()) continue;
                this.plotDao.update((TopiaEntity)plot4);
            }
            this.getTransaction().commit();
        }
        catch (Exception ex) {
            throw new AgrosystTechnicalException("Can't copy fields", (Throwable)ex);
        }
    }

    public List<Plot> getAllGrowingSystemPlot(GrowingSystem growingSystem) {
        Preconditions.checkNotNull((Object)growingSystem);
        List result = this.plotDao.forGrowingSystemEquals(growingSystem).findAll();
        return result;
    }

    public void importPZ0Plots(Map<Class, ImportResults> allResults) {
        ImportResults plotsImportResults = allResults.remove(Plot.class);
        if (plotsImportResults != null && plotsImportResults.getIgnoredRecords() == 0) {
            try {
                Map entitiesAndDependencies = plotsImportResults.getEntityAndDepsByCsvIds();
                int count = 1;
                int total = entitiesAndDependencies.values().size();
                for (EntityAndDependencies entityAndDependencies : entitiesAndDependencies.values()) {
                    PlotAndDependencies plotAndDependencies = (PlotAndDependencies)entityAndDependencies;
                    Plot plot = plotAndDependencies.getEntity();
                    long start = System.currentTimeMillis();
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("D\u00e9but sauvegarde de la parcelle %s - %d/%d.", plot.getName(), count++, total));
                    }
                    String domainId = plotAndDependencies.getDomainId();
                    String locationId = plotAndDependencies.getLocationId();
                    String growingSystemId = plotAndDependencies.getGrowingSystemId();
                    Collection selectedPlotZoningIds = plotAndDependencies.getSelectedPlotZoningIds();
                    String selectedSolId = plotAndDependencies.getSelectedSolId();
                    String selectedSurfaceTextureId = plotAndDependencies.getSelectedSurfaceTextureId();
                    String selectedSubSoilTextureId = plotAndDependencies.getSelectedSubSoilTextureId();
                    String selectedSolDepthId = plotAndDependencies.getSelectedSolDepthId();
                    List solHorizons = plotAndDependencies.getSolHorizonDtos();
                    List adjacentElementIds = plotAndDependencies.getAdjacentElementIds();
                    Map zoneByCsvIds = plotAndDependencies.getZones();
                    Plot persistedPlot = this.createOrUpdatePlotWithoutCommit(plot, domainId, locationId, growingSystemId, selectedPlotZoningIds, selectedSolId, selectedSurfaceTextureId, selectedSubSoilTextureId, selectedSolDepthId, solHorizons, zoneByCsvIds.values(), adjacentElementIds);
                    entityAndDependencies.setEntity((TopiaEntity)persistedPlot);
                    List<Zone> persistedZones = this.getPlotZones(persistedPlot);
                    ImmutableMap persistedZoneByCode = Maps.uniqueIndex(persistedZones, GET_ZONE_CODE);
                    for (Map.Entry entry : zoneByCsvIds.entrySet()) {
                        Zone zoneToSave = (Zone)entry.getValue();
                        Zone persistedZone = (Zone)persistedZoneByCode.get(zoneToSave.getCode());
                        entry.setValue(persistedZone);
                    }
                    long p1 = System.currentTimeMillis();
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Fin de sauvegarde de la parcelle, traitement r\u00e9alis\u00e9 en:" + (p1 - start)));
                }
            }
            catch (Exception e) {
                throw new AgrosystImportException("Echec de persistance des parcelles", (Throwable)e);
            }
        }
    }
}

