/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.performance.indicators;

import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.action.HarvestingAction;
import fr.inra.agrosyst.api.entities.action.HarvestingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.HarvestingYeald;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhase;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhase;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.services.performance.indicators.AbstractIndicator;
import java.util.List;

public class IndicatorYield
extends AbstractIndicator {
    protected HarvestingActionTopiaDao harvestingActionTopiaDao;

    public void setHarvestingActionTopiaDao(HarvestingActionTopiaDao harvestingActionTopiaDao) {
        this.harvestingActionTopiaDao = harvestingActionTopiaDao;
    }

    @Override
    public String getIndicatorCategory() {
        return "Indicateurs de r\u00e9sultats agronomiques";
    }

    @Override
    public String getIndicatorLabel(int i) {
        return "Rendement (t/ha)";
    }

    @Override
    public Double[] manageIntervention(PracticedIntervention intervention, GrowingSystem growingSystem, String campaigns, String croppingPlanEntryCode, String previousPlanEntryCode, PracticedCropCyclePhase phase) {
        List harvestingActions = this.harvestingActionTopiaDao.forPracticedInterventionEquals(intervention).findAll();
        double meanYieldSum = 0.0;
        for (HarvestingAction action : harvestingActions) {
            if (action.getHarvestingYealds() == null) continue;
            for (HarvestingYeald yeald : action.getHarvestingYealds()) {
                meanYieldSum += yeald.getYealdAverage();
            }
        }
        double value = meanYieldSum * this.getToolPSCi(intervention);
        return this.newResult(value);
    }

    @Override
    public Double[] manageIntervention(EffectiveIntervention intervention, Zone zone, CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry, EffectiveCropCyclePhase phase) {
        List harvestingActions = this.harvestingActionTopiaDao.forEffectiveInterventionEquals(intervention).findAll();
        double meanYieldSum = 0.0;
        for (HarvestingAction action : harvestingActions) {
            if (action.getHarvestingYealds() == null) continue;
            for (HarvestingYeald yeald : action.getHarvestingYealds()) {
                meanYieldSum += yeald.getYealdAverage();
            }
        }
        double value = meanYieldSum * this.getToolPSCi(intervention);
        return this.newResult(value);
    }
}

