/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.performance.indicators;

import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhase;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhase;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.services.performance.indicators.AbstractIndicator;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class IndicatorWorkTime
extends AbstractIndicator {
    @Override
    public String getIndicatorCategory() {
        return "R\u00e9sultats socio-techniques";
    }

    @Override
    public String getIndicatorLabel(int i) {
        String result = 0 <= i && i < 12 ? String.format("Temps de travail %s (h/ha)", MONTHS[i]) : "Temps de travail (h/ha)";
        return result;
    }

    @Override
    public Double[] manageIntervention(PracticedIntervention intervention, GrowingSystem growingSystem, String campaigns, String croppingPlanEntryCode, String previousPlanEntryCode, PracticedCropCyclePhase phase) {
        Double[] workTimes = null;
        Double workTime = null;
        if (intervention.getWorkRate() != null) {
            workTime = 1.0 / intervention.getWorkRate() * this.getToolPSCi(intervention);
        }
        if (workTime != null) {
            workTimes = this.newArray(13, 0.0);
            int month = this.getStartMonth(intervention);
            workTimes[month] = workTime;
            workTimes[12] = workTime;
        }
        return this.newResult(workTimes);
    }

    protected int getStartMonth(PracticedIntervention intervention) {
        int startMonth = -1;
        String startDate = intervention.getStartingPeriodDate();
        if (StringUtils.isEmpty((CharSequence)startDate)) {
            return startMonth;
        }
        Matcher mStartDate = PRACTICED_DATE_PATTERN.matcher(startDate);
        if (mStartDate.find()) {
            startMonth = Integer.parseInt(mStartDate.group(2)) - 1;
        }
        return startMonth;
    }

    @Override
    public Double[] manageIntervention(EffectiveIntervention intervention, Zone zone, CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry, EffectiveCropCyclePhase phase) {
        Double[] workTimes = null;
        Double workTime = null;
        if (intervention.getWorkRate() != null) {
            workTime = 1.0 / intervention.getWorkRate() * this.getToolPSCi(intervention);
        }
        if (workTime != null) {
            workTimes = this.newArray(13, 0.0);
            int month = this.getStartMonth(intervention);
            workTimes[month] = workTime;
            workTimes[12] = workTime;
        }
        return this.newResult(workTimes);
    }

    protected int getStartMonth(EffectiveIntervention intervention) {
        int startMonth = -1;
        Date startDate = intervention.getStartInterventionDate();
        if (startDate == null) {
            return startMonth;
        }
        Calendar testCalendar = Calendar.getInstance();
        testCalendar.setTime(startDate);
        startMonth = testCalendar.get(2);
        return startMonth;
    }
}

