/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.performance.indicators;

import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhase;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhase;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.services.performance.IndicatorWriter;
import fr.inra.agrosyst.services.performance.indicators.AbstractIndicator;

public class IndicatorSurfaceUTH
extends AbstractIndicator {
    @Override
    public String getIndicatorCategory() {
        return "R\u00e9sultats socio-techniques";
    }

    @Override
    public String getIndicatorLabel(int i) {
        return "Surface par UTH (ha)";
    }

    @Override
    public void computePracticed(IndicatorWriter writer, Domain domain) {
        if (domain.getUsedAgriculturalArea() != null) {
            double totalMO = this.getDomainTotalMO(domain);
            Double usedAgriArea = domain.getUsedAgriculturalArea();
            if (totalMO != 0.0 && usedAgriArea != null) {
                double areaBYMo = usedAgriArea / totalMO;
                writer.writePracticed(this.getIndicatorCategory(), this.getIndicatorLabel(0), String.valueOf(domain.getCampaign()), domain, areaBYMo);
            }
        }
    }

    @Override
    public void computeEffective(IndicatorWriter writer, Domain domain) {
        if (domain.getUsedAgriculturalArea() != null) {
            double totalMO = this.getDomainTotalMO(domain);
            Double usedAgriArea = domain.getUsedAgriculturalArea();
            if (totalMO != 0.0 && usedAgriArea != null) {
                double areaBYMo = usedAgriArea / totalMO;
                writer.writeEffective(this.getIndicatorCategory(), this.getIndicatorLabel(0), domain.getCampaign(), domain, areaBYMo);
            }
        }
    }

    public double getDomainTotalMO(Domain domain) {
        double result = 0.0;
        if (domain.getOtherWorkForce() != null) {
            result += domain.getOtherWorkForce().doubleValue();
        }
        if (domain.getPermanentEmployeesWorkForce() != null) {
            result += domain.getPermanentEmployeesWorkForce().doubleValue();
        }
        if (domain.getTemporaryEmployeesWorkForce() != null) {
            result += domain.getTemporaryEmployeesWorkForce().doubleValue();
        }
        return result;
    }

    @Override
    public Double[] manageIntervention(PracticedIntervention intervention, GrowingSystem growingSystem, String campaigns, String croppingPlanEntryCode, String previousPlanEntryCode, PracticedCropCyclePhase phase) {
        return null;
    }

    @Override
    public Double[] manageIntervention(EffectiveIntervention intervention, Zone zone, CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry, EffectiveCropCyclePhase phase) {
        return null;
    }
}

