/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.performance.indicators;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.BasicPlot;
import fr.inra.agrosyst.api.entities.BufferStrip;
import fr.inra.agrosyst.api.entities.CropCyclePhaseType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.MaxSlope;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.ToolsCouplingTopiaDao;
import fr.inra.agrosyst.api.entities.WaterFlowDistance;
import fr.inra.agrosyst.api.entities.WeedType;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.AbstractInput;
import fr.inra.agrosyst.api.entities.action.AbstractInputTopiaDao;
import fr.inra.agrosyst.api.entities.action.PesticideProductInput;
import fr.inra.agrosyst.api.entities.action.PhytoProductInput;
import fr.inra.agrosyst.api.entities.action.PhytoProductInputTopiaDao;
import fr.inra.agrosyst.api.entities.action.SeedingProductInputImpl;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnection;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnectionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNode;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNodeTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhase;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.effective.EffectiveInterventionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycle;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleConnection;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleConnectionTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNode;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhase;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedInterventionTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlot;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlotTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedSeasonalCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystemTopiaDao;
import fr.inra.agrosyst.api.entities.referential.PeriodeSemis;
import fr.inra.agrosyst.api.entities.referential.RefActaSubstanceActive;
import fr.inra.agrosyst.api.entities.referential.RefActaSubstanceActiveTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduit;
import fr.inra.agrosyst.api.entities.referential.RefCouvSolAnnuelle;
import fr.inra.agrosyst.api.entities.referential.RefCouvSolAnnuelleTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefCouvSolPerenne;
import fr.inra.agrosyst.api.entities.referential.RefCouvSolPerenneTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefCultureEdiGroupeCouvSol;
import fr.inra.agrosyst.api.entities.referential.RefCultureEdiGroupeCouvSolTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefEspece;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.entities.referential.RefPhytoSubstanceActiveIphy;
import fr.inra.agrosyst.api.entities.referential.RefPhytoSubstanceActiveIphyTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSaActaIphy;
import fr.inra.agrosyst.api.entities.referential.RefSaActaIphyTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefZoneClimatiqueIphy;
import fr.inra.agrosyst.api.entities.referential.RefZoneClimatiqueIphyTopiaDao;
import fr.inra.agrosyst.api.entities.referential.TypeCulture;
import fr.inra.agrosyst.api.entities.referential.VitesseCouv;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoCaseGroundWater;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoCaseGroundWaterTopiaDao;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoFuzzySetGroundWater;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoFuzzySetGroundWaterTopiaDao;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoRulesGroundWater;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoRulesGroundWaterTopiaDao;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesuRunoffPotRulesParc;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesuRunoffPotRulesParcTopiaDao;
import fr.inra.agrosyst.services.performance.IndicatorWriter;
import fr.inra.agrosyst.services.performance.indicators.Indicator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.collections4.map.MultiValueMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndicatorIPhy
extends Indicator {
    private static final Log log = LogFactory.getLog(IndicatorIPhy.class);
    protected static final String[] RESULTS = new String[]{"rceso", "rcesu_rd", "rcesu_de", "rcair_vo", "rcair_de", "iphyeso", "iphyesu", "iphyair", "iphy"};
    protected CroppingPlanEntryTopiaDao croppingPlanEntryDao;
    protected ToolsCouplingTopiaDao toolsCouplingDAO;
    protected AbstractActionTopiaDao abstractActionTopiaDao;
    protected AbstractInputTopiaDao abstractInputTopiaDao;
    protected PracticedSystemTopiaDao practicedSystemDao;
    protected PracticedSeasonalCropCycleTopiaDao practicedSeasonalCropCycleDao;
    protected PracticedPerennialCropCycleTopiaDao practicedPerennialCropCycleDao;
    protected PracticedCropCycleConnectionTopiaDao practicedCropCycleConnectionDao;
    protected PracticedInterventionTopiaDao practicedInterventionDAO;
    protected EffectivePerennialCropCycleTopiaDao effectivePerennialCropCycleTopiaDao;
    protected EffectiveSeasonalCropCycleTopiaDao effectiveSeasonalCropCycleTopiaDao;
    protected EffectiveInterventionTopiaDao effectiveInterventionTopiaDao;
    protected EffectiveCropCycleConnectionTopiaDao effectiveCropCycleConnectionTopiaDao;
    protected EffectiveCropCycleNodeTopiaDao effectiveCropCycleNodeTopiaDao;
    protected PracticedPlotTopiaDao practicedPlotTopiaDao;
    protected PhytoProductInputTopiaDao phytoProductInputTopiaDao;
    protected RefRcesoCaseGroundWaterTopiaDao rcesoCaseGroundWaterTopiaDao;
    protected RefRcesoFuzzySetGroundWaterTopiaDao rcesoFuzzySetGroundWaterTopiaDao;
    protected RefRcesoRulesGroundWaterTopiaDao rcesoRulesGroundWaterTopiaDao;
    protected RefActaSubstanceActiveTopiaDao actaSubstanceActiveTopiaDao;
    protected RefPhytoSubstanceActiveIphyTopiaDao phytoSubstanceActiveIphyTopiaDao;
    protected RefRcesuRunoffPotRulesParcTopiaDao rcesuRunoffPotRulesParcTopiaDao;
    protected RefSaActaIphyTopiaDao refSaActaIphyTopiaDao;
    protected RefZoneClimatiqueIphyTopiaDao refZoneClimatiqueIphyTopiaDao;
    protected RefCultureEdiGroupeCouvSolTopiaDao refCultureEdiGroupeCouvSolTopiaDao;
    protected RefCouvSolAnnuelleTopiaDao refCouvSolAnnuelleTopiaDao;
    protected RefCouvSolPerenneTopiaDao refCouvSolPerenneTopiaDao;
    protected MultiKeyMap<Object, Double[]> practicedGrowingSystemValues = new MultiKeyMap();
    protected MultiKeyMap<Object, Double[]> practicedSystemValues = new MultiKeyMap();
    protected MultiKeyMap<Object, List<IPhyStep>> effectiveCroppingValues = new MultiKeyMap();
    protected Map<Zone, List<IPhyStep>> effectiveZoneValues = Maps.newHashMap();
    protected Map<Plot, Double[]> effectivePlotValues = Maps.newHashMap();
    protected Map<GrowingSystem, Double[]> effectiveGrowingSystemValues = Maps.newHashMap();

    @Override
    public String getIndicatorCategory() {
        return "I-Phy";
    }

    @Override
    public String getIndicatorLabel(int i) {
        return RESULTS[i];
    }

    public void setCroppingPlanEntryDao(CroppingPlanEntryTopiaDao croppingPlanEntryDao) {
        this.croppingPlanEntryDao = croppingPlanEntryDao;
    }

    public void setToolsCouplingDAO(ToolsCouplingTopiaDao toolsCouplingDAO) {
        this.toolsCouplingDAO = toolsCouplingDAO;
    }

    public void setAbstractActionTopiaDao(AbstractActionTopiaDao abstractActionTopiaDao) {
        this.abstractActionTopiaDao = abstractActionTopiaDao;
    }

    public void setAbstractInputTopiaDao(AbstractInputTopiaDao abstractInputTopiaDao) {
        this.abstractInputTopiaDao = abstractInputTopiaDao;
    }

    public void setPracticedSystemDao(PracticedSystemTopiaDao practicedSystemDao) {
        this.practicedSystemDao = practicedSystemDao;
    }

    public void setPracticedSeasonalCropCycleDao(PracticedSeasonalCropCycleTopiaDao practicedSeasonalCropCycleDao) {
        this.practicedSeasonalCropCycleDao = practicedSeasonalCropCycleDao;
    }

    public void setPracticedPerennialCropCycleDao(PracticedPerennialCropCycleTopiaDao practicedPerennialCropCycleDao) {
        this.practicedPerennialCropCycleDao = practicedPerennialCropCycleDao;
    }

    public void setPracticedCropCycleConnectionDao(PracticedCropCycleConnectionTopiaDao practicedCropCycleConnectionDao) {
        this.practicedCropCycleConnectionDao = practicedCropCycleConnectionDao;
    }

    public void setPracticedInterventionDAO(PracticedInterventionTopiaDao practicedInterventionDAO) {
        this.practicedInterventionDAO = practicedInterventionDAO;
    }

    public void setEffectivePerennialCropCycleTopiaDao(EffectivePerennialCropCycleTopiaDao effectivePerennialCropCycleTopiaDao) {
        this.effectivePerennialCropCycleTopiaDao = effectivePerennialCropCycleTopiaDao;
    }

    public void setEffectiveInterventionTopiaDao(EffectiveInterventionTopiaDao effectiveInterventionTopiaDao) {
        this.effectiveInterventionTopiaDao = effectiveInterventionTopiaDao;
    }

    public void setEffectiveCropCycleConnectionTopiaDao(EffectiveCropCycleConnectionTopiaDao effectiveCropCycleConnectionTopiaDao) {
        this.effectiveCropCycleConnectionTopiaDao = effectiveCropCycleConnectionTopiaDao;
    }

    public EffectiveCropCycleConnectionTopiaDao getEffectiveCropCycleConnectionTopiaDao() {
        return this.effectiveCropCycleConnectionTopiaDao;
    }

    public void setEffectiveSeasonalCropCycleTopiaDao(EffectiveSeasonalCropCycleTopiaDao effectiveSeasonalCropCycleTopiaDao) {
        this.effectiveSeasonalCropCycleTopiaDao = effectiveSeasonalCropCycleTopiaDao;
    }

    public void setEffectiveCropCycleNodeTopiaDao(EffectiveCropCycleNodeTopiaDao effectiveCropCycleNodeTopiaDao) {
        this.effectiveCropCycleNodeTopiaDao = effectiveCropCycleNodeTopiaDao;
    }

    public void setPracticedPlotTopiaDao(PracticedPlotTopiaDao practicedPlotTopiaDao) {
        this.practicedPlotTopiaDao = practicedPlotTopiaDao;
    }

    public void setPhytoProductInputTopiaDao(PhytoProductInputTopiaDao phytoProductInputTopiaDao) {
        this.phytoProductInputTopiaDao = phytoProductInputTopiaDao;
    }

    public void setRcesoCaseGroundWaterTopiaDao(RefRcesoCaseGroundWaterTopiaDao rcesoCaseGroundWaterTopiaDao) {
        this.rcesoCaseGroundWaterTopiaDao = rcesoCaseGroundWaterTopiaDao;
    }

    public void setRcesoFuzzySetGroundWaterTopiaDao(RefRcesoFuzzySetGroundWaterTopiaDao rcesoFuzzySetGroundWaterTopiaDao) {
        this.rcesoFuzzySetGroundWaterTopiaDao = rcesoFuzzySetGroundWaterTopiaDao;
    }

    public void setRcesoRulesGroundWaterTopiaDao(RefRcesoRulesGroundWaterTopiaDao rcesoRulesGroundWaterTopiaDao) {
        this.rcesoRulesGroundWaterTopiaDao = rcesoRulesGroundWaterTopiaDao;
    }

    public void setActaSubstanceActiveTopiaDao(RefActaSubstanceActiveTopiaDao actaSubstanceActiveTopiaDao) {
        this.actaSubstanceActiveTopiaDao = actaSubstanceActiveTopiaDao;
    }

    public void setPhytoSubstanceActiveIphyTopiaDao(RefPhytoSubstanceActiveIphyTopiaDao phytoSubstanceActiveIphyTopiaDao) {
        this.phytoSubstanceActiveIphyTopiaDao = phytoSubstanceActiveIphyTopiaDao;
    }

    public void setRcesuRunoffPotRulesParcTopiaDao(RefRcesuRunoffPotRulesParcTopiaDao rcesuRunoffPotRulesParcTopiaDao) {
        this.rcesuRunoffPotRulesParcTopiaDao = rcesuRunoffPotRulesParcTopiaDao;
    }

    public void setRefSaActaIphyTopiaDao(RefSaActaIphyTopiaDao refSaActaIphyTopiaDao) {
        this.refSaActaIphyTopiaDao = refSaActaIphyTopiaDao;
    }

    public void setRefZoneClimatiqueIphyTopiaDao(RefZoneClimatiqueIphyTopiaDao refZoneClimatiqueIphyTopiaDao) {
        this.refZoneClimatiqueIphyTopiaDao = refZoneClimatiqueIphyTopiaDao;
    }

    public void setRefCultureEdiGroupeCouvSolTopiaDao(RefCultureEdiGroupeCouvSolTopiaDao refCultureEdiGroupeCouvSolTopiaDao) {
        this.refCultureEdiGroupeCouvSolTopiaDao = refCultureEdiGroupeCouvSolTopiaDao;
    }

    public void setRefCouvSolAnnuelleTopiaDao(RefCouvSolAnnuelleTopiaDao refCouvSolAnnuelleTopiaDao) {
        this.refCouvSolAnnuelleTopiaDao = refCouvSolAnnuelleTopiaDao;
    }

    public void setRefCouvSolPerenneTopiaDao(RefCouvSolPerenneTopiaDao refCouvSolPerenneTopiaDao) {
        this.refCouvSolPerenneTopiaDao = refCouvSolPerenneTopiaDao;
    }

    @Override
    public void computePracticed(IndicatorWriter writer, GrowingSystem growingSystem) {
        MultiKeyMap practicedCroppingValues = new MultiKeyMap();
        List practicedSystems = this.practicedSystemDao.forGrowingSystemEquals(growingSystem).findAll();
        for (PracticedSystem practicedSystem : practicedSystems) {
            String campaigns = practicedSystem.getCampaigns();
            List practicedSeasonalCropCycles = this.practicedSeasonalCropCycleDao.forPracticedSystemEquals(practicedSystem).findAll();
            for (PracticedSeasonalCropCycle cycle : practicedSeasonalCropCycles) {
                HashMap cycleValues = Maps.newHashMap();
                Collection nodes = cycle.getCropCycleNodes();
                if (CollectionUtils.isEmpty((Collection)nodes)) continue;
                List cropCycleConnections = this.practicedCropCycleConnectionDao.forTargetIn(nodes).findAll();
                List interventions = this.practicedInterventionDAO.forPracticedCropCycleConnectionIn(cropCycleConnections).findAll();
                for (PracticedIntervention intervention : interventions) {
                    String previousPlanEntryCode;
                    PracticedCropCycleConnection connection = intervention.getPracticedCropCycleConnection();
                    String croppingPlanEntryCode = intervention.isIntermediateCrop() && !Strings.isNullOrEmpty((String)connection.getIntermediateCroppingPlanEntryCode()) ? connection.getIntermediateCroppingPlanEntryCode() : connection.getTarget().getCroppingPlanEntryCode();
                    IPhyStep step = this.manageIntervention(intervention, growingSystem, campaigns, croppingPlanEntryCode, previousPlanEntryCode = connection.getSource().getCroppingPlanEntryCode(), null);
                    if (step == null) continue;
                    Double[] interValues = this.newResult(step.rceso, step.rcesu_rd, step.rcesu_de, step.rcair_vo, step.rcair_de, step.iphyeso, step.iphyesu, step.iphyair, step.iphy);
                    CroppingPlanEntry croppingPlanEntry = (CroppingPlanEntry)this.croppingPlanEntryDao.forCodeEquals(croppingPlanEntryCode).findAny();
                    CroppingPlanEntry previousPlanEntry = (CroppingPlanEntry)this.croppingPlanEntryDao.forCodeEquals(previousPlanEntryCode).findAny();
                    List actions = this.abstractActionTopiaDao.forPracticedInterventionEquals(intervention).findAll();
                    List<AbstractInput> inputs = this.abstractInputTopiaDao.findAllByPracticedIntervention(intervention);
                    for (int i = 0; i < interValues.length; ++i) {
                        writer.writePracticed(this.getIndicatorCategory(), this.getIndicatorLabel(i), campaigns, growingSystem.getGrowingPlan().getDomain(), growingSystem, practicedSystem, croppingPlanEntry, previousPlanEntry, intervention, (Collection<AbstractAction>)actions, inputs, interValues[i]);
                    }
                    ArrayList<IPhyStep> previousValue = (ArrayList<IPhyStep>)cycleValues.get(connection);
                    if (previousValue == null) {
                        previousValue = new ArrayList<IPhyStep>();
                        cycleValues.put(connection, previousValue);
                    }
                    previousValue.add(step);
                    ArrayList<IPhyStep> previous = (ArrayList<IPhyStep>)practicedCroppingValues.get((Object)practicedSystem, (Object)croppingPlanEntryCode, (Object)previousPlanEntryCode);
                    if (previous == null) {
                        previous = new ArrayList<IPhyStep>();
                        practicedCroppingValues.put((Object)practicedSystem, (Object)croppingPlanEntryCode, (Object)previousPlanEntryCode, previous);
                    }
                    previous.add(step);
                }
                Map<PracticedCropCycleConnection, Double> cumulativeFrequencies = this.computeCumulativeFrequencies(cropCycleConnections);
                int campaignCount = this.getCampaignsCount(cropCycleConnections);
                Double[] result = null;
                for (Map.Entry entry : cycleValues.entrySet()) {
                    PracticedCropCycleConnection conn = (PracticedCropCycleConnection)entry.getKey();
                    List values = (List)entry.getValue();
                    result = this.sumIPhyStep(values);
                    result = this.mults(result, cumulativeFrequencies.get(conn));
                }
                if (result == null || campaignCount <= 0) continue;
                result = this.divs(result, campaignCount);
                Double[] previousValue = (Double[])this.practicedGrowingSystemValues.get((Object)campaigns, (Object)growingSystem);
                if (previousValue == null) {
                    this.practicedGrowingSystemValues.put((Object)campaigns, (Object)growingSystem, (Object)result);
                } else {
                    Double[] sum = this.sum(previousValue, result);
                    this.practicedGrowingSystemValues.put((Object)campaigns, (Object)growingSystem, (Object)sum);
                }
                Double[] psPreviousValue = (Double[])this.practicedSystemValues.get((Object)campaigns, (Object)growingSystem);
                if (psPreviousValue == null) {
                    this.practicedGrowingSystemValues.put((Object)campaigns, (Object)growingSystem, (Object)practicedSystem, (Object)result);
                    continue;
                }
                Double[] sum = this.sum(psPreviousValue, result);
                this.practicedGrowingSystemValues.put((Object)campaigns, (Object)growingSystem, (Object)practicedSystem, (Object)sum);
            }
            List practicedPerennialCropCycles = this.practicedPerennialCropCycleDao.forPracticedSystemEquals(practicedSystem).findAll();
            for (PracticedPerennialCropCycle cycle : practicedPerennialCropCycles) {
                Collection phases = cycle.getCropCyclePhases();
                List interventions = this.practicedInterventionDAO.forPracticedCropCyclePhaseIn(phases).findAll();
                for (PracticedIntervention intervention : interventions) {
                    PracticedCropCyclePhase phase;
                    String croppingPlanEntryCode;
                    IPhyStep step = this.manageIntervention(intervention, growingSystem, campaigns, croppingPlanEntryCode = cycle.getCroppingPlanEntryCode(), null, phase = intervention.getPracticedCropCyclePhase());
                    if (step == null) continue;
                    CroppingPlanEntry croppingPlanEntry = (CroppingPlanEntry)this.croppingPlanEntryDao.forCodeEquals(croppingPlanEntryCode).findAny();
                    Double[] interValues = this.newResult(step.rceso, step.rcesu_rd, step.rcesu_de, step.rcair_vo, step.rcair_de, step.iphyeso, step.iphyesu, step.iphyair, step.iphy);
                    List actions = this.abstractActionTopiaDao.forPracticedInterventionEquals(intervention).findAll();
                    List<AbstractInput> inputs = this.abstractInputTopiaDao.findAllByPracticedIntervention(intervention);
                    for (int i = 0; i < interValues.length; ++i) {
                        writer.writePracticed(this.getIndicatorCategory(), this.getIndicatorLabel(i), campaigns, growingSystem.getGrowingPlan().getDomain(), growingSystem, practicedSystem, croppingPlanEntry, phase, intervention, (Collection<AbstractAction>)actions, inputs, interValues[i]);
                    }
                    ArrayList<IPhyStep> previous = (ArrayList<IPhyStep>)practicedCroppingValues.get((Object)practicedSystem, (Object)croppingPlanEntryCode, (Object)phase);
                    if (previous == null) {
                        previous = new ArrayList<IPhyStep>();
                        practicedCroppingValues.put((Object)practicedSystem, (Object)croppingPlanEntryCode, (Object)phase, previous);
                    }
                    previous.add(step);
                    Double[] previousValue = (Double[])this.practicedGrowingSystemValues.get((Object)campaigns, (Object)growingSystem);
                    if (previousValue == null) {
                        this.practicedGrowingSystemValues.put((Object)campaigns, (Object)growingSystem, (Object)interValues);
                    } else {
                        Double[] sum = this.sum(previousValue, interValues);
                        this.practicedGrowingSystemValues.put((Object)campaigns, (Object)growingSystem, (Object)sum);
                    }
                    Double[] psPreviousValue = (Double[])this.practicedSystemValues.get((Object)campaigns, (Object)growingSystem);
                    if (psPreviousValue == null) {
                        this.practicedGrowingSystemValues.put((Object)campaigns, (Object)growingSystem, (Object)practicedSystem, (Object)interValues);
                        continue;
                    }
                    Double[] sum = this.sum(psPreviousValue, interValues);
                    this.practicedGrowingSystemValues.put((Object)campaigns, (Object)growingSystem, (Object)practicedSystem, (Object)sum);
                }
            }
        }
        for (Map.Entry entry : practicedCroppingValues.entrySet()) {
            PracticedSystem practicedSystem = (PracticedSystem)((MultiKey)entry.getKey()).getKey(0);
            String croppingPlanEntryCode = (String)((MultiKey)entry.getKey()).getKey(1);
            Object previousPlanEntryCodeOrPhase = ((MultiKey)entry.getKey()).getKey(2);
            List steps = (List)entry.getValue();
            Double[] values = this.sumIPhyStep(steps);
            CroppingPlanEntry croppingPlanEntry = (CroppingPlanEntry)this.croppingPlanEntryDao.forCodeEquals(croppingPlanEntryCode).findAny();
            if (previousPlanEntryCodeOrPhase instanceof String) {
                CroppingPlanEntry previousPlanEntry = (CroppingPlanEntry)this.croppingPlanEntryDao.forCodeEquals((String)previousPlanEntryCodeOrPhase).findAny();
                for (int i = 0; i < values.length; ++i) {
                    writer.writePracticed(this.getIndicatorCategory(), this.getIndicatorLabel(i), practicedSystem.getCampaigns(), growingSystem.getGrowingPlan().getDomain(), growingSystem, practicedSystem, croppingPlanEntry, previousPlanEntry, values[i]);
                }
                continue;
            }
            for (int i = 0; i < values.length; ++i) {
                writer.writePracticed(this.getIndicatorCategory(), this.getIndicatorLabel(i), practicedSystem.getCampaigns(), growingSystem.getGrowingPlan().getDomain(), growingSystem, practicedSystem, croppingPlanEntry, (PracticedCropCyclePhase)previousPlanEntryCodeOrPhase, values[i]);
            }
        }
    }

    protected Map<PracticedCropCycleConnection, Double> computeCumulativeFrequencies(List<PracticedCropCycleConnection> cropCycleConnections) {
        ArrayList localConnections = Lists.newArrayList(cropCycleConnections);
        MultiValueMap precedenceMap = new MultiValueMap();
        for (PracticedCropCycleConnection conn : localConnections) {
            precedenceMap.put((Object)conn.getTarget(), (Object)conn);
        }
        HashMap result = Maps.newHashMap();
        for (PracticedCropCycleConnection conn : localConnections) {
            double frequency = this.getCumulativeFrequencies((MultiValueMap<PracticedCropCycleNode, PracticedCropCycleConnection>)precedenceMap, conn);
            result.put(conn, frequency);
        }
        return result;
    }

    protected double getCumulativeFrequencies(MultiValueMap<PracticedCropCycleNode, PracticedCropCycleConnection> precedenceMap, PracticedCropCycleConnection conn) {
        double result;
        Collection precedences = precedenceMap.getCollection((Object)conn.getSource());
        if (CollectionUtils.isEmpty((Collection)precedences)) {
            result = 1.0;
        } else {
            result = 0.0;
            for (PracticedCropCycleConnection precedence : precedences) {
                if (precedence.getSource().getRank() == 0) {
                    result = precedence.getSource().getInitNodeFrequency() == null ? 1.0 : precedence.getSource().getInitNodeFrequency() / 100.0;
                    result *= precedence.getCroppingPlanEntryFrequency() / 100.0;
                    continue;
                }
                if (precedence.getSource().getRank() >= precedence.getTarget().getRank()) continue;
                result += this.getCumulativeFrequencies(precedenceMap, precedence);
            }
        }
        return result *= conn.getCroppingPlanEntryFrequency() / 100.0;
    }

    protected int getCampaignsCount(List<PracticedCropCycleConnection> cropCycleConnections) {
        HashSet foundRanks = Sets.newHashSet();
        HashSet sameCampaignRanks = Sets.newHashSet();
        for (PracticedCropCycleConnection cropCycleConnection : cropCycleConnections) {
            PracticedCropCycleNode sourceNode = cropCycleConnection.getSource();
            PracticedCropCycleNode targetNode = cropCycleConnection.getTarget();
            foundRanks.add(sourceNode.getRank());
            foundRanks.add(targetNode.getRank());
            if (!targetNode.isSameCampaignAsPreviousNode()) continue;
            sameCampaignRanks.add(targetNode.getRank());
        }
        foundRanks.removeAll(sameCampaignRanks);
        return foundRanks.size();
    }

    @Override
    public void computePracticed(IndicatorWriter writer, Domain domain) {
        String campaigns;
        LinkedHashMap weightedValueSum = Maps.newLinkedHashMap();
        LinkedHashMap weightSum = Maps.newLinkedHashMap();
        for (Map.Entry entry : this.practicedSystemValues.entrySet()) {
            int n;
            Double[] doubleArray;
            int i;
            campaigns = (String)((MultiKey)entry.getKey()).getKey(0);
            GrowingSystem growingSystem = (GrowingSystem)((MultiKey)entry.getKey()).getKey(1);
            PracticedSystem practicedSystem = (PracticedSystem)((MultiKey)entry.getKey()).getKey(2);
            Double[] values = (Double[])entry.getValue();
            for (i = 0; i < values.length; ++i) {
                writer.writePracticed(this.getIndicatorCategory(), this.getIndicatorLabel(i), campaigns, domain, growingSystem, practicedSystem, values[i]);
            }
            if (domain.getUsedAgriculturalArea() == null || growingSystem.getAffectedAreaRate() == null) continue;
            if (!weightedValueSum.containsKey(campaigns)) {
                weightedValueSum.put(campaigns, this.newArray(values.length, 0.0));
            }
            for (i = 0; i < values.length; ++i) {
                doubleArray = (Double[])weightedValueSum.get(campaigns);
                n = i;
                Double.valueOf(doubleArray[n] + values[i] * domain.getUsedAgriculturalArea() * growingSystem.getAffectedAreaRate());
            }
            if (!weightSum.containsKey(campaigns)) {
                weightSum.put(campaigns, this.newArray(values.length, 0.0));
            }
            i = 0;
            while (i < values.length) {
                doubleArray = (Double[])weightSum.get(campaigns);
                n = i++;
                Double.valueOf(doubleArray[n] + domain.getUsedAgriculturalArea() * growingSystem.getAffectedAreaRate());
            }
        }
        for (Map.Entry entry : weightedValueSum.entrySet()) {
            campaigns = (String)entry.getKey();
            Double[] values = (Double[])entry.getValue();
            Double[] weightValues = (Double[])weightSum.get(campaigns);
            for (int i = 0; i < values.length; ++i) {
                if (weightValues[i] != 0.0) {
                    double weightedAverage = values[i] / weightValues[i];
                    writer.writePracticed(this.getIndicatorCategory(), this.getIndicatorLabel(i), campaigns, domain, weightedAverage);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"Can't compute growing system scale with 0 weigth");
            }
        }
    }

    @Override
    public void resetPracticed(Domain domain) {
        this.practicedGrowingSystemValues.clear();
    }

    @Override
    public void computeEffective(IndicatorWriter writer, Domain domain, GrowingSystem growingSystem, Plot plot, Zone zone) {
        List perennialCycles = this.effectivePerennialCropCycleTopiaDao.forZoneEquals(zone).findAll();
        for (EffectivePerennialCropCycle perennialCycle : perennialCycles) {
            EffectiveCropCyclePhase phase = perennialCycle.getPhase();
            List interventions = this.effectiveInterventionTopiaDao.forEffectiveCropCyclePhaseEquals(phase).findAll();
            for (EffectiveIntervention intervention : interventions) {
                IPhyStep step = this.manageIntervention(writer, intervention, zone, perennialCycle.getCroppingPlanEntry(), null, phase);
                if (step == null) continue;
                Double[] interValues = this.newResult(step.rceso, step.rcesu_rd, step.rcesu_de, step.rcair_vo, step.rcair_de, step.iphyeso, step.iphyesu, step.iphyair, step.iphy);
                List actions = this.abstractActionTopiaDao.forEffectiveInterventionEquals(intervention).findAll();
                List<AbstractInput> inputs = this.abstractInputTopiaDao.findAllByEffectiveIntervention(intervention);
                for (int i = 0; i < interValues.length; ++i) {
                    writer.writeEffective(this.getIndicatorCategory(), this.getIndicatorLabel(i), domain.getCampaign(), domain, zone.getPlot().getGrowingSystem(), zone.getPlot(), zone, perennialCycle.getCroppingPlanEntry(), phase, intervention, (Collection<AbstractAction>)actions, inputs, interValues[i]);
                }
                ArrayList<IPhyStep> previous = (ArrayList<IPhyStep>)this.effectiveCroppingValues.get((Object)perennialCycle.getCroppingPlanEntry(), (Object)phase);
                if (previous == null) {
                    previous = new ArrayList<IPhyStep>();
                    this.effectiveCroppingValues.put((Object)perennialCycle.getCroppingPlanEntry(), (Object)phase, previous);
                }
                previous.add(step);
                List<IPhyStep> previousValue = this.effectiveZoneValues.get(zone);
                if (previousValue == null) {
                    previousValue = new ArrayList<IPhyStep>();
                    this.effectiveZoneValues.put(zone, previousValue);
                }
                previousValue.add(step);
            }
        }
        List seasonnalCycles = this.effectiveSeasonalCropCycleTopiaDao.forZoneEquals(zone).findAll();
        for (EffectiveSeasonalCropCycle seasonnalCycle : seasonnalCycles) {
            Collection nodes = seasonnalCycle.getNodes();
            if (CollectionUtils.isEmpty((Collection)nodes)) continue;
            for (EffectiveCropCycleNode node : nodes) {
                EffectiveCropCycleConnection connection = (EffectiveCropCycleConnection)this.effectiveCropCycleConnectionTopiaDao.forTargetEquals(node).findUniqueOrNull();
                List interventions = this.effectiveInterventionTopiaDao.forEffectiveCropCycleNodeEquals(node).findAll();
                for (EffectiveIntervention intervention : interventions) {
                    EffectiveCropCycleNode lastNode;
                    CroppingPlanEntry croppingPlanEntry;
                    if (connection == null) {
                        croppingPlanEntry = node.getCroppingPlanEntry();
                        this.computeIphyStepIndicator(writer, domain, zone, node, intervention, croppingPlanEntry, null);
                        continue;
                    }
                    croppingPlanEntry = intervention.isIntermediateCrop() && connection.getIntermediateCroppingPlanEntry() != null ? connection.getIntermediateCroppingPlanEntry() : node.getCroppingPlanEntry();
                    Object previousPlanEntry = connection.getSource() == null ? ((lastNode = this.effectiveCropCycleNodeTopiaDao.findLastNodeForPreviousCampaign(zone)) == null ? null : lastNode.getCroppingPlanEntry()) : connection.getSource().getCroppingPlanEntry();
                    if (previousPlanEntry == null && log.isWarnEnabled()) {
                        log.warn((Object)"Can't get previous cropping plan entry");
                    }
                    this.computeIphyStepIndicator(writer, domain, zone, node, intervention, croppingPlanEntry, (CroppingPlanEntry)previousPlanEntry);
                }
            }
        }
        List<IPhyStep> steps = this.effectiveZoneValues.get(zone);
        if (steps != null) {
            Double[] values = this.sumIPhyStep(steps);
            for (int i = 0; i < values.length; ++i) {
                writer.writeEffective(this.getIndicatorCategory(), this.getIndicatorLabel(i), zone.getPlot().getDomain().getCampaign(), zone.getPlot().getDomain(), growingSystem, zone.getPlot(), zone, values[i]);
            }
        }
    }

    protected void computeIphyStepIndicator(IndicatorWriter writer, Domain domain, Zone zone, EffectiveCropCycleNode node, EffectiveIntervention intervention, CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry) {
        IPhyStep step = this.manageIntervention(writer, intervention, zone, node.getCroppingPlanEntry(), previousPlanEntry, null);
        if (step != null) {
            Double[] interValues = this.newResult(step.rceso, step.rcesu_rd, step.rcesu_de, step.rcair_vo, step.rcair_de, step.iphyeso, step.iphyesu, step.iphyair, step.iphy);
            List actions = this.abstractActionTopiaDao.forEffectiveInterventionEquals(intervention).findAll();
            List<AbstractInput> inputs = this.abstractInputTopiaDao.findAllByEffectiveIntervention(intervention);
            for (int i = 0; i < interValues.length; ++i) {
                writer.writeEffective(this.getIndicatorCategory(), this.getIndicatorLabel(i), domain.getCampaign(), domain, zone.getPlot().getGrowingSystem(), zone.getPlot(), zone, croppingPlanEntry, previousPlanEntry, intervention, (Collection<AbstractAction>)actions, inputs, interValues[i]);
            }
            ArrayList<IPhyStep> previous = (ArrayList<IPhyStep>)this.effectiveCroppingValues.get((Object)croppingPlanEntry, (Object)previousPlanEntry);
            if (previous == null) {
                previous = new ArrayList<IPhyStep>();
                this.effectiveCroppingValues.put((Object)croppingPlanEntry, (Object)previousPlanEntry, previous);
            }
            previous.add(step);
            List<IPhyStep> previousValue = this.effectiveZoneValues.get(zone);
            if (previousValue == null) {
                previousValue = new ArrayList<IPhyStep>();
                this.effectiveZoneValues.put(zone, previousValue);
            }
            previousValue.add(step);
        }
    }

    @Override
    public void computeEffective(IndicatorWriter writer, Domain domain, GrowingSystem growingSystem, Plot plot) {
        Double[] weightedValueSum = null;
        Double[] weightSum = null;
        for (Map.Entry<Zone, List<IPhyStep>> entry : this.effectiveZoneValues.entrySet()) {
            Zone zone = entry.getKey();
            List<IPhyStep> steps = entry.getValue();
            Double[] values = this.sumIPhyStep(steps);
            if (weightedValueSum == null) {
                weightedValueSum = this.newArray(values.length, 0.0);
                weightSum = this.newArray(values.length, 0.0);
            }
            int i = 0;
            while (i < values.length) {
                Double[] doubleArray = weightedValueSum;
                int n = i;
                Double.valueOf(doubleArray[n] + values[i] * zone.getArea());
                doubleArray = weightSum;
                n = i++;
                Double.valueOf(doubleArray[n] + zone.getArea());
            }
        }
        if (weightSum != null) {
            this.effectivePlotValues.put(plot, this.newArray(weightedValueSum.length, 0.0));
            for (int i = 0; i < weightedValueSum.length; ++i) {
                double plotValue = weightedValueSum[i].doubleValue() / weightSum[i].doubleValue();
                writer.writeEffective(this.getIndicatorCategory(), this.getIndicatorLabel(i), plot.getDomain().getCampaign(), plot.getDomain(), growingSystem, plot, plotValue);
                this.effectivePlotValues.get((Object)plot)[i] = plotValue;
            }
        }
    }

    @Override
    public void resetEffective(Domain domain, GrowingSystem growingSystem, Plot plot) {
        this.effectiveZoneValues.clear();
    }

    @Override
    public void computeEffective(IndicatorWriter writer, Domain domain, GrowingSystem growingSystem) {
        int i;
        for (Map.Entry entry : this.effectiveCroppingValues.entrySet()) {
            List steps = (List)entry.getValue();
            Double[] values = this.sumIPhyStep(steps);
            CroppingPlanEntry croppingPlanEntry = (CroppingPlanEntry)((MultiKey)entry.getKey()).getKey(0);
            Object previousPlanEntryOrPhase = ((MultiKey)entry.getKey()).getKey(1);
            for (i = 0; i < values.length; ++i) {
                if (previousPlanEntryOrPhase instanceof CroppingPlanEntry) {
                    writer.writeEffective(this.getIndicatorCategory(), this.getIndicatorLabel(i), domain.getCampaign(), domain, growingSystem, croppingPlanEntry, (CroppingPlanEntry)previousPlanEntryOrPhase, values[i]);
                    continue;
                }
                writer.writeEffective(this.getIndicatorCategory(), this.getIndicatorLabel(i), domain.getCampaign(), domain, growingSystem, croppingPlanEntry, (EffectiveCropCyclePhase)previousPlanEntryOrPhase, values[i]);
            }
        }
        Double[] weightedValueSum = null;
        Double[] weightSum = null;
        for (Map.Entry<Plot, Double[]> entry : this.effectivePlotValues.entrySet()) {
            Plot plot = entry.getKey();
            Double[] values = entry.getValue();
            if (weightedValueSum == null) {
                weightedValueSum = this.newArray(values.length, 0.0);
                weightSum = this.newArray(values.length, 0.0);
            }
            i = 0;
            while (i < values.length) {
                Double[] doubleArray = weightedValueSum;
                int n = i;
                Double.valueOf(doubleArray[n] + values[i] * plot.getArea());
                doubleArray = weightSum;
                n = i++;
                Double.valueOf(doubleArray[n] + plot.getArea());
            }
        }
        if (weightSum != null) {
            this.effectiveGrowingSystemValues.put(growingSystem, this.newArray(weightedValueSum.length, 0.0));
            for (int i2 = 0; i2 < weightedValueSum.length; ++i2) {
                double plotValue = weightedValueSum[i2] / weightSum[i2].doubleValue();
                writer.writeEffective(this.getIndicatorCategory(), this.getIndicatorLabel(i2), domain.getCampaign(), domain, growingSystem, plotValue);
                this.effectiveGrowingSystemValues.get((Object)growingSystem)[i2] = plotValue;
            }
        }
    }

    @Override
    public void resetEffective(Domain domain, GrowingSystem growingSystem) {
        this.effectiveCroppingValues.clear();
        this.effectivePlotValues.clear();
    }

    @Override
    public void computeEffective(IndicatorWriter writer, Domain domain) {
        Double[] weightedValueSum = null;
        Double[] weightSum = null;
        for (Map.Entry<GrowingSystem, Double[]> entry : this.effectiveGrowingSystemValues.entrySet()) {
            GrowingSystem growingSystem = entry.getKey();
            Double[] values = entry.getValue();
            if (growingSystem.getAffectedAreaRate() == null) continue;
            if (weightedValueSum == null) {
                weightedValueSum = this.newArray(values.length, 0.0);
                weightSum = this.newArray(values.length, 0.0);
            }
            int i = 0;
            while (i < values.length) {
                Double[] doubleArray = weightedValueSum;
                int n = i;
                Double.valueOf(doubleArray[n] + values[i] * growingSystem.getAffectedAreaRate());
                doubleArray = weightSum;
                n = i++;
                Double.valueOf(doubleArray[n] + growingSystem.getAffectedAreaRate());
            }
        }
        if (weightSum != null) {
            for (int i = 0; i < weightedValueSum.length; ++i) {
                if (weightSum[i].doubleValue() != 0.0) {
                    double domainValue = weightedValueSum[i].doubleValue() / weightSum[i].doubleValue();
                    writer.writeEffective(this.getIndicatorCategory(), this.getIndicatorLabel(i), domain.getCampaign(), domain, domainValue);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"Can't compute growing system scale with 0 weigth");
            }
        }
    }

    @Override
    public void resetEffective(Domain domain) {
    }

    public IPhyStep manageIntervention(PracticedIntervention intervention, GrowingSystem growingSystem, String campaigns, String croppingPlanEntryCode, String previousPlanEntryCode, PracticedCropCyclePhase phase) {
        IPhyStep result = null;
        IPhyStep step = new IPhyStep();
        boolean applicable = this.computeCouvertureSol(step, null, intervention, null, null, croppingPlanEntryCode, previousPlanEntryCode);
        PracticedPlot plot = null;
        if (applicable) {
            if (intervention.getPracticedCropCycleConnection() != null) {
                PracticedSystem practicedSystem = intervention.getPracticedCropCycleConnection().getTarget().getPracticedSeasonalCropCycle().getPracticedSystem();
                plot = (PracticedPlot)this.practicedPlotTopiaDao.forPracticedSystemEquals(practicedSystem).findUniqueOrNull();
            } else {
                plot = this.practicedPlotTopiaDao.getPlotForPracticedCropCyclePhase(intervention.getPracticedCropCyclePhase());
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Impossible de d\u00e9terminer la couverture de sol pour l'intervention " + intervention.getName()));
        }
        if (plot != null) {
            List<PhytoProductInput> inputs = this.phytoProductInputTopiaDao.findAllByPracticedIntervention(intervention);
            boolean bl = applicable = applicable && this.computeIphyIndicator(step, (BasicPlot)plot, inputs, null, intervention);
            if (applicable) {
                result = step;
            }
        }
        return result;
    }

    public IPhyStep manageIntervention(IndicatorWriter writer, EffectiveIntervention intervention, Zone zone, CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry, EffectiveCropCyclePhase phase) {
        IPhyStep result = null;
        IPhyStep step = new IPhyStep();
        boolean applicable = this.computeCouvertureSol(step, intervention, null, croppingPlanEntry, previousPlanEntry, null, null);
        if (applicable) {
            Plot plot = zone.getPlot();
            List<PhytoProductInput> inputs = this.phytoProductInputTopiaDao.findAllByEffectiveIntervention(intervention);
            boolean bl = applicable = applicable && this.computeIphyIndicator(step, (BasicPlot)plot, inputs, intervention, null);
            if (applicable) {
                result = step;
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Impossible de d\u00e9terminer la couverture de sol pour l'intervention " + intervention.getName()));
        }
        return result;
    }

    protected boolean computeIphyIndicator(IPhyStep step, BasicPlot plot, List<PhytoProductInput> inputs, EffectiveIntervention effectiveIntervention, PracticedIntervention practicedIntervention) {
        boolean applicable = true;
        applicable = applicable && this.computeRcesurdRceso(step, plot, inputs, effectiveIntervention, practicedIntervention);
        applicable = applicable && this.computeRcesude(step, plot, inputs, effectiveIntervention, practicedIntervention);
        applicable = applicable && this.computeRcairvo(step, plot, inputs, effectiveIntervention, practicedIntervention);
        applicable = applicable && this.computeRcairde(step, plot, inputs, effectiveIntervention, practicedIntervention);
        applicable = applicable && this.computeIPhyeso(step, plot, inputs, effectiveIntervention, practicedIntervention);
        applicable = applicable && this.computeIPhyesu(step, plot, inputs, effectiveIntervention, practicedIntervention);
        applicable = applicable && this.computeIPhyair(step, plot, inputs, effectiveIntervention, practicedIntervention);
        applicable = applicable && this.computeIPhy(step, plot, inputs, effectiveIntervention, practicedIntervention);
        return applicable;
    }

    protected boolean computeCouvertureSol(IPhyStep step, EffectiveIntervention effectiveIntervention, PracticedIntervention practicedIntervention, CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry, String croppingPlanEntryCode, String previousPlanEntryCode) {
        List croppingPlanSpecies;
        Matcher matcher;
        Preconditions.checkArgument((boolean)(effectiveIntervention != null ^ practicedIntervention != null));
        Preconditions.checkArgument((boolean)(croppingPlanEntry != null ^ practicedIntervention != null));
        boolean result = false;
        EffectiveIntervention seendingEffectiveIntervention = null;
        PracticedIntervention seendingPracticedIntervention = null;
        if (effectiveIntervention != null) {
            seendingEffectiveIntervention = effectiveIntervention.getEffectiveCropCycleNode() != null ? this.effectiveInterventionTopiaDao.findFirstInterventionWithSeedingAction(effectiveIntervention.getEffectiveCropCycleNode()) : this.effectiveInterventionTopiaDao.findFirstInterventionWithSeedingAction(effectiveIntervention.getEffectiveCropCyclePhase());
            if (seendingEffectiveIntervention == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Can't find intervention of seeding action for " + effectiveIntervention.getName()));
                }
                return result;
            }
        } else {
            seendingPracticedIntervention = practicedIntervention.getPracticedCropCycleConnection() != null ? this.practicedInterventionDAO.findFirstInterventionWithSeedingAction(practicedIntervention.getPracticedCropCycleConnection()) : this.practicedInterventionDAO.findFirstInterventionWithSeedingAction(practicedIntervention.getPracticedCropCyclePhase());
            if (seendingPracticedIntervention == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Can't find intervention of seeding action for " + practicedIntervention.getName()));
                }
                return result;
            }
        }
        int monthIndex = -1;
        if (seendingEffectiveIntervention != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(seendingEffectiveIntervention.getStartInterventionDate());
            monthIndex = calendar.get(2);
            if (monthIndex == 9 && calendar.get(5) >= 15 || monthIndex > 9) {
                ++monthIndex;
            }
        } else if (seendingPracticedIntervention != null && (matcher = PRACTICED_DATE_PATTERN.matcher(seendingPracticedIntervention.getStartingPeriodDate())).find() && ((monthIndex = Integer.parseInt(matcher.group(2)) - 1) == 9 && Integer.parseInt(matcher.group(1)) > 15 || monthIndex > 9)) {
            ++monthIndex;
        }
        PeriodeSemis periodSemis = PeriodeSemis.values()[monthIndex];
        CroppingPlanEntry localCroppingPlanEntry = croppingPlanEntry;
        if (localCroppingPlanEntry == null) {
            localCroppingPlanEntry = (CroppingPlanEntry)this.croppingPlanEntryDao.forCodeEquals(croppingPlanEntryCode).findAny();
        }
        if (CollectionUtils.isEmpty((Collection)(croppingPlanSpecies = localCroppingPlanEntry.getCroppingPlanSpecies())) && log.isWarnEnabled()) {
            log.warn((Object)("Can't find species for cropping plan entry " + localCroppingPlanEntry.getName()));
        }
        RefCultureEdiGroupeCouvSol refCultureEdiGroupeCouvSolMax = null;
        for (CroppingPlanSpecies species : croppingPlanSpecies) {
            RefEspece espece = species.getSpecies();
            RefCultureEdiGroupeCouvSol refCultureEdiGroupeCouvSol = (RefCultureEdiGroupeCouvSol)this.refCultureEdiGroupeCouvSolTopiaDao.forProperties("code_espece_botanique", espece.getCode_espece_botanique(), new Object[]{"code_qualifiant_aee", espece.getCode_qualifiant_AEE(), "code_type_saisonnier_aee", espece.getCode_type_saisonnier_AEE(), "code_destination_aee", espece.getCode_destination_AEE()}).findUniqueOrNull();
            if (refCultureEdiGroupeCouvSol == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)String.format("Can't find CultureEdiGroupeCouvSol for %s/%s/%s/%s", espece.getCode_espece_botanique(), espece.getCode_qualifiant_AEE(), espece.getCode_type_saisonnier_AEE(), espece.getCode_destination_AEE()));
                }
                return result;
            }
            if (refCultureEdiGroupeCouvSolMax != null && !(refCultureEdiGroupeCouvSolMax.getTaux_couverture_max() < refCultureEdiGroupeCouvSol.getTaux_couverture_max())) continue;
            refCultureEdiGroupeCouvSolMax = refCultureEdiGroupeCouvSol;
        }
        double couvSolMax = refCultureEdiGroupeCouvSolMax.getTaux_couverture_max();
        VitesseCouv vitesseCouv = refCultureEdiGroupeCouvSolMax.getVitesseCouv();
        int interventionStartMonth = 0;
        int interventionStartDay = 0;
        if (effectiveIntervention != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(effectiveIntervention.getStartInterventionDate());
            interventionStartMonth = calendar.get(2) + 1;
            interventionStartDay = calendar.get(5) + 1;
        } else {
            Matcher matcher2 = PRACTICED_DATE_PATTERN.matcher(practicedIntervention.getStartingPeriodDate());
            if (matcher2.find()) {
                interventionStartMonth = Integer.parseInt(matcher2.group(2));
                interventionStartDay = Integer.parseInt(matcher2.group(1));
            }
        }
        switch (refCultureEdiGroupeCouvSolMax.getTypeCulture()) {
            case ANNUELLE: 
            case PLURI_ANNUELLE: {
                if (refCultureEdiGroupeCouvSolMax.getTypeCulture() == TypeCulture.PLURI_ANNUELLE && (croppingPlanEntry != null && croppingPlanEntry.equals(previousPlanEntry) || croppingPlanEntryCode != null && croppingPlanEntryCode.equals(previousPlanEntryCode))) {
                    step.couvertureSol = 1.0;
                    result = true;
                    break;
                }
                List refCouvSolAnnuelles = this.refCouvSolAnnuelleTopiaDao.forProperties("periodeSemis", periodSemis, new Object[]{"vitesseCouv", vitesseCouv}).findAll();
                RefCouvSolAnnuelle matchingRefCouvSolAnnuelle = null;
                for (RefCouvSolAnnuelle refCouvSolAnnuelle : refCouvSolAnnuelles) {
                    Matcher debutInter = PRACTICED_DATE_PATTERN.matcher(refCouvSolAnnuelle.getDebut_inter());
                    Matcher finInter = PRACTICED_DATE_PATTERN.matcher(refCouvSolAnnuelle.getFin_inter());
                    if (!debutInter.find() || !finInter.find()) continue;
                    int debutInterMonth = Integer.parseInt(debutInter.group(2));
                    int debutInterDay = Integer.parseInt(debutInter.group(1));
                    int finInterMonth = Integer.parseInt(finInter.group(2));
                    int finInterDay = Integer.parseInt(finInter.group(1));
                    if (debutInterMonth != interventionStartMonth || interventionStartMonth != finInterMonth || debutInterDay > interventionStartDay || interventionStartDay > finInterDay) continue;
                    matchingRefCouvSolAnnuelle = refCouvSolAnnuelle;
                }
                if (matchingRefCouvSolAnnuelle == null) break;
                step.couvertureSol = Math.min(matchingRefCouvSolAnnuelle.getCouv(), couvSolMax);
                result = true;
                break;
            }
            case PERENNE: {
                WeedType weedType;
                if (practicedIntervention != null) {
                    PracticedPerennialCropCycle practicedPerennialCropCycle = this.practicedPerennialCropCycleDao.findPerennialCropCycleForIntervention(practicedIntervention);
                    weedType = practicedPerennialCropCycle.getWeedType();
                } else {
                    EffectivePerennialCropCycle effectivePerennialCropCycle = this.effectivePerennialCropCycleTopiaDao.findPerennialCropCycleForIntervention(effectiveIntervention);
                    weedType = effectivePerennialCropCycle.getWeedType();
                }
                if (weedType == null) {
                    result = false;
                    break;
                }
                if (weedType == WeedType.TOTAL) {
                    step.couvertureSol = 1.0;
                    result = true;
                    break;
                }
                CropCyclePhaseType cropCyclePhaseType = null;
                if (practicedIntervention != null && practicedIntervention.getPracticedCropCyclePhase() != null) {
                    cropCyclePhaseType = practicedIntervention.getPracticedCropCyclePhase().getType();
                } else if (effectiveIntervention != null && effectiveIntervention.getEffectiveCropCyclePhase() != null) {
                    cropCyclePhaseType = effectiveIntervention.getEffectiveCropCyclePhase().getType();
                } else {
                    return result;
                }
                List refCouvSolPerennes = this.refCouvSolPerenneTopiaDao.forProperties("phase", cropCyclePhaseType, new Object[]{"vitesseCouv", vitesseCouv}).findAll();
                RefCouvSolPerenne matchingRefCouvSolPerenne = null;
                for (RefCouvSolPerenne refCouvSolPerenne : refCouvSolPerennes) {
                    Matcher debutInter = PRACTICED_DATE_PATTERN.matcher(refCouvSolPerenne.getDebut_inter());
                    Matcher finInter = PRACTICED_DATE_PATTERN.matcher(refCouvSolPerenne.getFin_inter());
                    if (!debutInter.find() || !finInter.find()) continue;
                    int debutInterMonth = Integer.parseInt(debutInter.group(2));
                    int debutInterDay = Integer.parseInt(debutInter.group(1));
                    int finInterMonth = Integer.parseInt(finInter.group(2));
                    int finInterDay = Integer.parseInt(finInter.group(1));
                    if (debutInterMonth != interventionStartMonth || interventionStartMonth != finInterMonth || debutInterDay > interventionStartDay || interventionStartDay > finInterDay) continue;
                    matchingRefCouvSolPerenne = refCouvSolPerenne;
                }
                if (matchingRefCouvSolPerenne == null) break;
                if (weedType == WeedType.PARTIEL) {
                    step.couvertureSol = Math.max(0.5, Math.min(couvSolMax, matchingRefCouvSolPerenne.getCouv()));
                } else if (weedType == WeedType.PAS_ENHERBEMENT) {
                    step.couvertureSol = Math.min(couvSolMax, matchingRefCouvSolPerenne.getCouv());
                }
                result = true;
            }
        }
        return result;
    }

    protected boolean computeRcesurdRceso(IPhyStep step, BasicPlot plot, List<PhytoProductInput> inputs, EffectiveIntervention effectiveIntervention, PracticedIntervention practicedIntervention) {
        Double tauxMo;
        RefRcesoCaseGroundWater caseGroundWater;
        int month;
        RefRcesuRunoffPotRulesParc rcesuRunoffPotRulesParc;
        Preconditions.checkArgument((boolean)(effectiveIntervention == null ^ practicedIntervention == null));
        String soilTexture = null;
        if (plot.getSurfaceTexture() == null) {
            return false;
        }
        soilTexture = plot.getSurfaceTexture().getClasse_INDIGO();
        boolean battance = plot.isSolBattance();
        MaxSlope maxSlope = plot.getMaxSlope();
        if (maxSlope == null) {
            return false;
        }
        boolean hydromorphisms = plot.isSolHydromorphisms();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Search runoff potential for %s, %s, %s, %s", soilTexture, battance, hydromorphisms, maxSlope));
        }
        if ((rcesuRunoffPotRulesParc = (RefRcesuRunoffPotRulesParc)this.rcesuRunoffPotRulesParcTopiaDao.forProperties("active", true, new Object[]{"soil_texture", soilTexture, "battance", battance, "hydromorphisms", hydromorphisms, "slope", maxSlope}).findUniqueOrNull()) == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format(" Can't find %s with active %s, soilTexture %s, battance %s, hydromorphisms %s, slope %s", RefRcesuRunoffPotRulesParc.class.getName(), true, soilTexture, battance, hydromorphisms, maxSlope));
            }
            return false;
        }
        double runoffPotential = rcesuRunoffPotRulesParc != null ? rcesuRunoffPotRulesParc.getRunoff_potential() : 0.0;
        double factorTillage = 1.0;
        BufferStrip bufferStrip = plot.getBufferStrip();
        double factorBufferstrip = bufferStrip == BufferStrip.NONE ? 1.0 : (bufferStrip == BufferStrip.BUFFER_STRIP_NEXT_TO_WATER_FLOW ? 0.5 : 0.25);
        double potRuis = runoffPotential * factorTillage * factorBufferstrip;
        if (effectiveIntervention != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(effectiveIntervention.getStartInterventionDate());
            month = calendar.get(2) + 1;
        } else {
            String startDate = practicedIntervention.getStartingPeriodDate();
            String startMonth = StringUtils.substringAfterLast((String)startDate, (String)"/");
            month = Integer.parseInt(startMonth);
        }
        String applicationPeriod = month < 4 ? "Hiver" : (month < 9 ? "Printemps" : "Automne");
        RefLocation location = plot.getLocation();
        if (location == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No location found for plot " + plot.getName()));
            }
            return false;
        }
        String departement = location.getDepartement().toUpperCase();
        RefZoneClimatiqueIphy zoneClimatiqueIphy = (RefZoneClimatiqueIphy)this.refZoneClimatiqueIphyTopiaDao.forProperties("active", true, new Object[]{"departement", departement}).findUniqueOrNull();
        if (zoneClimatiqueIphy == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Can't find %s with active %s, departement %s", RefZoneClimatiqueIphy.class.getName(), true, departement));
            }
            return false;
        }
        int zoneClimatique = zoneClimatiqueIphy.getZone_climatique();
        if (plot.getSurfaceTexture() == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No surface texture found for plot " + plot.getName()));
            }
            return false;
        }
        String textureSurface = plot.getSurfaceTexture().getTexture_iphy();
        if (plot.getSubSoilTexture() == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No sub soil texture found for plot " + plot.getName()));
            }
            return false;
        }
        String textureSubSoil = plot.getSubSoilTexture().getTexture_iphy();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Searching caseNumber for %d,%s,%s,%s", zoneClimatique, applicationPeriod, textureSurface, textureSubSoil));
        }
        if ((caseGroundWater = (RefRcesoCaseGroundWater)this.rcesoCaseGroundWaterTopiaDao.forProperties("active", true, new Object[]{"climate", zoneClimatique, "applicationPeriod", applicationPeriod, "surface_texture", textureSurface, "subsoil_texture", textureSubSoil}).findUniqueOrNull()) == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Can't find %s with active %s, climate %s, applicationPeriod %s, surfaceTexture %s, subsoilTexture %s", RefRcesoCaseGroundWater.class.getName(), true, zoneClimatique, applicationPeriod, textureSurface, textureSubSoil));
            }
            return false;
        }
        int caseNumber = caseGroundWater.getCaseNumber();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format(" caseNumber is %d", caseNumber));
        }
        if ((tauxMo = plot.getSolOrganicMaterialPercent()) == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No organic material percent found for plot " + plot.getName()));
            }
            return false;
        }
        Integer depth = plot.getSolMaxDepth();
        if (depth == null) {
            if (plot.getSolDepth() == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("No default depth found for plot " + plot.getName()));
                }
                return false;
            }
            depth = plot.getSolDepth().getProfondeur_par_defaut();
        }
        double orgC = tauxMo > 5.0 ? 3.2 : (tauxMo >= 1.5 ? 2.03 : 0.87);
        step.rcesurds = new MultiKeyMap();
        step.rcesos = new MultiKeyMap();
        for (PhytoProductInput input : inputs) {
            RefActaTraitementsProduit produit = input.getPhytoProduct();
            if (produit == null) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't find phyto product for input " + input.getProductName()));
                continue;
            }
            double couvertureSol = step.couvertureSol;
            boolean incorporation = false;
            double tpsJusquaRuis = 3.0;
            String idProduit = produit.getId_produit();
            List substanceActives = this.actaSubstanceActiveTopiaDao.forId_produitEquals(idProduit).findAll();
            for (RefActaSubstanceActive substanceActive : substanceActives) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Gestion de la substance active ACTA : " + substanceActive.getNom_commun_sa()));
                }
                RefSaActaIphy saActaIphy = (RefSaActaIphy)this.refSaActaIphyTopiaDao.forNaturalId(substanceActive.getNom_commun_sa()).findUnique();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Gestion de la substance active IPhy : " + saActaIphy.getNom_sa_iphy()));
                }
                RefPhytoSubstanceActiveIphy substanceActiveIphy = (RefPhytoSubstanceActiveIphy)this.phytoSubstanceActiveIphyTopiaDao.forNom_saEquals(saActaIphy.getNom_sa_iphy()).findUnique();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Gestion de la phyto substance active iphy " + substanceActiveIphy.getNom_sa()));
                }
                double dt50 = substanceActiveIphy.getDt50();
                double koc = substanceActiveIphy.getKoc();
                double doseSA = 0.0;
                if (!(input instanceof SeedingProductInputImpl)) {
                    doseSA = input.getQtAvg() * substanceActive.getConcentration_valeur();
                }
                double dispo = Math.exp(-Math.log(2.0) * tpsJusquaRuis / dt50);
                if (incorporation) {
                    dispo /= 2.0;
                }
                double potRuis_D_pt01 = 0.0;
                double potRuis_D_pt11 = 1.0;
                double potRuis_F_pt12 = 0.0;
                double potRuis_F_pt02 = 1.0;
                double dispo_D_pt01 = 0.0;
                double dispo_D_pt11 = 1.0;
                double dispo_F_pt12 = 0.0;
                double dispo_F_pt02 = 1.0;
                double mbshipD_potRuis = potRuis < potRuis_D_pt01 ? 0.0 : (potRuis > potRuis_D_pt11 ? 1.0 : 0.5 + 0.5 * Math.sin(Math.PI * (potRuis - potRuis_D_pt01) / (potRuis_D_pt11 - potRuis_D_pt01) - 0.5));
                double mbshipD_dispo = dispo < dispo_D_pt01 ? 0.0 : (dispo > dispo_D_pt11 ? 1.0 : 0.5 + 0.5 * Math.sin(Math.PI * (dispo - dispo_D_pt01) / (dispo_D_pt11 - dispo_D_pt01) - 0.5));
                double mbshipF_potRuis = potRuis < potRuis_F_pt12 ? 1.0 : (potRuis > potRuis_F_pt02 ? 0.0 : 0.5 + 0.5 * Math.cos(Math.PI * (potRuis - potRuis_F_pt12) / (potRuis_F_pt02 - potRuis_F_pt12)));
                double mbshipF_dispo = dispo < dispo_F_pt12 ? 1.0 : (dispo > dispo_F_pt02 ? 0.0 : 0.5 + 0.5 * Math.cos(Math.PI * (dispo - dispo_F_pt12) / (dispo_F_pt02 - dispo_F_pt12)));
                double weightDD = Math.min(mbshipD_potRuis, mbshipD_dispo);
                double weightDF = Math.min(mbshipD_potRuis, mbshipF_dispo);
                double weightFD = Math.min(mbshipF_potRuis, mbshipD_dispo);
                double weightFF = Math.min(mbshipF_potRuis, mbshipF_dispo);
                double zDD = 0.0;
                double zDF = 5.5;
                double zFD = 6.7;
                double zFF = 10.0;
                double wr_DD = weightDD * zDD;
                double wr_DF = weightDF * zDF;
                double wr_FD = weightFD * zFD;
                double wr_FF = weightFF * zFF;
                double rcesu_rd1kg = (weightDD + weightDF + weightFD + weightFF) / (wr_DD + wr_DF + wr_FD + wr_FF);
                RefRcesoFuzzySetGroundWater dOrgc = (RefRcesoFuzzySetGroundWater)this.rcesoFuzzySetGroundWaterTopiaDao.forNaturalId(caseNumber, "OrgC", "D").findUnique();
                RefRcesoFuzzySetGroundWater fOrgc = (RefRcesoFuzzySetGroundWater)this.rcesoFuzzySetGroundWaterTopiaDao.forNaturalId(caseNumber, "OrgC", "F").findUnique();
                RefRcesoFuzzySetGroundWater dDepth = (RefRcesoFuzzySetGroundWater)this.rcesoFuzzySetGroundWaterTopiaDao.forNaturalId(caseNumber, "Depth", "D").findUnique();
                RefRcesoFuzzySetGroundWater fDepth = (RefRcesoFuzzySetGroundWater)this.rcesoFuzzySetGroundWaterTopiaDao.forNaturalId(caseNumber, "Depth", "F").findUnique();
                RefRcesoFuzzySetGroundWater dKoc = (RefRcesoFuzzySetGroundWater)this.rcesoFuzzySetGroundWaterTopiaDao.forNaturalId(caseNumber, "Koc", "D").findUnique();
                RefRcesoFuzzySetGroundWater fKoc = (RefRcesoFuzzySetGroundWater)this.rcesoFuzzySetGroundWaterTopiaDao.forNaturalId(caseNumber, "Koc", "F").findUnique();
                RefRcesoFuzzySetGroundWater dDt50 = (RefRcesoFuzzySetGroundWater)this.rcesoFuzzySetGroundWaterTopiaDao.forNaturalId(caseNumber, "DT50", "D").findUnique();
                RefRcesoFuzzySetGroundWater fDt50 = (RefRcesoFuzzySetGroundWater)this.rcesoFuzzySetGroundWaterTopiaDao.forNaturalId(caseNumber, "DT50", "F").findUnique();
                double mbshipDOrgC = Math.exp(-Math.pow(Math.max(orgC, dOrgc.getC()) - dOrgc.getC(), 2.0) / (2.0 * Math.pow(dOrgc.getSigma(), 2.0)));
                double mbshipDDepth = Math.exp(-Math.pow(Math.max((double)depth.intValue(), dDepth.getC()) - dDepth.getC(), 2.0) / (2.0 * Math.pow(dDepth.getSigma(), 2.0)));
                double mbshipDKOC = Math.exp(-Math.pow(Math.max(koc, dKoc.getC()) - dKoc.getC(), 2.0) / (2.0 * Math.pow(dKoc.getSigma(), 2.0)));
                double mbshipDDT50 = Math.exp(-Math.pow(Math.max(dt50, dDt50.getC()) - dDt50.getC(), 2.0) / (2.0 * Math.pow(dDt50.getSigma(), 2.0)));
                double mbshipFOrgC = Math.exp(-Math.pow(Math.min(orgC, fOrgc.getC()) - fOrgc.getC(), 2.0) / (2.0 * Math.pow(fOrgc.getSigma(), 2.0)));
                double mbshipFDepth = Math.exp(-Math.pow(Math.min((double)depth.intValue(), fDepth.getC()) - fDepth.getC(), 2.0) / (2.0 * Math.pow(fDepth.getSigma(), 2.0)));
                double mbshipFKOC = Math.exp(-Math.pow(Math.min(koc, fKoc.getC()) - fKoc.getC(), 2.0) / (2.0 * Math.pow(fKoc.getSigma(), 2.0)));
                double mbshipFDT50 = Math.exp(-Math.pow(Math.min(dt50, fDt50.getC()) - fDt50.getC(), 2.0) / (2.0 * Math.pow(fDt50.getSigma(), 2.0)));
                double weightDDDD = mbshipDOrgC * mbshipDDepth * mbshipDKOC * mbshipDDT50;
                double weightDDDF = mbshipDOrgC * mbshipDDepth * mbshipDKOC * mbshipFDT50;
                double weightDDFD = mbshipDOrgC * mbshipDDepth * mbshipFKOC * mbshipDDT50;
                double weightDDFF = mbshipDOrgC * mbshipDDepth * mbshipFKOC * mbshipFDT50;
                double weightDFDD = mbshipDOrgC * mbshipFDepth * mbshipDKOC * mbshipDDT50;
                double weightDFDF = mbshipDOrgC * mbshipFDepth * mbshipDKOC * mbshipFDT50;
                double weightDFFD = mbshipDOrgC * mbshipFDepth * mbshipFKOC * mbshipDDT50;
                double weightDFFF = mbshipDOrgC * mbshipFDepth * mbshipFKOC * mbshipFDT50;
                double weightFDDD = mbshipFOrgC * mbshipDDepth * mbshipDKOC * mbshipDDT50;
                double weightFDDF = mbshipFOrgC * mbshipDDepth * mbshipDKOC * mbshipFDT50;
                double weightFDFD = mbshipFOrgC * mbshipDDepth * mbshipFKOC * mbshipDDT50;
                double weightFDFF = mbshipFOrgC * mbshipDDepth * mbshipFKOC * mbshipFDT50;
                double weightFFDD = mbshipFOrgC * mbshipFDepth * mbshipDKOC * mbshipDDT50;
                double weightFFDF = mbshipFOrgC * mbshipFDepth * mbshipDKOC * mbshipFDT50;
                double weightFFFD = mbshipFOrgC * mbshipFDepth * mbshipFKOC * mbshipDDT50;
                double weightFFFF = mbshipFOrgC * mbshipFDepth * mbshipFKOC * mbshipFDT50;
                double zDDDD = ((RefRcesoRulesGroundWater)this.rcesoRulesGroundWaterTopiaDao.forNaturalId(caseNumber, "D", "D", "D", "D").findUnique()).getZ();
                double zDDDF = ((RefRcesoRulesGroundWater)this.rcesoRulesGroundWaterTopiaDao.forNaturalId(caseNumber, "D", "D", "D", "F").findUnique()).getZ();
                double zDDFD = ((RefRcesoRulesGroundWater)this.rcesoRulesGroundWaterTopiaDao.forNaturalId(caseNumber, "D", "D", "F", "D").findUnique()).getZ();
                double zDDFF = ((RefRcesoRulesGroundWater)this.rcesoRulesGroundWaterTopiaDao.forNaturalId(caseNumber, "D", "D", "F", "F").findUnique()).getZ();
                double zDFDD = ((RefRcesoRulesGroundWater)this.rcesoRulesGroundWaterTopiaDao.forNaturalId(caseNumber, "D", "F", "D", "D").findUnique()).getZ();
                double zDFDF = ((RefRcesoRulesGroundWater)this.rcesoRulesGroundWaterTopiaDao.forNaturalId(caseNumber, "D", "F", "D", "F").findUnique()).getZ();
                double zDFFD = ((RefRcesoRulesGroundWater)this.rcesoRulesGroundWaterTopiaDao.forNaturalId(caseNumber, "D", "F", "F", "D").findUnique()).getZ();
                double zDFFF = ((RefRcesoRulesGroundWater)this.rcesoRulesGroundWaterTopiaDao.forNaturalId(caseNumber, "D", "F", "F", "F").findUnique()).getZ();
                double zFDDD = ((RefRcesoRulesGroundWater)this.rcesoRulesGroundWaterTopiaDao.forNaturalId(caseNumber, "F", "D", "D", "D").findUnique()).getZ();
                double zFDDF = ((RefRcesoRulesGroundWater)this.rcesoRulesGroundWaterTopiaDao.forNaturalId(caseNumber, "F", "D", "D", "F").findUnique()).getZ();
                double zFDFD = ((RefRcesoRulesGroundWater)this.rcesoRulesGroundWaterTopiaDao.forNaturalId(caseNumber, "F", "D", "F", "D").findUnique()).getZ();
                double zFDFF = ((RefRcesoRulesGroundWater)this.rcesoRulesGroundWaterTopiaDao.forNaturalId(caseNumber, "F", "D", "F", "F").findUnique()).getZ();
                double zFFDD = ((RefRcesoRulesGroundWater)this.rcesoRulesGroundWaterTopiaDao.forNaturalId(caseNumber, "F", "F", "D", "D").findUnique()).getZ();
                double zFFDF = ((RefRcesoRulesGroundWater)this.rcesoRulesGroundWaterTopiaDao.forNaturalId(caseNumber, "F", "F", "D", "F").findUnique()).getZ();
                double zFFFD = ((RefRcesoRulesGroundWater)this.rcesoRulesGroundWaterTopiaDao.forNaturalId(caseNumber, "F", "F", "F", "D").findUnique()).getZ();
                double zFFFF = ((RefRcesoRulesGroundWater)this.rcesoRulesGroundWaterTopiaDao.forNaturalId(caseNumber, "F", "F", "F", "F").findUnique()).getZ();
                double wrDDDD = weightDDDD * zDDDD;
                double wrDDDF = weightDDDF * zDDDF;
                double wrDDFD = weightDDFD * zDDFD;
                double wrDDFF = weightDDFF * zDDFF;
                double wrDFDD = weightDFDD * zDFDD;
                double wrDFDF = weightDFDF * zDFDF;
                double wrDFFD = weightDFFD * zDFFD;
                double wrDFFF = weightDFFF * zDFFF;
                double wrFDDD = weightFDDD * zFDDD;
                double wrFDDF = weightFDDF * zFDDF;
                double wrFDFD = weightFDFD * zFDFD;
                double wrFDFF = weightFDFF * zFDFF;
                double wrFFDD = weightFFDD * zFFDD;
                double wrFFDF = weightFFDF * zFFDF;
                double wrFFFD = weightFFFD * zFFFD;
                double wrFFFF = weightFFFF * zFFFF;
                double rcesokg = (weightDDDD + weightDDDF + weightDDFD + weightDDFF + weightDFDD + weightDFDF + weightDFFD + weightDFFF + weightFDDD + weightFDDF + weightFDFD + weightFDFF + weightFFDD + weightFFDF + weightFFFD + weightFFFF) / (wrDDDD + wrDDDF + wrDDFD + wrDDFF + wrDFDD + wrDFDF + wrDFFD + wrDFFF + wrFDDD + wrFDDF + wrFDFD + wrFDFF + wrFFDD + wrFFDF + wrFFFD + wrFFFF);
                if (plot.isDrainage() && rcesu_rd1kg > rcesokg) {
                    rcesu_rd1kg = rcesokg;
                    rcesokg = 10.0;
                }
                doseSA = doseSA * (1.0 - couvertureSol) / 1000.0;
                double rcesu_rd = 0.0;
                if (doseSA > 1.0) {
                    if (rcesu_rd1kg == 0.0) {
                        rcesu_rd = 0.0;
                    } else if (doseSA <= 10.0) {
                        rcesu_rd = Math.max(rcesu_rd1kg - 2.0 * (doseSA - 1.0) / 9.0, 0.0);
                    } else if (doseSA <= 100.0) {
                        rcesu_rd = Math.max(rcesu_rd1kg - 2.0 - 2.0 * (doseSA / 10.0 - 1.0) / 9.0, 0.0);
                    }
                } else if (doseSA >= 0.1) {
                    rcesu_rd = Math.min(rcesu_rd1kg + 2.0 - 2.0 * (doseSA * 10.0 - 1.0) / 9.0, 10.0);
                } else if (doseSA >= 0.01) {
                    rcesu_rd = Math.min(rcesu_rd1kg + 4.0 - 2.0 * (doseSA * 100.0 - 1.0) / 9.0, 10.0);
                } else if (doseSA >= 0.001) {
                    rcesu_rd = Math.min(rcesu_rd1kg + 6.0 - 2.0 * (doseSA * 1000.0 - 1.0) / 9.0, 10.0);
                }
                double psci = effectiveIntervention != null ? this.getInputPSCi(effectiveIntervention, input) : this.getInputPSCi(practicedIntervention, input);
                rcesu_rd = 10.0 * (1.0 - psci) + rcesu_rd * psci;
                step.rcesurds.put((Object)produit, (Object)substanceActiveIphy, (Object)rcesu_rd);
                doseSA = doseSA * (1.0 - couvertureSol) / 1000.0;
                double rceso = 0.0;
                if (doseSA > 1.0) {
                    if (rcesokg == 0.0) {
                        rceso = 0.0;
                    } else if (doseSA <= 10.0) {
                        rceso = Math.max(rcesokg - 2.0 * (doseSA - 1.0) / 9.0, 0.0);
                    } else if (doseSA <= 100.0) {
                        rceso = Math.max(rcesokg - 2.0 - 2.0 * (doseSA / 10.0 - 1.0) / 9.0, 0.0);
                    }
                } else if (doseSA >= 0.1) {
                    rceso = Math.min(rcesokg + 2.0 - 2.0 * (doseSA * 10.0 - 1.0) / 9.0, 10.0);
                } else if (doseSA >= 0.01) {
                    rceso = Math.min(rcesokg + 4.0 - 2.0 * (doseSA * 100.0 - 1.0) / 9.0, 10.0);
                } else if (doseSA >= 0.001) {
                    rceso = Math.min(rcesokg + 6.0 - 2.0 * (doseSA * 1000.0 - 1.0) / 9.0, 10.0);
                }
                rceso = 10.0 * (1.0 - psci / 100.0) + rceso * psci / 100.0;
                step.rcesos.put((Object)produit, (Object)substanceActiveIphy, (Object)rceso);
            }
        }
        double rcesu_rd = this.scaleToTreatment(step.rcesurds.values());
        if (log.isDebugEnabled()) {
            log.debug((Object)("rcesu_rd = " + rcesu_rd));
        }
        step.rcesu_rd = rcesu_rd;
        double rceso = this.scaleToTreatment(step.rcesos.values());
        if (log.isDebugEnabled()) {
            log.debug((Object)("rceso = " + rceso));
        }
        step.rceso = rceso;
        return true;
    }

    protected boolean computeRcesude(IPhyStep step, BasicPlot plot, List<PhytoProductInput> inputs, EffectiveIntervention effectiveIntervention, PracticedIntervention practicedIntervention) {
        Preconditions.checkArgument((boolean)(effectiveIntervention == null ^ practicedIntervention == null));
        WaterFlowDistance distanceRiviere = plot.getWaterFlowDistance();
        BufferStrip bandeEnherbee = plot.getBufferStrip();
        double driftPotential = 1.0E-4;
        if (distanceRiviere == WaterFlowDistance.LESS_THAN_THREE) {
            if (bandeEnherbee == BufferStrip.NONE) {
                driftPotential = 0.0209229411025554;
            } else if (bandeEnherbee == BufferStrip.BUFFER_STRIP_NEXT_TO_WATER_FLOW) {
                driftPotential = 1.60096648750328E-4;
            }
        } else if (distanceRiviere == WaterFlowDistance.THREE_TO_FIVE) {
            if (bandeEnherbee == BufferStrip.NONE) {
                driftPotential = 2.63232689183211E-4;
            } else if (bandeEnherbee == BufferStrip.BUFFER_STRIP_NEXT_TO_WATER_FLOW) {
                driftPotential = 1.60096648750328E-4;
            }
        } else if (distanceRiviere == WaterFlowDistance.FIVE_TO_TEN) {
            if (bandeEnherbee == BufferStrip.NONE) {
                driftPotential = 1.60096648750328E-4;
            } else if (bandeEnherbee == BufferStrip.BUFFER_STRIP_NEXT_TO_WATER_FLOW) {
                driftPotential = 1.60096648750328E-4;
            }
        }
        double potDer1 = 100.0 * driftPotential;
        step.rcesudes = new MultiKeyMap();
        for (PhytoProductInput input : inputs) {
            RefActaTraitementsProduit produit = input.getPhytoProduct();
            if (produit == null) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't find phyto product for input " + input.getProductName()));
                continue;
            }
            double couvertureSol = step.couvertureSol;
            boolean buseAntiDerive = false;
            if (input instanceof PesticideProductInput) {
                buseAntiDerive = ((PesticideProductInput)input).getPesticidesSpreadingAction().isAntiDriftNozzle();
            }
            String idProduit = produit.getId_produit();
            List substanceActives = this.actaSubstanceActiveTopiaDao.forId_produitEquals(idProduit).findAll();
            for (RefActaSubstanceActive substanceActive : substanceActives) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Gestion de la substance active ACTA : " + substanceActive.getNom_commun_sa()));
                }
                RefSaActaIphy saActaIphy = (RefSaActaIphy)this.refSaActaIphyTopiaDao.forNaturalId(substanceActive.getNom_commun_sa()).findUnique();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Gestion de la substance active IPhy : " + saActaIphy.getNom_sa_iphy()));
                }
                RefPhytoSubstanceActiveIphy substanceActiveIphy = (RefPhytoSubstanceActiveIphy)this.phytoSubstanceActiveIphyTopiaDao.forNom_saEquals(saActaIphy.getNom_sa_iphy()).findUnique();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Gestion de la phyto substance active iphy " + substanceActiveIphy.getNom_sa()));
                }
                double doseSA = 0.0;
                if (!(input instanceof SeedingProductInputImpl)) {
                    doseSA = input.getQtAvg() * substanceActive.getConcentration_valeur();
                }
                double driftCorrection = buseAntiDerive ? 0.01 : 1.0;
                double potDer = potDer1 * driftCorrection;
                double potDer_F_pt12 = 0.0;
                double potDer_F_pt02 = 1.0;
                double mbshipF_potDer = potDer < potDer_F_pt12 ? 1.0 : (potDer > potDer_F_pt02 ? 0.0 : 0.5 + 0.5 * Math.cos(Math.PI * (potDer - potDer_F_pt12) / (potDer_F_pt02 - potDer_F_pt12)));
                double rcesu_de1kg = mbshipF_potDer * 10.0;
                doseSA = doseSA * (1.0 - couvertureSol) / 1000.0;
                double rcesu_de = 0.0;
                if (doseSA > 1.0) {
                    if (rcesu_de1kg == 0.0) {
                        rcesu_de = 0.0;
                    } else if (doseSA <= 10.0) {
                        rcesu_de = Math.max(rcesu_de1kg - 2.0 * (doseSA - 1.0) / 9.0, 0.0);
                    } else if (doseSA <= 100.0) {
                        rcesu_de = Math.max(rcesu_de1kg - 2.0 - 2.0 * (doseSA / 10.0 - 1.0) / 9.0, 0.0);
                    }
                } else if (doseSA >= 0.1) {
                    rcesu_de = Math.min(rcesu_de1kg + 2.0 - 2.0 * (doseSA * 10.0 - 1.0) / 9.0, 10.0);
                } else if (doseSA >= 0.01) {
                    rcesu_de = Math.min(rcesu_de1kg + 4.0 - 2.0 * (doseSA * 100.0 - 1.0) / 9.0, 10.0);
                } else if (doseSA >= 0.001) {
                    rcesu_de = Math.min(rcesu_de1kg + 6.0 - 2.0 * (doseSA * 1000.0 - 1.0) / 9.0, 10.0);
                }
                double psci = effectiveIntervention != null ? this.getInputPSCi(effectiveIntervention, input) : this.getInputPSCi(practicedIntervention, input);
                rcesu_de = 10.0 * (1.0 - psci) + rcesu_de * psci;
                step.rcesudes.put((Object)produit, (Object)substanceActiveIphy, (Object)rcesu_de);
            }
        }
        double rcesu_de = this.scaleToTreatment(step.rcesudes.values());
        if (log.isDebugEnabled()) {
            log.debug((Object)("rcesu_de = " + rcesu_de));
        }
        step.rcesu_de = rcesu_de;
        return true;
    }

    protected boolean computeRcairvo(IPhyStep step, BasicPlot plot, List<PhytoProductInput> inputs, EffectiveIntervention effectiveIntervention, PracticedIntervention practicedIntervention) {
        step.rcairvos = new MultiKeyMap();
        for (PhytoProductInput input : inputs) {
            RefActaTraitementsProduit produit = input.getPhytoProduct();
            if (produit == null) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't find phyto product for input " + input.getProductName()));
                continue;
            }
            double couvertureSol = step.couvertureSol;
            String idProduit = produit.getId_produit();
            List substanceActives = this.actaSubstanceActiveTopiaDao.forId_produitEquals(idProduit).findAll();
            for (RefActaSubstanceActive substanceActive : substanceActives) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Gestion de la substance active ACTA : " + substanceActive.getNom_commun_sa()));
                }
                RefSaActaIphy saActaIphy = (RefSaActaIphy)this.refSaActaIphyTopiaDao.forNaturalId(substanceActive.getNom_commun_sa()).findUnique();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Gestion de la substance active IPhy : " + saActaIphy.getNom_sa_iphy()));
                }
                RefPhytoSubstanceActiveIphy substanceActiveIphy = (RefPhytoSubstanceActiveIphy)this.phytoSubstanceActiveIphyTopiaDao.forNom_saEquals(saActaIphy.getNom_sa_iphy()).findUnique();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Gestion de la phyto substance active iphy " + substanceActiveIphy.getNom_sa()));
                }
                double koc = substanceActiveIphy.getKoc();
                double vp = substanceActiveIphy.getPressionVapeur();
                double sol = substanceActiveIphy.getSolubilite();
                double doseSA = 0.0;
                if (!(input instanceof SeedingProductInputImpl)) {
                    doseSA = input.getQtAvg() * substanceActive.getConcentration_valeur();
                }
                double volatilisationSol = Math.pow(Math.E, 28.335 + Math.log(vp / (koc * sol)) * 1.6158) * couvertureSol;
                double volatilisationPlante = Math.pow(Math.E, 11.779 + Math.log(vp) * 0.85543) * (1.0 - couvertureSol);
                double volatilisation = volatilisationPlante + volatilisationSol;
                double pt01 = 0.0;
                double pt11 = 200500.0;
                double rcair_vol1kg = volatilisation < pt01 ? 10.0 : (volatilisation > pt11 ? 0.0 : 0.5 + 0.5 * Math.sin(Math.PI * (volatilisation - pt01) / (pt11 - pt01) - 0.5));
                doseSA = doseSA * (1.0 - couvertureSol) / 1000.0;
                double rcair_vol = 0.0;
                if (doseSA > 1.0) {
                    if (rcair_vol1kg == 0.0) {
                        rcair_vol = 0.0;
                    } else if (doseSA <= 10.0) {
                        rcair_vol = Math.max(rcair_vol1kg - 2.0 * (doseSA - 1.0) / 9.0, 0.0);
                    } else if (doseSA <= 100.0) {
                        rcair_vol = Math.max(rcair_vol1kg - 2.0 - 2.0 * (doseSA / 10.0 - 1.0) / 9.0, 0.0);
                    }
                } else if (doseSA >= 0.1) {
                    rcair_vol = Math.min(rcair_vol1kg + 2.0 - 2.0 * (doseSA * 10.0 - 1.0) / 9.0, 10.0);
                } else if (doseSA >= 0.01) {
                    rcair_vol = Math.min(rcair_vol1kg + 4.0 - 2.0 * (doseSA * 100.0 - 1.0) / 9.0, 10.0);
                } else if (doseSA >= 0.001) {
                    rcair_vol = Math.min(rcair_vol1kg + 6.0 - 2.0 * (doseSA * 1000.0 - 1.0) / 9.0, 10.0);
                }
                double psci = effectiveIntervention != null ? this.getInputPSCi(effectiveIntervention, input) : this.getInputPSCi(practicedIntervention, input);
                rcair_vol = 10.0 * (1.0 - psci) + rcair_vol * psci;
                step.rcairvos.put((Object)produit, (Object)substanceActiveIphy, (Object)rcair_vol);
            }
        }
        double rcair_vo = this.scaleToTreatment(step.rcairvos.values());
        if (log.isDebugEnabled()) {
            log.debug((Object)("rcair_vo = " + rcair_vo));
        }
        step.rcair_vo = rcair_vo;
        return true;
    }

    protected boolean computeRcairde(IPhyStep step, BasicPlot plot, List<PhytoProductInput> inputs, EffectiveIntervention effectiveIntervention, PracticedIntervention practicedIntervention) {
        Preconditions.checkArgument((boolean)(effectiveIntervention == null ^ practicedIntervention == null));
        WaterFlowDistance distanceRiviere = plot.getWaterFlowDistance();
        BufferStrip bandeEnherbee = plot.getBufferStrip();
        double driftPotential = 1.0E-4;
        if (distanceRiviere == WaterFlowDistance.LESS_THAN_THREE) {
            if (bandeEnherbee == BufferStrip.NONE) {
                driftPotential = 0.0209229411025554;
            } else if (bandeEnherbee == BufferStrip.BUFFER_STRIP_NEXT_TO_WATER_FLOW) {
                driftPotential = 1.60096648750328E-4;
            }
        } else if (distanceRiviere == WaterFlowDistance.THREE_TO_FIVE) {
            if (bandeEnherbee == BufferStrip.NONE) {
                driftPotential = 2.63232689183211E-4;
            } else if (bandeEnherbee == BufferStrip.BUFFER_STRIP_NEXT_TO_WATER_FLOW) {
                driftPotential = 1.60096648750328E-4;
            }
        } else if (distanceRiviere == WaterFlowDistance.FIVE_TO_TEN) {
            if (bandeEnherbee == BufferStrip.NONE) {
                driftPotential = 1.60096648750328E-4;
            } else if (bandeEnherbee == BufferStrip.BUFFER_STRIP_NEXT_TO_WATER_FLOW) {
                driftPotential = 1.60096648750328E-4;
            }
        }
        double potDer1 = 100.0 * driftPotential;
        step.rcairdes = new MultiKeyMap();
        for (PhytoProductInput input : inputs) {
            RefActaTraitementsProduit produit = input.getPhytoProduct();
            if (produit == null) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't find phyto product for input " + input.getProductName()));
                continue;
            }
            double couvertureSol = step.couvertureSol;
            boolean buseAntiDerive = false;
            if (input instanceof PesticideProductInput) {
                buseAntiDerive = ((PesticideProductInput)input).getPesticidesSpreadingAction().isAntiDriftNozzle();
            }
            String idProduit = produit.getId_produit();
            List substanceActives = this.actaSubstanceActiveTopiaDao.forId_produitEquals(idProduit).findAll();
            for (RefActaSubstanceActive substanceActive : substanceActives) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Gestion de la substance active ACTA : " + substanceActive.getNom_commun_sa()));
                }
                RefSaActaIphy saActaIphy = (RefSaActaIphy)this.refSaActaIphyTopiaDao.forNaturalId(substanceActive.getNom_commun_sa()).findUnique();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Gestion de la substance active IPhy : " + saActaIphy.getNom_sa_iphy()));
                }
                RefPhytoSubstanceActiveIphy substanceActiveIphy = (RefPhytoSubstanceActiveIphy)this.phytoSubstanceActiveIphyTopiaDao.forNom_saEquals(saActaIphy.getNom_sa_iphy()).findUnique();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Gestion de la phyto substance active iphy " + substanceActiveIphy.getNom_sa()));
                }
                double doseSA = 0.0;
                if (!(input instanceof SeedingProductInputImpl)) {
                    doseSA = input.getQtAvg() * substanceActive.getConcentration_valeur();
                }
                double driftCorrection = buseAntiDerive ? 0.01 : 0.1;
                double potDer = potDer1 * driftCorrection;
                double potDer_F_pt12 = 0.0;
                double potDer_F_pt02 = 10.0;
                double mbshipF_potDer = potDer < potDer_F_pt12 ? 1.0 : (potDer > potDer_F_pt02 ? 0.0 : 0.5 + 0.5 * Math.cos(Math.PI * (potDer - potDer_F_pt12) / (potDer_F_pt02 - potDer_F_pt12)));
                double rcair_de1kg = mbshipF_potDer * 10.0;
                doseSA = doseSA * (1.0 - couvertureSol) / 1000.0;
                double rcair_de = 0.0;
                if (doseSA > 1.0) {
                    if (rcair_de1kg == 0.0) {
                        rcair_de = 0.0;
                    } else if (doseSA <= 10.0) {
                        rcair_de = Math.max(rcair_de1kg - 2.0 * (doseSA - 1.0) / 9.0, 0.0);
                    } else if (doseSA <= 100.0) {
                        rcair_de = Math.max(rcair_de1kg - 2.0 - 2.0 * (doseSA / 10.0 - 1.0) / 9.0, 0.0);
                    }
                } else if (doseSA >= 0.1) {
                    rcair_de = Math.min(rcair_de1kg + 2.0 - 2.0 * (doseSA * 10.0 - 1.0) / 9.0, 10.0);
                } else if (doseSA >= 0.01) {
                    rcair_de = Math.min(rcair_de1kg + 4.0 - 2.0 * (doseSA * 100.0 - 1.0) / 9.0, 10.0);
                } else if (doseSA >= 0.001) {
                    rcair_de = Math.min(rcair_de1kg + 6.0 - 2.0 * (doseSA * 1000.0 - 1.0) / 9.0, 10.0);
                }
                double psci = effectiveIntervention != null ? this.getInputPSCi(effectiveIntervention, input) : this.getInputPSCi(practicedIntervention, input);
                rcair_de = 10.0 * (1.0 - psci) + rcair_de * psci;
                step.rcairdes.put((Object)produit, (Object)substanceActiveIphy, (Object)rcair_de);
            }
        }
        double rcair_de = this.scaleToTreatment(step.rcairdes.values());
        if (log.isDebugEnabled()) {
            log.debug((Object)("rcair_de = " + rcair_de));
        }
        step.rcair_de = rcair_de;
        return true;
    }

    protected boolean computeIPhyeso(IPhyStep step, BasicPlot plot, List<PhytoProductInput> inputs, EffectiveIntervention effectiveIntervention, PracticedIntervention practicedIntervention) {
        step.iphyesos = new MultiKeyMap();
        for (Map.Entry entry : step.rcesos.entrySet()) {
            RefActaTraitementsProduit produit = (RefActaTraitementsProduit)((MultiKey)entry.getKey()).getKey(0);
            RefPhytoSubstanceActiveIphy substanceActiveIphy = (RefPhytoSubstanceActiveIphy)((MultiKey)entry.getKey()).getKey(1);
            double rceso = (Double)entry.getValue();
            double dja = substanceActiveIphy.getDja();
            double rceso_D_pt12 = 0.0;
            double rceso_D_pt02 = 0.0;
            double rceso_F_pt01 = 0.0;
            double rceso_F_pt11 = 10.0;
            double log10dja_D_pt12 = -4.0;
            double log10dja_D_pt02 = 0.0;
            double log10dja_F_pt01 = -4.0;
            double log10dja_F_pt11 = 0.0;
            double mbshipD_rceso = rceso < rceso_D_pt12 ? 1.0 : (rceso > rceso_D_pt02 ? 0.0 : 0.5 + 0.5 * Math.cos(Math.PI * (rceso - rceso_D_pt12) / (rceso_D_pt02 - rceso_D_pt12)));
            double mbshipF_rceso = rceso < rceso_F_pt01 ? 0.0 : (rceso > rceso_F_pt11 ? 1.0 : 0.5 + 0.5 * Math.sin(Math.PI * ((rceso - rceso_F_pt01) / (rceso_F_pt11 - rceso_F_pt01) - 0.5)));
            double mbshipD_log10dja = Math.log10(dja) < log10dja_D_pt12 ? 1.0 : (Math.log10(dja) > log10dja_D_pt02 ? 0.0 : 0.5 + 0.5 * Math.cos(Math.PI * (Math.log10(dja) - log10dja_D_pt12) / (log10dja_D_pt02 - log10dja_D_pt12)));
            double mbshipF_log10dja = Math.log10(dja) < log10dja_F_pt01 ? 0.0 : (Math.log10(dja) > log10dja_F_pt11 ? 1.0 : 0.5 + 0.5 * Math.sin(Math.PI * ((Math.log10(dja) - log10dja_F_pt01) / (log10dja_F_pt11 - log10dja_F_pt01) - 0.5)));
            double weightDD = Math.min(mbshipD_rceso, mbshipD_log10dja);
            double weightDF = Math.min(mbshipD_rceso, mbshipF_log10dja);
            double weightFD = Math.min(mbshipF_rceso, mbshipD_log10dja);
            double weightFF = Math.min(mbshipF_rceso, mbshipF_log10dja);
            double zDD = 0.0;
            double zDF = 4.0;
            double zFD = 6.0;
            double zFF = 10.0;
            double wr_DD = weightDD * zDD;
            double wr_DF = weightDF * zDF;
            double wr_FD = weightFD * zFD;
            double wr_FF = weightFF * zFF;
            double iPhyeso = (weightDD + weightDF + weightFD + weightFF) / (wr_DD + wr_DF + wr_FD + wr_FF);
            step.iphyesos.put((Object)produit, (Object)substanceActiveIphy, (Object)iPhyeso);
        }
        double iphyeso = this.scaleToTreatment(step.iphyesos.values());
        if (log.isDebugEnabled()) {
            log.debug((Object)("iphyeso = " + iphyeso));
        }
        step.iphyeso = iphyeso;
        return true;
    }

    protected boolean computeIPhyesu(IPhyStep step, BasicPlot plot, List<PhytoProductInput> inputs, EffectiveIntervention effectiveIntervention, PracticedIntervention practicedIntervention) {
        step.iphyesus = new MultiKeyMap();
        for (Map.Entry entry : step.rcesudes.entrySet()) {
            RefActaTraitementsProduit produit = (RefActaTraitementsProduit)((MultiKey)entry.getKey()).getKey(0);
            RefPhytoSubstanceActiveIphy substanceActiveIphy = (RefPhytoSubstanceActiveIphy)((MultiKey)entry.getKey()).getKey(1);
            double dja = substanceActiveIphy.getDja();
            double aquatox = substanceActiveIphy.getAquatox();
            double rceso_de = (Double)entry.getValue();
            double rceso_rd = (Double)step.rcesurds.get((Object)produit, (Object)substanceActiveIphy);
            double tox = Math.min(Math.log10(dja) + 2.0, Math.log10(aquatox));
            double rceso_rd_D_pt12 = 0.0;
            double rceso_rd_D_pt02 = 10.0;
            double rceso_rd_F_pt01 = 0.0;
            double rceso_rd_F_pt11 = 10.0;
            double rceso_de_D_pt12 = 0.0;
            double rceso_de_D_pt02 = 10.0;
            double rceso_de_F_pt01 = 0.0;
            double rceso_de_F_pt11 = 10.0;
            double tox_D_pt12 = -2.0;
            double tox_D_pt02 = 2.0;
            double tox_F_pt01 = -2.0;
            double tox_F_pt11 = 2.0;
            double mbshipD_rceso_rd = rceso_rd < rceso_rd_D_pt12 ? 1.0 : (rceso_rd > rceso_rd_D_pt02 ? 0.0 : 0.5 + 0.5 * Math.cos(Math.PI * (rceso_rd - rceso_rd_D_pt12) / (rceso_rd_D_pt02 - rceso_rd_D_pt12)));
            double mbshipF_rceso_rd = rceso_rd < rceso_rd_F_pt01 ? 0.0 : (rceso_rd > rceso_rd_F_pt11 ? 1.0 : 0.5 + 0.5 * Math.sin(Math.PI * ((rceso_rd - rceso_rd_F_pt01) / (rceso_rd_F_pt11 - rceso_rd_F_pt01) - 0.5)));
            double mbshipD_rceso_de = rceso_de < rceso_de_D_pt12 ? 1.0 : (rceso_de > rceso_de_D_pt02 ? 0.0 : 0.5 + 0.5 * Math.cos(Math.PI * (rceso_de - rceso_de_D_pt12) / (rceso_de_D_pt02 - rceso_de_D_pt12)));
            double mbshipF_rceso_de = rceso_de < rceso_de_F_pt01 ? 0.0 : (rceso_de > rceso_de_F_pt11 ? 1.0 : 0.5 + 0.5 * Math.sin(Math.PI * ((rceso_de - rceso_de_F_pt01) / (rceso_de_F_pt11 - rceso_de_F_pt01) - 0.5)));
            double mbshipD_tox = tox < tox_D_pt12 ? 1.0 : (tox > tox_D_pt02 ? 0.0 : 0.5 + 0.5 * Math.cos(Math.PI * (tox - tox_D_pt12) / (tox_D_pt02 - tox_D_pt12)));
            double mbshipF_tox = tox < tox_F_pt01 ? 0.0 : (tox > tox_F_pt11 ? 1.0 : 0.5 + 0.5 * Math.sin(Math.PI * ((tox - tox_F_pt01) / (tox_F_pt11 - tox_F_pt01) - 0.5)));
            double weightDDD = NumberUtils.min((double)mbshipD_rceso_rd, (double)mbshipD_rceso_de, (double)mbshipD_tox);
            double weightDDF = NumberUtils.min((double)mbshipD_rceso_rd, (double)mbshipD_rceso_de, (double)mbshipF_tox);
            double weightDFD = NumberUtils.min((double)mbshipD_rceso_rd, (double)mbshipF_rceso_de, (double)mbshipD_tox);
            double weightDFF = NumberUtils.min((double)mbshipD_rceso_rd, (double)mbshipF_rceso_de, (double)mbshipF_tox);
            double weightFDD = NumberUtils.min((double)mbshipF_rceso_rd, (double)mbshipD_rceso_de, (double)mbshipD_tox);
            double weightFDF = NumberUtils.min((double)mbshipF_rceso_rd, (double)mbshipD_rceso_de, (double)mbshipF_tox);
            double weightFFD = NumberUtils.min((double)mbshipF_rceso_rd, (double)mbshipF_rceso_de, (double)mbshipD_tox);
            double weightFFF = NumberUtils.min((double)mbshipF_rceso_rd, (double)mbshipF_rceso_de, (double)mbshipF_tox);
            double zDDD = 0.0;
            double zDDF = 4.0;
            double zDFD = 1.0;
            double zDFF = 9.0;
            double zFDD = 1.0;
            double zFDF = 9.0;
            double zFFD = 6.0;
            double zFFF = 10.0;
            double wr_DDD = weightDDD * zDDD;
            double wr_DDF = weightDDF * zDDF;
            double wr_DFD = weightDFD * zDFD;
            double wr_DFF = weightDFF * zDFF;
            double wr_FDD = weightFDD * zFDD;
            double wr_FDF = weightFDF * zFDF;
            double wr_FFD = weightFFD * zFFD;
            double wr_FFF = weightFFF * zFFF;
            double iphyesu = (wr_DDD + wr_DDF + wr_DFD + wr_DFF + wr_FDD + wr_FDF + wr_FFD + wr_FFF) / (weightDDD + weightDDF + weightDFD + weightDFF + weightFDD + weightFDF + weightFFD + weightFFF);
            step.iphyesus.put((Object)produit, (Object)substanceActiveIphy, (Object)iphyesu);
        }
        double iphyesu = this.scaleToTreatment(step.iphyesus.values());
        if (log.isDebugEnabled()) {
            log.debug((Object)("iphyesu = " + iphyesu));
        }
        step.iphyesu = iphyesu;
        return true;
    }

    protected boolean computeIPhyair(IPhyStep step, BasicPlot plot, List<PhytoProductInput> inputs, EffectiveIntervention effectiveIntervention, PracticedIntervention practicedIntervention) {
        step.iphyairs = new MultiKeyMap();
        for (Map.Entry entry : step.rcairvos.entrySet()) {
            RefActaTraitementsProduit produit = (RefActaTraitementsProduit)((MultiKey)entry.getKey()).getKey(0);
            RefPhytoSubstanceActiveIphy substanceActiveIphy = (RefPhytoSubstanceActiveIphy)((MultiKey)entry.getKey()).getKey(1);
            double dja = substanceActiveIphy.getDja();
            double rcair_vo = (Double)entry.getValue();
            double rcair_de = (Double)step.rcairdes.get((Object)produit, (Object)substanceActiveIphy);
            double tox = Math.log10(dja);
            double rcair_vo_D_pt12 = 0.0;
            double rcair_vo_D_pt02 = 10.0;
            double rcair_vo_F_pt01 = 0.0;
            double rcair_vo_F_pt11 = 10.0;
            double rcair_de_D_pt12 = 0.0;
            double rcair_de_D_pt02 = 10.0;
            double rcair_de_F_pt01 = 0.0;
            double rcair_de_F_pt11 = 10.0;
            double tox_D_pt12 = -4.0;
            double tox_D_pt02 = -4.0;
            double tox_F_pt01 = -4.0;
            double tox_F_pt11 = 0.0;
            double mbshipD_rcair_vo = rcair_vo < rcair_vo_D_pt12 ? 1.0 : (rcair_vo > rcair_vo_D_pt02 ? 0.0 : 0.5 + 0.5 * Math.cos(Math.PI * (rcair_vo - rcair_vo_D_pt12) / (rcair_vo_D_pt02 - rcair_vo_D_pt12)));
            double mbshipF_rcair_vo = rcair_vo < rcair_vo_F_pt01 ? 0.0 : (rcair_vo > rcair_vo_F_pt11 ? 1.0 : 0.5 + 0.5 * Math.sin(Math.PI * ((rcair_vo - rcair_vo_F_pt01) / (rcair_vo_F_pt11 - rcair_vo_F_pt01) - 0.5)));
            double mbshipD_rcair_de = rcair_de < rcair_de_D_pt12 ? 1.0 : (rcair_de > rcair_de_D_pt02 ? 0.0 : 0.5 + 0.5 * Math.cos(Math.PI * (rcair_de - rcair_de_D_pt12) / (rcair_de_D_pt02 - rcair_de_D_pt12)));
            double mbshipF_rcair_de = rcair_de < rcair_de_F_pt01 ? 0.0 : (rcair_de > rcair_de_F_pt11 ? 1.0 : 0.5 + 0.5 * Math.sin(Math.PI * ((rcair_de - rcair_de_F_pt01) / (rcair_de_F_pt11 - rcair_de_F_pt01) - 0.5)));
            double mbshipD_tox = tox < tox_D_pt12 ? 1.0 : (tox > tox_D_pt02 ? 0.0 : 0.5 + 0.5 * Math.cos(Math.PI * (tox - tox_D_pt12) / (tox_D_pt02 - tox_D_pt12)));
            double mbshipF_tox = tox < tox_F_pt01 ? 0.0 : (tox > tox_F_pt11 ? 1.0 : 0.5 + 0.5 * Math.sin(Math.PI * ((tox - tox_F_pt01) / (tox_F_pt11 - tox_F_pt01) - 0.5)));
            double weightDDD = NumberUtils.min((double)mbshipD_rcair_vo, (double)mbshipD_rcair_de, (double)mbshipD_tox);
            double weightDDF = NumberUtils.min((double)mbshipD_rcair_vo, (double)mbshipD_rcair_de, (double)mbshipF_tox);
            double weightDFD = NumberUtils.min((double)mbshipD_rcair_vo, (double)mbshipF_rcair_de, (double)mbshipD_tox);
            double weightDFF = NumberUtils.min((double)mbshipD_rcair_vo, (double)mbshipF_rcair_de, (double)mbshipF_tox);
            double weightFDD = NumberUtils.min((double)mbshipF_rcair_vo, (double)mbshipD_rcair_de, (double)mbshipD_tox);
            double weightFDF = NumberUtils.min((double)mbshipF_rcair_vo, (double)mbshipD_rcair_de, (double)mbshipF_tox);
            double weightFFD = NumberUtils.min((double)mbshipF_rcair_vo, (double)mbshipF_rcair_de, (double)mbshipD_tox);
            double weightFFF = NumberUtils.min((double)mbshipF_rcair_vo, (double)mbshipF_rcair_de, (double)mbshipF_tox);
            double zDDD = 0.0;
            double zDDF = 4.0;
            double zDFD = 1.0;
            double zDFF = 9.0;
            double zFDD = 1.0;
            double zFDF = 9.0;
            double zFFD = 6.0;
            double zFFF = 10.0;
            double wr_DDD = weightDDD * zDDD;
            double wr_DDF = weightDDF * zDDF;
            double wr_DFD = weightDFD * zDFD;
            double wr_DFF = weightDFF * zDFF;
            double wr_FDD = weightFDD * zFDD;
            double wr_FDF = weightFDF * zFDF;
            double wr_FFD = weightFFD * zFFD;
            double wr_FFF = weightFFF * zFFF;
            double iphyair = (wr_DDD + wr_DDF + wr_DFD + wr_DFF + wr_FDD + wr_FDF + wr_FFD + wr_FFF) / (weightDDD + weightDDF + weightDFD + weightDFF + weightFDD + weightFDF + weightFFD + weightFFF);
            step.iphyairs.put((Object)produit, (Object)substanceActiveIphy, (Object)iphyair);
        }
        double iphyair = this.scaleToTreatment(step.iphyairs.values());
        if (log.isDebugEnabled()) {
            log.debug((Object)("iphyesu = " + iphyair));
        }
        step.iphyesu = iphyair;
        return true;
    }

    protected boolean computeIPhy(IPhyStep step, BasicPlot plot, List<PhytoProductInput> inputs, EffectiveIntervention effectiveIntervention, PracticedIntervention practicedIntervention) {
        step.iphys = new MultiKeyMap();
        for (Map.Entry entry : step.iphyesos.entrySet()) {
            RefActaTraitementsProduit produit = (RefActaTraitementsProduit)((MultiKey)entry.getKey()).getKey(0);
            RefPhytoSubstanceActiveIphy substanceActiveIphy = (RefPhytoSubstanceActiveIphy)((MultiKey)entry.getKey()).getKey(1);
            double iphyeso = (Double)entry.getValue();
            double iphyesu = (Double)step.iphyesus.get((Object)produit, (Object)substanceActiveIphy);
            double iphyair = (Double)step.iphyairs.get((Object)produit, (Object)substanceActiveIphy);
            double iphyeso_D_pt12 = 0.0;
            double iphyeso_D_pt02 = 10.0;
            double iphyeso_F_pt01 = 0.0;
            double iphyeso_F_pt11 = 10.0;
            double iphyesu_D_pt12 = 0.0;
            double iphyesu_D_pt02 = 10.0;
            double iphyesu_F_pt01 = 0.0;
            double iphyesu_F_pt11 = 10.0;
            double iphyair_D_pt12 = -4.0;
            double iphyair_D_pt02 = -4.0;
            double iphyair_F_pt01 = -4.0;
            double iphyair_F_pt11 = 0.0;
            double mbshipD_iphyeso = iphyeso < iphyeso_D_pt12 ? 1.0 : (iphyeso > iphyeso_D_pt02 ? 0.0 : 0.5 + 0.5 * Math.cos(Math.PI * (iphyeso - iphyeso_D_pt12) / (iphyeso_D_pt02 - iphyeso_D_pt12)));
            double mbshipF_iphyeso = iphyeso < iphyeso_F_pt01 ? 0.0 : (iphyeso > iphyeso_F_pt11 ? 1.0 : 0.5 + 0.5 * Math.sin(Math.PI * ((iphyeso - iphyeso_F_pt01) / (iphyeso_F_pt11 - iphyeso_F_pt01) - 0.5)));
            double mbshipD_iphyesu = iphyesu < iphyesu_D_pt12 ? 1.0 : (iphyesu > iphyesu_D_pt02 ? 0.0 : 0.5 + 0.5 * Math.cos(Math.PI * (iphyesu - iphyesu_D_pt12) / (iphyesu_D_pt02 - iphyesu_D_pt12)));
            double mbshipF_iphyesu = iphyesu < iphyesu_F_pt01 ? 0.0 : (iphyesu > iphyesu_F_pt11 ? 1.0 : 0.5 + 0.5 * Math.sin(Math.PI * ((iphyesu - iphyesu_F_pt01) / (iphyesu_F_pt11 - iphyesu_F_pt01) - 0.5)));
            double mbshipD_iphyair = iphyair < iphyair_D_pt12 ? 1.0 : (iphyair > iphyair_D_pt02 ? 0.0 : 0.5 + 0.5 * Math.cos(Math.PI * (iphyair - iphyair_D_pt12) / (iphyair_D_pt02 - iphyair_D_pt12)));
            double mbshipF_iphyair = iphyair < iphyair_F_pt01 ? 0.0 : (iphyair > iphyair_F_pt11 ? 1.0 : 0.5 + 0.5 * Math.sin(Math.PI * ((iphyair - iphyair_F_pt01) / (iphyair_F_pt11 - iphyair_F_pt01) - 0.5)));
            double weightDDD = NumberUtils.min((double)mbshipD_iphyeso, (double)mbshipD_iphyesu, (double)mbshipD_iphyair);
            double weightDDF = NumberUtils.min((double)mbshipD_iphyeso, (double)mbshipD_iphyesu, (double)mbshipF_iphyair);
            double weightDFD = NumberUtils.min((double)mbshipD_iphyeso, (double)mbshipF_iphyesu, (double)mbshipD_iphyair);
            double weightDFF = NumberUtils.min((double)mbshipD_iphyeso, (double)mbshipF_iphyesu, (double)mbshipF_iphyair);
            double weightFDD = NumberUtils.min((double)mbshipF_iphyeso, (double)mbshipD_iphyesu, (double)mbshipD_iphyair);
            double weightFDF = NumberUtils.min((double)mbshipF_iphyeso, (double)mbshipD_iphyesu, (double)mbshipF_iphyair);
            double weightFFD = NumberUtils.min((double)mbshipF_iphyeso, (double)mbshipF_iphyesu, (double)mbshipD_iphyair);
            double weightFFF = NumberUtils.min((double)mbshipF_iphyeso, (double)mbshipF_iphyesu, (double)mbshipF_iphyair);
            double zDDD = 0.0;
            double zDDF = 2.0;
            double zDFD = 2.0;
            double zDFF = 7.0;
            double zFDD = 2.0;
            double zFDF = 7.0;
            double zFFD = 7.0;
            double zFFF = 10.0;
            double wr_DDD = weightDDD * zDDD;
            double wr_DDF = weightDDF * zDDF;
            double wr_DFD = weightDFD * zDFD;
            double wr_DFF = weightDFF * zDFF;
            double wr_FDD = weightFDD * zFDD;
            double wr_FDF = weightFDF * zFDF;
            double wr_FFD = weightFFD * zFFD;
            double wr_FFF = weightFFF * zFFF;
            double iphy = (wr_DDD + wr_DDF + wr_DFD + wr_DFF + wr_FDD + wr_FDF + wr_FFD + wr_FFF) / (weightDDD + weightDDF + weightDFD + weightDFF + weightFDD + weightFDF + weightFFD + weightFFF);
            step.iphys.put((Object)produit, (Object)substanceActiveIphy, (Object)iphy);
        }
        double iphy = this.scaleToTreatment(step.iphys.values());
        if (log.isDebugEnabled()) {
            log.debug((Object)("iphy = " + iphy));
        }
        step.iphy = iphy;
        return true;
    }

    protected double scaleToTreatment(Collection<Double> savalues) {
        double value = 0.0;
        double valuek = 0.0;
        Double minvalue = null;
        for (Double valuei : savalues) {
            if (minvalue == null) {
                minvalue = valuei;
            } else if (valuei < minvalue) {
                minvalue = valuei;
            }
            double value0_1 = 1.0 - valuei / 10.0;
            double k = 1.7175 * Math.pow(Math.E, -0.2913 * valuei);
            double kmin = 1.7175 * Math.pow(Math.E, -0.2913 * minvalue);
            value = minvalue - (valuek += k * value0_1) + kmin * (1.0 - minvalue / 10.0);
        }
        if (value < 0.0) {
            value = 0.0;
        }
        return value;
    }

    protected Double[] sumIPhyStep(List<IPhyStep> iphysteps) {
        ArrayList<Double> rcesos = new ArrayList<Double>();
        ArrayList<Double> rcesurds = new ArrayList<Double>();
        ArrayList<Double> rcesudes = new ArrayList<Double>();
        ArrayList<Double> rcairvos = new ArrayList<Double>();
        ArrayList<Double> rcairdes = new ArrayList<Double>();
        ArrayList<Double> iphyesos = new ArrayList<Double>();
        ArrayList<Double> iphyesus = new ArrayList<Double>();
        ArrayList<Double> iphyairs = new ArrayList<Double>();
        ArrayList<Double> iphys = new ArrayList<Double>();
        for (IPhyStep iphystep : iphysteps) {
            rcesos.addAll(iphystep.rcesos.values());
            rcesurds.addAll(iphystep.rcesurds.values());
            rcesudes.addAll(iphystep.rcesudes.values());
            rcairvos.addAll(iphystep.rcairvos.values());
            rcairdes.addAll(iphystep.rcairdes.values());
            iphyesos.addAll(iphystep.iphyesos.values());
            iphyesus.addAll(iphystep.iphyesus.values());
            iphyairs.addAll(iphystep.iphyairs.values());
            iphys.addAll(iphystep.iphys.values());
        }
        Double[] result = new Double[]{this.scaleToTreatment(rcesos), this.scaleToTreatment(rcesurds), this.scaleToTreatment(rcesudes), this.scaleToTreatment(rcairvos), this.scaleToTreatment(rcairdes), this.scaleToTreatment(iphyesos), this.scaleToTreatment(iphyesus), this.scaleToTreatment(iphyairs), this.scaleToTreatment(iphys)};
        return result;
    }

    static class IPhyStep {
        protected double couvertureSol;
        protected MultiKeyMap<Object, Double> rcesos;
        protected MultiKeyMap<Object, Double> rcesurds;
        protected MultiKeyMap<Object, Double> rcesudes;
        protected MultiKeyMap<Object, Double> rcairvos;
        protected MultiKeyMap<Object, Double> rcairdes;
        protected MultiKeyMap<Object, Double> iphyesos;
        protected MultiKeyMap<Object, Double> iphyesus;
        protected MultiKeyMap<Object, Double> iphyairs;
        protected MultiKeyMap<Object, Double> iphys;
        protected double rceso;
        protected double rcesu_rd;
        protected double rcesu_de;
        protected double rcair_vo;
        protected double rcair_de;
        protected double iphyeso;
        protected double iphyesu;
        protected double iphyair;
        protected double iphy;

        IPhyStep() {
        }
    }
}

