/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.performance.indicators;

import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.CroppingPlanSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.action.PesticideProductInput;
import fr.inra.agrosyst.api.entities.action.PhytoProductInput;
import fr.inra.agrosyst.api.entities.action.PhytoProductInputTopiaDao;
import fr.inra.agrosyst.api.entities.action.PhytoProductUnit;
import fr.inra.agrosyst.api.entities.action.SeedingAction;
import fr.inra.agrosyst.api.entities.action.SeedingActionSpecies;
import fr.inra.agrosyst.api.entities.action.SeedingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.SeedingProductInputImpl;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhase;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.effective.EffectiveSpeciesStade;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhase;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedSpeciesStade;
import fr.inra.agrosyst.api.entities.referential.RefActaDosageSPC;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduit;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduitsCateg;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduitsCategTopiaDao;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.services.performance.indicators.AbstractIndicator;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndicatorIFT
extends AbstractIndicator {
    private static final Log log = LogFactory.getLog(IndicatorIFT.class);
    protected PhytoProductInputTopiaDao phytoProductInputTopiaDao;
    protected RefActaTraitementsProduitsCategTopiaDao refActaTraitementsProduitsCategTopiaDao;
    protected CroppingPlanSpeciesTopiaDao croppingPlanSpeciesTopiaDao;
    protected ReferentialService referentialService;
    protected SeedingActionTopiaDao seedingActionTopiaDao;
    protected static final String[] RESULTS = new String[]{"IFT total", "IFT tot hts", "IFT h", "IFT f", "IFT i", "IFT ts", "IFT a", "IFT hh", "IFT biocontrole", "IFT moyens biologiques"};

    @Override
    public String getIndicatorCategory() {
        return "Indicateurs de pression d\u2019utilisation des intrants";
    }

    @Override
    public String getIndicatorLabel(int i) {
        return RESULTS[i];
    }

    public void setSeedingActionTopiaDao(SeedingActionTopiaDao seedingActionTopiaDao) {
        this.seedingActionTopiaDao = seedingActionTopiaDao;
    }

    public void setPhytoProductInputTopiaDao(PhytoProductInputTopiaDao phytoProductInputTopiaDao) {
        this.phytoProductInputTopiaDao = phytoProductInputTopiaDao;
    }

    public void setRefActaTraitementsProduitsCategTopiaDao(RefActaTraitementsProduitsCategTopiaDao refActaTraitementsProduitsCategTopiaDao) {
        this.refActaTraitementsProduitsCategTopiaDao = refActaTraitementsProduitsCategTopiaDao;
    }

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setCroppingPlanSpeciesTopiaDao(CroppingPlanSpeciesTopiaDao croppingPlanSpeciesTopiaDao) {
        this.croppingPlanSpeciesTopiaDao = croppingPlanSpeciesTopiaDao;
    }

    @Override
    public Double[] manageIntervention(PracticedIntervention intervention, GrowingSystem growingSystem, String campaigns, String croppingPlanEntryCode, String previousPlanEntryCode, PracticedCropCyclePhase phase) {
        Double[] result = this.newArray(RESULTS.length, 0.0);
        List seedingActions = this.seedingActionTopiaDao.forPracticedInterventionEquals(intervention).findAll();
        this.computeSeedingActionIFT(result, seedingActions);
        List<PhytoProductInput> phytoProductInputs = this.phytoProductInputTopiaDao.findAllByPracticedIntervention(intervention);
        if (phytoProductInputs != null) {
            for (PhytoProductInput phytoProductInput : phytoProductInputs) {
                Collection speciesStades;
                RefActaTraitementsProduit phytoProduct = phytoProductInput.getPhytoProduct();
                if (phytoProduct == null) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("Can't find phyto product for input " + phytoProductInput.getProductName()));
                    continue;
                }
                boolean isSeedingPhytoProduct = phytoProductInput instanceof SeedingProductInputImpl;
                if (isSeedingPhytoProduct) continue;
                int idTraitement = phytoProduct.getId_traitement();
                boolean nodu = phytoProduct.isNodu();
                RefActaTraitementsProduitsCateg traitementProduitCateg = (RefActaTraitementsProduitsCateg)this.refActaTraitementsProduitsCategTopiaDao.forNaturalId(idTraitement).findUnique();
                Double da = phytoProductInput.getQtAvg();
                if (da == null || phytoProductInput.getPhytoProductUnit() == null) continue;
                if (phytoProductInput.getPhytoProductUnit() == PhytoProductUnit.G_HL || phytoProductInput.getPhytoProductUnit() == PhytoProductUnit.KG_HL || phytoProductInput.getPhytoProductUnit() == PhytoProductUnit.L_HL) {
                    if (phytoProductInput instanceof PesticideProductInput) {
                        PesticideProductInput pesticideProductInput = (PesticideProductInput)phytoProductInput;
                        if (pesticideProductInput.getPesticidesSpreadingAction().getBoiledQuantity() != null) {
                            da = da * pesticideProductInput.getPesticidesSpreadingAction().getBoiledQuantity();
                        }
                    } else if (log.isWarnEnabled()) {
                        log.warn((Object)"Phyto quantity defined as hl, but not on PesticideProductInput");
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)(speciesStades = intervention.getSpeciesStades()))) {
                    HashSet speciesIds = Sets.newHashSetWithExpectedSize((int)speciesStades.size());
                    for (PracticedSpeciesStade speciesStade : speciesStades) {
                        CroppingPlanSpecies species = (CroppingPlanSpecies)this.croppingPlanSpeciesTopiaDao.forCodeEquals(speciesStade.getSpeciesCode()).findAny();
                        speciesIds.add(species.getSpecies().getTopiaId());
                    }
                    RefActaDosageSPC referenceDose = this.referentialService.computeActaReferenceDose(phytoProduct.getId_produit(), (Set)speciesIds);
                    double dh = 0.0;
                    if (referenceDose != null) {
                        dh = referenceDose.getDosage_spc_valeur();
                        if (referenceDose.getDosage_spc_unite() == PhytoProductUnit.G_HL || referenceDose.getDosage_spc_unite() == PhytoProductUnit.KG_HL || referenceDose.getDosage_spc_unite() == PhytoProductUnit.L_HL) {
                            dh *= 10.0;
                        }
                    } else if (log.isWarnEnabled()) {
                        log.warn((Object)String.format("Can't find reference dose for %s/%s", phytoProduct.getNom_produit(), phytoProduct.getNom_traitement()));
                    }
                    double ift = dh == 0.0 ? 1.0 * this.getInputPSCi(intervention, phytoProductInput) : da / dh * this.getInputPSCi(intervention, phytoProductInput);
                    this.feedUpIftResults(result, nodu, traitementProduitCateg, ift);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("No species selected for intervention " + intervention.getName()));
            }
        }
        return this.newResult(result);
    }

    @Override
    public Double[] manageIntervention(EffectiveIntervention intervention, Zone zone, CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry, EffectiveCropCyclePhase phase) {
        Double[] result = this.newArray(RESULTS.length, 0.0);
        List seedingActions = this.seedingActionTopiaDao.forEffectiveInterventionEquals(intervention).findAll();
        this.computeSeedingActionIFT(result, seedingActions);
        List<PhytoProductInput> phytoProductInputs = this.phytoProductInputTopiaDao.findAllByEffectiveIntervention(intervention);
        if (phytoProductInputs != null) {
            for (PhytoProductInput phytoProductInput : phytoProductInputs) {
                Collection speciesStades;
                RefActaTraitementsProduit phytoProduct = phytoProductInput.getPhytoProduct();
                if (phytoProduct == null) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("Can't find phyto product for input " + phytoProductInput.getProductName()));
                    continue;
                }
                boolean isSeedingPhytoProduct = phytoProductInput instanceof SeedingProductInputImpl;
                if (isSeedingPhytoProduct) continue;
                int idTraitement = phytoProduct.getId_traitement();
                boolean nodu = phytoProduct.isNodu();
                RefActaTraitementsProduitsCateg traitementProduitCateg = (RefActaTraitementsProduitsCateg)this.refActaTraitementsProduitsCategTopiaDao.forNaturalId(idTraitement).findUnique();
                Double da = phytoProductInput.getQtAvg();
                if (da == null) continue;
                if (phytoProductInput.getPhytoProductUnit() == PhytoProductUnit.G_HL || phytoProductInput.getPhytoProductUnit() == PhytoProductUnit.KG_HL || phytoProductInput.getPhytoProductUnit() == PhytoProductUnit.L_HL) {
                    if (phytoProductInput instanceof PesticideProductInput) {
                        PesticideProductInput pesticideProductInput = (PesticideProductInput)phytoProductInput;
                        if (pesticideProductInput.getPesticidesSpreadingAction().getBoiledQuantity() != null) {
                            da = da * pesticideProductInput.getPesticidesSpreadingAction().getBoiledQuantity();
                        }
                    } else if (log.isWarnEnabled()) {
                        log.warn((Object)"Phyto quantity defined as hl, but not on PesticideProductInput");
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)(speciesStades = intervention.getSpeciesStades()))) {
                    HashSet speciesIds = Sets.newHashSetWithExpectedSize((int)speciesStades.size());
                    for (EffectiveSpeciesStade speciesStade : speciesStades) {
                        CroppingPlanSpecies species = speciesStade.getCroppingPlanSpecies();
                        speciesIds.add(species.getSpecies().getTopiaId());
                    }
                    RefActaDosageSPC referenceDose = this.referentialService.computeActaReferenceDose(phytoProduct.getId_produit(), (Set)speciesIds);
                    double dh = 0.0;
                    if (referenceDose != null) {
                        dh = referenceDose.getDosage_spc_valeur();
                        if (referenceDose.getDosage_spc_unite() == PhytoProductUnit.G_HL || referenceDose.getDosage_spc_unite() == PhytoProductUnit.KG_HL || referenceDose.getDosage_spc_unite() == PhytoProductUnit.L_HL) {
                            dh *= 10.0;
                        }
                    } else if (log.isWarnEnabled()) {
                        log.warn((Object)String.format("Can't find reference dose for %s/%s", phytoProduct.getNom_produit(), phytoProduct.getNom_traitement()));
                    }
                    double ift = dh == 0.0 ? 1.0 * this.getInputPSCi(intervention, phytoProductInput) : da / dh * this.getInputPSCi(intervention, phytoProductInput);
                    this.feedUpIftResults(result, nodu, traitementProduitCateg, ift);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("No species selected for intervention " + intervention.getName()));
            }
        }
        return this.newResult(result);
    }

    protected void feedUpIftResults(Double[] result, boolean nodu, RefActaTraitementsProduitsCateg traitementProduitCateg, double ift) {
        Double[] doubleArray;
        if (traitementProduitCateg.isIft_total() && !nodu) {
            doubleArray = result;
            Double.valueOf(doubleArray[0] + ift);
        }
        if (traitementProduitCateg.isIft_tot_hts() && !nodu) {
            doubleArray = result;
            Double.valueOf(doubleArray[1] + ift);
        }
        if (traitementProduitCateg.isIft_h() && !nodu) {
            doubleArray = result;
            Double.valueOf(doubleArray[2] + ift);
        }
        if (traitementProduitCateg.isIft_f() && !nodu) {
            doubleArray = result;
            Double.valueOf(doubleArray[3] + ift);
        }
        if (traitementProduitCateg.isIft_i() && !nodu) {
            doubleArray = result;
            Double.valueOf(doubleArray[4] + ift);
        }
        if (traitementProduitCateg.isIft_ts() && !nodu) {
            doubleArray = result;
            Double.valueOf(doubleArray[5] + ift);
        }
        if (traitementProduitCateg.isIft_a() && !nodu) {
            doubleArray = result;
            Double.valueOf(doubleArray[6] + ift);
        }
        if (traitementProduitCateg.isIft_hh() && !nodu) {
            doubleArray = result;
            Double.valueOf(doubleArray[7] + ift);
        }
        if (nodu) {
            doubleArray = result;
            Double.valueOf(doubleArray[8] + ift);
        }
        if (traitementProduitCateg.isIft_moy_bio()) {
            doubleArray = result;
            Double.valueOf(doubleArray[9] + ift);
        }
    }

    protected void computeSeedingActionIFT(Double[] result, List<SeedingAction> seedingActions) {
        if (seedingActions != null) {
            double ift_ts = 0.0;
            double ift_bio = 0.0;
            for (SeedingAction seedingAction : seedingActions) {
                boolean isTreatment = false;
                boolean isBiologicalSeedInoculation = false;
                Collection seedingActionSpecieses = seedingAction.getSeedingSpecies();
                if (seedingActionSpecieses != null) {
                    for (SeedingActionSpecies seedingActionSpeciese : seedingActionSpecieses) {
                        if (seedingActionSpeciese.isTreatment()) {
                            isTreatment = true;
                        }
                        if (!seedingActionSpeciese.isBiologicalSeedInoculation()) continue;
                        isBiologicalSeedInoculation = true;
                    }
                }
                ift_ts = isTreatment ? ift_ts + 1.0 : ift_ts;
                ift_bio = isBiologicalSeedInoculation ? ift_bio + 1.0 : ift_bio;
            }
            result[0] = result[0] + ift_ts;
            Double[] doubleArray = result;
            Double.valueOf(doubleArray[1] + 0.0);
            doubleArray = result;
            Double.valueOf(doubleArray[2] + 0.0);
            doubleArray = result;
            Double.valueOf(doubleArray[3] + 0.0);
            doubleArray = result;
            Double.valueOf(doubleArray[4] + 0.0);
            doubleArray = result;
            Double.valueOf(doubleArray[5] + ift_ts);
            doubleArray = result;
            Double.valueOf(doubleArray[6] + 0.0);
            doubleArray = result;
            Double.valueOf(doubleArray[7] + 0.0);
            doubleArray = result;
            Double.valueOf(doubleArray[8] + 0.0);
            doubleArray = result;
            Double.valueOf(doubleArray[9] + ift_bio);
        }
    }
}

