/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.performance.indicators;

import com.google.common.base.Strings;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.Equipment;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhase;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhase;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.referential.RefMateriel;
import fr.inra.agrosyst.api.entities.referential.RefMaterielAutomoteur;
import fr.inra.agrosyst.api.entities.referential.RefMaterielOutil;
import fr.inra.agrosyst.api.entities.referential.RefMaterielTraction;
import fr.inra.agrosyst.services.performance.indicators.AbstractIndicator;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndicatorFuelConsumption
extends AbstractIndicator {
    private static final Log log = LogFactory.getLog(IndicatorFuelConsumption.class);

    @Override
    public String getIndicatorCategory() {
        return "R\u00e9sultats socio-techniques";
    }

    @Override
    public String getIndicatorLabel(int i) {
        return "Consommation de carburant (l/ha)";
    }

    @Override
    public Double[] manageIntervention(PracticedIntervention intervention, GrowingSystem growingSystem, String campaigns, String croppingPlanEntryCode, String previousPlanEntryCode, PracticedCropCyclePhase phase) {
        Collection toolsCouplingCodes = intervention.getToolsCouplingCodes();
        Double puissance = null;
        Double tauxDeCharge = null;
        Double[] result = null;
        if (toolsCouplingCodes != null) {
            for (String toolsCouplingCode : toolsCouplingCodes) {
                ToolsCoupling toolsCoupling = (ToolsCoupling)this.toolsCouplingDAO.forCodeEquals(toolsCouplingCode).findAny();
                Equipment tracteur = toolsCoupling.getTractor();
                if (tracteur != null) {
                    String strTauxCharge;
                    RefMateriel materiel = tracteur.getRefMateriel();
                    if (materiel instanceof RefMaterielAutomoteur) {
                        puissance = ((RefMaterielAutomoteur)materiel).getPuissanceChISO();
                        strTauxCharge = ((RefMaterielAutomoteur)materiel).getDonneesTauxDeChargeMoteur().replace(',', '.');
                        if (strTauxCharge.matches("\\d+(\\.\\d+)?")) {
                            tauxDeCharge = Double.parseDouble(strTauxCharge);
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)("Can't parse '" + strTauxCharge + "' as number"));
                        }
                    } else if (materiel instanceof RefMaterielTraction) {
                        puissance = ((RefMaterielTraction)materiel).getPuissanceChIso();
                        strTauxCharge = ((RefMaterielTraction)materiel).getDonneesTauxDeChargeMoteur().replace(',', '.');
                        if (strTauxCharge.matches("\\d+(\\.\\d+)?")) {
                            tauxDeCharge = Double.parseDouble(strTauxCharge);
                        } else if (Strings.isNullOrEmpty((String)strTauxCharge)) {
                            tauxDeCharge = 1.0;
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)("Can't parse '" + strTauxCharge + "' as number"));
                        }
                    }
                    tauxDeCharge = this.findHigherTauxDeCharge(tauxDeCharge, toolsCoupling);
                }
                result = this.computeFuelConsumption(puissance, tauxDeCharge, result);
            }
        }
        return result;
    }

    @Override
    public Double[] manageIntervention(EffectiveIntervention intervention, Zone zone, CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry, EffectiveCropCyclePhase phase) {
        Double puissance = null;
        Double tauxDeCharge = null;
        Double[] result = null;
        Collection toolsCouplings = intervention.getToolCouplings();
        if (toolsCouplings != null) {
            for (ToolsCoupling toolsCoupling : toolsCouplings) {
                Equipment tracteur = toolsCoupling.getTractor();
                if (tracteur != null) {
                    String strTauxCharge;
                    RefMateriel materiel = tracteur.getRefMateriel();
                    if (materiel instanceof RefMaterielAutomoteur) {
                        puissance = ((RefMaterielAutomoteur)materiel).getPuissanceChISO();
                        strTauxCharge = ((RefMaterielAutomoteur)materiel).getDonneesTauxDeChargeMoteur().replace(',', '.');
                        if (strTauxCharge.matches("\\d+(\\.\\d+)?")) {
                            tauxDeCharge = Double.parseDouble(strTauxCharge);
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)("Can't parse '" + strTauxCharge + "' as number"));
                        }
                    } else if (materiel instanceof RefMaterielTraction) {
                        puissance = ((RefMaterielTraction)materiel).getPuissanceChIso();
                        strTauxCharge = ((RefMaterielTraction)materiel).getDonneesTauxDeChargeMoteur().replace(',', '.');
                        if (strTauxCharge.matches("\\d+(\\.\\d+)?")) {
                            tauxDeCharge = Double.parseDouble(strTauxCharge);
                        } else if (Strings.isNullOrEmpty((String)strTauxCharge)) {
                            tauxDeCharge = 1.0;
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)("Can't parse '" + strTauxCharge + "' as number"));
                        }
                    }
                    tauxDeCharge = this.findHigherTauxDeCharge(tauxDeCharge, toolsCoupling);
                }
                result = this.computeFuelConsumption(puissance, tauxDeCharge, result);
            }
        }
        return result;
    }

    protected Double[] computeFuelConsumption(Double puissance, Double tauxDeCharge, Double[] result) {
        if (puissance != null && tauxDeCharge != null) {
            double fuelConsumption = puissance * tauxDeCharge * 0.22;
            result = this.newResult(fuelConsumption);
        }
        return result;
    }

    protected Double findHigherTauxDeCharge(Double tauxDeCharge, ToolsCoupling toolsCoupling) {
        if (tauxDeCharge != null && toolsCoupling.getEquipments() != null) {
            for (Equipment equipement : toolsCoupling.getEquipments()) {
                if (!(equipement.getRefMateriel() instanceof RefMaterielOutil)) continue;
                String strTauxCharge = ((RefMaterielOutil)equipement.getRefMateriel()).getDonnessTauxDeChargeMoteur().replace(',', '.');
                if (strTauxCharge.matches("\\d+(\\.\\d+)?")) {
                    Double tauxDeCharge2 = Double.parseDouble(strTauxCharge);
                    if (!(tauxDeCharge2 > tauxDeCharge)) continue;
                    tauxDeCharge = tauxDeCharge2;
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't parse '" + strTauxCharge + "' as number"));
            }
        }
        return tauxDeCharge;
    }
}

